/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.text.ParseException;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.types.Date;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSDate
extends XSType {
    private static final JType jType = new JClass("org.exolab.castor.types.Date");
    private Date _maxInclusive;
    private Date _maxExclusive;
    private Date _minInclusive;
    private Date _minExclusive;

    public XSDate() {
        super((short)5);
    }

    public String newInstanceCode() {
        return "new " + this.getJType().getName() + "();";
    }

    public JType getJType() {
        return jType;
    }

    public Date getMaxExclusive() {
        return this._maxExclusive;
    }

    public Date getMaxInclusive() {
        return this._maxInclusive;
    }

    public Date getMinExclusive() {
        return this._minExclusive;
    }

    public Date getMinInclusive() {
        return this._minInclusive;
    }

    public void setMaxExclusive(Date date) {
        this._maxExclusive = date;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(Date date) {
        this._maxInclusive = date;
        this._maxExclusive = null;
    }

    public void setMinExclusive(Date date) {
        this._minExclusive = date;
        this._minInclusive = null;
    }

    public void setMinInclusive(Date date) {
        this._minInclusive = date;
        this._minExclusive = null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            try {
                if ("maxExclusive".equals(string)) {
                    this.setMaxExclusive(Date.parseDate(facet.getValue()));
                    continue;
                }
                if ("maxInclusive".equals(string)) {
                    this.setMaxInclusive(Date.parseDate(facet.getValue()));
                    continue;
                }
                if ("minExclusive".equals(string)) {
                    this.setMinExclusive(Date.parseDate(facet.getValue()));
                    continue;
                }
                if ("minInclusive".equals(string)) {
                    this.setMinInclusive(Date.parseDate(facet.getValue()));
                    continue;
                }
                if (!"pattern".equals(string)) continue;
                System.out.println("Warning: The facet 'pattern' is not currently supported for Date.");
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return;
            }
        }
    }

    public void validationCode(JSourceCode jSourceCode, String string, String string2) {
        Date date;
        if (jSourceCode == null) {
            jSourceCode = new JSourceCode();
        }
        jSourceCode.add("DateTimeValidator typeValidator = new DateTimeValidator();");
        if (this.hasMinimum()) {
            jSourceCode.add("try {");
            jSourceCode.indent();
            date = this.getMinExclusive();
            if (date != null) {
                jSourceCode.add("org.exolab.castor.types.Date min =org.exolab.castor.types.Date.parseDate(\"" + date.toString() + "\");");
                jSourceCode.add("typeValidator.setMinExclusive(");
            } else {
                date = this.getMinInclusive();
                jSourceCode.add("org.exolab.castor.types.Date min =org.exolab.castor.types.Date.parseDate(\"" + date.toString() + "\");");
                jSourceCode.add("typeValidator.setMinInclusive(");
            }
            jSourceCode.append("min");
            jSourceCode.append(");");
            jSourceCode.unindent();
            jSourceCode.add("} catch (java.text.ParseException e) {");
            jSourceCode.indent();
            jSourceCode.add("System.out.println(e);");
            jSourceCode.add("e.printStackTrace();");
            jSourceCode.add("return;");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        if (this.hasMaximum()) {
            jSourceCode.add("try {");
            jSourceCode.indent();
            date = this.getMaxExclusive();
            if (date != null) {
                jSourceCode.add("org.exolab.castor.types.Date max =org.exolab.castor.types.Date.parseDate(\"" + date.toString() + "\");");
                jSourceCode.add("typeValidator.setMaxExclusive(");
            } else {
                date = this.getMaxInclusive();
                jSourceCode.add("org.exolab.castor.types.Date max =org.exolab.castor.types.Date.parseDate(\"" + date.toString() + "\");");
                jSourceCode.add("typeValidator.setMaxInclusive(");
            }
            jSourceCode.append("max");
            jSourceCode.append(");");
            jSourceCode.unindent();
            jSourceCode.add("} catch (java.text.ParseException e) {");
            jSourceCode.indent();
            jSourceCode.add("System.out.println(e);");
            jSourceCode.add("e.printStackTrace();");
            jSourceCode.add("return;");
            jSourceCode.unindent();
            jSourceCode.add("}");
        }
        jSourceCode.add(string2 + ".setValidator(typeValidator);");
    }
}

