/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.types.OperationNotSupportedException;

public class Time
extends DateTimeBase {
    private static final String TIME_FORMAT_MILLI = "HH:mm:ss.SSS";
    private static final String TIME_FORMAT_NO_MILLI = "HH:mm:ss";
    private static final int HOUR_FLAG = 31;
    private static final int MINUTE_FLAG = 15;
    private static final int SECOND_FLAG = 7;
    private static final int MILLI_FLAG = 3;
    private static final int TIMEZONE_FLAG = 1;
    private static final String BAD_TIME = "Bad Time format: ";

    public Time() {
    }

    public Time(short[] sArray) {
        this.setValues(sArray);
    }

    public Time(long l) {
        if (l > 86400000L) {
            throw new IllegalArgumentException("Bad Time: the long value can't represent more than 24h.");
        }
        this.setHour((short)(l / 3600000L));
        this.setMinute((short)((l %= 3600000L) / 60000L));
        this.setSecond((short)((l %= 60000L) / 1000L), (short)(l % 1000L));
    }

    public Time(String string) throws ParseException {
        this();
        Time.parseTimeInternal(string, this);
    }

    public void setValues(short[] sArray) {
        if (sArray.length != 4) {
            throw new IllegalArgumentException("Time#setValues: not the right number of values");
        }
        this.setHour(sArray[0]);
        this.setMinute(sArray[1]);
        this.setSecond(sArray[2], sArray[3]);
    }

    public short[] getValues() {
        short[] sArray = null;
        sArray = new short[]{this.getHour(), this.getMinute(), this.getSeconds(), this.getMilli()};
        return sArray;
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat simpleDateFormat = null;
        String string = this.toString();
        simpleDateFormat = string.indexOf(46) > 0 ? new SimpleDateFormat(TIME_FORMAT_MILLI) : new SimpleDateFormat(TIME_FORMAT_NO_MILLI);
        if (this.isUTC()) {
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
            simpleDateFormat.setTimeZone(simpleTimeZone);
        }
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isNegative()) {
            stringBuffer.append('-');
        }
        if (this.getHour() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getHour());
        stringBuffer.append(':');
        if (this.getMinute() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getMinute());
        stringBuffer.append(':');
        if (this.getSeconds() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getSeconds());
        if (this.getMilli() != 0) {
            stringBuffer.append('.');
            if (this.getMilli() < 100) {
                stringBuffer.append('0');
                if (this.getMilli() < 10) {
                    stringBuffer.append('0');
                }
            }
            stringBuffer.append(this.getMilli());
        }
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                stringBuffer.append('Z');
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                if (this.isZoneNegative()) {
                    stringBuffer2.append('-');
                } else {
                    stringBuffer2.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneHour());
                stringBuffer2.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneMinute());
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2 = null;
            }
        }
        return stringBuffer.toString();
    }

    public static Object parse(String string) throws ParseException {
        return Time.parseTime(string);
    }

    public static Time parseTime(String string) throws ParseException {
        Time time = new Time();
        return Time.parseTimeInternal(string, time);
    }

    private static Time parseTimeInternal(String string, Time time) throws ParseException {
        int n;
        char[] cArray;
        if (string == null) {
            throw new IllegalArgumentException("The string to be parsed must notbe null.");
        }
        if (time == null) {
            time = new Time();
        }
        if ((cArray = string.toCharArray())[n = 0] == '-') {
            ++n;
            time.setNegative();
        }
        boolean bl = false;
        boolean bl2 = false;
        short s = 0;
        short s2 = 0;
        int n2 = 31;
        while (n < cArray.length) {
            char c = cArray[n++];
            switch (c) {
                case ':': {
                    if (!bl2) {
                        throw new ParseException(BAD_TIME + string + "\nAn hour field must have 2 digits.", n);
                    }
                    if (n2 == 31) {
                        time.setHour(s);
                        n2 = 15;
                    } else if (n2 == 15) {
                        time.setMinute(s);
                        n2 = 7;
                    } else if (n2 == 3) {
                        time.setSecond(s2, s);
                    } else if (n2 == 1) {
                        s2 = s;
                        s = 0;
                        n2 = 0;
                    } else {
                        throw new ParseException(BAD_TIME + string + "\nA Time must follow the pattern hh:mm:ss.s(Z|((+|-)hh:mm)).", n);
                    }
                    bl = false;
                    bl2 = false;
                    break;
                }
                case '.': {
                    if (n2 != 7) {
                        throw new ParseException(BAD_TIME + string + "\n'.'" + "is wrongly placed.", n);
                    }
                    s2 = s;
                    s = 0;
                    bl = false;
                    bl2 = false;
                    n2 = 3;
                    break;
                }
                case 'Z': {
                    if (n2 != 7 && n2 != 3) {
                        throw new ParseException(BAD_TIME + string + "\n'Z'" + "is wrongly placed.", n);
                    }
                    time.setUTC();
                    break;
                }
                case '-': {
                    if (n2 != 7 && n2 != 3) {
                        throw new ParseException(BAD_TIME + string + "\n'-'" + "is wrongly placed.", n);
                    }
                    if (n2 == 7) {
                        time.setSecond(s, (short)0);
                    } else if (n2 == 3) {
                        time.setSecond(s2, s);
                    }
                    time.setUTC();
                    time.setZoneNegative(true);
                    n2 = 1;
                    bl = false;
                    bl2 = false;
                    break;
                }
                case '+': {
                    if (n2 != 7 && n2 != 3) {
                        throw new ParseException(BAD_TIME + string + "\n'+'" + "is wrongly placed.", n);
                    }
                    if (n2 == 7) {
                        time.setSecond(s, (short)0);
                    } else if (n2 == 3) {
                        time.setSecond(s2, s);
                    }
                    time.setUTC();
                    n2 = 1;
                    bl = false;
                    bl2 = false;
                    break;
                }
                default: {
                    if ('0' <= c && c <= '9') {
                        if (bl) {
                            if (n2 == 3) {
                                if (bl2) {
                                    s = (short)(s + (c - 48));
                                    break;
                                }
                                s = (short)(s + 10 * (c - 48));
                                bl2 = true;
                                break;
                            }
                            s = (short)(s * 10 + (c - 48));
                            bl2 = true;
                            break;
                        }
                        bl = true;
                        if (n2 == 3) {
                            s = (short)(100 * (c - 48));
                            break;
                        }
                        s = (short)(c - 48);
                        break;
                    }
                    throw new ParseException(string + ": Invalid character: " + c, n);
                }
            }
        }
        if (n2 != 7 && n2 != 3 && n2 != 0) {
            throw new ParseException(BAD_TIME + string + "\nA Time must follow the pattern hh:mm:ss.s(Z|((+|-)hh:mm)).", n);
        }
        if (n2 == 7) {
            time.setSecond(s, (short)0);
        } else if (n2 == 3) {
            time.setSecond(s2, s);
        } else if (n2 == 0) {
            if (s != -1) {
                time.setZone(s2, s);
            } else {
                throw new ParseException(string + "\n In a time zone, the minute field must always be present.", n);
            }
        }
        return time;
    }

    public short getCentury() {
        String string = "Time: couldn't access to the Century field.";
        throw new OperationNotSupportedException(string);
    }

    public short getYear() {
        String string = "Time: couldn't access to the Year field.";
        throw new OperationNotSupportedException(string);
    }

    public short getMonth() {
        String string = "Time: couldn't access to the Month field.";
        throw new OperationNotSupportedException(string);
    }

    public short getDay() {
        String string = "Time: couldn't access to the Day field.";
        throw new OperationNotSupportedException(string);
    }

    public void setCentury(short s) {
        String string = "Time: couldn't access to the Century field.";
        throw new OperationNotSupportedException(string);
    }

    public void getYear(short s) {
        String string = "Time: couldn't access to the Year field.";
        throw new OperationNotSupportedException(string);
    }

    public void getMonth(short s) {
        String string = "Time: couldn't access to the Month field.";
        throw new OperationNotSupportedException(string);
    }

    public void getDay(short s) {
        String string = "Time: couldn't access to the Day field.";
        throw new OperationNotSupportedException(string);
    }
}

