/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pm.gui.PM_FocusPanel;
import pm.gui.PM_IndexViewCollection;
import pm.gui.PM_PictureView;
import pm.gui.PM_WindowBase;
import pm.gui.PM_WindowDialogSequences;
import pm.gui.PM_WindowMain;
import pm.inout.PM_Export;
import pm.picture.PM_Picture;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_IndexView
extends JPanel
implements PM_Interface,
MouseListener,
FocusListener {
    private static List<PM_Picture> tempPictureList = new ArrayList<PM_Picture>();
    private boolean showTempPictureList = false;
    private final PM_IndexViewCollection indexViewCollection;
    static final List<PM_PictureView> thumbsToRead = new ArrayList<PM_PictureView>();
    static final Object token = new Object();
    int sliderValue = 100;
    private boolean allowGetFromRight = false;
    private boolean allowCrossing = false;
    private boolean windowsEqual = false;
    private PM_FocusPanel focusPanel;
    private JScrollPane scrollPane = null;
    private PM_WindowMain windowMain = null;
    private boolean popUpLoeschen = false;
    private boolean popUpLoeschenAufheben = false;
    private boolean popUpAendern = false;
    private boolean popUpDiaShow = false;
    private boolean popUpExternBearbeiten = false;
    private boolean popUpSerien = false;
    private boolean drehenSpiegeln = true;
    private boolean ausschneiden = true;
    private double cutGlobalSize = 0.0;
    private boolean paintBildText = false;
    private PM_Configuration config = null;
    private boolean markImportDatum = false;
    private ActionListener timerAl = null;
    private Timer timer = null;
    private JViewport indexViewPort;
    ReadThumbsThread readThumbsThread;
    boolean textAufloesung = false;
    private final Object lesethread = new Object();
    private final int hGap = 10;
    private final int vGap = 10;
    private Dimension preferredSizeIndexView = new Dimension(15, 15);
    private Point viewPortPosition = new Point();
    private Dimension viewPortExtentSize = new Dimension(15, 15);
    private PM_Picture firstPaintedPicture = null;

    public PM_IndexView(PM_WindowMain pM_WindowMain, PM_WindowBase pM_WindowBase) {
        this.focusPanel = new PM_FocusPanel(null, this, this);
        this.config = PM_Configuration.getInstance();
        this.windowMain = pM_WindowMain;
        if (this.config.isNurLesen()) {
            this.setBackground(PM_WindowBase.COLOR_NUR_LESEN);
        } else {
            this.setBackground(PM_WindowBase.COLOR_BACKGROUND);
        }
        this.setLayout(null);
        this.indexViewCollection = new PM_IndexViewCollection(pM_WindowMain, this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                if (pM_Action.getObject() instanceof PM_Picture) {
                    PM_Picture pM_Picture = (PM_Picture)pM_Action.getObject();
                    PM_IndexView.this.indexViewCollection.paintPictureDeleted(pM_Picture);
                }
                if (pM_Action.getObject() == null) {
                    // empty if block
                }
            }
        };
        PM_Export.addDeleteListener(pM_Listener);
        this.scrollPane = new JScrollPane(this);
        this.setScrollPane();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void initEnd() {
        this.setPreferredSize(this.indexViewPort.getExtentSize());
        this.indexViewPort.validate();
    }

    public void showTempPictureList(boolean bl) {
        if (bl == this.showTempPictureList) {
            return;
        }
        this.showTempPictureList = true;
        this.setAndPaintPictureList(new ArrayList<PM_Picture>(tempPictureList));
    }

    public static List<PM_Picture> getTempPictureList() {
        return tempPictureList;
    }

    public static boolean hasTempPictureList(PM_Picture pM_Picture) {
        return tempPictureList.contains(pM_Picture);
    }

    public boolean insertPicture(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        if (this.hasPicture(pM_Picture)) {
            return false;
        }
        if (!this.hasPicture(pM_Picture2)) {
            return false;
        }
        this.indexViewCollection.insertPicture(pM_Picture, pM_Picture2);
        this.paintViewPort(-1);
        return true;
    }

    public boolean movePicture(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
        if (!this.hasPicture(pM_Picture) || !this.hasPicture(pM_Picture2)) {
            return false;
        }
        this.indexViewCollection.movePicture(pM_Picture, pM_Picture2);
        this.paintViewPort(-1);
        return true;
    }

    public void removePictureList(List<PM_Picture> list) {
        this.indexViewCollection.removePictureList(list);
        this.paintViewPort(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAndPaintPictureList(List<PM_Picture> list) {
        Object object = token;
        synchronized (object) {
            List<PM_PictureView> list2 = thumbsToRead;
            synchronized (list2) {
                thumbsToRead.clear();
                this.indexViewCollection.setPictureList(list);
                this.paintViewPort(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendPictureList(List<PM_Picture> list) {
        Object object = thumbsToRead;
        synchronized (object) {
            thumbsToRead.clear();
        }
        list.removeAll(this.indexViewCollection.getPictureList());
        if (list.isEmpty()) {
            return false;
        }
        object = token;
        synchronized (object) {
            List<PM_PictureView> list2 = thumbsToRead;
            synchronized (list2) {
                this.indexViewCollection.appendPictureList(list);
                this.paintViewPort(-1);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rereadAllThumbs() {
        Object object = token;
        synchronized (object) {
            List<PM_PictureView> list = thumbsToRead;
            synchronized (list) {
                thumbsToRead.clear();
                this.indexViewCollection.removePictureClosed();
                this.indexViewCollection.removePictureDeleted();
                this.paintViewPort(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllThumbs() {
        Object object = token;
        synchronized (object) {
            List<PM_PictureView> list = thumbsToRead;
            synchronized (list) {
                thumbsToRead.clear();
            }
            this.indexViewCollection.removeAllPicture();
            this.paintViewPort(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPicture(PM_Picture pM_Picture) {
        Object object = token;
        synchronized (object) {
            List<PM_PictureView> list = thumbsToRead;
            synchronized (list) {
                if (!this.indexViewCollection.addPicture(pM_Picture, this, -1)) {
                    return false;
                }
                thumbsToRead.clear();
                this.paintViewPort(-1);
            }
        }
        return true;
    }

    public void repaintPicture(PM_Picture pM_Picture) {
        if (this.indexViewCollection.hasPictureView(pM_Picture)) {
            this.indexViewCollection.getPictureView(pM_Picture).repaint();
        }
    }

    public void repaintViewport() {
        this.indexViewPort.repaint();
    }

    public void rereadPictureViewThumbnail(PM_Picture pM_Picture) {
        if (this.indexViewCollection.hasPictureView(pM_Picture)) {
            this.indexViewCollection.getPictureView(pM_Picture).flushImageThumbnail();
            this.indexViewCollection.getPictureView(pM_Picture).repaint();
        }
    }

    public void rereadAllPictureViewThumbnail() {
        this.indexViewCollection.rereadAllPictureViewThumbnail();
        this.paintViewPort(-1);
    }

    private void setScrollPane() {
        this.indexViewPort = this.scrollPane.getViewport();
        this.indexViewPort.setView(this);
        this.scrollPane.setViewport(this.indexViewPort);
        this.scrollPane.setWheelScrollingEnabled(false);
        this.readThumbsThread = new ReadThumbsThread();
        this.readThumbsThread.start();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                Object object = token;
                synchronized (object) {
                    List<PM_PictureView> list = thumbsToRead;
                    synchronized (list) {
                        thumbsToRead.clear();
                        PM_IndexView.this.paintViewPort(mouseWheelEvent);
                    }
                }
            }
        };
        this.scrollPane.addMouseWheelListener(mouseWheelListener);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (PM_IndexView.this.timerAl == null) {
                    PM_IndexView.this.timerAl = new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void actionPerformed(ActionEvent actionEvent) {
                            Object object = token;
                            synchronized (object) {
                                PM_IndexView.this.paintViewPort(PM_IndexView.this.scrollPane.getViewport().getViewPosition());
                            }
                            PM_IndexView.this.timer.stop();
                        }
                    };
                    PM_IndexView.this.timer = new Timer(300, PM_IndexView.this.timerAl);
                }
                if (!PM_IndexView.this.preferredSizeIndexView.equals(PM_IndexView.this.getPreferredSize())) {
                    return;
                }
                if (!PM_IndexView.this.viewPortExtentSize.equals(PM_IndexView.this.scrollPane.getViewport().getExtentSize())) {
                    PM_IndexView.this.viewPortExtentSize = PM_IndexView.this.scrollPane.getViewport().getExtentSize();
                    PM_IndexView.this.paintViewPort(PM_IndexView.this.scrollPane.getViewport().getViewPosition());
                    return;
                }
                if (!PM_IndexView.this.viewPortPosition.equals(PM_IndexView.this.scrollPane.getViewport().getViewPosition())) {
                    PM_IndexView.this.viewPortPosition = PM_IndexView.this.scrollPane.getViewport().getViewPosition();
                    PM_IndexView.this.timer.start();
                    return;
                }
            }
        };
        this.scrollPane.getViewport().addChangeListener(changeListener);
    }

    public PM_FocusPanel getFocusPanel() {
        return this.focusPanel;
    }

    public void setAllowGetFromRight(boolean bl) {
        this.allowGetFromRight = bl;
    }

    public boolean getAllowGetFromRight() {
        return this.allowGetFromRight;
    }

    public void setAllowCrossing(boolean bl) {
        this.allowCrossing = bl;
    }

    public boolean getAllowCrossing() {
        return this.allowCrossing;
    }

    public void setWindowsEqual(boolean bl) {
        this.windowsEqual = bl;
    }

    public boolean getWindowsEqual() {
        return this.windowsEqual;
    }

    public boolean isLeft() {
        return this.windowMain.getIndexViewThumbnails() == this;
    }

    public void setMarkImportDatum(boolean bl) {
        this.markImportDatum = bl;
    }

    public boolean getMarkImportDatum() {
        return this.markImportDatum;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setDrehenAusschneiden(boolean bl) {
        this.drehenSpiegeln = bl;
        this.ausschneiden = bl;
    }

    public void setAusschneiden(boolean bl) {
        this.ausschneiden = bl;
    }

    public void setDrehenSpiegeln(boolean bl) {
        this.drehenSpiegeln = bl;
    }

    public boolean getDrehenSpiegeln() {
        return this.drehenSpiegeln;
    }

    public boolean getAusschneiden() {
        return this.ausschneiden;
    }

    public void setPaintBildText(boolean bl) {
        this.paintBildText = bl;
    }

    public boolean getPaintBildText() {
        return this.paintBildText;
    }

    public void setGlobalCutSize(double d) {
        this.cutGlobalSize = d;
    }

    public double getGlobalCutSize() {
        return this.cutGlobalSize;
    }

    public void setTextAufloesung(boolean bl) {
        this.textAufloesung = bl;
    }

    public boolean getTextAufloesung() {
        return this.textAufloesung;
    }

    public void setPopUpLoeschen(boolean bl) {
        this.popUpLoeschen = bl;
    }

    public void setPopUpLoeschenAufheben(boolean bl) {
        this.popUpLoeschenAufheben = bl;
    }

    public void setPopUpAendern(boolean bl) {
        this.popUpAendern = bl;
    }

    public void setPopUpDiaShow(boolean bl) {
        this.popUpDiaShow = bl;
    }

    public void setPopUpExternBearbeiten(boolean bl) {
        this.popUpExternBearbeiten = bl;
    }

    public void setPopUpSerien(boolean bl) {
        this.popUpSerien = bl;
    }

    public List<PM_Picture> getPictureListDarstellen() {
        return this.indexViewCollection.getPictureListDarstellen();
    }

    public boolean isPictureViewSelected(PM_PictureView pM_PictureView) {
        return this.indexViewCollection.isPictureViewSelected(pM_PictureView);
    }

    public PM_PictureView getPictureViewSelected() {
        return this.indexViewCollection.getPictureViewSelected();
    }

    public void setPictureViewSelected(PM_PictureView pM_PictureView) {
        this.indexViewCollection.setPictureViewSelected(pM_PictureView);
    }

    public boolean isEqual(PM_IndexView pM_IndexView) {
        return this.indexViewCollection.isEqual(pM_IndexView);
    }

    public boolean isEqual(List<PM_Picture> list) {
        return this.indexViewCollection.isEqual(list);
    }

    public PM_PictureView getPictureView(PM_Picture pM_Picture) {
        return this.indexViewCollection.getPictureView(pM_Picture);
    }

    public boolean hasPictureView(PM_Picture pM_Picture) {
        return this.indexViewCollection.hasPictureView(pM_Picture);
    }

    public boolean hasPicture(PM_Picture pM_Picture) {
        return this.indexViewCollection.hasPicture(pM_Picture);
    }

    public int sizeDargestellt() {
        return this.indexViewCollection.sizeDargestellt();
    }

    public int getPictureSize() {
        return this.indexViewCollection.getSize();
    }

    public int getSizeClosed() {
        return this.indexViewCollection.getSizeClosed();
    }

    public boolean isPictureClosed(PM_Picture pM_Picture) {
        return this.indexViewCollection.isPictureClosed(pM_Picture);
    }

    public void closePicture(PM_Picture pM_Picture) {
        this.indexViewCollection.closePicture(pM_Picture);
    }

    public void openPicture(PM_Picture pM_Picture) {
        this.indexViewCollection.openPicture(pM_Picture);
    }

    public JSlider getSlider() {
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (!jSlider.getValueIsAdjusting()) {
                    PM_IndexView.this.sliderValue = jSlider.getValue();
                    PM_IndexView.this.paintViewPort(-1);
                }
            }
        };
        JSlider jSlider = new JSlider(0, 50, 400, 100);
        jSlider.addChangeListener(changeListener);
        jSlider.setMajorTickSpacing(100);
        jSlider.setMinorTickSpacing(30);
        return jSlider;
    }

    public void doMouseClickLeft(PM_PictureView pM_PictureView, int n) {
        this.indexViewCollection.setPictureViewSelected(pM_PictureView);
        pM_PictureView.requestFocusInWindow();
        if (!pM_PictureView.getIndexView().isLeft()) {
            if (n == 1) {
                return;
            }
            this.windowMain.getWindowRightSelected().doubleClickOnPictureView(pM_PictureView);
            return;
        }
        if (n == 1 && this.windowMain.getWindowRightSelected().getIndexView() == null) {
            this.windowMain.getWindowRightSelected().appendPicture(pM_PictureView);
        } else if (n == 2 && pM_PictureView.getIndexView().isLeft()) {
            this.windowMain.getWindowRightSelected().appendPicture(pM_PictureView);
        }
    }

    public void keyEnterPressed(PM_PictureView pM_PictureView) {
        if (pM_PictureView.getIndexView().isLeft()) {
            this.windowMain.getWindowRightSelected().appendPicture(pM_PictureView);
        }
        this.doSelectNextPictureView(pM_PictureView.getPicture(), 39);
    }

    public void doSelectNextPictureView(PM_Picture pM_Picture, int n) {
        PM_Picture pM_Picture2 = pM_Picture;
        if (n == 39) {
            pM_Picture2 = this.indexViewCollection.getNextPicture(pM_Picture2);
        }
        if (n == 37) {
            pM_Picture2 = this.indexViewCollection.getPreviousPicture(pM_Picture2);
        }
        if (pM_Picture2 == null) {
            return;
        }
        PM_PictureView pM_PictureView = this.indexViewCollection.getPictureView(pM_Picture2);
        if (pM_PictureView == null) {
            return;
        }
        this.indexViewCollection.setPictureViewSelected(pM_PictureView);
        pM_PictureView.requestFocus();
    }

    private void doAllSequences(PM_PictureView pM_PictureView) {
        if (!pM_PictureView.getPicture().meta.hasSequenz()) {
            JOptionPane.showConfirmDialog(this, PM_MSG.getMsg("indViewNoSequ"), "Error", -1, 1);
            return;
        }
        new PM_WindowDialogSequences(this.windowMain, pM_PictureView, this.indexViewCollection);
    }

    public void doPopUp(final PM_PictureView pM_PictureView, final PM_Picture pM_Picture, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(PM_MSG.getMsg("indViewPopUpDel"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (pM_PictureView != null) {
                    if (pM_PictureView.getIndexView().isLeft()) {
                        PM_IndexView.this.windowMain.getWindowThumbnails().closePicture(pM_Picture);
                        pM_PictureView.repaint();
                    } else {
                        PM_IndexView.this.windowMain.getWindowRightSelected().closePicture(pM_Picture);
                        pM_PictureView.repaint();
                        PM_IndexView.this.windowMain.getIndexViewThumbnails().repaintPicture(pM_Picture);
                    }
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        if (this.popUpLoeschen) {
            jPopupMenu.add(jMenuItem);
        }
        JMenuItem jMenuItem2 = new JMenuItem(PM_MSG.getMsg("indViewPopUpSus"));
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (pM_PictureView != null) {
                    if (pM_PictureView.getIndexView().isLeft()) {
                        PM_IndexView.this.windowMain.getWindowThumbnails().openPicture(pM_Picture);
                        pM_PictureView.repaint();
                    } else {
                        PM_IndexView.this.windowMain.getWindowRightSelected().openPicture(pM_Picture);
                        pM_PictureView.repaint();
                        PM_IndexView.this.windowMain.getIndexViewThumbnails().repaintPicture(pM_Picture);
                    }
                }
            }
        };
        jMenuItem2.addActionListener(actionListener2);
        if (this.popUpLoeschenAufheben) {
            jPopupMenu.add(jMenuItem2);
        }
        JMenuItem jMenuItem3 = new JMenuItem("?Diashow");
        jMenuItem3.setText(PM_MSG.getMsg("diashow"));
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (pM_PictureView != null) {
                    PM_IndexView.this.windowMain.doDiaShow(pM_PictureView.getPicture(), PM_IndexView.this.getPictureListDarstellen(), 1);
                }
            }
        };
        jMenuItem3.addActionListener(actionListener3);
        if (this.popUpDiaShow) {
            jPopupMenu.add(jMenuItem3);
        }
        JMenuItem jMenuItem4 = new JMenuItem(PM_MSG.getMsg("indViewPopUpCut"));
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (pM_PictureView != null) {
                    PM_IndexView.this.windowMain.doBildZeigenOriginal(pM_PictureView.getPicture(), PM_IndexView.this.getPictureListDarstellen());
                }
            }
        };
        jMenuItem4.addActionListener(actionListener4);
        if (this.popUpAendern) {
            jPopupMenu.add(jMenuItem4);
        }
        JMenuItem jMenuItem5 = new JMenuItem(PM_MSG.getMsg("indViewPopUpExtern"));
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (pM_PictureView != null) {
                    PM_IndexView.this.windowMain.doExternBearbeiten(pM_PictureView.getPicture());
                }
            }
        };
        jMenuItem5.addActionListener(actionListener5);
        if (this.popUpExternBearbeiten) {
            jPopupMenu.add(jMenuItem5);
        }
        JMenuItem jMenuItem6 = new JMenuItem(PM_MSG.getMsg("indViewPopUpSequ"));
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (pM_PictureView != null && pM_PictureView != null) {
                    PM_IndexView.this.doAllSequences(pM_PictureView);
                }
            }
        };
        jMenuItem6.addActionListener(actionListener6);
        if (this.popUpSerien) {
            jPopupMenu.add(jMenuItem6);
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private int getColCount() {
        if (this.indexViewCollection.getSize() == 0) {
            return 0;
        }
        int n = 0;
        Dimension dimension = this.getPreferredSizePictureView();
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        n = rectangle.width / (dimension.width + 10);
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    private int getRowCount() {
        int n = this.getColCount();
        if (n == 0) {
            return 0;
        }
        int n2 = this.indexViewCollection.getSize();
        return n2 % n == 0 ? n2 / n : n2 / n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintViewPort(int n) {
        Object object = token;
        synchronized (object) {
            if (n < 0) {
                n = this.getFirstPaintedIndex();
            }
            int n2 = this.getColCount();
            int n3 = this.getRowCount();
            this.setPreferredSizeIndexView(n2, n3);
            this.viewPortPosition = this.indexToPosition(n, n2, n3);
            this.indexViewPort.setViewPosition(this.viewPortPosition);
            this._paintViewPort(n2, n3);
        }
    }

    private void paintViewPort(Point point) {
        int n = this.getColCount();
        int n2 = this.getRowCount();
        this.setPreferredSizeIndexView(n, n2);
        this.positionToIndex(point, n, n2);
        this._paintViewPort(n, n2);
    }

    private int getFirstPaintedIndex() {
        int n = 0;
        if (this.firstPaintedPicture != null) {
            if (this.hasPicture(this.firstPaintedPicture)) {
                n = this.indexViewCollection.getPictureIndex(this.firstPaintedPicture);
            } else {
                this.firstPaintedPicture = this.indexViewCollection.getPreviousPicture(this.firstPaintedPicture);
                if (this.firstPaintedPicture != null) {
                    n = this.indexViewCollection.getPictureIndex(this.firstPaintedPicture);
                }
            }
        }
        return n;
    }

    public int getPictureIndex(PM_Picture pM_Picture) {
        return this.indexViewCollection.getPictureIndex(pM_Picture);
    }

    public Dimension getPreferredSizePictureView() {
        return new Dimension(this.sliderValue + 12, this.sliderValue + 12 + 18);
    }

    private void paintViewPort(MouseWheelEvent mouseWheelEvent) {
        int n = this.getColCount();
        int n2 = this.getRowCount();
        int n3 = this.indexViewCollection.getSize();
        if (n3 == 0 || n == 0) {
            return;
        }
        int n4 = this.getPreferredSizePictureView().height + 10;
        int n5 = mouseWheelEvent.getWheelRotation() * n4 + this.viewPortPosition.y;
        n5 = n5 + this.viewPortExtentSize.height > this.preferredSizeIndexView.height ? this.preferredSizeIndexView.height - this.viewPortExtentSize.height : n5;
        n5 = n5 < 0 ? 0 : n5;
        this.viewPortPosition = new Point(0, n5);
        this.indexViewPort.setViewPosition(this.viewPortPosition);
        this._paintViewPort(n, n2);
    }

    private void setPreferredSizeIndexView(int n, int n2) {
        Dimension dimension = this.getPreferredSizePictureView();
        this.preferredSizeIndexView = new Dimension(n * dimension.width + 10, n2 * (dimension.height + 10) + 10);
        this.setPreferredSize(this.preferredSizeIndexView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _paintViewPort(int n, int n2) {
        Dimension dimension = this.getPreferredSizePictureView();
        this.firstPaintedPicture = null;
        this.removeAll();
        this.repaint();
        Rectangle rectangle = new Rectangle(this.indexViewPort.getExtentSize());
        rectangle.x = this.indexViewPort.getViewPosition().x;
        rectangle.y = this.indexViewPort.getViewPosition().y;
        int n3 = -1;
        for (PM_Picture object2 : this.indexViewCollection.getPictureList()) {
            PM_PictureView pM_PictureView;
            Rectangle rectangle2;
            if ((rectangle2 = this.getBounds(++n3, n, n2, dimension)).intersects(rectangle)) {
                if (this.firstPaintedPicture == null) {
                    this.firstPaintedPicture = object2;
                }
                pM_PictureView = this.getPictureView(object2);
                pM_PictureView.setPictureViewPreferredSize(dimension);
                pM_PictureView.setBounds(rectangle2);
                this.add(pM_PictureView);
                if (pM_PictureView.getPicture().hasImageThumbnail()) continue;
                List<PM_PictureView> list = thumbsToRead;
                synchronized (list) {
                    thumbsToRead.add(pM_PictureView);
                    continue;
                }
            }
            if (!this.hasPictureView(object2) || this.indexViewCollection.isPictureViewSelected(pM_PictureView = this.getPictureView(object2))) continue;
            this.indexViewCollection.removePictureView(object2);
        }
        this.indexViewPort.repaint();
        this.indexViewPort.validate();
        Object object = this.lesethread;
        synchronized (object) {
            this.lesethread.notify();
        }
    }

    private int positionToIndex(Point point, int n, int n2) {
        Dimension dimension = this.getPreferredSizePictureView();
        int n3 = point.y / (dimension.height + 10) * n;
        return n3;
    }

    private Point indexToPosition(int n, int n2, int n3) {
        int n4 = this.indexViewCollection.getSize();
        if (n4 == 0 || n == 0 || n2 == 0 || n >= n4) {
            return new Point(0, 0);
        }
        int n5 = ++n % n2 == 0 ? n / n2 : n / n2 + 1;
        n5 = --n5 <= 0 ? 0 : n5;
        Dimension dimension = this.getPreferredSizePictureView();
        int n6 = n5 * (dimension.height + 10) + 10;
        return new Point(0, n6);
    }

    private Rectangle getBounds(int n, int n2, int n3, Dimension dimension) {
        int n4;
        Rectangle rectangle = new Rectangle();
        int n5 = this.indexViewCollection.getSize();
        if (n >= n5) {
            return rectangle;
        }
        int n6 = (n + 1) / n2;
        if ((n + 1) % n2 != 0) {
            ++n6;
        }
        if ((n4 = (n + 1) % n2) == 0) {
            n4 = n2;
        }
        rectangle.x = --n4 * (dimension.width + 10) + 10;
        rectangle.y = --n6 * (dimension.height + 10) + 10;
        rectangle.width = dimension.width + 10;
        rectangle.height = dimension.height + 10;
        return rectangle;
    }

    private class ReadThumbsThread
    extends Thread {
        private ReadThumbsThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                PM_PictureView pM_PictureView = null;
                Object object = thumbsToRead;
                synchronized (object) {
                    if (!thumbsToRead.isEmpty()) {
                        pM_PictureView = thumbsToRead.get(0);
                    }
                }
                if (pM_PictureView != null) {
                    object = pM_PictureView.getPicture().getImageThumbnail();
                    pM_PictureView.repaint();
                    object = null;
                    List<PM_PictureView> list = thumbsToRead;
                    synchronized (list) {
                        thumbsToRead.remove(pM_PictureView);
                    }
                }
                try {
                    object = PM_IndexView.this.lesethread;
                    synchronized (object) {
                        PM_IndexView.this.lesethread.wait(5000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

