/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pm.gui.PM_WindowDialogBase;
import pm.picture.PM_MetadataContainer;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_Utils;

public class PM_WindowDialogBackupBilder
extends PM_WindowDialogBase
implements PM_Interface {
    private static final long serialVersionUID = 1L;
    private PM_Configuration einstellungen;
    private File fileBilderDir;
    private String pathFileBilderdir;
    private int bilderGesamt = 0;
    private File fileHomeBilder;
    private String pathHomeBilder;
    private PM_WindowDialogBase.ZeilenPanel pruefen = new PM_WindowDialogBase.ZeilenPanel(this, "Bilder. Pr\u00fcfen l\u00f6schen/neu", false);
    private PM_WindowDialogBase.ZeilenPanel dateienLoeschen = new PM_WindowDialogBase.ZeilenPanel(this, "Dateien l\u00f6schen", true);
    private PM_WindowDialogBase.ZeilenPanel dateienNeu = new PM_WindowDialogBase.ZeilenPanel(this, "neue Dateien \u00fcbertragen", true);
    private PM_WindowDialogBase.ZeilenPanel dateienUeberschreiben = new PM_WindowDialogBase.ZeilenPanel(this, "vorhandene Dateien \u00fcberschreiben", true);
    private PM_WindowDialogBase.ZeilenPanel fertig = new PM_WindowDialogBase.ZeilenPanel(this, "fertig", false);
    private List<File> listeDateienLoeschen = new ArrayList<File>();
    private List<File> listeDateienNeu = new ArrayList<File>();
    private List<File> listeDateienUeberschreiben = new ArrayList<File>();

    public PM_WindowDialogBackupBilder(PM_Configuration.BackUp backUp) {
        this.fileBilderDir = backUp.getFileDirTo();
        this.pathFileBilderdir = this.fileBilderDir.getAbsolutePath();
        if (!this.pathFileBilderdir.endsWith(File.separator)) {
            this.pathFileBilderdir = this.pathFileBilderdir + File.separator;
        }
        this.einstellungen = PM_Configuration.getInstance();
        this.bilderGesamt = PM_MetadataContainer.getInstance().getPictureSizeValid();
        this.fileHomeBilder = this.einstellungen.getTopLevelPictureDirectory();
        this.pathHomeBilder = this.einstellungen.getTopLevelPictureDirectory().getAbsolutePath();
        if (!this.pathHomeBilder.endsWith(File.separator)) {
            this.pathHomeBilder = this.pathHomeBilder + File.separator;
        }
    }

    public boolean init() {
        File file = new File(this.pathFileBilderdir + "pm_metadaten_root");
        if (!file.isDirectory()) {
            JOptionPane.showConfirmDialog(this, "Fehler:\nbilder-dir = " + this.pathFileBilderdir + "\nVerzeichnis '" + "pm_metadaten_root" + "' nicht vorhanden", "Keine gefunden", -1, 0);
            return false;
        }
        return true;
    }

    private void pruefen(PM_Listener pM_Listener) {
        this.lesenDateienLoeschen(this.fileBilderDir);
        this.lesenDateienNeuUeberschreiben(this.einstellungen.getTopLevelPictureDirectory());
    }

    private void lesenDateienLoeschen(File file) {
        if (file.isDirectory() && file.getName().equals("pm_temp")) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (file.getName().equals("pm_metadaten_root")) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.getName().equals("pm_sequenzen.xml")) continue;
                this.addFileToListeDateiLoeschen(file2);
            }
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (file3.isDirectory()) {
                this.lesenDateienLoeschen(file3);
                continue;
            }
            this.addFileToListeDateiLoeschen(file3);
        }
    }

    private void addFileToListeDateiLoeschen(File file) {
        if (!file.isFile()) {
            return;
        }
        String string = PM_Utils.getRelativePath(this.fileBilderDir, file);
        File file2 = new File(this.pathHomeBilder + string);
        if (!file2.isFile()) {
            this.listeDateienLoeschen.add(file);
        }
    }

    private void lesenDateienNeuUeberschreiben(File file) {
        if (file.isDirectory() && file.getName().equals("pm_temp")) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (file.getName().equals("pm_metadaten_root")) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.getName().equals("pm_sequenzen.xml")) continue;
                this.addFileToListeDateiNeuUeberschreiben(file2);
            }
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (file3.isDirectory()) {
                this.lesenDateienNeuUeberschreiben(file3);
                continue;
            }
            this.addFileToListeDateiNeuUeberschreiben(file3);
        }
    }

    private void addFileToListeDateiNeuUeberschreiben(File file) {
        if (!file.isFile()) {
            return;
        }
        String string = PM_Utils.getRelativePath(this.fileHomeBilder, file);
        File file2 = new File(this.pathFileBilderdir + string);
        if (!file2.isFile()) {
            this.listeDateienNeu.add(file2);
        } else if (file.lastModified() != file2.lastModified()) {
            this.listeDateienUeberschreiben.add(file2);
        }
    }

    private void loeschen(PM_Listener pM_Listener) {
        for (File file : this.listeDateienLoeschen) {
            pM_Listener.actionPerformed(new PM_Action(null));
            file.delete();
        }
    }

    private void neu(PM_Listener pM_Listener) {
        for (File file : this.listeDateienNeu) {
            pM_Listener.actionPerformed(new PM_Action(null));
            this.copyFile(file);
        }
    }

    private void ueberschreiben(PM_Listener pM_Listener) {
        for (File file : this.listeDateienUeberschreiben) {
            pM_Listener.actionPerformed(new PM_Action(null));
            this.copyFile(file);
        }
    }

    private void copyFile(File file) {
        String string = PM_Utils.getRelativePath(this.fileBilderDir, file);
        File file2 = new File(this.pathHomeBilder + string);
        file.getParentFile().mkdirs();
        PM_Utils.copyFile(file2, file);
        file.setLastModified(file2.lastModified());
    }

    protected void setZeilen(JPanel jPanel) {
        jPanel.add(this.pruefen);
        jPanel.add(this.dateienLoeschen);
        jPanel.add(this.dateienNeu);
        jPanel.add(this.dateienUeberschreiben);
        jPanel.add(this.fertig);
    }

    protected void goDialog(JDialog jDialog, int n, PM_Listener pM_Listener) {
        switch (n) {
            case 1: {
                this.pruefen.start();
                this.setAnzahl(this.bilderGesamt);
                this.pruefen(pM_Listener);
                this.dateienLoeschen.setAnzahl(this.listeDateienLoeschen.size());
                this.dateienNeu.setAnzahl(this.listeDateienNeu.size());
                this.dateienUeberschreiben.setAnzahl(this.listeDateienUeberschreiben.size());
                this.pruefen.stop();
                break;
            }
            case 2: {
                if (this.listeDateienLoeschen.size() > 0 || this.listeDateienNeu.size() > 0 || this.listeDateienUeberschreiben.size() > 0) {
                    // empty if block
                }
                this.setAnzahl(this.listeDateienLoeschen.size());
                this.dateienLoeschen.start();
                this.loeschen(pM_Listener);
                this.dateienLoeschen.stop();
                this.setAnzahl(this.listeDateienNeu.size());
                this.dateienNeu.start();
                this.neu(pM_Listener);
                this.dateienNeu.stop();
                this.setAnzahl(this.listeDateienUeberschreiben.size());
                this.dateienUeberschreiben.start();
                this.ueberschreiben(pM_Listener);
                this.dateienUeberschreiben.stop();
                this.fertig.start();
                this.fertig.stop();
                break;
            }
            case 3: {
                jDialog.dispose();
            }
        }
    }
}

