/*
 * Decompiled with CFR 0.152.
 */
package pm.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import pm.gui.PM_IndexView;
import pm.gui.PM_WindowDialogBackupBilder;
import pm.gui.PM_WindowDialogBackupDaten;
import pm.gui.PM_WindowDialogGetLocale;
import pm.gui.PM_WindowMain;
import pm.inout.PM_SequencesInout;
import pm.picture.PM_DoublePictures;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.search.PM_DatabaseLucene;
import pm.search.PM_Search;
import pm.search.PM_SearchExpr;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_WindowMainMenu
implements PM_Interface {
    private PM_WindowMain windowMain;
    private JMenuBar menuBar;
    private PM_Configuration einstellungen;
    private JMenu menuDatei;
    private JMenu menuSuchen;
    private JMenu menuLoeschen;
    private JMenu menuExtras;
    private JMenu menuInfo;
    private JMenuItem miClose;
    private JMenuItem menuItemDoppelte;
    private JMenuItem menuItemOhneIndex1;
    private JMenuItem menuItemOhneIndex2;
    private JMenuItem menuItemOhneSerien;
    private JMenuItem menuItemLoeschenIndex1;
    private JMenuItem menuItemLoeschenIndex2;
    private JMenuItem menuItemLoeschenSeq;
    private JMenuItem menuItemLoeschenMeta;
    private JMenuItem menuItemFlush;
    private JMenuItem menuItemIndizieren;
    private JMenuItem menuItemLanguage;
    private JMenuItem menuItemInfoEinstellungen;
    private JMenuItem menuItemInfoAbout;
    private static final Comparator<PM_Picture> ORDER_TIME = new Comparator<PM_Picture>(){

        @Override
        public int compare(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
            Long l = pM_Picture.meta.getDateCurrent().getTime();
            Long l2 = pM_Picture2.meta.getDateCurrent().getTime();
            return l.compareTo(l2);
        }
    };

    public PM_WindowMainMenu(PM_WindowMain pM_WindowMain) {
        this.windowMain = pM_WindowMain;
        this.einstellungen = PM_Configuration.getInstance();
        this.init();
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                PM_WindowMainMenu.this.setMsg();
            }
        };
        PM_MSG.addChangeListener(pM_Listener);
        this.setMsg();
    }

    private void setMsg() {
        this.menuDatei.setText(PM_MSG.getMsg("menuFile"));
        this.miClose.setText(PM_MSG.getMsg("miClose"));
        this.menuSuchen.setText(PM_MSG.getMsg("menuSearch"));
        this.menuItemDoppelte.setText(PM_MSG.getMsg("miDouble"));
        this.menuItemOhneIndex1.setText(PM_MSG.getMsg("miNotIndx1"));
        this.menuItemOhneIndex2.setText(PM_MSG.getMsg("miNotIndx2"));
        this.menuItemOhneSerien.setText(PM_MSG.getMsg("miNotSequ"));
        this.menuLoeschen.setText(PM_MSG.getMsg("menuDelete"));
        this.menuItemLoeschenIndex1.setText(PM_MSG.getMsg("miDelAllIndx1"));
        this.menuItemLoeschenIndex2.setText(PM_MSG.getMsg("miDelAllIndx2"));
        this.menuItemLoeschenSeq.setText(PM_MSG.getMsg("miDelAllSequ"));
        this.menuExtras.setText(PM_MSG.getMsg("menuExtra"));
        this.menuItemFlush.setText(PM_MSG.getMsg("miFlush"));
        this.menuItemIndizieren.setText(PM_MSG.getMsg("miLucene"));
        this.menuItemLanguage.setText(PM_MSG.getMsg("miLanguage"));
        this.menuItemLoeschenMeta.setText(PM_MSG.getMsg("miUninstall"));
        this.menuInfo.setText(PM_MSG.getMsg("menuInfo"));
        this.menuItemInfoEinstellungen.setText(PM_MSG.getMsg("miPref"));
        this.menuItemInfoAbout.setText(PM_MSG.getMsg("miAbout"));
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private void init() {
        Object object;
        Object object2;
        Object object3;
        this.menuBar = new JMenuBar();
        this.menuDatei = new JMenu("Datei");
        this.menuSuchen = new JMenu("Suchen");
        this.menuLoeschen = new JMenu("L\u00f6schen");
        this.menuExtras = new JMenu("Extras");
        this.menuInfo = new JMenu("PM-Info");
        this.miClose = new JMenuItem("Beenden");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMainMenu.this.windowMain.close();
            }
        };
        this.miClose.addActionListener(actionListener);
        this.menuDatei.add(this.miClose);
        this.menuItemDoppelte = new JMenuItem("doppelte Bilder");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMainMenu.this.doDoppelteBilder();
            }
        };
        this.menuItemDoppelte.addActionListener(actionListener2);
        this.menuSuchen.add(this.menuItemDoppelte);
        String string = "Bilder ohne Index 1";
        this.menuItemOhneIndex1 = new JMenuItem(string);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMainMenu.this.doOhneIndex1();
            }
        };
        this.menuItemOhneIndex1.addActionListener(actionListener3);
        this.menuSuchen.add(this.menuItemOhneIndex1);
        String string2 = "Bilder ohne Index 2";
        this.menuItemOhneIndex2 = new JMenuItem(string2);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMainMenu.this.doOhneIndex2();
            }
        };
        this.menuItemOhneIndex2.addActionListener(actionListener4);
        this.menuSuchen.add(this.menuItemOhneIndex2);
        this.menuItemOhneSerien = new JMenuItem("Basis-Serien: nicht zugeordnete Bilder suchen");
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMainMenu.this.doOhneSequenzen();
            }
        };
        this.menuItemOhneSerien.addActionListener(actionListener5);
        this.menuSuchen.add(this.menuItemOhneSerien);
        this.menuItemLoeschenIndex1 = new JMenuItem("l\u00f6schen alle Index 1");
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMainMenu.this.deleteIndex(PM_Interface.IndexType.INDEX_1);
            }
        };
        this.menuItemLoeschenIndex1.addActionListener(actionListener6);
        this.menuLoeschen.add(this.menuItemLoeschenIndex1);
        this.menuItemLoeschenIndex2 = new JMenuItem("l\u00f6schen alle Index-2");
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMainMenu.this.deleteIndex(PM_Interface.IndexType.INDEX_2);
            }
        };
        this.menuItemLoeschenIndex2.addActionListener(actionListener7);
        this.menuLoeschen.add(this.menuItemLoeschenIndex2);
        this.menuItemLoeschenSeq = new JMenuItem("l\u00f6schen alle Serien");
        ActionListener actionListener8 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMainMenu.this.doLoeschenSeq();
            }
        };
        this.menuItemLoeschenSeq.addActionListener(actionListener8);
        this.menuLoeschen.add(this.menuItemLoeschenSeq);
        this.menuItemInfoEinstellungen = new JMenuItem("Einstellungen");
        ActionListener actionListener9 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                PM_Configuration pM_Configuration = PM_Configuration.getInstance();
                String string2 = pM_Configuration.getTopLevelPictureDirectory().getPath();
                Properties properties = System.getProperties();
                string = string + "PM-Version = " + PM_Utils.getPmVersion();
                string = string + "\n";
                string = string + "\nBilder-Verzeichnis = " + string2;
                string = string + "\nEinstellungen = " + pM_Configuration.getFileEinstellungen().getPath();
                string = string + "\n";
                string = string + "\nJAVA-Runtime-Version =  " + PM_Utils.getPropertyString(properties, "java.version");
                string = string + "\nJAVA-Compiler-Version =  " + PM_Utils.getCompilerVersion() + " (compiliert am  =  " + PM_Utils.getDateCompiled() + ")";
                string = string + "\n";
                string = string + "\nuser.dir =  " + PM_Utils.getPropertyString(properties, "user.dir");
                string = string + "\nuser.home =  " + PM_Utils.getPropertyString(properties, "user.home");
                string = string + "\nawt.multiClickInterval =  " + Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval") + " ms";
                string = string + "\nVerzeichnis 'pm_temp' = " + pM_Configuration.getFileHomeTemp().getPath();
                JOptionPane.showConfirmDialog(null, string, "Info", -1, 1);
            }
        };
        this.menuItemInfoEinstellungen.addActionListener(actionListener9);
        this.menuInfo.add(this.menuItemInfoEinstellungen);
        JMenuItem jMenuItem = new JMenuItem("Help");
        ActionListener actionListener10 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = PM_MSG.getMsg("menuHelp1") + PM_MSG.getMsg("menuHelp2") + PM_MSG.getMsg("menuHelp3") + PM_MSG.getMsg("menuHelp4") + PM_MSG.getMsg("menuHelp5");
                JOptionPane.showConfirmDialog(null, string, "Help", -1, 1);
            }
        };
        jMenuItem.addActionListener(actionListener10);
        this.menuInfo.add(jMenuItem);
        this.menuItemInfoAbout = new JMenuItem("\u00dcber Photomanager");
        ActionListener actionListener11 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = String.format(PM_MSG.getMsg("aboutTxt"), PM_Utils.getPmVersion(), PM_MSG.getMsg("eMail"));
                JOptionPane.showConfirmDialog(null, string, PM_MSG.getMsg("miAbout"), -1, 1);
            }
        };
        this.menuItemInfoAbout.addActionListener(actionListener11);
        this.menuInfo.add(this.menuItemInfoAbout);
        this.menuItemFlush = new JMenuItem("Metadaten sichern");
        ActionListener actionListener12 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_MetadataContainer.getInstance().flush();
                PM_DatabaseLucene.getInstance().flush();
                PM_SequencesInout.getInstance().setChanged(true);
                PM_SequencesInout.getInstance().flush();
            }
        };
        this.menuItemFlush.addActionListener(actionListener12);
        this.menuExtras.add(this.menuItemFlush);
        this.menuItemIndizieren = new JMenuItem("Datenbank neu erstellen");
        ActionListener actionListener13 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_DatabaseLucene.getInstance().alleLuceneEintraegeNeuErstellen();
            }
        };
        this.menuItemIndizieren.addActionListener(actionListener13);
        this.menuExtras.add(this.menuItemIndizieren);
        this.menuItemLanguage = new JMenuItem("Sprache einstellen");
        this.menuExtras.add(this.menuItemLanguage);
        ActionListener actionListener14 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Locale locale = new PM_WindowDialogGetLocale(PM_MSG.getLocale()).getLocale();
                PM_Configuration.getInstance().setLocale(locale);
            }
        };
        this.menuItemLanguage.addActionListener(actionListener14);
        this.menuExtras.add(this.menuItemLanguage);
        this.menuExtras.addSeparator();
        this.menuItemLoeschenMeta = new JMenuItem("Uninstall");
        ActionListener actionListener15 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PM_WindowMainMenu.this.doLoeschenMeta();
            }
        };
        this.menuItemLoeschenMeta.addActionListener(actionListener15);
        this.menuExtras.add(this.menuItemLoeschenMeta);
        List<PM_Configuration.BackUp> list = this.einstellungen.getBackupBilderList();
        if (list.size() != 0) {
            this.menuExtras.addSeparator();
            object3 = new JMenu("sichern Bilder");
            this.menuExtras.add((JMenuItem)object3);
            object2 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("   action" + actionEvent.getActionCommand());
                    List<PM_Configuration.BackUp> list = PM_WindowMainMenu.this.einstellungen.getBackupBilderList();
                    for (PM_Configuration.BackUp backUp : list) {
                        if (!backUp.getName().equals(actionEvent.getActionCommand())) continue;
                        PM_WindowMainMenu.this.doBackupBilder(backUp);
                    }
                }
            };
            for (PM_Configuration.BackUp object4 : list) {
                object = new JMenuItem(object4.getName());
                ((AbstractButton)object).addActionListener((ActionListener)object2);
                ((JMenu)object3).add((JMenuItem)object);
            }
        }
        if ((object3 = this.einstellungen.getBackupDatenList()).size() != 0) {
            if (list.isEmpty()) {
                this.menuExtras.addSeparator();
            }
            object2 = new JMenu("sichern Daten");
            this.menuExtras.add((JMenuItem)object2);
            ActionListener actionListener16 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println("   action" + actionEvent.getActionCommand());
                    List<PM_Configuration.BackUp> list = PM_WindowMainMenu.this.einstellungen.getBackupDatenList();
                    for (PM_Configuration.BackUp backUp : list) {
                        if (!backUp.getName().equals(actionEvent.getActionCommand())) continue;
                        PM_WindowMainMenu.this.doBackupDaten(backUp);
                    }
                }
            };
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (PM_Configuration.BackUp)iterator.next();
                JMenuItem jMenuItem2 = new JMenuItem(((PM_Configuration.BackUp)object).getName());
                jMenuItem2.addActionListener(actionListener16);
                ((JMenu)object2).add(jMenuItem2);
            }
        }
        this.menuBar.add(this.menuDatei);
        this.menuBar.add(this.menuSuchen);
        this.menuBar.add(this.menuLoeschen);
        this.menuBar.add(this.menuExtras);
        this.menuBar.add(this.menuInfo);
    }

    public void doDoppelteBilder() {
        PM_DoublePictures pM_DoublePictures = new PM_DoublePictures(this.windowMain);
        pM_DoublePictures.doppelteBilderErmitteln();
        int n = pM_DoublePictures.getAnzGesamt();
        int n2 = pM_DoublePictures.getAnzDoppelt();
        int n3 = pM_DoublePictures.getAnzDreifach();
        int n4 = pM_DoublePictures.getAnzVierfachPlus();
        List<PM_Picture> list = pM_DoublePictures.getAlleFiles();
        if (n == 0) {
            JOptionPane.showConfirmDialog(null, PM_MSG.getMsg("doubleNotFound"), PM_MSG.getMsg("doubleSearch"), -1, 1);
            return;
        }
        String string = String.format(PM_MSG.getMsg("doubleFound"), Integer.toString(n2), Integer.toString(n3), Integer.toString(n4));
        int n5 = JOptionPane.showConfirmDialog(this.windowMain, string, PM_MSG.getMsg("doubleSearch"), 0, 3);
        if (n5 == 1) {
            return;
        }
        PM_IndexView pM_IndexView = this.windowMain.getWindowThumbnails().getIndexView();
        pM_IndexView.setAndPaintPictureList(list);
    }

    private void doOhneIndex1() {
        PM_Search pM_Search = new PM_Search(new PM_SearchExpr(PM_Interface.SearchType.NO_INDEX_1));
        pM_Search.search();
        this.doSearchNoIndices(pM_Search.getPictureList(PM_Interface.SearchSortType.NOTHING), "Index 1");
    }

    private void doOhneIndex2() {
        PM_Search pM_Search = new PM_Search(new PM_SearchExpr(PM_Interface.SearchType.NO_INDEX_2));
        pM_Search.search();
        this.doSearchNoIndices(pM_Search.getPictureList(PM_Interface.SearchSortType.NOTHING), "Index 2");
    }

    private void doOhneSequenzen() {
        PM_MetadataContainer.getInstance().flush();
        List<Object> list = new ArrayList();
        list = PM_MetadataContainer.getInstance().bilderOhneSequenzen();
        if (list.size() == 0) {
            JOptionPane.showConfirmDialog(this.windowMain, PM_MSG.getMsg("allPicsInSequ"), PM_MSG.getMsg("noSequSearch"), -1, 0);
            return;
        }
        String string = String.format(PM_MSG.getMsg("notAllPicsInSequ"), Integer.toString(list.size()));
        int n = JOptionPane.showConfirmDialog(this.windowMain, string, PM_MSG.getMsg("noSequSearch"), 0, 3);
        if (n == 1) {
            return;
        }
        Collections.sort(list, ORDER_TIME);
        PM_IndexView pM_IndexView = this.windowMain.getWindowThumbnails().getIndexView();
        pM_IndexView.setAndPaintPictureList(list);
    }

    private void doSearchNoIndices(List<PM_Picture> list, String string) {
        String string2 = String.format(PM_MSG.getMsg("indSearch"), string);
        if (list.size() == 0) {
            String string3 = String.format(PM_MSG.getMsg("indSearchNotFound"), string);
            JOptionPane.showConfirmDialog(this.windowMain, string3, string2, -1, 0);
            return;
        }
        String string4 = String.format(PM_MSG.getMsg("indSearchFound"), Integer.toString(list.size()));
        int n = JOptionPane.showConfirmDialog(this.windowMain, string4, string2, 0, 3);
        if (n == 1) {
            return;
        }
        PM_IndexView pM_IndexView = this.windowMain.getWindowThumbnails().getIndexView();
        pM_IndexView.setAndPaintPictureList(list);
    }

    private void doBackupDaten(PM_Configuration.BackUp backUp) {
        File file = backUp.getFileDirFrom();
        File file2 = backUp.getFileDirTo();
        if (!file.isDirectory()) {
            JOptionPane.showConfirmDialog(this.windowMain, "In Datei Einstellungen:\nfrom   '" + file.getAbsolutePath() + "'    kein Directory", "Dir nigefu", -1, 0);
            return;
        }
        if (!file2.isDirectory()) {
            JOptionPane.showConfirmDialog(this.windowMain, "In Datei Einstellungen:\nto   '" + file2.getAbsolutePath() + "'    kein Directory", "Dir nigefu", -1, 0);
            return;
        }
        String string = backUp.getName();
        int n = JOptionPane.showConfirmDialog(this.windowMain, "Daten sichern?\nname = " + string + "\nfrom = " + file.getAbsolutePath() + "\nto = " + file2.getAbsolutePath(), "Sicherheitsabfrage", 0, 3);
        if (n == 1) {
            return;
        }
        this.windowMain.getWindowRechts().getWindowSelected().requestToChange();
        PM_MetadataContainer.getInstance().flush();
        PM_WindowDialogBackupDaten pM_WindowDialogBackupDaten = new PM_WindowDialogBackupDaten(backUp);
        if (!pM_WindowDialogBackupDaten.init()) {
            return;
        }
        pM_WindowDialogBackupDaten.start();
    }

    private void doBackupBilder(PM_Configuration.BackUp backUp) {
        File file = backUp.getFileDirTo();
        if (!file.isDirectory()) {
            JOptionPane.showConfirmDialog(this.windowMain, "In Datei Einstellungen:\nbilder-dir   '" + file.getAbsolutePath() + "'    kein Directory", "Keine gefunden", -1, 0);
            return;
        }
        String string = backUp.getName();
        int n = JOptionPane.showConfirmDialog(this.windowMain, "Bilder sichern?\nname = " + string + "\nfrom = " + PM_Configuration.getInstance().getTopLevelPictureDirectory().getPath() + "\nto = " + file.getAbsolutePath(), "Sicherheitsabfrage", 0, 3);
        if (n == 1) {
            return;
        }
        this.windowMain.getWindowRechts().getWindowSelected().requestToChange();
        PM_MetadataContainer.getInstance().flush();
        PM_WindowDialogBackupBilder pM_WindowDialogBackupBilder = new PM_WindowDialogBackupBilder(backUp);
        if (!pM_WindowDialogBackupBilder.init()) {
            return;
        }
        pM_WindowDialogBackupBilder.start();
    }

    private void deleteIndex(PM_Interface.IndexType indexType) {
        String string = indexType == PM_Interface.IndexType.INDEX_1 ? PM_MSG.getMsg("index1") : PM_MSG.getMsg("index2");
        int n = JOptionPane.showConfirmDialog(this.windowMain, String.format(PM_MSG.getMsg("wantDeleteInd"), string), String.format(PM_MSG.getMsg("deleteInd"), string), 0, 3);
        if (n == 1) {
            return;
        }
        PM_MetadataContainer.getInstance().deleteIndex(indexType);
        PM_DatabaseLucene.getInstance().alleLuceneEintraegeNeuErstellen();
    }

    private void doLoeschenSeq() {
        int n = JOptionPane.showConfirmDialog(this.windowMain, PM_MSG.getMsg("wantDeleteSequ"), PM_MSG.getMsg("deleteAllSequ"), 0, 3);
        if (n == 1) {
            return;
        }
        PM_MetadataContainer.getInstance().alleSequenzenLoeschen();
        PM_DatabaseLucene.getInstance().alleLuceneEintraegeNeuErstellen();
    }

    private void doLoeschenMeta() {
        int n = JOptionPane.showConfirmDialog(this.windowMain, PM_MSG.getMsg("wantUninstall1"), PM_MSG.getMsg("miUninstall"), 0, 3);
        if (n == 1) {
            return;
        }
        n = JOptionPane.showConfirmDialog(this.windowMain, PM_MSG.getMsg("wantUninstall2"), PM_MSG.getMsg("miUninstall"), 0, 3);
        if (n == 1) {
            return;
        }
        File file = this.einstellungen.getTopLevelPictureDirectory();
        this.deleteMeta(file);
        JOptionPane.showConfirmDialog(null, PM_MSG.getMsg("doneUninstall"), PM_MSG.getMsg("miUninstall"), -1, 1);
        System.exit(0);
    }

    private void deleteMeta(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory() && file2.getName().equals("pm.metadaten")) {
                PM_Utils.deleteDirectory(file2);
            }
            if (file2.isDirectory() && file2.getName().equals("pm_metadaten_root")) {
                PM_Utils.deleteDirectory(file2);
            }
            if (file2.isDirectory() && file2.getName().equals("pm_temp")) {
                PM_Utils.deleteDirectory(file2);
            }
            if (!file2.isDirectory()) continue;
            this.deleteMeta(file2);
        }
    }
}

