/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.swing.tree.DefaultMutableTreeNode;
import pm.gui.PM_WindowDialogImport;
import pm.gui.PM_WindowImport;
import pm.gui.PM_WindowMain;
import pm.inout.PM_SequencesInout;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureDirectory;
import pm.search.PM_DatabaseLucene;
import pm.sequence.PM_SequenceNew;
import pm.sequence.PM_TreeModelNew;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_ListenerX;
import pm.utilities.PM_MSG;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PM_Import {
    protected Lock lock;
    protected PM_WindowDialogImport dialogImport;
    protected PM_ListenerX listener;
    private static Set<PM_Listener> importListeners = new HashSet<PM_Listener>();

    public static void addImportListener(PM_Listener pM_Listener) {
        importListeners.add(pM_Listener);
    }

    public void fireImportListener() {
        for (PM_Listener pM_Listener : importListeners) {
            pM_Listener.actionPerformed(new PM_Action(null));
        }
    }

    public PM_Import(PM_Interface.Import import_) {
        this.dialogImport = new PM_WindowDialogImport(import_);
        this.listener = this.dialogImport.getListener();
        this.lock = this.dialogImport.getLock();
    }

    protected List<File> getNewDouble(List<File> list, PM_ListenerX pM_ListenerX) {
        List<Object> list2;
        HashMap hashMap = new HashMap();
        for (File arrayList2 : list) {
            long l = arrayList2.length();
            list2 = null;
            if (hashMap.containsKey(l)) {
                list2 = (List)hashMap.get(l);
                list2.add(arrayList2);
                continue;
            }
            list2 = new ArrayList<File>();
            list2.add(arrayList2);
            hashMap.put(l, list2);
        }
        ArrayList arrayList3 = new ArrayList();
        for (Long l : hashMap.keySet()) {
            List list3;
            if (pM_ListenerX != null) {
                int n = ((List)hashMap.get(l)).size();
                pM_ListenerX.actionPerformed(new PM_Action(null, n));
            }
            if ((list3 = (List)hashMap.get(l)).size() == 1) {
                arrayList3.add(list3.get(0));
                continue;
            }
            list2 = this.getMD5(list3);
            HashSet hashSet = new HashSet(list2);
            for (String string : hashSet) {
                arrayList3.add(list3.get(list2.indexOf(string)));
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>(list);
        arrayList.removeAll(arrayList3);
        return arrayList;
    }

    protected List<File> getKnownPictures(List<File> list, PM_ListenerX pM_ListenerX) {
        HashMap hashMap = new HashMap();
        for (File arrayList2 : list) {
            long l = arrayList2.length();
            Object list3 = null;
            if (hashMap.containsKey(l)) {
                List list2 = (List)hashMap.get(l);
                list2.add(arrayList2);
                continue;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            arrayList.add(arrayList2);
            hashMap.put(l, arrayList);
        }
        HashMap hashMap2 = new HashMap();
        for (PM_PictureDirectory pM_PictureDirectory : PM_MetadataContainer.getInstance().getPictureDirectories()) {
            for (File file : pM_PictureDirectory.getOrigValidFiles()) {
                long l = file.length();
                List<File> list3 = null;
                if (hashMap2.containsKey(l)) {
                    list3 = (List)hashMap2.get(l);
                    list3.add(file);
                    continue;
                }
                list3 = new ArrayList<File>();
                list3.add(file);
                hashMap2.put(l, list3);
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Object object : hashMap.keySet()) {
            if (pM_ListenerX != null) {
                int n = ((List)hashMap.get(object)).size();
                pM_ListenerX.actionPerformed(new PM_Action(null, n));
            }
            if (!hashMap2.containsKey(object)) continue;
            List list4 = (List)hashMap.get(object);
            List<String> list5 = this.getMD5((List)hashMap2.get(object));
            List<String> list6 = this.getMD5(list4);
            int n = -1;
            block4: for (File file : list4) {
                String string = list6.get(++n);
                for (String string2 : list5) {
                    if (!string.equals(string2)) continue;
                    arrayList.add(file);
                    continue block4;
                }
            }
        }
        return arrayList;
    }

    private List<String> getMD5(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : list) {
            arrayList.add(new String(PM_Utils.getMessageDigest(file)));
        }
        return arrayList;
    }

    protected void runImport(List<File> list) {
        this.dialogImport.setEnableInfoDoublePic(false);
        if (list.isEmpty()) {
            return;
        }
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        for (File file : list) {
            file = this.copyFile(file);
            if (PM_MetadataContainer.getInstance().getNumberIndexFile(file) < 0) {
                PM_MetadataContainer.getInstance().createPictureDirectory(file.getParentFile());
            }
            PM_Picture pM_Picture = PM_Picture.getPicture(file);
            arrayList.add(pM_Picture);
            if (!PM_Utils.hasFileThumbnail(file)) {
                pM_Picture.getImageThumbnail();
            }
            boolean bl = this.listener.actionPerformed(new PM_Action(null, 1, file.getPath()));
            if (list.size() == arrayList.size() || bl) continue;
            this.listener.actionPerformed(new PM_Action("max", arrayList.size(), String.format(PM_MSG.getMsg("importMsgEnd"), arrayList.size())));
            this.dialogImport.setEnableContinue(true);
            this.dialogImport.setEnableStop(false);
            this.dialogImport.await();
            this.makeSequence(arrayList);
            return;
        }
        this.makeSequence(arrayList);
        this.fireImportListener();
    }

    protected File copyFile(File file) {
        return file;
    }

    private void makeSequence(List<PM_Picture> list) {
        String string = new Long(System.currentTimeMillis()).toString();
        Collections.sort(list, PM_Utils.SORT_TIME_ORDER);
        PM_SequenceNew pM_SequenceNew = new PM_SequenceNew(string, list);
        PM_SequencesInout.getInstance().setChanged(true);
        PM_TreeModelNew pM_TreeModelNew = PM_TreeModelNew.getInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(pM_SequenceNew);
        pM_TreeModelNew.insertNodeInto(defaultMutableTreeNode, pM_TreeModelNew.rootNode, 0);
        pM_TreeModelNew.nodeChanged(pM_TreeModelNew.getRootNode());
        PM_WindowImport pM_WindowImport = PM_WindowMain.getInstance().getWindowRechts().getWindowImport();
        pM_WindowImport.getTreeWindowNew().expandTree(-1);
        PM_WindowMain.getInstance().getIndexViewThumbnails().setAndPaintPictureList(list);
        PM_MetadataContainer.getInstance().flush();
        PM_DatabaseLucene.getInstance().flush();
        PM_SequencesInout.getInstance().flush();
    }
}

