/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import pm.inout.PM_SequencesInout;
import pm.picture.PM_Import;
import pm.picture.PM_MetadataContainer;
import pm.search.PM_DatabaseLucene;
import pm.utilities.PM_Action;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_ImportExternal
extends PM_Import
implements PM_Interface {
    public PM_ImportExternal() {
        super(PM_Interface.Import.EXTERN);
    }

    public void checkAndImport(final List<File> list) {
        Thread thread = new Thread(){

            public void run() {
                Object object2;
                PM_MetadataContainer.getInstance().flush();
                PM_DatabaseLucene.getInstance().flush();
                PM_SequencesInout.getInstance().flush();
                boolean bl = false;
                ArrayList<File> arrayList = new ArrayList<File>();
                PM_ImportExternal.this.listener.actionPerformed(new PM_Action("max", -1, ""));
                for (Object object2 : list) {
                    if (((File)object2).isFile()) {
                        if (!PM_Utils.isPictureFile((File)object2)) continue;
                        arrayList.add((File)object2);
                        continue;
                    }
                    PM_ImportExternal.this.addFiles((File)object2, arrayList);
                }
                int n = arrayList.size();
                if (n == 0) {
                    object2 = "Keine neuen Bilder zum Importieren gefunden.";
                    PM_ImportExternal.this.listener.actionPerformed(new PM_Action("max", 0, (String)object2));
                    PM_ImportExternal.this.dialogImport.setEnableContinue(true);
                    PM_ImportExternal.this.dialogImport.setEnableStop(false);
                    PM_ImportExternal.this.dialogImport.await();
                    PM_ImportExternal.this.dialogImport.dispose();
                    return;
                }
                object2 = n == 1 ? "1 neues Bild gefunden." : n + " neue Bilder gefunden";
                PM_ImportExternal.this.listener.actionPerformed(new PM_Action("max", n, (String)object2));
                PM_ImportExternal.this.dialogImport.setEnableContinue(true);
                PM_ImportExternal.this.dialogImport.setEnableStop(true);
                bl = PM_ImportExternal.this.dialogImport.await();
                if (bl) {
                    PM_ImportExternal.this.dialogImport.dispose();
                    return;
                }
                int n2 = arrayList.size();
                PM_ImportExternal.this.listener.actionPerformed(new PM_Action("max", n2 * 2, "Pr\u00fcfen auf vorhandene Bilder."));
                List<File> list3 = PM_ImportExternal.this.getNewDouble(arrayList, PM_ImportExternal.this.listener);
                arrayList.removeAll(list3);
                List<File> list2 = PM_ImportExternal.this.getKnownPictures(arrayList, PM_ImportExternal.this.listener);
                arrayList.removeAll(list2);
                if (arrayList.isEmpty()) {
                    PM_ImportExternal.this.listener.actionPerformed(new PM_Action("max", 0, "Alle Bilder bereits vorhanden"));
                    PM_ImportExternal.this.dialogImport.setEnableContinue(true);
                    PM_ImportExternal.this.dialogImport.setEnableStop(false);
                    PM_ImportExternal.this.dialogImport.await();
                    PM_ImportExternal.this.dialogImport.dispose();
                    return;
                }
                int n3 = n - arrayList.size();
                if (n3 == 0) {
                    PM_ImportExternal.this.listener.actionPerformed(new PM_Action("max", n, "Alle Bilder importieren (keine vorhanden)"));
                } else {
                    PM_ImportExternal.this.listener.actionPerformed(new PM_Action("max", arrayList.size(), arrayList.size() + " Bilder importieren (" + n3 + " Bilder sind bereits vorhanden)"));
                }
                PM_ImportExternal.this.dialogImport.setEnableContinue(true);
                PM_ImportExternal.this.dialogImport.setEnableStop(true);
                bl = PM_ImportExternal.this.dialogImport.await();
                if (bl) {
                    PM_ImportExternal.this.dialogImport.dispose();
                    return;
                }
                PM_ImportExternal.this.runImport(arrayList);
                PM_ImportExternal.this.dialogImport.dispose();
            }
        };
        thread.start();
    }

    private void addFiles(File file, List<File> list) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                this.addFiles(file2, list);
            }
            if (!PM_Utils.isPictureFile(file2)) continue;
            list.add(file2);
        }
    }

    @Override
    protected File copyFile(File file) {
        File file2 = PM_Utils.copyFileUnique(file, this.dialogImport.getTargetDir());
        if (file2 == null) {
            return file;
        }
        return file2;
    }
}

