/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import pm.picture.PM_Picture;
import pm.picture.PM_PictureDirectory;
import pm.picture.PM_PictureMetadaten;
import pm.sequence.PM_Sequence;
import pm.utilities.PM_Action;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;
import pm.utilities.PM_Listener;
import pm.utilities.PM_ListenerX;
import pm.utilities.PM_Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_MetadataContainer
implements PM_Interface {
    private static PM_MetadataContainer instance = null;
    private PM_Configuration properties;
    private List<PM_PictureDirectory> pictureDirectories = new ArrayList<PM_PictureDirectory>();
    private Vector<PM_Listener> changeListener = new Vector();
    private Hashtable<String, Integer> initSequences = new Hashtable();
    private int level = 0;

    public static PM_MetadataContainer getInstance() {
        if (instance == null) {
            instance = new PM_MetadataContainer();
        }
        return instance;
    }

    private PM_MetadataContainer() {
        this.properties = PM_Configuration.getInstance();
        PM_Listener pM_Listener = new PM_Listener(){

            public void actionPerformed(PM_Action pM_Action) {
                if (pM_Action.getObject() instanceof PM_Picture) {
                    PM_Picture pM_Picture = (PM_Picture)pM_Action.getObject();
                    PM_PictureDirectory pM_PictureDirectory = PM_MetadataContainer.this.getPictureDirectory(pM_Picture);
                    if (pM_PictureDirectory == null) {
                        return;
                    }
                    pM_PictureDirectory.metadatenChanged(pM_Picture);
                    PM_MetadataContainer.this.metadatenChanged();
                }
            }
        };
        PM_PictureMetadaten.addChangeListener(pM_Listener);
    }

    public void initialize(PM_ListenerX pM_ListenerX) {
        if (pM_ListenerX != null) {
            pM_ListenerX.actionPerformed(new PM_Action("max", this.getAnzahlIndexFiles(), "pr\u00fcfen Metadaten"));
        } else {
            System.out.println("pr\u00fcfen Metadaten. Anzahl Bilder = " + this.getPictureSizeValid());
        }
        this.makeAllPictureDirectories(pM_ListenerX);
    }

    public List<PM_PictureDirectory> getPictureDirectories() {
        return this.pictureDirectories;
    }

    public File getFileOriginal(String string) {
        String[] stringArray = string.split("_");
        if (stringArray.length != 2) {
            return null;
        }
        int n = -1;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        File file = this.getDirOrigFile(n);
        if (file == null) {
            return null;
        }
        return new File(file.getPath() + File.separator + stringArray[1]);
    }

    private File getDirOrigFile(int n) {
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            if (pM_PictureDirectory.getIdNumber() != n) continue;
            return pM_PictureDirectory.getDirOrigFile();
        }
        return null;
    }

    public int getNumberIndexFile(File file) {
        if (!file.canRead()) {
            return -1;
        }
        String string = file.getParent();
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            if (!string.equalsIgnoreCase(pM_PictureDirectory.getDirOrigFile().getPath())) continue;
            return pM_PictureDirectory.getIdNumber();
        }
        return -1;
    }

    public void addChangeListener(PM_Listener pM_Listener) {
        if (!this.changeListener.contains(pM_Listener)) {
            this.changeListener.add(pM_Listener);
        }
    }

    private void fireChangeListener() {
        for (int i = 0; i < this.changeListener.size(); ++i) {
            PM_Listener pM_Listener = this.changeListener.elementAt(i);
            pM_Listener.actionPerformed(new PM_Action(this));
        }
    }

    public void addInitSequence(String string) {
        if (string.trim().length() == 0) {
            return;
        }
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = PM_Sequence.getSequenzKurzName(stringArray[i]);
            if (string2 == null) continue;
            if (this.initSequences.containsKey(string2)) {
                Integer n = this.initSequences.get(string2);
                this.initSequences.put(string2, new Integer(n + 1));
                continue;
            }
            this.initSequences.put(string2, new Integer(1));
        }
    }

    public Hashtable<String, Integer> getInitSequences() {
        return this.initSequences;
    }

    private int getAnzahlMetadatenToChange() {
        int n = 0;
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            n += pM_PictureDirectory.getAnzahlMetadatenToChange();
        }
        return n;
    }

    public void initMetadaten(PM_Picture pM_Picture) {
        PM_PictureDirectory pM_PictureDirectory = this.getPictureDirectory(pM_Picture);
        if (pM_PictureDirectory == null) {
            return;
        }
        pM_PictureDirectory.initMetadaten(pM_Picture);
    }

    public int getPictureSizeValid() {
        int n = 0;
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            n += pM_PictureDirectory.getPictureSizeValid();
        }
        return n;
    }

    public int getPictureSizeInvalid() {
        int n = 0;
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            n += pM_PictureDirectory.getPictureSizeInvalid();
        }
        return n;
    }

    public void flush() {
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            pM_PictureDirectory.flush();
        }
        this.fireChangeListener();
    }

    public void close() {
        this.flush();
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            pM_PictureDirectory.close();
        }
        this.fireChangeListener();
    }

    public void alleLuceneEintraegeNeuErstellen(PM_ListenerX pM_ListenerX) {
        if (pM_ListenerX != null) {
            pM_ListenerX.actionPerformed(new PM_Action("max", this.getPictureSizeValid(), "Datenbank neu erstellen"));
        } else {
            System.out.println("Datenbank neu erstellen. Anzahl Bilder = " + this.getPictureSizeValid());
        }
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            pM_PictureDirectory.alleLuceneEintraegeNeuErstellen(pM_ListenerX);
        }
    }

    public List<PM_Picture> bilderOhneSequenzen() {
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            arrayList.addAll(pM_PictureDirectory.bilderOhneSequenzen());
        }
        return arrayList;
    }

    public List<PM_Picture> bilderDoppelteSequenzen() {
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            arrayList.addAll(pM_PictureDirectory.bilderDoppelteSequenzen());
        }
        return arrayList;
    }

    public PM_PictureDirectory getPictureDirectory(PM_Picture pM_Picture) {
        return this.getPictureDirectory(pM_Picture.getFileOriginal().getParentFile());
    }

    private PM_PictureDirectory getPictureDirectory(File file) {
        String string = file.getAbsolutePath();
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            String string2 = pM_PictureDirectory.getDirOrigFile().getAbsolutePath();
            if (!string.equalsIgnoreCase(string2)) continue;
            return pM_PictureDirectory;
        }
        return null;
    }

    public void deleteIndex(PM_Interface.IndexType indexType) {
        if (indexType == PM_Interface.IndexType.INDEX_1) {
            for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
                pM_PictureDirectory.loeschenIndex1();
            }
        } else {
            for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
                pM_PictureDirectory.loeschenIndex2();
            }
        }
    }

    public void alleSequenzenLoeschen() {
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            pM_PictureDirectory.alleSequenzenLoeschen();
        }
    }

    private void metadatenChanged() {
        int n = this.getAnzahlMetadatenToChange();
        if (n > 100) {
            this.flush();
        }
        this.fireChangeListener();
    }

    private void makeAllPictureDirectories(PM_ListenerX pM_ListenerX) {
        this.flush();
        this.pictureDirectories = new ArrayList<PM_PictureDirectory>();
        System.out.print("Lesen Index-Files ");
        File file = PM_Configuration.getInstance().getTopLevelPictureDirectory();
        this.level = -1;
        this.lesenDirInit(file, pM_ListenerX);
        System.out.println();
        this.flush();
    }

    private void lesenDirInit(File file, PM_ListenerX pM_ListenerX) {
        ++this.level;
        Object[] objectArray = file.listFiles();
        Arrays.sort(objectArray);
        boolean bl = false;
        for (Object object : objectArray) {
            if (!PM_Utils.isPictureFile((File)object)) continue;
            bl = true;
            break;
        }
        Object object = null;
        if (bl) {
            object = new PM_PictureDirectory(file, this.level);
            ((PM_PictureDirectory)object).initProgramStart(pM_ListenerX);
        }
        if (object != null && (((PM_PictureDirectory)object).getPictureSizeValid() > 0 || ((PM_PictureDirectory)object).getPictureSizeInvalid() > 0)) {
            this.pictureDirectories.add((PM_PictureDirectory)object);
            System.out.print(".");
            if (pM_ListenerX != null) {
                pM_ListenerX.actionPerformed(new PM_Action(null, 1, file.getPath()));
            }
        }
        for (Object object2 : objectArray) {
            String[] stringArray;
            if (((File)object2).isFile() || (stringArray = ((File)object2).list()) == null) continue;
            if (stringArray.length == 1 && stringArray[0].equals("pm.metadaten")) {
                PM_Utils.deleteDirectory((File)object2);
                continue;
            }
            if (stringArray.length == 0) {
                ((File)object2).delete();
                continue;
            }
            if (!PM_Utils.isBilderDir((File)object2)) continue;
            this.lesenDirInit((File)object2, pM_ListenerX);
            --this.level;
        }
    }

    public PM_PictureDirectory createPictureDirectory(File file) {
        PM_PictureDirectory pM_PictureDirectory = new PM_PictureDirectory(file, -1);
        this.pictureDirectories.add(pM_PictureDirectory);
        return pM_PictureDirectory;
    }

    public List<File> getPicturesWithoutThumbs(PM_ListenerX pM_ListenerX) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (PM_PictureDirectory pM_PictureDirectory : this.pictureDirectories) {
            arrayList.addAll(pM_PictureDirectory.getPicturesWithoutThumbs(pM_ListenerX));
        }
        File file = this.properties.getTopLevelPictureDirectory();
        this.getNewPictures(file, arrayList);
        return arrayList;
    }

    private void getNewPictures(File file, List<File> list) {
        File[] fileArray;
        PM_PictureDirectory pM_PictureDirectory = this.getPictureDirectory(file);
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                if (!PM_Utils.isBilderDir(file2)) continue;
                this.getNewPictures(file2, list);
                continue;
            }
            if (!PM_Utils.isPictureFile(file2) || pM_PictureDirectory != null) continue;
            list.add(file2);
        }
    }

    private int getAnzahlIndexFiles() {
        return this.lesenDir(this.properties.getTopLevelPictureDirectory());
    }

    private int lesenDir(File file) {
        int n = 0;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                n += this.lesenDir(file2);
                continue;
            }
            if (!file2.getName().equals("pm_index.xml")) continue;
            ++n;
        }
        return n;
    }
}

