/*
 * Decompiled with CFR 0.152.
 */
package pm.picture;

import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import pm.picture.PM_MetadataContainer;
import pm.picture.PM_PictureImageMetadaten;
import pm.picture.PM_PictureMetadaten;
import pm.picture.PM_ReadImageMetadaten;
import pm.picture.PM_ReadImageOriginal;
import pm.picture.PM_ReadImageThumbnail;
import pm.utilities.PM_Interface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_Picture
implements PM_Interface {
    private Image imageOriginal = null;
    private File fileOriginal = null;
    public final PM_PictureMetadaten meta;
    private static Hashtable<String, WeakReference> allePictureReferences = new Hashtable();
    private static ReferenceQueue<PM_Picture> refQueue = new ReferenceQueue();
    private static Thread thread = null;
    private SoftReference<Image> srImageThumbnail = null;

    public static PM_Picture getPicture(String string) {
        File file = PM_MetadataContainer.getInstance().getFileOriginal(string);
        return PM_Picture.getPicture(file);
    }

    public static PM_Picture getPicture(File file) {
        WeakReference<PM_Picture> weakReference;
        PM_Picture pM_Picture = null;
        String string = PM_Picture.getPictureKey(file);
        if (string == null) {
            return null;
        }
        if (allePictureReferences.containsKey(string) && (pM_Picture = (PM_Picture)(weakReference = allePictureReferences.get(string)).get()) != null) {
            return pM_Picture;
        }
        pM_Picture = new PM_Picture(file);
        weakReference = new WeakReference<PM_Picture>(pM_Picture, refQueue);
        allePictureReferences.put(string, weakReference);
        return pM_Picture;
    }

    private PM_Picture(File file) {
        this.fileOriginal = file;
        this.meta = new PM_PictureMetadaten(file, this);
        PM_MetadataContainer.getInstance().initMetadaten(this);
        this.meta.setInit(false);
        if (thread == null) {
            thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                refQueue.remove();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.start();
        }
    }

    public static boolean isPictureInstanceAvailable(File file) {
        WeakReference weakReference;
        PM_Picture pM_Picture;
        String string = PM_Picture.getPictureKey(file);
        if (string == null) {
            return false;
        }
        return allePictureReferences.containsKey(string) && (pM_Picture = (PM_Picture)(weakReference = allePictureReferences.get(string)).get()) != null;
    }

    protected void setImageOriginal(Image image) {
        this.imageOriginal = image;
    }

    public boolean hasImageOriginal() {
        return this.imageOriginal != null;
    }

    public Image getImageOriginal() {
        return this.imageOriginal;
    }

    public void setImageThumbnail(Image image) {
        this.srImageThumbnail = new SoftReference<Image>(image);
    }

    public Image getImageThumbnail() {
        Image image;
        Image image2 = image = this.srImageThumbnail == null ? null : this.srImageThumbnail.get();
        if (image == null) {
            image = PM_ReadImageThumbnail.getInstance().getImage(this);
            this.srImageThumbnail = new SoftReference<Image>(image);
        }
        return image;
    }

    public boolean hasImageThumbnail() {
        Image image = this.srImageThumbnail == null ? null : this.srImageThumbnail.get();
        return image != null;
    }

    public void readImageOriginal() {
        ArrayList<PM_Picture> arrayList = new ArrayList<PM_Picture>();
        arrayList.add(this);
        PM_ReadImageOriginal.getInstance().readImages(arrayList, new ArrayList<PM_Picture>());
    }

    public static void readImageOriginal(List<PM_Picture> list, List<PM_Picture> list2) {
        PM_ReadImageOriginal.getInstance().readImages(list, list2);
    }

    public static void flushAllImagesOriginal() {
        PM_ReadImageOriginal.getInstance().readImages(new ArrayList<PM_Picture>(), new ArrayList<PM_Picture>());
    }

    public PM_PictureImageMetadaten getImageMetadaten() {
        PM_ReadImageMetadaten pM_ReadImageMetadaten = new PM_ReadImageMetadaten();
        return pM_ReadImageMetadaten.readMetadaten(this.getFileOriginal());
    }

    public File getFileOriginal() {
        return this.fileOriginal;
    }

    public double getImageOriginalRatio() {
        Dimension dimension = this.meta.getImageSize();
        return dimension.width / dimension.height;
    }

    public static String getPictureKey(File file) {
        int n = PM_MetadataContainer.getInstance().getNumberIndexFile(file);
        if (n < 0) {
            return null;
        }
        return Integer.toString(n) + "_" + file.getName();
    }
}

