/*
 * Decompiled with CFR 0.152.
 */
package pm.utilities;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import pm.picture.PM_Picture;
import pm.sequence.PM_Sequence;
import pm.utilities.PM_Configuration;
import pm.utilities.PM_Interface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PM_Utils
implements PM_Interface {
    public static final Comparator<PM_Sequence> SORT_SEQUENZ_NUMMER = new Comparator<PM_Sequence>(){

        @Override
        public int compare(PM_Sequence pM_Sequence, PM_Sequence pM_Sequence2) {
            int n = pM_Sequence.getSequenceNumber();
            int n2 = pM_Sequence2.getSequenceNumber();
            PM_Interface.SequenceType sequenceType = pM_Sequence.getType();
            PM_Interface.SequenceType sequenceType2 = pM_Sequence2.getType();
            String string = (Object)((Object)sequenceType) + PM_Utils.stringToString("0000000" + Integer.toString(n), 6);
            String string2 = (Object)((Object)sequenceType2) + PM_Utils.stringToString("0000000" + Integer.toString(n2), 6);
            return string.compareTo(string2);
        }
    };
    public static final Comparator<PM_Sequence> SORT_SEQUENZ_PATH = new Comparator<PM_Sequence>(){

        @Override
        public int compare(PM_Sequence pM_Sequence, PM_Sequence pM_Sequence2) {
            return pM_Sequence.getPath().compareTo(pM_Sequence2.getPath());
        }
    };
    public static final Comparator<PM_Sequence> SORT_SEQUENZ_NAME = new Comparator<PM_Sequence>(){

        @Override
        public int compare(PM_Sequence pM_Sequence, PM_Sequence pM_Sequence2) {
            String string = pM_Sequence.getShortName();
            String string2 = pM_Sequence2.getShortName();
            String string3 = string.substring(0) + pM_Sequence.getPath();
            String string4 = string2.substring(0) + pM_Sequence2.getPath();
            return string3.compareTo(string4);
        }
    };
    public static final Comparator<File> SORT_FILE_NAMES = new Comparator<File>(){

        @Override
        public int compare(File file, File file2) {
            String string = file.getName();
            String string2 = file2.getName();
            return string.compareTo(string2);
        }
    };
    public static final Comparator<PM_Picture> SORT_TIME_ORDER = new Comparator<PM_Picture>(){

        @Override
        public int compare(PM_Picture pM_Picture, PM_Picture pM_Picture2) {
            long l;
            long l2 = pM_Picture.meta.getDateCurrent().getTime();
            if (l2 == (l = pM_Picture2.meta.getDateCurrent().getTime())) {
                return 0;
            }
            if (l2 < l) {
                return -1;
            }
            return 1;
        }
    };
    private static String pmVersion = "unknown";
    private static String pmDateCompiled = "unknown";
    private static String pmCompilerVersion = "unknown";
    private static boolean getPmPropertiesDone = false;

    public static JButton getJButonKlein(String string) {
        int n = new JTextField((String)" ").getPreferredSize().height;
        Dimension dimension = new Dimension(n, n);
        return PM_Utils.getJButon(string, dimension);
    }

    public static JButton getJButon(String string) {
        int n = new JButton((String)" ").getPreferredSize().height;
        Dimension dimension = new Dimension(n, n);
        return PM_Utils.getJButon(string, dimension);
    }

    public static JButton getJButon(String string, Dimension dimension) {
        URL uRL = PM_Utils.getImageURL(string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        Image image = imageIcon.getImage();
        image = image.getScaledInstance(dimension.height, dimension.height, 2);
        imageIcon.setImage(image);
        JButton jButton = new JButton(imageIcon);
        jButton.setPreferredSize(dimension);
        return jButton;
    }

    public static JButton getJButon() {
        int n = new JTextField((String)" ").getPreferredSize().height;
        Dimension dimension = new Dimension(n, n);
        JButton jButton = new JButton(".");
        jButton.setPreferredSize(dimension);
        return jButton;
    }

    public static String removeDirectory(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        String string3 = string.substring(string2.length());
        if (string3.charAt(0) == File.separatorChar) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    public static String removeLastSeparatorChar(String string) {
        if (string.length() < 1) {
            return string;
        }
        if (string.charAt(string.length() - 1) == File.separatorChar) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getExtension(File file) {
        String string = "";
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1);
        }
        return string;
    }

    public static String getExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static boolean isPictureFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        if (PM_Utils.getStopFile(file).isFile()) {
            return false;
        }
        String string = PM_Utils.getExtension(file);
        return string.equalsIgnoreCase("jpg") || string.equalsIgnoreCase("jpeg");
    }

    public static File getStopFile(File file) {
        return new File(file.getParent() + File.separator + "pm.metadaten" + File.separator + "pm.stop-files" + File.separator + file.getName());
    }

    public static void setStop(File file) {
        File file2 = new File(file.getParent() + File.separator + "pm.metadaten" + File.separator + "pm.stop-files");
        file2.mkdirs();
        try {
            PM_Utils.getStopFile(file).createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isLink(File file) throws IOException {
        String string = file.getCanonicalPath();
        String string2 = file.getAbsolutePath();
        return !string2.equals(string);
    }

    public static boolean isUnderTLD(File file) {
        if (file == null) {
            return false;
        }
        File file2 = PM_Configuration.getInstance().getTopLevelPictureDirectory();
        String string = "";
        File file3 = null;
        try {
            string = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        for (file3 = new File(file.getCanonicalPath()); file3 != null; file3 = file3.getParentFile()) {
            if (!file3.getAbsolutePath().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static int stringToInt(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        return n;
    }

    public static long stringToLong(String string) {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        return l;
    }

    public static String stringToString(String string, int n) {
        String string2 = "                                                                  ";
        string2 = string2 + string;
        return string2.substring(string2.length() - n);
    }

    public static String getPropertyString(Properties properties, String string) {
        String string2 = "";
        string2 = properties.getProperty(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static int getPropertyInt(Properties properties, String string) {
        String string2 = "";
        string2 = properties.getProperty(string);
        if (string2 == null) {
            return 0;
        }
        return PM_Utils.stringToInt(string2);
    }

    public static boolean isLinux() {
        String string = PM_Utils.getPropertyString(System.getProperties(), "os.name");
        return string.equalsIgnoreCase("linux");
    }

    public static String getWorkingDirectory() {
        String string = PM_Utils.getPropertyString(System.getProperties(), "user.dir");
        if (string.length() == 0) {
            PM_Utils.writeErrorExit("java-Fehler: Property 'user.dir' nicht gefunden");
        }
        return string;
    }

    public static File getConfigDir() {
        File file;
        String string = PM_Utils.getPropertyString(System.getProperties(), "user.home");
        File file2 = new File(string);
        if (string.length() == 0 || !file2.isDirectory()) {
            PM_Utils.writeErrorExit("java-Fehler: Property 'user.home' nicht gefunden oder kein Verzeichnis");
        }
        if (!(file = new File(file2.getPath() + File.separator + ".photo-manager")).isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    public static String getWithoutExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static Rectangle getDestinationRectangle(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = null;
        int n = 0;
        double d = (double)rectangle.height / (double)rectangle.width;
        double d2 = (double)rectangle2.height / (double)rectangle2.width;
        if (d == d2) {
            return new Rectangle(rectangle2);
        }
        if (d > d2) {
            int n2 = (int)((double)rectangle2.height / d);
            n = (int)((double)(rectangle2.width - n2) / 2.0);
            rectangle3 = new Rectangle(n, 0, n2, rectangle2.height);
        } else {
            int n3 = (int)((double)rectangle2.width * d);
            n = (int)((double)(rectangle2.height - n3) / 2.0);
            rectangle3 = new Rectangle(0, n, rectangle2.width, n3);
        }
        rectangle3.x += rectangle2.x;
        rectangle3.y += rectangle2.y;
        return rectangle3;
    }

    public static boolean hasFileThumbnail(File file) {
        File file2 = new File(file.getParent() + File.separator + "pm.metadaten");
        if (!file2.isDirectory()) {
            return false;
        }
        File file3 = new File(file2.getPath() + File.separator + "pm.thumbnails");
        if (!file3.isDirectory()) {
            return false;
        }
        String string = file3.getPath() + File.separator + file.getName() + "_th";
        File file4 = new File(string);
        return file4.isFile();
    }

    public static File getFileThumbnail(File file) {
        File file2 = new File(file.getParent() + File.separator + "pm.metadaten");
        File file3 = new File(file2.getPath() + File.separator + "pm.thumbnails");
        String string = file3.getPath() + File.separator + file.getName() + "_th";
        return new File(string);
    }

    public static File[] getFilesBearbeitet(File file) {
        Vector<File> vector = new Vector<File>();
        File file2 = new File(file.getParent() + File.separator + "pm.metadaten");
        File file3 = new File(file2.getPath() + File.separator + "pm.bilder_bearbeiten");
        if (!file3.isDirectory()) {
            return vector.toArray(new File[vector.size()]);
        }
        File[] fileArray = file3.listFiles();
        String string = file.getName();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            File file4 = fileArray[i];
            if (string.length() <= 1 || string.length() > file4.getName().length() || !string.equals(string2 = file4.getName().substring(0, string.length()))) continue;
            vector.add(file4);
        }
        return vector.toArray(new File[vector.size()]);
    }

    public static boolean hasFileIndexXML(File file) {
        File file2 = new File(file.getPath() + File.separator + "pm.metadaten");
        if (!file2.isDirectory()) {
            return false;
        }
        File file3 = new File(file2.getPath() + File.separator + "pm_index.xml");
        return file3.isFile();
    }

    public static File getFileIndexXML(File file) {
        File file2 = new File(file.getPath() + File.separator + "pm.metadaten");
        return new File(file2.getPath() + File.separator + "pm_index.xml");
    }

    public static String fileOriginalToXmlId(File file) {
        return file.getName();
    }

    public static File xmlIdToFileOriginal(File file, String string) {
        String string2 = new File(file.getParent()).getParent() + File.separator + string;
        return new File(string2);
    }

    public static Dimension getScreenSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return dimension;
    }

    public static void writeErrorExit(String string) {
        String string2 = string;
        if (string2.length() > 50) {
            string2 = "";
            for (int i = 0; i < string.length() && i < string.length(); i += 80) {
                int n = i + 80;
                if (n >= string.length()) {
                    n = string.length();
                }
                string2 = string2 + string.substring(i, n) + "\n";
            }
        }
        JOptionPane.showConfirmDialog(null, string2, "Fehler", -1, 0);
        System.exit(0);
    }

    public static boolean dateienIdentisch(File file, File file2) {
        return file.length() == file2.length();
    }

    public static byte[] getMessageDigest(File file) {
        MessageDigest messageDigest;
        DigestInputStream digestInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            messageDigest = MessageDigest.getInstance("MD5");
            digestInputStream = new DigestInputStream(fileInputStream, messageDigest);
            byte[] byArray = new byte[5120];
            int n2 = byArray.length;
            while ((n = digestInputStream.read(byArray, 0, n2)) != -1 && (n2 -= n) > 0) {
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(file.getPath() + " does not exist!");
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("NoSuchAlgorithmException" + noSuchAlgorithmException);
            return null;
        }
        catch (IOException iOException) {
            System.out.println("Error reading/writing files!");
            return null;
        }
        messageDigest = digestInputStream.getMessageDigest();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return messageDigest.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            file2.delete();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[1024];
            while (bufferedInputStream.available() != 0) {
                int n = bufferedInputStream.read(byArray);
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static SortedSet<String> getSortedSet(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (string == null || string.length() == 0) {
            return treeSet;
        }
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            treeSet.add(stringArray[i]);
        }
        return treeSet;
    }

    public static List<String> getList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i].trim());
        }
        return arrayList;
    }

    public static String sortedSetToString(SortedSet sortedSet) {
        String string = "";
        if (sortedSet.size() == 0) {
            return string;
        }
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            string = string + " " + (String)iterator.next();
        }
        return string.trim();
    }

    public static Date datumToDate(String string) {
        Date date = new Date(System.currentTimeMillis());
        if (string == null) {
            return date;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return new Date(System.currentTimeMillis());
        }
        return date;
    }

    public static String getDateString(Date date, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static String getTimeStamp() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        return simpleDateFormat.format(date);
    }

    public static Vector<String> getJahre(boolean bl) {
        PM_Configuration pM_Configuration = PM_Configuration.getInstance();
        int n = pM_Configuration.getDatumJahrVon();
        int n2 = pM_Configuration.getDatumJahrBis();
        return PM_Utils.getArrayString(n, n2, 4, bl);
    }

    public static Vector getMonate(boolean bl) {
        return PM_Utils.getArrayString(1, 12, 2, bl);
    }

    public static Vector getTage(boolean bl) {
        return PM_Utils.getArrayString(1, 31, 2, bl);
    }

    public static Vector getStunden(boolean bl) {
        return PM_Utils.getArrayString(0, 23, 2, bl);
    }

    public static Vector getMinuten(boolean bl) {
        return PM_Utils.getArrayString(0, 59, 2, bl);
    }

    public static Vector getSekunden(boolean bl) {
        return PM_Utils.getArrayString(0, 59, 2, bl);
    }

    public static Vector<String> getArrayString(int n, int n2, int n3, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (bl && n3 == 1) {
            vector.add(" ");
        }
        if (bl && n3 == 2) {
            vector.add("  ");
        }
        if (bl && n3 == 3) {
            vector.add("   ");
        }
        if (bl && n3 == 4) {
            vector.add("    ");
        }
        for (int i = n; i < n2 + 1; ++i) {
            String string = PM_Utils.stringToString("00000" + Integer.toString(i), n3);
            vector.add(string);
        }
        return vector;
    }

    public static File[] loeschenBilder(File file) {
        int n;
        File[] fileArray;
        Vector<Object> vector = new Vector<Object>();
        if (PM_Utils.hasFileThumbnail(file)) {
            fileArray = PM_Utils.getFileThumbnail(file);
            fileArray.delete();
            vector.add(fileArray);
        }
        fileArray = PM_Utils.getFilesBearbeitet(file);
        for (n = 0; n < fileArray.length; ++n) {
            File file2 = fileArray[n];
            file2.delete();
            vector.add(file2);
        }
        n = file.delete() ? 1 : 0;
        if (n == 0) {
            // empty if block
        }
        vector.add(file);
        return vector.toArray(new File[vector.size()]);
    }

    public static boolean setWrite(File file) {
        if (file.canWrite()) {
            return true;
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        String string = "attrib -R " + file.getPath();
        try {
            process = runtime.exec(string);
        }
        catch (IOException iOException) {
            JOptionPane.showConfirmDialog(null, "setWrite Fehler. (cmd = " + string + ")", "Fehler", -1, 1);
            return false;
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return file.canWrite();
    }

    public static boolean isBilderDir(File file) {
        String string;
        if (!file.isDirectory()) {
            return false;
        }
        PM_Configuration pM_Configuration = PM_Configuration.getInstance();
        String string2 = file.getPath();
        if (string2.equals(string = pM_Configuration.getFileHomeTemp().getPath())) {
            return false;
        }
        String string3 = pM_Configuration.getMetaRootDir().getPath();
        if (string2.equals(string3)) {
            return false;
        }
        return !file.getName().equals("pm.metadaten");
    }

    public static boolean isAncestorOf(Component component, Component component2) {
        if (component == null || component2 == null) {
            return false;
        }
        if (component == component2) {
            return true;
        }
        Container container = component.getParent();
        if (container == component2) {
            return true;
        }
        while (container != null) {
            if ((container = container.getParent()) != component2) continue;
            return true;
        }
        return false;
    }

    public static void removeKeyCode(JComponent jComponent, int n) {
        PM_Utils.removeKeyCode(jComponent.getInputMap(0), n);
        PM_Utils.removeKeyCode(jComponent.getInputMap(1), n);
        PM_Utils.removeKeyCode(jComponent.getInputMap(2), n);
    }

    public static void removeKeyCode(InputMap inputMap, int n) {
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        if (keyStrokeArray == null) {
            return;
        }
        inputMap.clear();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            if (keyStrokeArray[i].getKeyCode() != n) continue;
        }
    }

    public static URL getImageURL(String string) {
        PM_Utils pM_Utils = new PM_Utils();
        URL uRL = pM_Utils.getClass().getClassLoader().getResource("images/" + string);
        if (uRL == null) {
            uRL = pM_Utils.getClass().getClassLoader().getResource(string);
        }
        return uRL;
    }

    public static boolean isToDay(long l) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(l);
        if (calendar.get(1) != calendar2.get(1)) {
            return false;
        }
        return calendar.get(6) == calendar2.get(6);
    }

    public static int getNextRotation(int n, PM_Interface.Rotate rotate) {
        if (rotate == PM_Interface.Rotate.LEFT) {
            return PM_Utils.getNextRotationLeft(n);
        }
        return PM_Utils.getNextRotationRight(n);
    }

    private static int getNextRotationLeft(int n) {
        switch (n) {
            case 0: {
                return 270;
            }
            case 90: {
                return 0;
            }
            case 180: {
                return 90;
            }
            case 270: {
                return 180;
            }
        }
        return 0;
    }

    private static int getNextRotationRight(int n) {
        switch (n) {
            case 0: {
                return 90;
            }
            case 90: {
                return 180;
            }
            case 180: {
                return 270;
            }
            case 270: {
                return 0;
            }
        }
        return 0;
    }

    public static long getTime(File file) {
        if (!file.isFile()) {
            return 0L;
        }
        try {
            String string;
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((n = (string = bufferedReader.readLine()).indexOf("update-time=\"")) == -1) {
            }
            String string2 = string.substring(n);
            if ((n = string2.indexOf("\"")) != -1 && (n = (string2 = string2.substring(n + 1)).indexOf("\"")) != -1) {
                string2 = string2.substring(0, n);
                try {
                    return Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    return 0L;
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return 0L;
        }
        return 0L;
    }

    public static String getRelativePath(File file, File file2) {
        String string = "";
        String string2 = "";
        string = file.getAbsolutePath();
        string2 = file2.getAbsolutePath();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if (string2.indexOf(string) != 0) {
            return "";
        }
        return string2.substring(string.length());
    }

    public static boolean deleteDirectory(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    PM_Utils.deleteDirectory(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        return file.delete();
    }

    public static Vector<String> getComboBoxVector(List<PM_Sequence> list) {
        Vector<String> vector = new Vector<String>();
        vector.add("                      ");
        for (PM_Sequence pM_Sequence : list) {
            String string = pM_Sequence.toStringComboBox();
            vector.add(string);
        }
        return vector;
    }

    public static PM_Sequence getSelectedSequenz(int n, List<PM_Sequence> list) {
        if (list.size() <= 0) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        if (list.size() <= n) {
            return null;
        }
        return list.get(n);
    }

    public static int getSelectedIndex(PM_Sequence pM_Sequence, List<PM_Sequence> list) {
        Iterator<PM_Sequence> iterator = list.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            PM_Sequence pM_Sequence2 = iterator.next();
            if (pM_Sequence == pM_Sequence2) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static File copyFileUnique(File file, File file2) {
        if (!file.isFile() || !file2.isDirectory()) {
            return null;
        }
        int n = 0;
        String string = PM_Utils.getWithoutExtension(file.getName());
        String string2 = PM_Utils.getExtension(file.getName());
        File file3 = new File(file2.getPath() + File.separator + file.getName());
        while (file3.isFile()) {
            file3 = new File(file2.getPath() + File.separator + string + "_" + ++n + "." + string2);
        }
        if (PM_Utils.copyFile(file, file3)) {
            return file3;
        }
        return null;
    }

    public static boolean isTemp(KeyEvent keyEvent) {
        return keyEvent.getKeyChar() == 't' && keyEvent.getModifiers() == 0;
    }

    public static boolean isTempDelete(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        if (keyEvent.getKeyChar() != 't') {
            return false;
        }
        if (n == 128 || n == 256) {
            return true;
        }
        return n == 128 && n == 256;
    }

    public static boolean isTempViewed(KeyEvent keyEvent) {
        return keyEvent.getKeyChar() == 'T';
    }

    private static void getPmProperties() {
        if (getPmPropertiesDone) {
            return;
        }
        getPmPropertiesDone = true;
        PM_Utils pM_Utils = new PM_Utils();
        URL uRL = pM_Utils.getClass().getClassLoader().getResource("pm-properties.txt");
        if (uRL == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            System.out.println("url.openStream() ERROR = " + iOException);
            return;
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = (string = string.trim()).split(":", 2);
                if (stringArray.length != 2) continue;
                if (stringArray[0].contains("pm-version")) {
                    pmVersion = stringArray[1].trim();
                    continue;
                }
                if (stringArray[0].contains("date-compiled")) {
                    pmDateCompiled = stringArray[1].trim();
                    continue;
                }
                if (!stringArray[0].contains("compiler-version")) continue;
                pmCompilerVersion = stringArray[1].trim();
            }
        }
        catch (IOException iOException) {
            System.out.println("read ERROR = " + iOException);
            return;
        }
    }

    public static String getPmVersion() {
        PM_Utils.getPmProperties();
        return pmVersion;
    }

    public static String getCompilerVersion() {
        PM_Utils.getPmProperties();
        return pmCompilerVersion;
    }

    public static String getDateCompiled() {
        PM_Utils.getPmProperties();
        return pmDateCompiled;
    }
}

