/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg.test;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import java.io.File;
import java.io.FileInputStream;
import junit.framework.TestCase;

public class JpegSegmentReaderTest
extends TestCase {
    public JpegSegmentReaderTest(String string) {
        super(string);
    }

    public void testIsJpegWithJpegFile() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        try {
            new JpegSegmentReader(file);
        }
        catch (JpegProcessingException jpegProcessingException) {
            JpegSegmentReaderTest.fail((String)"Error creating JpegSegmentReader");
        }
    }

    public void testIsJpegWithNonJpegFile() throws Exception {
        File file = new File("src/com/drew/metadata/test/AllTests.java");
        try {
            new JpegSegmentReader(file);
            JpegSegmentReaderTest.fail((String)"shouldn't be able to construct JpegSegmentReader with non-jpeg file");
        }
        catch (JpegProcessingException jpegProcessingException) {
            // empty catch block
        }
    }

    public void testReadApp1Segment() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        byte[] byArray = jpegSegmentReader.readSegment((byte)-31);
        JpegSegmentReaderTest.assertTrue((String)"exif data too short", (byArray.length > 4 ? 1 : 0) != 0);
        JpegSegmentReaderTest.assertEquals((String)"Exif", (String)new String(byArray, 0, 4));
    }

    public void testReadDQTSegment() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        byte[] byArray = jpegSegmentReader.readSegment((byte)-37);
        JpegSegmentReaderTest.assertTrue((String)"shouldn't have zero length quantizationTableData", (byArray.length > 0 ? 1 : 0) != 0);
        JpegSegmentReaderTest.assertTrue((String)"quantizationTableData shouldn't start with 'Exif'", (!"Exif".equals(new String(byArray, 0, 4)) ? 1 : 0) != 0);
    }

    public void testReadJpegByteArray() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        byte[] byArray = new byte[(int)file.length()];
        new FileInputStream(file).read(byArray);
        new JpegSegmentReader(byArray).readSegment((byte)-31);
    }

    public void testCreateWithInputStream() throws Exception {
        File file = new File("src/com/drew/metadata/exif/test/withExif.jpg");
        FileInputStream fileInputStream = new FileInputStream(file);
        JpegSegmentReader jpegSegmentReader = null;
        try {
            jpegSegmentReader = new JpegSegmentReader(fileInputStream);
        }
        catch (JpegProcessingException jpegProcessingException) {
            JpegSegmentReaderTest.fail((String)"Error constructing JpegSegmentReader using InputStream");
        }
        byte[] byArray = jpegSegmentReader.readSegment((byte)-31);
        JpegSegmentReaderTest.assertEquals((String)"Exif", (String)new String(byArray, 0, 4));
    }

    public void testReadSecondSegmentInstanace() throws Exception {
        File file = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        byte[] byArray = jpegSegmentReader.readSegment((byte)-31, 0);
        byte[] byArray2 = jpegSegmentReader.readSegment((byte)-31, 1);
        JpegSegmentReaderTest.assertEquals((String)"Exif", (String)new String(byArray, 0, 4));
        JpegSegmentReaderTest.assertEquals((String)"http", (String)new String(byArray2, 0, 4));
    }

    public void testReadNonExistantSegmentInstance() throws Exception {
        File file = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        JpegSegmentReaderTest.assertNull((String)"third exif segment shouldn't exist", (Object)jpegSegmentReader.readSegment((byte)-31, 3));
    }

    public void testGetSegmentCount() throws Exception {
        File file = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        JpegSegmentReaderTest.assertEquals((int)2, (int)jpegSegmentReader.getSegmentCount((byte)-31));
        JpegSegmentReaderTest.assertEquals((int)1, (int)jpegSegmentReader.getSegmentCount((byte)-30));
        JpegSegmentReaderTest.assertEquals((int)0, (int)jpegSegmentReader.getSegmentCount((byte)-29));
    }

    public void testCreateWithFileAndReadMultipleSegments() throws Exception {
        File file = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        this.validateMultipleSegmentRead(jpegSegmentReader);
    }

    public void testCreateWithInputStreamAndReadMultipleSegments() throws Exception {
        File file = new File("src/com/drew/imaging/jpeg/test/withExifAndIptc.jpg");
        FileInputStream fileInputStream = new FileInputStream(file);
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(fileInputStream);
        this.validateMultipleSegmentRead(jpegSegmentReader);
    }

    private void validateMultipleSegmentRead(JpegSegmentReader jpegSegmentReader) throws JpegProcessingException {
        byte[] byArray = jpegSegmentReader.readSegment((byte)-19);
        byte[] byArray2 = jpegSegmentReader.readSegment((byte)-31);
        JpegSegmentReaderTest.assertTrue((String)"exif data too short", (byArray2.length > 4 ? 1 : 0) != 0);
        new ExifReader(byArray2).extract();
        new IptcReader(byArray).extract();
        JpegSegmentReaderTest.assertEquals((String)"Exif", (String)new String(byArray2, 0, 4));
    }
}

