/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.exif.ExifDirectory;
import java.io.File;

public class ExifReader
implements MetadataReader {
    private final byte[] _data;
    private boolean _isMotorollaByteOrder;
    private Metadata _metadata;
    static final int[] BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    private static final int MAX_FORMAT_CODE = 12;
    private static final int FMT_BYTE = 1;
    private static final int FMT_STRING = 2;
    private static final int FMT_USHORT = 3;
    private static final int FMT_ULONG = 4;
    private static final int FMT_URATIONAL = 5;
    private static final int FMT_SBYTE = 6;
    private static final int FMT_UNDEFINED = 7;
    private static final int FMT_SSHORT = 8;
    private static final int FMT_SLONG = 9;
    private static final int FMT_SRATIONAL = 10;
    private static final int FMT_SINGLE = 11;
    private static final int FMT_DOUBLE = 12;
    public static final int TAG_EXIF_OFFSET = 34665;
    public static final int TAG_INTEROP_OFFSET = 40965;
    public static final int TAG_GPS_INFO_OFFSET = 34853;
    public static final int TAG_MAKER_NOTE = 37500;
    public static int TIFF_HEADER_START_OFFSET = 6;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifInteropDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$GpsDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$OlympusMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$NikonType1MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$NikonType3MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$NikonType2MakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$CanonMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$CasioMakernoteDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$FujiFilmMakernoteDirectory;

    public ExifReader(File file) throws JpegProcessingException {
        this(new JpegSegmentReader(file).readSegment((byte)-31));
    }

    public ExifReader(byte[] byArray) {
        this._data = byArray;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    public Metadata extract(Metadata metadata) {
        this._metadata = metadata;
        if (this._data == null) {
            return this._metadata;
        }
        Directory directory = this._metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReader.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        if (this._data.length <= 14) {
            directory.addError("Exif data segment must contain at least 14 bytes");
            return this._metadata;
        }
        if (!"Exif\u0000\u0000".equals(new String(this._data, 0, 6))) {
            directory.addError("Exif data segment doesn't begin with 'Exif'");
            return this._metadata;
        }
        String string = new String(this._data, 6, 2);
        if (!this.setByteOrder(string)) {
            directory.addError("Unclear distinction between Motorola/Intel byte ordering");
            return this._metadata;
        }
        if (this.get16Bits(8) != 42) {
            directory.addError("Invalid Exif start - should have 0x2A at offset 8 in Exif header");
            return this._metadata;
        }
        int n = this.get32Bits(10) + TIFF_HEADER_START_OFFSET;
        if (n >= this._data.length - 1) {
            directory.addError("First exif directory offset is beyond end of Exif data segment");
            n = 14;
        }
        this.processDirectory(directory, n);
        this.extractThumbnail(directory);
        return this._metadata;
    }

    private void extractThumbnail(Directory directory) {
        if (!(directory instanceof ExifDirectory)) {
            return;
        }
        if (!directory.containsTag(514) || !directory.containsTag(513)) {
            return;
        }
        try {
            int n = directory.getInt(513);
            int n2 = directory.getInt(514);
            byte[] byArray = new byte[n2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this._data[TIFF_HEADER_START_OFFSET + n + i];
            }
            directory.setByteArray(61441, byArray);
        }
        catch (Throwable throwable) {
            directory.addError("Unable to extract thumbnail: " + throwable.getMessage());
        }
    }

    private boolean setByteOrder(String string) {
        if ("MM".equals(string)) {
            this._isMotorollaByteOrder = true;
        } else if ("II".equals(string)) {
            this._isMotorollaByteOrder = false;
        } else {
            return false;
        }
        return true;
    }

    private void processDirectory(Directory directory, int n) {
        int n2;
        if (n >= this._data.length || n < 0) {
            directory.addError("Ignored directory marked to start outside data segement");
            return;
        }
        int n3 = this.get16Bits(n);
        if (!this.isDirectoryLengthValid(n)) {
            directory.addError("Illegally sized directory");
            return;
        }
        System.out.println("dirTagCount = " + n3);
        block6: for (n2 = 0; n2 < n3; ++n2) {
            int n4 = this.calculateDirectoryEntryOffset(n, n2);
            int n5 = this.get16Bits(n4);
            int n6 = this.get16Bits(n4 + 2);
            if (n6 < 0 || n6 > 12) {
                directory.addError("Invalid format code: " + n6);
                continue;
            }
            int n7 = this.get32Bits(n4 + 4);
            int n8 = n7 * BYTES_PER_FORMAT[n6];
            int n9 = this.calculateTagValueOffset(n8, n4);
            if (n9 < 0) {
                directory.addError("Illegal pointer offset value in EXIF");
                continue;
            }
            int n10 = TIFF_HEADER_START_OFFSET + this.get32Bits(n9);
            switch (n5) {
                case 34665: {
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? ExifReader.class$("com.drew.metadata.exif.ExifDirectory") : class$com$drew$metadata$exif$ExifDirectory), n10);
                    continue block6;
                }
                case 40965: {
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$ExifInteropDirectory == null ? ExifReader.class$("com.drew.metadata.exif.ExifInteropDirectory") : class$com$drew$metadata$exif$ExifInteropDirectory), n10);
                    continue block6;
                }
                case 34853: {
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$GpsDirectory == null ? ExifReader.class$("com.drew.metadata.exif.GpsDirectory") : class$com$drew$metadata$exif$GpsDirectory), n10);
                    continue block6;
                }
                case 37500: {
                    this.processMakerNote(n9);
                    continue block6;
                }
                default: {
                    this.processTag(directory, n5, n9, n7, n6);
                }
            }
        }
        n2 = this.get32Bits(n + 2 + 12 * n3);
        if (n2 != 0) {
            if ((n2 += TIFF_HEADER_START_OFFSET) >= this._data.length) {
                return;
            }
            this.processDirectory(directory, n2);
        }
    }

    private void processMakerNote(int n) {
        Directory directory = this._metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = ExifReader.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
        if (directory == null) {
            return;
        }
        String string = directory.getString(271);
        if ("OLYMP".equals(new String(this._data, n, 5))) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$OlympusMakernoteDirectory == null ? (class$com$drew$metadata$exif$OlympusMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.OlympusMakernoteDirectory")) : class$com$drew$metadata$exif$OlympusMakernoteDirectory), n + 8);
        } else if (string != null && string.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(new String(this._data, n, 5))) {
                if (this._data[n + 6] == 1) {
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$NikonType1MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType1MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.NikonType1MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType1MakernoteDirectory), n + 8);
                } else if (this._data[n + 6] == 2) {
                    int n2 = TIFF_HEADER_START_OFFSET;
                    TIFF_HEADER_START_OFFSET = n + 10;
                    this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$NikonType3MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType3MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.NikonType3MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType3MakernoteDirectory), n + 18);
                    TIFF_HEADER_START_OFFSET = n2;
                } else {
                    directory.addError("Unsupported makernote data ignored.");
                }
            } else {
                this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$NikonType2MakernoteDirectory == null ? (class$com$drew$metadata$exif$NikonType2MakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.NikonType2MakernoteDirectory")) : class$com$drew$metadata$exif$NikonType2MakernoteDirectory), n);
            }
        } else if ("Canon".equalsIgnoreCase(string)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$CanonMakernoteDirectory == null ? (class$com$drew$metadata$exif$CanonMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.CanonMakernoteDirectory")) : class$com$drew$metadata$exif$CanonMakernoteDirectory), n);
        } else if ("Casio".equalsIgnoreCase(string)) {
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$CasioMakernoteDirectory == null ? (class$com$drew$metadata$exif$CasioMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.CasioMakernoteDirectory")) : class$com$drew$metadata$exif$CasioMakernoteDirectory), n);
        } else if ("FUJIFILM".equals(new String(this._data, n, 8)) || "Fujifilm".equalsIgnoreCase(string)) {
            boolean bl = this._isMotorollaByteOrder;
            this._isMotorollaByteOrder = false;
            int n3 = n + this.get32Bits(n + 8);
            this.processDirectory(this._metadata.getDirectory(class$com$drew$metadata$exif$FujiFilmMakernoteDirectory == null ? (class$com$drew$metadata$exif$FujiFilmMakernoteDirectory = ExifReader.class$("com.drew.metadata.exif.FujiFilmMakernoteDirectory")) : class$com$drew$metadata$exif$FujiFilmMakernoteDirectory), n3);
            this._isMotorollaByteOrder = bl;
        } else {
            directory.addError("Unsupported makernote data ignored.");
        }
    }

    private boolean isDirectoryLengthValid(int n) {
        int n2 = this.get16Bits(n);
        int n3 = 2 + 12 * n2 + 4;
        return n3 + n + TIFF_HEADER_START_OFFSET < this._data.length;
    }

    private void processTag(Directory directory, int n, int n2, int n3, int n4) {
        switch (n4) {
            case 2: 
            case 7: {
                String string = n == 37510 ? this.readCommentString(n2, n3, n4) : this.readString(n2, n3);
                directory.setString(n, string);
                break;
            }
            case 5: 
            case 10: {
                if (n3 == 1) {
                    Rational rational = new Rational(this.get32Bits(n2), this.get32Bits(n2 + 4));
                    directory.setRational(n, rational);
                    break;
                }
                Rational[] rationalArray = new Rational[n3];
                for (int i = 0; i < n3; ++i) {
                    rationalArray[i] = new Rational(this.get32Bits(n2 + 8 * i), this.get32Bits(n2 + 4 + 8 * i));
                }
                directory.setRationalArray(n, rationalArray);
                break;
            }
            case 1: 
            case 6: {
                if (n3 == 1) {
                    byte by = this._data[n2];
                    directory.setInt(n, by);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this._data[n2 + i];
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 11: 
            case 12: {
                if (n3 == 1) {
                    byte by = this._data[n2];
                    directory.setInt(n, by);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this._data[n2 + i];
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 3: 
            case 8: {
                if (n3 == 1) {
                    int n5 = this.get16Bits(n2);
                    directory.setInt(n, n5);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.get16Bits(n2 + i * 2);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            case 4: 
            case 9: {
                if (n3 == 1) {
                    int n6 = this.get32Bits(n2);
                    directory.setInt(n, n6);
                    break;
                }
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = this.get32Bits(n2 + i * 4);
                }
                directory.setIntArray(n, nArray);
                break;
            }
            default: {
                directory.addError("unknown format code " + n4);
            }
        }
    }

    private int calculateTagValueOffset(int n, int n2) {
        if (n > 4) {
            int n3 = this.get32Bits(n2 + 8);
            if (n3 + n > this._data.length) {
                return -1;
            }
            return TIFF_HEADER_START_OFFSET + n3;
        }
        return n2 + 8;
    }

    private String readString(int n, int n2) {
        int n3;
        for (n3 = 0; n + n3 < this._data.length && this._data[n + n3] != 0 && n3 < n2; ++n3) {
        }
        return new String(this._data, n, n3);
    }

    private String readCommentString(int n, int n2, int n3) {
        int n4;
        int n5 = n2 * BYTES_PER_FORMAT[n3];
        for (n4 = n5 - 1; n4 >= 0 && this._data[n + n4] == 32; --n4) {
            this._data[n + n4] = 0;
        }
        if ("ASCII".equals(new String(this._data, n, 5))) {
            for (n4 = 5; n4 < 10; ++n4) {
                byte by = this._data[n + n4];
                if (by == 0 || by == 32) continue;
                return this.readString(n + n4, 1999);
            }
        }
        return this.readString(n, 1999);
    }

    private int calculateDirectoryEntryOffset(int n, int n2) {
        return n + 2 + 12 * n2;
    }

    private int get16Bits(int n) {
        if (n < 0 || n >= this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorollaByteOrder) {
            return this._data[n] << 8 & 0xFF00 | this._data[n + 1] & 0xFF;
        }
        return this._data[n + 1] << 8 & 0xFF00 | this._data[n] & 0xFF;
    }

    private int get32Bits(int n) {
        if (n < 0 || n >= this._data.length) {
            throw new ArrayIndexOutOfBoundsException("attempt to read data outside of exif segment (index " + n + " where max index is " + (this._data.length - 1) + ")");
        }
        if (this._isMotorollaByteOrder) {
            return this._data[n] << 24 & 0xFF000000 | this._data[n + 1] << 16 & 0xFF0000 | this._data[n + 2] << 8 & 0xFF00 | this._data[n + 3] & 0xFF;
        }
        return this._data[n + 3] << 24 & 0xFF000000 | this._data[n + 2] << 16 & 0xFF0000 | this._data[n + 1] << 8 & 0xFF00 | this._data[n] & 0xFF;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

