/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.event.ZEvent;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseListener;
import edu.umd.cs.jazz.event.ZMouseMotionListener;
import edu.umd.cs.jazz.event.ZNodeEvent;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZListImpl;
import edu.umd.cs.jazz.util.ZObjectReferenceTable;
import edu.umd.cs.jazz.util.ZProperty;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public abstract class ZSceneGraphObject
implements ZSerializable,
Serializable,
Cloneable {
    public static final boolean volatileBounds_DEFAULT = false;
    private static ZObjectReferenceTable objRefTable;
    private static boolean inClone;
    protected ZBounds bounds;
    protected transient boolean invalidBounds = true;
    protected boolean volatileBounds = false;
    protected transient boolean invalidVolatileBounds = true;
    protected transient boolean inTransaction = false;
    protected transient EventListenerList listenerList = null;
    private ZList.ZPropertyList clientProperties = ZListImpl.NullList;
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZMouseListener;
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZMouseMotionListener;

    protected ZSceneGraphObject() {
        this.bounds = new ZBounds();
    }

    protected void addClientProperty(ZProperty prop) {
        if (this.clientProperties.isNull()) {
            this.clientProperties = new ZListImpl.ZPropertyListImpl(1);
        }
        this.clientProperties.add(prop);
    }

    public void addMouseListener(ZMouseListener l) {
        this.getListenerList().add(class$edu$umd$cs$jazz$event$ZMouseListener == null ? (class$edu$umd$cs$jazz$event$ZMouseListener = ZSceneGraphObject.class$("edu.umd.cs.jazz.event.ZMouseListener")) : class$edu$umd$cs$jazz$event$ZMouseListener, l);
    }

    public void addMouseMotionListener(ZMouseMotionListener l) {
        this.getListenerList().add(class$edu$umd$cs$jazz$event$ZMouseMotionListener == null ? (class$edu$umd$cs$jazz$event$ZMouseMotionListener = ZSceneGraphObject.class$("edu.umd.cs.jazz.event.ZMouseMotionListener")) : class$edu$umd$cs$jazz$event$ZMouseMotionListener, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Object newObject;
        if (inClone) {
            newObject = this.duplicateObject();
        } else {
            try {
                inClone = true;
                objRefTable.reset();
                newObject = this.duplicateObject();
                Iterator iter = objRefTable.iterator();
                while (iter.hasNext()) {
                    ZSceneGraphObject clonedObject = (ZSceneGraphObject)iter.next();
                    clonedObject.updateObjectReferences(objRefTable);
                }
                Object var5_4 = null;
                inClone = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                inClone = false;
                throw throwable;
            }
        }
        return newObject;
    }

    protected void computeBounds() {
    }

    protected void computeVolatileBounds() {
    }

    public String dump() {
        String str = this.toString();
        ZBounds b = this.getBounds();
        str = b.isEmpty() ? str + ": Bounds = [Empty]" : str + ": Bounds = [x=" + b.getX() + ", y=" + b.getY() + ", w=" + b.getWidth() + ", h=" + b.getHeight() + "]";
        if (this.getVolatileBounds()) {
            str = str + "\n Volatile";
        }
        Iterator i = this.clientProperties.iterator();
        while (i.hasNext()) {
            ZProperty each = (ZProperty)i.next();
            str = str + "\n Property '" + each.getKey() + "': " + each.getValue();
        }
        return str;
    }

    protected Object duplicateObject() {
        ZSceneGraphObject newObject;
        try {
            newObject = (ZSceneGraphObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Object.clone() failed: " + e);
        }
        if (this.bounds != null) {
            newObject.bounds = (ZBounds)this.bounds.clone();
        }
        objRefTable.addObject(this, newObject);
        newObject.listenerList = null;
        if (!this.clientProperties.isNull()) {
            newObject.clientProperties = new ZListImpl.ZPropertyListImpl(this.clientProperties.size());
            ZProperty[] propertiesRef = this.clientProperties.getPropertiesReference();
            int i = 0;
            while (i < this.clientProperties.size()) {
                newObject.clientProperties.add((ZProperty)propertiesRef[i].clone());
                ++i;
            }
        }
        return newObject;
    }

    public void endTransaction() {
        this.markNotInTransaction();
        this.updateVolatility();
        this.updateBounds();
        this.repaint();
    }

    protected void fireEvent(ZEvent anEvent) {
        if (this.listenerList == null) {
            return;
        }
        anEvent.setSource(this);
        Object[] listeners = this.getListenerList().getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == anEvent.getListenerType()) {
                anEvent.dispatchTo(listeners[i + 1]);
            }
            if (anEvent.isConsumed()) {
                return;
            }
            i -= 2;
        }
    }

    public void fireMouseEvent(ZMouseEvent e) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$edu$umd$cs$jazz$event$ZMouseListener == null ? ZSceneGraphObject.class$("edu.umd.cs.jazz.event.ZMouseListener") : class$edu$umd$cs$jazz$event$ZMouseListener)) {
                switch (e.getID()) {
                    case 501: {
                        ((ZMouseListener)listeners[i + 1]).mousePressed(e);
                        break;
                    }
                    case 502: {
                        ((ZMouseListener)listeners[i + 1]).mouseReleased(e);
                        break;
                    }
                    case 504: {
                        ((ZMouseListener)listeners[i + 1]).mouseEntered(e);
                        break;
                    }
                    case 505: {
                        ((ZMouseListener)listeners[i + 1]).mouseExited(e);
                        break;
                    }
                    case 500: {
                        ((ZMouseListener)listeners[i + 1]).mouseClicked(e);
                    }
                }
            }
            if (e.isConsumed()) break;
            if (listeners[i] == (class$edu$umd$cs$jazz$event$ZMouseMotionListener == null ? ZSceneGraphObject.class$("edu.umd.cs.jazz.event.ZMouseMotionListener") : class$edu$umd$cs$jazz$event$ZMouseMotionListener)) {
                switch (e.getID()) {
                    case 506: {
                        ((ZMouseMotionListener)listeners[i + 1]).mouseDragged(e);
                        break;
                    }
                    case 503: {
                        ((ZMouseMotionListener)listeners[i + 1]).mouseMoved(e);
                    }
                }
            }
            if (e.isConsumed()) break;
            i -= 2;
        }
    }

    public ZBounds getBounds() {
        return (ZBounds)this.getBoundsReference().clone();
    }

    public ZBounds getBoundsReference() {
        if (this.getVolatileBounds() || this.invalidBounds) {
            double oldX = 0.0;
            double oldY = 0.0;
            double oldWidth = 0.0;
            double oldHeight = 0.0;
            boolean oldIsEmpty = true;
            boolean hasOldBound = false;
            if (this.bounds != null) {
                oldX = this.bounds.getX();
                oldY = this.bounds.getY();
                oldWidth = this.bounds.getWidth();
                oldHeight = this.bounds.getHeight();
                oldIsEmpty = this.bounds.isEmpty();
                hasOldBound = true;
            }
            this.computeBounds();
            this.invalidBounds = false;
            if (hasOldBound && oldX == this.bounds.getX() && oldY == this.bounds.getY() && oldWidth == this.bounds.getWidth() && oldHeight == this.bounds.getHeight() && oldIsEmpty == this.bounds.isEmpty()) {
                return this.bounds;
            }
            if (this instanceof ZNode) {
                ZNode thisNode = (ZNode)this;
                thisNode.percolateEventUpSceneGraph(ZNodeEvent.createBoundsChangedEvent(thisNode));
                thisNode.percolateEventUpSceneGraph(ZNodeEvent.createGlobalBoundsChangedEvent(thisNode));
            }
        }
        return this.bounds;
    }

    public Object getClientProperty(Object key) {
        return this.clientProperties.getMatchingProperty(key);
    }

    public Collection getHandles() {
        return new ArrayList(0);
    }

    protected EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public boolean getVolatileBounds() {
        if (this.invalidVolatileBounds) {
            this.computeVolatileBounds();
            this.invalidVolatileBounds = false;
        }
        return this.volatileBounds;
    }

    public boolean hasLisenerOfType(Class aType) {
        if (this.listenerList == null) {
            return false;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == aType) {
                return true;
            }
            i -= 2;
        }
        return false;
    }

    public boolean hasListenerOfType(Class aType) {
        if (this.listenerList == null) {
            return false;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == aType) {
                return true;
            }
            i -= 2;
        }
        return false;
    }

    public boolean hasMouseListener() {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$edu$umd$cs$jazz$event$ZMouseListener == null ? ZSceneGraphObject.class$("edu.umd.cs.jazz.event.ZMouseListener") : class$edu$umd$cs$jazz$event$ZMouseListener) || listeners[i] == (class$edu$umd$cs$jazz$event$ZMouseMotionListener == null ? ZSceneGraphObject.class$("edu.umd.cs.jazz.event.ZMouseMotionListener") : class$edu$umd$cs$jazz$event$ZMouseMotionListener)) {
                    return true;
                }
                i -= 2;
            }
        }
        return false;
    }

    protected void markInTransaction() {
        this.inTransaction = true;
    }

    protected void markNotInTransaction() {
        this.inTransaction = false;
    }

    public void processMouseEvent(ZMouseEvent e) {
        this.fireEvent(e);
    }

    public void putClientProperty(Object key, Object value) {
        int index = this.clientProperties.indexOfPropertyWithKey(key);
        if (value == null) {
            if (index != -1) {
                this.clientProperties.remove(index);
            }
        } else if (index == -1) {
            this.addClientProperty(new ZProperty(key, value));
        } else {
            ZProperty found = (ZProperty)this.clientProperties.get(index);
            found.set(key, value);
        }
        if (this.clientProperties.size() == 0) {
            this.clientProperties = ZListImpl.NullList;
        }
    }

    protected void removeEventListener(Class listenerType, EventListener listener) {
        this.getListenerList().remove(listenerType, listener);
        if (this.listenerList.getListenerCount() == 0) {
            this.listenerList = null;
        }
    }

    public void removeMouseListener(ZMouseListener l) {
        this.removeEventListener(class$edu$umd$cs$jazz$event$ZMouseListener == null ? (class$edu$umd$cs$jazz$event$ZMouseListener = ZSceneGraphObject.class$("edu.umd.cs.jazz.event.ZMouseListener")) : class$edu$umd$cs$jazz$event$ZMouseListener, l);
    }

    public void removeMouseMotionListener(ZMouseMotionListener l) {
        this.removeEventListener(class$edu$umd$cs$jazz$event$ZMouseMotionListener == null ? (class$edu$umd$cs$jazz$event$ZMouseMotionListener = ZSceneGraphObject.class$("edu.umd.cs.jazz.event.ZMouseMotionListener")) : class$edu$umd$cs$jazz$event$ZMouseMotionListener, l);
    }

    public void repaint() {
        if (ZDebug.debugRepaint) {
            System.out.println("ZSceneGraphObject.repaint: this = " + this);
        }
    }

    public void repaint(ZBounds bounds) {
        if (ZDebug.debugRepaint) {
            System.out.println("ZSceneGraphObject.repaint(ZBounds): this = " + this);
            System.out.println("ZSceneGraphObject.repaint(ZBounds): bounds = " + bounds);
        }
    }

    public void reshape() {
        if (!this.inTransaction && this.getVolatileBounds()) {
            this.repaint((ZBounds)this.bounds.clone());
        } else {
            this.repaint();
        }
        this.updateBounds();
        this.repaint();
    }

    protected void setBounds(ZBounds newBounds) {
        this.bounds.setRect(newBounds);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        if (fieldName.compareTo("volatileBounds") == 0) {
            this.setVolatileBounds((Boolean)fieldValue);
        } else if (fieldName.compareTo("properties") == 0) {
            Iterator i = ((Vector)fieldValue).iterator();
            while (i.hasNext()) {
                ZProperty prop = (ZProperty)i.next();
                this.addClientProperty(prop);
            }
        }
    }

    public void setVolatileBounds(boolean v) {
        this.volatileBounds = v;
        this.updateVolatility();
    }

    public void startTransaction() {
        this.repaint();
        this.markInTransaction();
    }

    public void trimToSize() {
        this.clientProperties.trimToSize();
    }

    protected void updateBounds() {
        this.invalidBounds = true;
    }

    protected void updateObjectReferences(ZObjectReferenceTable objRefTable) {
        if (!inClone) {
            throw new RuntimeException("ZSceneGraphObject.updateObjectReferences: Called outside of a clone");
        }
        ZProperty[] propertiesRef = this.clientProperties.getPropertiesReference();
        int i = 0;
        while (i < this.clientProperties.size()) {
            propertiesRef[i].updateObjectReferences(objRefTable);
            ++i;
        }
    }

    protected void updateVolatility() {
        this.invalidVolatileBounds = true;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        if (this.volatileBounds) {
            out.writeState("boolean", "volatileBounds", this.volatileBounds);
        }
        this.clientProperties.writeObject("properties", out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.invalidBounds = true;
        this.invalidVolatileBounds = true;
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        ZProperty[] propertiesRef = this.clientProperties.getPropertiesReference();
        int i = 0;
        while (i < this.clientProperties.size()) {
            out.addObject(propertiesRef[i]);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        volatileBounds_DEFAULT = false;
        objRefTable = ZObjectReferenceTable.getInstance();
    }
}

