/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.util.ZUtil;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class ZCoordListShape
implements Shape,
Cloneable {
    public static int DEFAULT_WINDING_RULE = 0;
    protected int coordCount = 0;
    protected double[] xCoords = new double[2];
    protected double[] yCoords = new double[2];
    protected boolean isClosed = false;
    protected int windingRule = DEFAULT_WINDING_RULE;

    public ZCoordListShape() {
        this.xCoords = new double[2];
        this.yCoords = new double[2];
    }

    public ZCoordListShape(boolean isClosed) {
        this();
        this.isClosed = isClosed;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean aBoolean) {
        this.isClosed = aBoolean;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public void setWindingRule(int aWindingRule) {
        this.windingRule = aWindingRule;
    }

    public int getNumberPoints() {
        return this.getVertexCount();
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            this.trimToSize();
            ZCoordListShape copy = (ZCoordListShape)super.clone();
            copy.xCoords = (double[])this.xCoords.clone();
            copy.yCoords = (double[])this.yCoords.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean contains(double x, double y) {
        if (!this.isClosed) {
            return false;
        }
        return ZUtil.isInsidePolygon(x, y, this.getVertexCount(), this.xCoords, this.yCoords);
    }

    public boolean contains(double x1, double y1, double w, double h) {
        double x2 = x1 + w;
        double y2 = y1 + h;
        return this.contains(x1, y1) && this.contains(x1, y2) && this.contains(x2, y1) && this.contains(x2, y2);
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(Rectangle2D r) {
        return ZUtil.isInsidePolygon(r, this.getVertexCount(), this.xCoords, this.yCoords);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        if (this.coordCount <= 0) {
            return new Rectangle2D.Double();
        }
        double x1 = this.xCoords[0];
        double y1 = this.yCoords[0];
        double x2 = x1;
        double y2 = y1;
        int i = 1;
        while (i < this.getVertexCount()) {
            if (this.xCoords[i] < x1) {
                x1 = this.xCoords[i];
            } else if (this.xCoords[i] > x2) {
                x2 = this.xCoords[i];
            }
            if (this.yCoords[i] < y1) {
                y1 = this.yCoords[i];
            } else if (this.yCoords[i] > y2) {
                y2 = this.yCoords[i];
            }
            ++i;
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new ZCoordListIterator(this, at, this.isClosed && this.getNumberPoints() > 0);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public int getVertexCount() {
        return this.coordCount;
    }

    public double getX(int index) {
        return this.xCoords[index];
    }

    public double getY(int index) {
        return this.yCoords[index];
    }

    public void insertPoint(int index, double x, double y) {
        if (index > this.getVertexCount()) {
            index = this.getVertexCount();
        }
        this.lineTo(x, y);
        int i = this.getVertexCount() - 1;
        while (i > index) {
            this.setX(i, this.getX(i - 1));
            this.setY(i, this.getY(i - 1));
            --i;
        }
        this.setX(index, x);
        this.setY(index, y);
    }

    public boolean intersects(double x1, double y1, double w, double h) {
        if (this.isClosed) {
            double x2 = x1 + w;
            double y2 = y1 + h;
            return this.contains(x1, y1) || this.contains(x1, y2) || this.contains(x2, y1) || this.contains(x2, y2);
        }
        return this.intersects(new Rectangle2D.Double(x1, y1, w, h));
    }

    public boolean intersects(Rectangle2D r) {
        if (this.isClosed) {
            return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }
        if (this.coordCount == 0) {
            return false;
        }
        if (this.coordCount == 1) {
            return r.contains(this.getX(0), this.getY(0));
        }
        int count = this.getVertexCount();
        double x2 = this.getX(0);
        double y2 = this.getY(0);
        int i = 1;
        while (i < count) {
            double x1 = x2;
            double y1 = y2;
            if (r.intersectsLine(x1, y1, x2 = this.getX(i), y2 = this.getY(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void lineTo(double x, double y) {
        if (this.coordCount == this.xCoords.length) {
            double[] temp = new double[this.coordCount * 2];
            System.arraycopy(this.xCoords, 0, temp, 0, this.coordCount);
            this.xCoords = temp;
            temp = new double[this.coordCount * 2];
            System.arraycopy(this.yCoords, 0, temp, 0, this.coordCount);
            this.yCoords = temp;
        }
        this.xCoords[this.coordCount] = x;
        this.yCoords[this.coordCount] = y;
        ++this.coordCount;
    }

    public void moveTo(double x, double y) {
        if (this.coordCount > 0) {
            throw new UnsupportedOperationException("This coordlist already has vertices");
        }
        this.xCoords[0] = x;
        this.yCoords[0] = y;
        this.coordCount = 1;
    }

    public void reset() {
        this.coordCount = 0;
    }

    public void setX(int index, double x) {
        this.xCoords[index] = x;
    }

    public void setY(int index, double y) {
        this.yCoords[index] = y;
    }

    public double[] getXCoords() {
        this.trimToSize();
        return this.xCoords;
    }

    public double[] getYCoords() {
        this.trimToSize();
        return this.yCoords;
    }

    public void trimToSize() {
        double[] newXP = new double[this.coordCount];
        double[] newYP = new double[this.coordCount];
        int i = 0;
        while (i < this.coordCount) {
            newXP[i] = this.xCoords[i];
            newYP[i] = this.yCoords[i];
            ++i;
        }
        this.xCoords = newXP;
        this.yCoords = newYP;
    }

    protected static class ZCoordListIterator
    implements PathIterator {
        private ZCoordListShape coordList;
        private AffineTransform transform;
        private int index = 0;
        private boolean isClosed;

        public ZCoordListIterator(ZCoordListShape pl, AffineTransform at, boolean isClosed) {
            this.transform = at;
            this.index = 0;
            this.coordList = pl;
            this.isClosed = isClosed;
        }

        public int currentSegment(double[] coords) {
            int result = -1;
            if (this.index == this.coordList.getVertexCount()) {
                return 4;
            }
            coords[0] = this.coordList.getX(this.index);
            coords[1] = this.coordList.getY(this.index);
            result = this.index == 0 ? 0 : 1;
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return result;
        }

        public int currentSegment(float[] coords) {
            int result = -1;
            if (this.index == this.coordList.getVertexCount()) {
                return 4;
            }
            coords[0] = (float)this.coordList.getX(this.index);
            coords[1] = (float)this.coordList.getY(this.index);
            result = this.index == 0 ? 0 : 1;
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return result;
        }

        public int getWindingRule() {
            return this.coordList.getWindingRule();
        }

        public boolean isDone() {
            if (this.isClosed) {
                return this.index > this.coordList.getVertexCount();
            }
            return this.index == this.coordList.getVertexCount();
        }

        public void next() {
            ++this.index;
        }
    }
}

