/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSelectionManager;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZRectangle;
import edu.umd.cs.jazz.event.ZEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseListener;
import edu.umd.cs.jazz.event.ZMouseMotionListener;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZMagBoundsFindFilter;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class ZSelectionEventHandler
implements ZEventHandler,
ZMouseListener,
ZMouseMotionListener,
KeyListener,
Serializable {
    private boolean active = false;
    private ZNode node = null;
    private ZCanvas canvas = null;
    private ArrayList prevMotionSelection;
    private ArrayList itemsToRemove;
    private ZNode selNode;
    private transient Point2D pt1;
    private transient Point2D pt2;
    private transient Point2D pressPt;
    private transient Point2D dragPt;
    private transient Point2D prevPt;
    private ZVisualLeaf marquee;
    private ZGroup marqueeLayer;
    private int scaleUpKey = 33;
    private int scaleDownKey = 34;
    private int translateLeftKey = 37;
    private int translateRightKey = 39;
    private int translateUpKey = 38;
    private int translateDownKey = 40;
    private int deleteKey = 127;
    private int all_button_mask = 63;
    private int all_button_but_shift_mask = 62;
    ArrayList invisibleNodes = new ArrayList();

    public ZSelectionEventHandler(ZNode node, ZCanvas canvas, ZGroup marqueeLayer) {
        this.node = node;
        this.canvas = canvas;
        this.pt1 = new Point2D.Double();
        this.pt2 = new Point2D.Double();
        this.pressPt = new Point2D.Double();
        this.dragPt = new Point2D.Double();
        this.prevPt = new Point2D.Double();
        this.prevMotionSelection = new ArrayList();
        this.itemsToRemove = new ArrayList();
        this.marqueeLayer = marqueeLayer;
        this.marquee = null;
    }

    public void setActive(boolean active) {
        if (this.active && !active) {
            this.active = false;
            this.node.removeMouseListener(this);
            this.node.removeMouseMotionListener(this);
            this.canvas.removeKeyListener(this);
            ZSelectionManager.unselectAll(this.canvas.getCamera());
        } else if (!this.active && active) {
            this.active = true;
            this.node.addMouseListener(this);
            this.node.addMouseMotionListener(this);
            this.canvas.addKeyListener(this);
            this.canvas.requestFocus();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setMarqueeLayer(ZGroup layer) {
        this.marqueeLayer = layer;
    }

    public void keyPressed(KeyEvent e) {
        block18: {
            ArrayList selection;
            boolean delete;
            block19: {
                ZNode node;
                boolean scale;
                double scaleZ;
                block17: {
                    ZCamera camera = this.canvas.getCamera();
                    int keyCode = e.getKeyCode();
                    double scaleDelta = 1.1f;
                    double panDelta = 1.0;
                    scaleZ = 1.0;
                    double panX = 0.0;
                    double panY = 0.0;
                    scale = false;
                    boolean pan = false;
                    delete = false;
                    if (keyCode == this.scaleUpKey) {
                        scale = true;
                        scaleZ = scaleDelta;
                    } else if (keyCode == this.scaleDownKey) {
                        scale = true;
                        scaleZ = 1.0 / scaleDelta;
                    } else if (keyCode == this.translateLeftKey) {
                        pan = true;
                        panX = -1.0 * panDelta;
                        panY = 0.0;
                    } else if (keyCode == this.translateRightKey) {
                        pan = true;
                        panX = 1.0 * panDelta;
                        panY = 0.0;
                    } else if (keyCode == this.translateUpKey) {
                        pan = true;
                        panX = 0.0;
                        panY = -1.0 * panDelta;
                    } else if (keyCode == this.translateDownKey) {
                        pan = true;
                        panX = 0.0;
                        panY = 1.0 * panDelta;
                    } else if (keyCode == this.deleteKey) {
                        delete = true;
                    }
                    selection = ZSelectionManager.getSelectedNodes(camera);
                    if (!pan) break block17;
                    Iterator i = selection.iterator();
                    while (i.hasNext()) {
                        ZNode node2 = (ZNode)i.next();
                        ZTransformGroup transform = node2.editor().getTransformGroup();
                        this.pt1.setLocation(0.0, 0.0);
                        camera.cameraToLocal(this.pt1, (ZNode)transform);
                        this.pt2.setLocation(panX, panY);
                        camera.cameraToLocal(this.pt2, (ZNode)transform);
                        double dx = this.pt2.getX() - this.pt1.getX();
                        double dy = this.pt2.getY() - this.pt1.getY();
                        transform.translate(dx, dy);
                    }
                    break block18;
                }
                if (!scale) break block19;
                ZTransformGroup transform = null;
                ZBounds bounds = new ZBounds();
                Iterator i = selection.iterator();
                while (i.hasNext()) {
                    node = (ZNode)i.next();
                    bounds.add(node.getGlobalBounds());
                }
                Point2D center = bounds.getCenter2D();
                Iterator i2 = selection.iterator();
                while (i2.hasNext()) {
                    node = (ZNode)i2.next();
                    this.pt1.setLocation(center);
                    node.globalToLocal(this.pt1);
                    transform = node.editor().getTransformGroup();
                    transform.scale(scaleZ, this.pt1.getX(), this.pt1.getY());
                }
                break block18;
            }
            if (!delete) break block18;
            Iterator i = selection.iterator();
            while (i.hasNext()) {
                ZNode node = (ZNode)i.next();
                ZNode handle = node.editor().getTop();
                handle.getParent().removeChild(handle);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mousePressed(ZMouseEvent e) {
        if ((e.getModifiers() & this.all_button_but_shift_mask) == 16) {
            ZSceneGraphPath path = e.getPath();
            ZCamera camera = path.getCamera();
            boolean marqueeSelect = false;
            path.getTopCamera().getDrawingSurface().setInteracting(true);
            this.selNode = path.getObject() == null ? null : path.getNode();
            this.pressPt.setLocation(e.getX(), e.getY());
            this.prevPt.setLocation(this.pressPt);
            if (this.selNode == null) {
                if (!e.isShiftDown()) {
                    ZSelectionManager.unselectAll(camera);
                }
                marqueeSelect = true;
            } else if (e.isShiftDown()) {
                if (ZSelectionManager.isSelected(this.selNode)) {
                    ZSelectionManager.unselect(this.selNode);
                } else if (this.selNode.isFindable()) {
                    ZSelectionManager.select(this.selNode);
                }
            } else if (!ZSelectionManager.isSelected(this.selNode)) {
                ZSelectionManager.unselectAll(camera);
                if (this.selNode.isFindable()) {
                    ZSelectionManager.select(this.selNode);
                }
            }
            if (marqueeSelect) {
                this.pt1.setLocation(this.pressPt);
                double dz = camera.cameraToLocal(this.pt1, (ZNode)this.marqueeLayer);
                ZRectangle rect = new ZRectangle(this.pt1.getX(), this.pt1.getY());
                rect.setPenWidth(1.0 * dz);
                rect.setPenPaint(Color.black);
                rect.setFillPaint(null);
                this.marquee = new ZVisualLeaf(rect);
                this.marquee.setPickable(false);
                this.marquee.setFindable(false);
                this.marqueeLayer.addChild(this.marquee);
            }
        }
    }

    public void mouseDragged(ZMouseEvent e) {
        if ((e.getModifiers() & this.all_button_mask) == 16) {
            ZSceneGraphPath path = e.getPath();
            ZCamera camera = path.getCamera();
            this.dragPt.setLocation(e.getX(), e.getY());
            if (this.marquee == null) {
                if (this.selNode == null) {
                    return;
                }
                ArrayList selection = ZSelectionManager.getSelectedNodes(camera);
                Iterator i = selection.iterator();
                while (i.hasNext()) {
                    ZNode node = (ZNode)i.next();
                    ZTransformGroup transform = node.editor().getTransformGroup();
                    this.pt1.setLocation(this.prevPt);
                    camera.cameraToLocal(this.pt1, (ZNode)transform);
                    this.pt2.setLocation(this.dragPt);
                    camera.cameraToLocal(this.pt2, (ZNode)transform);
                    double dx = this.pt2.getX() - this.pt1.getX();
                    double dy = this.pt2.getY() - this.pt1.getY();
                    transform.translate(dx, dy);
                }
                this.prevPt.setLocation(this.dragPt);
            } else {
                ZNode node;
                this.pt1.setLocation(this.dragPt);
                camera.cameraToLocal(this.pt1, this.selNode);
                this.pt2.setLocation(this.pressPt);
                camera.cameraToLocal(this.pt2, this.selNode);
                double x = Math.min(this.pt2.getX(), this.pt1.getX());
                double y = Math.min(this.pt2.getY(), this.pt1.getY());
                double width = Math.abs(this.pt2.getX() - this.pt1.getX());
                double height = Math.abs(this.pt2.getY() - this.pt1.getY());
                ZRectangle rect = (ZRectangle)this.marquee.getFirstVisualComponent();
                rect.setRect(x, y, width, height);
                ZMagBoundsFindFilter filter = new ZMagBoundsFindFilter(this.marquee.getGlobalBounds(), camera.getMagnification());
                ArrayList nodes = camera.findNodes(filter);
                Iterator i = nodes.iterator();
                while (i.hasNext()) {
                    node = (ZNode)i.next();
                    if (this.prevMotionSelection.contains(node)) continue;
                    ZSelectionManager.select(node);
                    this.prevMotionSelection.add(node);
                }
                this.itemsToRemove.clear();
                Iterator i2 = this.prevMotionSelection.iterator();
                while (i2.hasNext()) {
                    node = (ZNode)i2.next();
                    if (nodes.contains(node)) continue;
                    ZSelectionManager.unselect(node);
                    this.itemsToRemove.add(node);
                }
                Iterator i3 = this.itemsToRemove.iterator();
                while (i3.hasNext()) {
                    node = (ZNode)i3.next();
                    this.prevMotionSelection.remove(node);
                }
            }
        }
    }

    public void mouseReleased(ZMouseEvent e) {
        if ((e.getModifiers() & this.all_button_mask) == 16) {
            ZSceneGraphPath path = e.getPath();
            this.selNode = null;
            this.prevMotionSelection.clear();
            if (this.marquee != null) {
                this.marqueeLayer.removeChild(this.marquee);
                this.marquee = null;
            }
            path.getTopCamera().getDrawingSurface().setInteracting(false);
        }
    }

    public void mouseEntered(ZMouseEvent e) {
    }

    public void mouseExited(ZMouseEvent e) {
    }

    public void mouseClicked(ZMouseEvent e) {
    }

    public void mouseMoved(ZMouseEvent e) {
    }
}

