/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.ZVisualGroup;
import edu.umd.cs.jazz.ZVisualLeaf;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import javax.swing.SwingUtilities;

public class ZDebug
implements Serializable {
    public static final boolean debug = true;
    public static boolean showBounds;
    private static ZCamera boundsCamera;
    public static boolean debugRegionMgmt;
    public static boolean debugRender;
    public static boolean debugRepaint;
    public static boolean debugTiming;
    public static boolean debugPick;
    public static boolean debugSpatialIndexing;
    private static int paintCount;
    private static StringBuffer dumpBuffer;

    public static void setShowBounds(boolean showBounds, ZCamera camera) {
        if (boundsCamera != null) {
            boundsCamera.repaint();
        }
        ZDebug.showBounds = showBounds;
        boundsCamera = camera;
        if (camera != null) {
            camera.repaint();
        }
    }

    public static void clearPaintCount() {
        paintCount = 0;
    }

    public static void incPaintCount() {
        ++paintCount;
    }

    public static boolean isEventThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public static int getPaintCount() {
        return paintCount;
    }

    public static void dump(ZNode node) {
        dumpBuffer = null;
        ZDebug.dump(node, 0, true);
    }

    public static String dumpString(ZSceneGraphObject obj, boolean includeChildren) {
        dumpBuffer = new StringBuffer();
        ZDebug.dump(obj, 0, includeChildren);
        return dumpBuffer.toString();
    }

    private static void println(String line) {
        if (dumpBuffer != null) {
            dumpBuffer.append(line);
            dumpBuffer.append('\n');
        } else {
            System.out.println(line);
        }
    }

    private static void print(String str) {
        if (dumpBuffer != null) {
            dumpBuffer.append(str);
        } else {
            System.out.print(str);
        }
    }

    protected static void dump(ZSceneGraphObject sgo, int level, boolean includeChildren) {
        ZNode[] children;
        String space = "";
        int i = 0;
        while (i < level) {
            space = space.concat("    ");
            ++i;
        }
        ZDebug.dumpElement(space, "* ", sgo.dump());
        if (includeChildren && sgo instanceof ZGroup && (children = ((ZGroup)sgo).getChildren()).length > 0) {
            ZDebug.println(space + "  - Children:      ");
            i = 0;
            while (i < children.length) {
                ZNode child = children[i];
                if (child.getParent() != sgo) {
                    ZDebug.println("");
                    ZDebug.println("WARNING: parent pointer of " + child + " not equal to " + sgo);
                    ZDebug.println("WARNING: instead it is set to " + child.getParent());
                    ZDebug.println("");
                }
                ZDebug.dump(child, level + 1, includeChildren);
                ++i;
            }
        }
        ZVisualComponent vc = null;
        if (sgo instanceof ZVisualLeaf && (vc = ((ZVisualLeaf)sgo).getFirstVisualComponent()) != null) {
            ZDebug.println(space + "  => Visual Component:      ");
            ZDebug.dump(vc, level + 1, includeChildren);
        }
        if (sgo instanceof ZVisualGroup) {
            vc = ((ZVisualGroup)sgo).getFrontVisualComponent();
            if (vc != null) {
                ZDebug.println(space + "  => Front Visual Component:      ");
                ZDebug.dump(vc, level + 1, includeChildren);
            }
            if ((vc = ((ZVisualGroup)sgo).getBackVisualComponent()) != null) {
                ZDebug.println(space + "  => Back Visual Component:      ");
                ZDebug.dump(vc, level + 1, includeChildren);
            }
        }
    }

    protected static void dumpElement(String space, String origHeader, String element) {
        boolean done = false;
        boolean newLine = true;
        String header = origHeader;
        StringReader reader = new StringReader(element);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.eolIsSignificant(true);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(44, 44);
        tokenizer.wordChars(58, 58);
        tokenizer.wordChars(61, 61);
        tokenizer.wordChars(64, 64);
        tokenizer.wordChars(40, 40);
        tokenizer.wordChars(41, 41);
        tokenizer.wordChars(91, 91);
        tokenizer.wordChars(93, 93);
        tokenizer.wordChars(39, 39);
        do {
            if (newLine) {
                ZDebug.print(space + header);
                String temp = new String();
                int i = 0;
                while (i < origHeader.length()) {
                    temp = temp.concat(" ");
                    ++i;
                }
                header = temp = temp.concat("- ");
                newLine = false;
            }
            try {
                tokenizer.nextToken();
                switch (tokenizer.ttype) {
                    case -3: {
                        ZDebug.print(tokenizer.sval + " ");
                        break;
                    }
                    case -2: {
                        ZDebug.print(tokenizer.nval + " ");
                        break;
                    }
                    case 10: {
                        ZDebug.println("");
                        newLine = true;
                        break;
                    }
                    case -1: {
                        done = true;
                    }
                }
            }
            catch (IOException e) {
                ZDebug.println("");
                ZDebug.println("Error parsing string while dumping scenegraph: " + element);
                done = true;
            }
        } while (!done);
        ZDebug.println("");
    }

    static {
        debug = true;
        showBounds = false;
        boundsCamera = null;
        debugRegionMgmt = false;
        debugRender = false;
        debugRepaint = false;
        debugTiming = false;
        debugPick = false;
        debugSpatialIndexing = false;
        dumpBuffer = null;
    }
}

