/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZListImpl;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Stack;

public class ZRenderContext
implements Serializable {
    private static final int DEFAULT_NUM_VISIBLE_BOUNDS = 10;
    private Stack cameras;
    private Stack transforms;
    private ZList.ZBoundsList visibleBounds = ZListImpl.NullList;
    private ZDrawingSurface surface = null;
    private transient Graphics2D g2;
    private boolean greekText = false;

    public ZRenderContext(ZCamera camera) {
        this.cameras = new Stack();
        this.transforms = new Stack();
        this.visibleBounds = new ZListImpl.ZBoundsListImpl(10);
        this.visibleBounds.add(0, camera.getViewBounds());
        this.cameras.push(camera);
    }

    public ZRenderContext(Graphics2D aG2, ZBounds visibleBounds, ZDrawingSurface aSurface, int qualityRequested) {
        this.cameras = new Stack();
        this.transforms = new Stack();
        this.visibleBounds = new ZListImpl.ZBoundsListImpl(10);
        this.visibleBounds.add(0, visibleBounds);
        this.g2 = aG2;
        this.surface = aSurface;
        this.setRenderingHints(this.g2, qualityRequested);
    }

    public Graphics2D getGraphics2D() {
        return this.g2;
    }

    public void pushVisibleBounds(ZBounds bounds) {
        this.visibleBounds.add(bounds);
    }

    public void popVisibleBounds() {
        this.visibleBounds.pop();
    }

    public ZBounds getVisibleBounds() {
        if (this.visibleBounds.size() == 0) {
            return null;
        }
        return (ZBounds)this.visibleBounds.get(this.visibleBounds.size() - 1);
    }

    public ZDrawingSurface getDrawingSurface() {
        return this.surface;
    }

    public void setAccurateSpacing(boolean b) {
    }

    public boolean getAccurateSpacing() {
        return false;
    }

    public void setGreekText(boolean b) {
        this.greekText = b;
    }

    public boolean getGreekText() {
        return this.greekText;
    }

    protected void setRenderingHints(Graphics2D g2, int quality) {
        switch (quality) {
            case 1: {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                this.setGreekText(true);
                break;
            }
            case 2: {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                this.setGreekText(false);
                break;
            }
            case 3: {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                this.setGreekText(false);
            }
        }
    }

    public ZCamera getRenderingCamera() {
        if (this.cameras.isEmpty()) {
            return null;
        }
        return (ZCamera)this.cameras.peek();
    }

    public AffineTransform getCameraTransform() {
        if (this.transforms.isEmpty()) {
            return null;
        }
        return (AffineTransform)this.transforms.peek();
    }

    public void pushCamera(ZCamera camera) {
        this.cameras.push(camera);
        this.transforms.push(this.g2.getTransform());
    }

    public void popCamera() {
        this.cameras.pop();
        this.transforms.pop();
    }

    public double getCameraMagnification() {
        ZCamera camera = this.getRenderingCamera();
        if (camera == null) {
            return 1.0;
        }
        return camera.getMagnification();
    }

    public double getCompositeMagnification() {
        return ZTransformGroup.computeScale(this.g2.getTransform());
    }

    static {
        DEFAULT_NUM_VISIBLE_BOUNDS = 10;
    }
}

