/*
 * Decompiled with CFR 0.152.
 */
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import se.datadosen.component.ComponentUtilities;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JAlphaColorSelector;
import se.datadosen.component.JColorSelector;
import se.datadosen.component.JLabelFor;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JPlaylist;
import se.datadosen.component.JSmartTextArea;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.ShareIcons;
import se.datadosen.component.StateMonitor;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.CompiledBase;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JAlbumWindow;
import se.datadosen.jalbum.JCustomPanel;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.tags.ElementException;
import se.datadosen.util.IO;
import se.datadosen.util.Item;

public class Gui
extends CompiledBase {
    private String skinVer;
    private String license;
    JTextArea readme;
    JScrollPane aboutPanel;
    private JFileChooser fc;
    private JFileFilter imgFilter;
    List<String> fontFaces;
    StateMonitor commercialMonitor;
    ControlPanel ui;

    private Object[] getPosition() {
        return new Object[]{new Item((Object)"left top", (Object)this.texts.getString("ui.bg_left_top")), new Item((Object)"center top", (Object)this.texts.getString("ui.bg_center_top")), new Item((Object)"right top", (Object)this.texts.getString("ui.bg_right_top")), new Item((Object)"left center", (Object)this.texts.getString("ui.bg_left_middle")), new Item((Object)"center center", (Object)this.texts.getString("ui.bg_center_middle")), new Item((Object)"right center", (Object)this.texts.getString("ui.bg_right_middle")), new Item((Object)"left bottom", (Object)this.texts.getString("ui.bg_left_bottom")), new Item((Object)"center bottom", (Object)this.texts.getString("ui.bg_center_bottom")), new Item((Object)"right bottom", (Object)this.texts.getString("ui.bg_right_bottom"))};
    }

    private Color getHighlightedColor(String s) {
        long[] lArray = new long[]{Integer.parseInt(s.substring(1, 3), 16), Integer.parseInt(s.substring(3, 5), 16), Integer.parseInt(s.substring(5, 7), 16)};
        long[] rgb = lArray;
        if ((double)(3L * rgb[0] + 4L * rgb[1] + rgb[2]) / 2040.0 < 0.85) {
            for (int i = 0; i < 3; ++i) {
                rgb[i] = rgb[i] < 128L ? Math.round(127.0 * Math.pow((double)rgb[i] / 127.0, 2.0)) : Math.round(255.0 - 127.0 * Math.pow((double)(255L - rgb[i]) / 127.0, 2.0));
                rgb[i] = Math.round(Math.floor(127.0 + (double)rgb[i] * 0.5));
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                rgb[i] = Math.round((double)rgb[i] * 0.8);
            }
        }
        return new Color((int)rgb[0], (int)rgb[1], (int)rgb[2]);
    }

    private ImageIcon createImageIcon(String path) {
        URL imgURL = ((Object)((Object)this)).getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, path);
        }
        System.out.println("Couldn't find file: " + path);
        return null;
    }

    private String attemptSignIn() {
        SignInManager mgr = SignInManager.getInstance();
        if (mgr != null && mgr.isSignedIn()) {
            return "&cid=" + AccountManager.getCid((String)mgr.getUserName(), (String)mgr.getPassword());
        }
        return "";
    }

    private String getLicense() {
        return this.licenseManager.isLicenseValid() ? this.licenseManager.getUserName() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContents(String name) {
        StringBuilder cont = new StringBuilder();
        String nl = System.getProperty("line.separator");
        File f = new File(this.skinDirectory, name);
        try {
            BufferedReader in = new BufferedReader(new FileReader(f));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    cont.append(line);
                    cont.append(nl);
                }
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return cont.toString();
    }

    private void getFileToRes(String[] ext, JTextField name) {
        this.getFileToRes(new JFileFilter(ext, "allowed files"), name);
    }

    private void getFileToRes(JFileFilter filter, JTextField name) {
        String fn;
        this.fc.setFileFilter(filter);
        int returnVal = this.fc.showOpenDialog((Component)this.window);
        if (returnVal == 0 && !(fn = this.fc.getSelectedFile().toString()).trim().equals("")) {
            File src = new File(fn);
            File dst = new File(this.engine.getDirectory(), "res");
            if (!dst.exists()) {
                dst.mkdir();
            }
            if (src.exists() && dst.exists()) {
                try {
                    IO.copyFile((File)src, (File)dst);
                    name.setText(src.getName());
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            }
        }
    }

    private void getFile(JFileFilter filter, JTextField name) {
        this.fc.setFileFilter(filter);
        int returnVal = this.fc.showOpenDialog((Component)this.window);
        if (returnVal == 0) {
            name.setText(this.fc.getSelectedFile().toString());
        }
    }

    private void fillFontFaces() {
        if (this.fontFaces.isEmpty()) {
            String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            this.fontFaces.addAll(Arrays.asList(fonts));
        }
    }

    private void processSubdirectoriesWarning() {
        if (!this.engine.isSubdirs() || this.engine.isUpdatedDirsOnly()) {
            JOptionPane.showMessageDialog((Component)this.window, this.texts.getString("ui.processSubdirectoriesWarning").replace("{0}", Msg.get((String)"ui.advancedPanel") + " : " + Msg.get((String)"ui.processSubdirectoriesCheckbox")).replace("{1}", Msg.get((String)"ui.advancedPanel") + " : " + Msg.get((String)"ui.updatedDirsOnly")), "Warning", 2);
        }
    }

    public Gui(JAlbumWindow window, JAlbumContext context) {
        super(context.getEngine());
        this.skinVer = new SkinProperties(this.skinDirectory).getProperty("version").toString();
        this.license = this.getLicense();
        this.readme = new JSmartTextArea(this.getFileContents("readme.txt"), 20, 30);
        this.readme.setLineWrap(true);
        this.readme.setWrapStyleWord(true);
        this.readme.setEditable(false);
        this.aboutPanel = new JScrollPane(this.readme, 22, 31);
        this.fc = new JFileChooser();
        this.imgFilter = new JFileFilter(new String[]{"jpg", "png", "gif"}, "Images");
        this.fontFaces = new ArrayList<String>();
        this.commercialMonitor = new StateMonitor(){

            public void onChange() {
                if (((JCheckBox)this.source).isSelected() && Gui.this.license.length() == 0) {
                    Object[] options = new Object[]{Gui.this.texts.getString("ui.signUp"), Gui.this.texts.getString("ui.noThanks")};
                    int n = JOptionPane.showOptionDialog((Component)Gui.this.window, Gui.this.texts.getString("ui.licenseWarningText"), Gui.this.texts.getString("ui.licenseWarningTitle"), 0, 1, null, options, options[1]);
                    if (n == 0) {
                        try {
                            BrowserLauncher.openURL((String)(JAlbumSite.getTrueInstance().getMyJAlbumUpgradeUrl() + "/?referrer=" + Gui.this.skin + Gui.this.attemptSignIn()));
                        }
                        catch (ElementException x) {
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    ((JCheckBox)this.source).setSelected(false);
                }
            }
        };
        this.ui = new ControlPanel(){
            JCheckBox guiExists = new JCheckBox("", true);
            JTextField skinVersion = new JTextField(Gui.access$200(Gui.this));
            JLabel formattingHint1h;
            JLabel formattingHint2h;
            JLabel formattingHint1f;
            JLabel formattingHint2f;
            ControlPanel site;
            JScrollPane sitePanel;
            ControlPanel design;
            JScrollPane designPanel;
            ControlPanel themeImage;
            JScrollPane themeImagePanel;
            ControlPanel thumbnails;
            JScrollPane thumbnailsPanel;
            ControlPanel images;
            JScrollPane imagesPanel;
            ControlPanel filters;
            ControlPanel social;
            ControlPanel photoData;
            ControlPanel map;
            ControlPanel shop;
            ControlPanel av;
            ControlPanel advanced;
            ControlPanel about;
            JTabbedPane tabs;
            {
                this.formattingHint1h = new JLabel(Gui.this.texts.getString("ui.formattingHint1"));
                this.formattingHint2h = new JLabel(Gui.this.texts.getString("ui.formattingHint2"));
                this.formattingHint1f = new JLabel(Gui.this.texts.getString("ui.formattingHint1"));
                this.formattingHint2f = new JLabel(Gui.this.texts.getString("ui.formattingHint2"));
                this.site = new ControlPanel(){
                    ControlPanel navigationPanel;
                    ControlPanel featuresPanel;
                    ControlPanel footerPanel;
                    {
                        this.navigationPanel = new ControlPanel(Gui.this.texts.getString("ui.navigation")){
                            JCheckBox showTopNavigation;
                            JCheckBox topNavigationExcludeFolders;
                            JTextField logoName;
                            JButton selectLogo;
                            JCheckBox hidePagesIfTopnav;
                            JCheckBox linkNeighboringFolders;
                            JCheckBox showBreadcrumbPath;
                            JCheckBox skipThumbnailPage;
                            {
                                this.showTopNavigation = new JCheckBox(Gui.this.texts.getString("ui.showTopNavigation"), false);
                                this.topNavigationExcludeFolders = new JCheckBox(Gui.this.texts.getString("ui.excludeFolders"), false);
                                this.logoName = new JSmartTextField(30);
                                this.selectLogo = new JButton(Gui.this.texts.getString("ui.select"));
                                this.hidePagesIfTopnav = new JCheckBox(Gui.this.texts.getString("ui.hidePagesIfTopnav"), true);
                                this.linkNeighboringFolders = new JCheckBox(Gui.this.texts.getString("ui.linkNeighboringFolders"), true);
                                this.showBreadcrumbPath = new JCheckBox(Gui.this.texts.getString("ui.useBreadcrumbPath"), false);
                                this.skipThumbnailPage = new JCheckBox(Gui.this.texts.getString("ui.skipThumbnailPage"));
                                this.showTopNavigation.setToolTipText(Gui.this.texts.getString("ui.showTopNavigationInfo"));
                                this.topNavigationExcludeFolders.setToolTipText(Gui.this.texts.getString("ui.excludeFoldersInfo"));
                                this.selectLogo.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        Gui.this.getFileToRes(Gui.this.imgFilter, logoName);
                                    }
                                });
                                this.hidePagesIfTopnav.setToolTipText(Gui.this.texts.getString("ui.hidePagesIfTopnavInfo"));
                                ComponentUtilities.whenSelectedEnable((AbstractButton)this.showTopNavigation, (JComponent[])new JComponent[]{this.topNavigationExcludeFolders, this.logoName, this.selectLogo, this.hidePagesIfTopnav});
                                this.showBreadcrumbPath.setToolTipText(Gui.this.texts.getString("ui.useBreadcrumbPathInfo"));
                                this.skipThumbnailPage.setToolTipText(Gui.this.texts.getString("ui.skipThumbnailPageInfo"));
                                this.linkNeighboringFolders.setToolTipText(Gui.this.texts.getString("ui.linkNeighboringFoldersInfo"));
                                this.add(this.showTopNavigation);
                                this.add("tab", this.topNavigationExcludeFolders);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.logo"), (JComponent)this.logoName));
                                this.add("hfill", this.logoName);
                                this.add("", this.selectLogo);
                                this.add("br", this.hidePagesIfTopnav);
                                this.add("br", this.showBreadcrumbPath);
                                this.add("tab", this.skipThumbnailPage);
                                this.add("br", this.linkNeighboringFolders);
                            }
                        };
                        this.featuresPanel = new ControlPanel(Gui.this.texts.getString("ui.features")){
                            JCheckBox useSearch;
                            JCheckBox useSearchForNew;
                            JTextField newDaysCount;
                            JComboBox newDaysRef;
                            JComboBox zipImages;
                            JLabel zipInfo;
                            {
                                this.useSearch = new JCheckBox(Gui.this.texts.getString("ui.useSearch"), false);
                                this.useSearchForNew = new JCheckBox(Gui.this.texts.getString("ui.useSearchForNew"), false);
                                this.newDaysCount = new JSmartTextField("0", 3);
                                this.newDaysRef = new JComboBox<Object>(new Object[]{new Item((Object)"dateTaken", (Object)Gui.this.texts.getString("ui.dateTaken")), new Item((Object)"fileModified", (Object)Gui.this.texts.getString("ui.fileModified")), new Item((Object)"added", (Object)Gui.this.texts.getString("ui.addedToAlbum"))});
                                this.zipImages = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.texts.getString("ui.nothing")), new Item((Object)"slides", (Object)Gui.this.texts.getString("ui.scaledDown")), new Item((Object)"originals", (Object)Gui.this.texts.getString("ui.originals")), new Item((Object)"included", (Object)Gui.this.texts.getString("ui.includedOriginals")), new Item((Object)"album", (Object)Gui.this.texts.getString("ui.wholeAlbum"))});
                                this.zipInfo = new JLabel(Gui.this.createImageIcon("info.png"));
                                this.useSearch.setToolTipText(Gui.this.texts.getString("ui.useSearchBoxInfo"));
                                this.newDaysCount.setToolTipText(Gui.this.texts.getString("ui.newDaysCountInfo"));
                                this.useSearch.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        if (((JCheckBox)e.getSource()).isSelected()) {
                                            Gui.this.processSubdirectoriesWarning();
                                        }
                                    }
                                });
                                this.useSearchForNew.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        if (((JCheckBox)e.getSource()).isSelected()) {
                                            Gui.this.processSubdirectoriesWarning();
                                        }
                                    }
                                });
                                this.zipInfo.addMouseListener(new MouseAdapter(){

                                    public void mouseReleased(MouseEvent e) {
                                        JOptionPane.showMessageDialog((Component)Gui.this.window, Gui.this.texts.getString("ui.nonAsciiWarning"), "Warning", 2);
                                    }
                                });
                                this.add("", this.useSearch);
                                this.add("tab", this.useSearchForNew);
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.markFilesNew")));
                                this.add("", this.newDaysCount);
                                this.add(new JLabel(Gui.this.texts.getString("ui.daysOld")));
                                this.add(" ", new JLabel(Gui.this.texts.getString("ui.reference")));
                                this.add(this.newDaysRef);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.offerDownload"), (JComponent)this.zipImages));
                                this.add("tab", this.zipImages);
                                this.add("", this.zipInfo);
                            }
                        };
                        this.footerPanel = new ControlPanel(Gui.this.texts.getString("ui.footer")){
                            JCheckBox showImageCount;
                            JCheckBox showBottomNavigation;
                            JCheckBox showHelp;
                            ControlPanel customLinkPanel;
                            {
                                this.showImageCount = new JCheckBox(Gui.this.texts.getString("ui.showFolderImageCount"), true);
                                this.showBottomNavigation = new JCheckBox(Gui.this.texts.getString("ui.showBottomNavigation"), false);
                                this.showHelp = new JCheckBox(Gui.this.texts.getString("ui.showHelpLink"), true);
                                this.customLinkPanel = new ControlPanel(Gui.this.texts.getString("ui.customLink")){
                                    JTextField customLink;
                                    JTextField customLinkText;
                                    {
                                        this.customLink = new JSmartTextField();
                                        this.customLinkText = new JSmartTextField();
                                        this.customLink.setToolTipText(Gui.this.texts.getString("ui.customLinkInfo"));
                                        this.customLinkText.setToolTipText(Gui.this.texts.getString("ui.customLinkTextInfo"));
                                        this.add(new JLabel("URL"));
                                        this.add("tab hfill", this.customLink);
                                        this.add("br", new JLabel(Gui.this.texts.getString("ui.customLinkText")));
                                        this.add("tab hfill", this.customLinkText);
                                    }
                                };
                                this.showImageCount.setToolTipText(Gui.this.texts.getString("ui.showFolderImageCountInfo"));
                                this.showBottomNavigation.setToolTipText(Gui.this.texts.getString("ui.showBottomNavigationInfo"));
                                this.showHelp.setToolTipText(Gui.this.texts.getString("ui.displayHelpButtonInfo"));
                                this.add("", this.showImageCount);
                                this.add("br", this.showBottomNavigation);
                                this.add("tab", this.showHelp);
                                this.add("br hfill", (Component)this.customLinkPanel);
                            }
                        };
                        this.add("hfill", (Component)this.navigationPanel);
                        this.add("br hfill", (Component)this.featuresPanel);
                        this.add("br hfill", (Component)this.footerPanel);
                    }
                };
                this.sitePanel = new JScrollPane((Component)this.site, 20, 31);
                this.design = new ControlPanel(){
                    ControlPanel fontsPanel;
                    ControlPanel colorsPanel;
                    ControlPanel roundingPanel;
                    ControlPanel backgroundImagePanel;
                    ControlPanel miscPanel;
                    {
                        this.fontsPanel = new ControlPanel(Gui.this.texts.getString("ui.fonts")){
                            JComboBox fontFamily;
                            JComboBox fontSize;
                            JComboBox headlineFamily;
                            JComboBox headlineSize;
                            JComboBox folderTitleSize;
                            JCheckBox folderTitleSameAsHeadline;
                            {
                                this.fontFamily = new JComboBox<Object>(new Object[]{new Item((Object)"Arial, \"Helvetica Neue\", Helvetica, sans-serif", (Object)"Arial"), new Item((Object)"\"Arial Rounded MT Bold\", \"Helvetica Rounded\", Arial, sans-serif;", (Object)"Arial Rounded"), new Item((Object)"Baskerville, \"Baskerville Old Face\", \"Hoefler Text\", Garamond, \"Times New Roman\", serif", (Object)"Baskerville"), new Item((Object)"Calibri, Candara, Segoe, \"Segoe UI\", Optima, Arial, sans-serif", (Object)"Calibri"), new Item((Object)"Cambria, Georgia, Times, \"Times New Roman\", serif", (Object)"Cambria"), new Item((Object)"Candara, Calibri, Segoe, \"Segoe UI\", Optima, Arial, sans-serif", (Object)"Candara"), new Item((Object)"\"Century Gothic\", \"Apple Gothic\", \"Goudy Old Style\", sans-serif", (Object)"Century Gothic"), new Item((Object)"\"Comic Sans MS\", cursive", (Object)"Comic Sans"), new Item((Object)"Consolas, \"Lucida Console\", Monaco, monospace", (Object)"Consolas"), new Item((Object)"Constantia, Palatino, \"Palatino Linotype\", \"Palatino LT STD\", Georgia, serif", (Object)"Constantia"), new Item((Object)"\"Copperplate Light\", \"Copperplate Gothic Light\", serif", (Object)"Copperplate Light"), new Item((Object)"\"Courier New\", Courier, monospace", (Object)"Courier New"), new Item((Object)"\"Franklin Gothic Medium\", \"Arial Narrow Bold\", Arial, sans-serif", (Object)"Franklin Gothic"), new Item((Object)"Futura, \"Century Gothic\", AppleGothic, sans-serif", (Object)"Futura"), new Item((Object)"Garamond, \"Hoefler Text\", Times New Roman, Times, serif", (Object)"Garamond"), new Item((Object)"Geneva, \"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Geneva"), new Item((Object)"Georgia, Palatino, \"Palatino Linotype\", Times, \"Times New Roman\", serif", (Object)"Georgia"), new Item((Object)"\"Gill Sans\", \"Gill Sans MT\", Calibri, \"Trebuchet MS\", sans-serif", (Object)"Gill Sans"), new Item((Object)"\"Goudy Old Style\", Garamond, \"Big Caslon\", \"Times New Roman\", serif", (Object)"Goudy Old Style"), new Item((Object)"\"Helvetica Neue\", Helvetica, Arial, sans-serif", (Object)"Helvetica Neue"), new Item((Object)"\"Hoefler Text\", Constantia, Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Hoefler Text"), new Item((Object)"Impact, Haettenschweiler, \"Arial Narrow Bold\", sans-serif", (Object)"Impact"), new Item((Object)"\"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Lucida Sans"), new Item((Object)"\"Lucida Bright\", Georgia, serif", (Object)"Lucida Bright"), new Item((Object)"Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Palatino"), new Item((Object)"Segoe, \"Segoe UI\", Tahoma, Geneva, \"Nimbus Sans L\", sans-serif", (Object)"Segoe"), new Item((Object)"Tahoma, Geneva, Verdana, sans-serif", (Object)"Tahoma"), new Item((Object)"Times, \"Times New Roman\", Georgia, serif", (Object)"Times"), new Item((Object)"\"Trebuchet MS\", \"Lucida Sans Unicode\", \"Lucida Grande\", \"Lucida Sans\", Tahoma, sans-serif", (Object)"Trebuchet MS"), new Item((Object)"Verdana, Geneva, Tahoma, sans-serif", (Object)"Verdana")});
                                this.fontSize = new JComboBox<Object>(new Object[]{new Item((Object)"10px", (Object)"71%"), new Item((Object)"11px", (Object)"78%"), new Item((Object)"12px", (Object)"86%"), new Item((Object)"13px", (Object)"93%"), new Item((Object)"14px", (Object)"100%"), new Item((Object)"15px", (Object)"107%"), new Item((Object)"16px", (Object)"114%"), new Item((Object)"17px", (Object)"121%"), new Item((Object)"18px", (Object)"129%"), new Item((Object)"20px", (Object)"143%")});
                                this.headlineFamily = new JComboBox<Object>(new Object[]{new Item((Object)"", (Object)("[ " + Gui.this.texts.getString("ui.sameAsBaseFont") + " ]")), new Item((Object)"Arial, \"Helvetica Neue\", Helvetica, sans-serif", (Object)"Arial"), new Item((Object)"\"Arial Black\", \"Arial Bold\", Gadget, sans-serif", (Object)"Arial Black"), new Item((Object)"\"Arial Rounded MT Bold\", \"Helvetica Rounded\", Arial, sans-serif;", (Object)"Arial Rounded"), new Item((Object)"Baskerville, \"Baskerville Old Face\", \"Hoefler Text\", Garamond, \"Times New Roman\", serif", (Object)"Baskerville"), new Item((Object)"Calibri, Candara, Segoe, \"Segoe UI\", Optima, Arial, sans-serif", (Object)"Calibri"), new Item((Object)"Cambria, Georgia, Times, \"Times New Roman\", serif", (Object)"Cambria"), new Item((Object)"Candara, Calibri, Segoe, \"Segoe UI\", Optima, Arial, sans-serif", (Object)"Candara"), new Item((Object)"\"Century Gothic\", \"Apple Gothic\", \"Goudy Old Style\", sans-serif", (Object)"Century Gothic"), new Item((Object)"\"Comic Sans MS\", cursive", (Object)"Comic Sans"), new Item((Object)"Consolas, \"Lucida Console\", Monaco, monospace", (Object)"Consolas"), new Item((Object)"Constantia, Palatino, \"Palatino Linotype\", \"Palatino LT STD\", Georgia, serif", (Object)"Constantia"), new Item((Object)"Copperplate, \"Copperplate Gothic\", serif", (Object)"Copperplate"), new Item((Object)"\"Courier New\", Courier, monospace", (Object)"Courier New"), new Item((Object)"\"Franklin Gothic\", \"Franklin Gothic Medium\", \"Arial Narrow Bold\", Arial, sans-serif", (Object)"Franklin Gothic"), new Item((Object)"Futura, \"Futura Bk BT\", \"Century Gothic\", AppleGothic, sans-serif", (Object)"Futura"), new Item((Object)"Garamond, \"Hoefler Text\", Times New Roman, Times, serif", (Object)"Garamond"), new Item((Object)"Geneva, \"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Geneva"), new Item((Object)"Georgia, Palatino, \"Palatino Linotype\", Times, \"Times New Roman\", serif", (Object)"Georgia"), new Item((Object)"\"Gill Sans\", \"Gill Sans MT\", Calibri, \"Trebuchet MS\", sans-serif", (Object)"Gill Sans"), new Item((Object)"\"Goudy Old Style\", Garamond, \"Big Caslon\", \"Times New Roman\", serif", (Object)"Goudy Old Style"), new Item((Object)"\"Helvetica Neue\", Helvetica, Arial, sans-serif", (Object)"Helvetica Neue"), new Item((Object)"\"Hoefler Text\", Constantia, Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Hoefler Text"), new Item((Object)"Impact, Haettenschweiler, \"Arial Narrow Bold\", sans-serif", (Object)"Impact"), new Item((Object)"\"Lucida Sans\", \"Lucida Grande\", \"Lucida Sans Unicode\", Verdana, sans-serif", (Object)"Lucida Sans"), new Item((Object)"\"Lucida Bright\", Georgia, serif", (Object)"Lucida Bright"), new Item((Object)"Palatino, \"Palatino Linotype\", \"Book Antiqua\", Georgia, serif", (Object)"Palatino"), new Item((Object)"Segoe, \"Segoe UI\", Tahoma, Geneva, \"Nimbus Sans L\", sans-serif", (Object)"Segoe"), new Item((Object)"Tahoma, Geneva, Verdana, sans-serif", (Object)"Tahoma"), new Item((Object)"Times, \"Times New Roman\", Georgia, serif", (Object)"Times"), new Item((Object)"\"Trebuchet MS\", \"Lucida Sans Unicode\", \"Lucida Grande\", \"Lucida Sans\", Tahoma, sans-serif", (Object)"Trebuchet MS"), new Item((Object)"Verdana, Geneva, Tahoma, sans-serif", (Object)"Verdana"), new Item((Object)"", (Object)("--- " + Gui.this.texts.getString("ui.webFonts") + " ---")), new Item((Object)"Abel::abel/v4/_c5D7Wxu-NSk4vT8jUYrkQ.woff", (Object)"Abel"), new Item((Object)"Abril Fatface::abrilfatface/v6/X1g_KwGeBV3ajZIXQ9VnDuhS-En80r5m6Wj7KydCWb8.woff", (Object)"Abril Fatface"), new Item((Object)"Alex Brush::alexbrush/v4/0JFIM7b_LgqHWlCbkgAO2fesZW2xOQ-xsNqO47m55DA.woff", (Object)"Alex Brush"), new Item((Object)"Amaranth::amaranth/v4/j5OFHqadfxyLnQRxFeox6j8E0i7KZn-EPnyo3HZu7kw.woff", (Object)"Amaranth"), new Item((Object)"Amatic SC::amaticsc/v4/IDnkRTPGcrSVo50UyYNK7xsxEYwM7FgeyaSgU71cLG0.woff", (Object)"Amatic SC"), new Item((Object)"Cantata One::cantataone/v3/-a5FDvnBqaBMDaGgZYnEfj8E0i7KZn-EPnyo3HZu7kw.woff", (Object)"Cantata One"), new Item((Object)"Cookie::cookie/v5/FRKZFc5cUzT1rhNTWK08-w.woff", (Object)"Cookie"), new Item((Object)"Dancing Script::dancingscript/v4/DK0eTGXiZjN6yA8zAEyM2cKbQLsA1R_lLnELzgJ1NTs.woff", (Object)"Dancing Script"), new Item((Object)"Dosis::dosis/v2/-Wwu1A8cJMyON3jsSn8jTg.woff", (Object)"Dosis"), new Item((Object)"Dynalight::dynalight/v3/fFTIQo5srxFzkXPDHWokhw.woff", (Object)"Dynalight"), new Item((Object)"Economica::economica/v2/WdKryqRqKTiMRgP-z9ZT7w.woff", (Object)"Economica"), new Item((Object)"Emilys Candy::emilyscandy/v2/PofLVm6v1SwZGOzC8s-I3RsxEYwM7FgeyaSgU71cLG0.woff", (Object)"Emilys Candy"), new Item((Object)"Euphoria Script::euphoriascript/v2/c4XB4Iijj_NvSsCF4I0O2HVXOZy8HQCyPSdnDJOr3a8.woff", (Object)"Euphoria Script"), new Item((Object)"Fjalla One::fjallaone/v2/mvYKuOKM821QBNz_cAJOSPesZW2xOQ-xsNqO47m55DA.woff", (Object)"Fjalla One"), new Item((Object)"Fredericka the Great::frederickathegreat/v3/7Es8Lxoku-e5eOZWpxw18t2QR9E88_XBMnxeisbi_2k.woff", (Object)"Fredericka the Great"), new Item((Object)"Germania One::germaniaone/v2/3_6AyUql_-FbDi1e68jHdBsxEYwM7FgeyaSgU71cLG0.woff", (Object)"Germania One"), new Item((Object)"Geo::geo/v6/Yu2Azq-XPjYmhANCEZdRmw.woff", (Object)"Geo"), new Item((Object)"Great Vibes::greatvibes/v2/4Mi5RG_9LjQYrTU55GN_Lz8E0i7KZn-EPnyo3HZu7kw.woff", (Object)"Great Vibes"), new Item((Object)"Gruppo::gruppo/v5/5HbckBWnUDolflDIG6jXoQ.woff", (Object)"Gruppo"), new Item((Object)"IM Fell English::imfellenglish/v4/xwIisCqGFi8pff-oa9uSVPoFIMOozBiPs6w2jDr_Ki8.woff", (Object)"IM Fell English"), new Item((Object)"Indie Flower::indieflower/v5/10JVD_humAd5zP2yrFqw6hsxEYwM7FgeyaSgU71cLG0.woff", (Object)"Indie Flower"), new Item((Object)"La Belle Aurore::labelleaurore/v4/Irdbc4ASuUoWDjd_Wc3mdw8tuJzfDdJzet9TevnX4dY.woff", (Object)"La Belle Aurore"), new Item((Object)"Lobster::lobster/v6/9eID_a1kLfzp_BP9s4L15g.woff", (Object)"Lobster"), new Item((Object)"Lobster Two::lobstertwo/v5/xb9aY4w9ceh8JRzobID1nT8E0i7KZn-EPnyo3HZu7kw.woff", (Object)"Lobster Two"), new Item((Object)"Loved by the King::lovedbytheking/v4/wg03xD4cWigj4YDufLBSrwvs-PHmBmba6eqIx5ccdqU.woff", (Object)"Loved by the King"), new Item((Object)"Maiden Orange::maidenorange/v4/ZhKIA2SPisEwdhW7g0RUWuhS-En80r5m6Wj7KydCWb8.woff", (Object)"Maiden Orange"), new Item((Object)"Marvel::marvel/v4/d7-cZxe9oCQlA6Nnb4ztzA.woff", (Object)"Marvel"), new Item((Object)"Medula One::medulaone/v4/W9t25ji44ziOSOF0Xa6QbvesZW2xOQ-xsNqO47m55DA.woff", (Object)"Medula One"), new Item((Object)"Mountains of Christmas::mountainsofchristmas/v6/dVGBFPwd6G44IWDbQtPew5Dfk5bPX3CRoRBVNU6bFOQ.woff", (Object)"Mountains of Christmas"), new Item((Object)"Old Standard TT Regular::oldstandardtt/v5/n6RTCDcIPWSE8UNBa4k-DG_x2mqHAItWyd7pf7F9WCM.woff", (Object)"Old Standard TT"), new Item((Object)"Open Sans Cond Light::opensanscondensed/v7/gk5FxslNkTTHtojXrkp-xMTgyteJAvYJ1fpbrx49ekQ.woff", (Object)"Open Sans Cond Light"), new Item((Object)"Oswald::oswald/v8/cKJn9qYJKRGi7ghmghRZYg.woff", (Object)"Oswald"), new Item((Object)"Poiret One::poiretone/v2/BTpJg8_B_DLGSuk_1Pf0tvesZW2xOQ-xsNqO47m55DA.woff", (Object)"Poiret One"), new Item((Object)"Princess Sofia::princesssofia/v2/8g5l8r9BM0t1QsXLTajDe2y1RO09RDKWlu_EElX0vQo.woff", (Object)"Princess Sofia"), new Item((Object)"PT Mono::ptmono/v2/q-8MB3u-6uRcCyTjD42CkA.woff", (Object)"PT Mono"), new Item((Object)"Shadows Into Light Two::shadowsintolighttwo/v2/gDxHeefcXIo-lOuZFCn2xY3AoYkOaVfZZSwfFk_LVmE.woff", (Object)"Shadows Into Light Two"), new Item((Object)"Six Caps::sixcaps/v5/qKgUvDn-iXTHPvPcmiWNng.woff", (Object)"Six Caps"), new Item((Object)"Special Elite::specialelite/v4/9-wW4zu3WNoD5Fjka35Jm-hS-En80r5m6Wj7KydCWb8.woff", (Object)"Special Elite"), new Item((Object)"Raleway::raleway/v7/fj4GB2RX6COD1Mnz53LyUA.woff", (Object)"Raleway"), new Item((Object)"Rochester::rochester/v4/f_NvJxIwJC1g7a4yzlmghQ.woff", (Object)"Rochester"), new Item((Object)"Squada One::squadaone/v3/f-OUPQPez9RsgdltZVHvEvesZW2xOQ-xsNqO47m55DA.woff", (Object)"Squada One"), new Item((Object)"Ubuntu Condensed::ubuntucondensed/v4/DBCt-NXN57MTAFjitYxdrO3ikv6SQm_yYbVf3nddkGw.woff", (Object)"Ubuntu Condensed"), new Item((Object)"Yanone Kaffeesatz Light::yanonekaffeesatz/v5/We_iSDqttE3etzfdfhuPRaNLGymlXcQihalkb1itBKs.woff", (Object)"Yanone Kaffeesatz Light"), new Item((Object)"Yanone Kaffeesatz Regular::yanonekaffeesatz/v5/YDAoLskQQ5MOAgvHUQCcLaQIa8YiKSd62pwUFuxbIgM.woff", (Object)"Yanone Kaffeesatz Regular")});
                                this.headlineSize = new JComboBox<Object>(new Object[]{"200%", "220%", "240%", "260%", "300%", "360%", "420%", "500%"});
                                this.folderTitleSize = new JComboBox<Object>(new Object[]{"100%", "110%", "120%", "133%", "150%", "200%"});
                                this.folderTitleSameAsHeadline = new JCheckBox(Gui.this.texts.getString("ui.sameAsHeadline"), true);
                                this.fontFamily.setSelectedIndex(28);
                                this.headlineFamily.setSelectedIndex(64);
                                this.fontSize.setSelectedIndex(4);
                                this.headlineSize.setSelectedIndex(2);
                                this.folderTitleSize.setSelectedIndex(2);
                                this.add(new JLabel(Gui.this.texts.getString("ui.fontFamily")));
                                this.add("tab", this.fontFamily);
                                this.add(" ", new JLabel(Gui.this.texts.getString("ui.fontSize")));
                                this.add("tab", this.fontSize);
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.headlineFamily")));
                                this.add("tab", this.headlineFamily);
                                this.add("tab", this.headlineSize);
                                this.add(" ", (Component)new JLinkLabel("http://lazaworx.com/font-selection-in-turtle-skin/", Gui.this.texts.getString("ui.fontSamples"), Gui.this.texts.getString("ui.seeFontSamples")));
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.folderTitle")));
                                this.add("tab", this.folderTitleSameAsHeadline);
                                this.add("tab", this.folderTitleSize);
                            }
                        };
                        this.colorsPanel = new ControlPanel(Gui.this.texts.getString("ui.colors")){
                            JColorSelector backgroundColor;
                            JColorSelector textColor;
                            JColorSelector linkColor;
                            JColorSelector hoverColor;
                            JColorSelector borderColor;
                            JSpinner borderWidth;
                            JComboBox modalWindowsTheme;
                            {
                                this.backgroundColor = new JAlphaColorSelector(Gui.this.texts.getString("ui.backgroundColor"), (JTextField)new JSmartTextField("#222222", 8));
                                this.textColor = new JColorSelector(Gui.this.texts.getString("ui.textColor"), (JTextField)new JSmartTextField("#bbbbbb", 8));
                                this.linkColor = new JColorSelector(Gui.this.texts.getString("ui.linkColor"), (JTextField)new JSmartTextField("#dddddd", 8));
                                this.hoverColor = new JColorSelector(Gui.this.texts.getString("ui.hoverColor"), (JTextField)new JSmartTextField("#ffffff", 8));
                                this.borderColor = new JAlphaColorSelector(Gui.this.texts.getString("ui.borderColor"), (JTextField)new JSmartTextField("#eeeeee", 8));
                                this.borderWidth = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
                                this.modalWindowsTheme = new JComboBox<Object>(new Object[]{new Item((Object)"auto", (Object)Gui.this.texts.getString("ui.auto")), new Item((Object)"light", (Object)Gui.this.texts.getString("ui.light")), new Item((Object)"dark", (Object)Gui.this.texts.getString("ui.dark"))});
                                this.backgroundColor.setToolTipText(Gui.this.texts.getString("ui.backgroundColorInfo"));
                                this.textColor.setToolTipText(Gui.this.texts.getString("ui.textColorInfo"));
                                this.linkColor.setToolTipText(Gui.this.texts.getString("ui.linkColorInfo"));
                                this.hoverColor.setToolTipText(Gui.this.texts.getString("ui.hoverColorInfo"));
                                this.borderColor.setToolTipText(Gui.this.texts.getString("ui.borderColorInfo"));
                                this.linkColor.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        hoverColor.setColor(Gui.this.getHighlightedColor(linkColor.getHTMLColor()));
                                    }
                                });
                                this.add("", (Component)new JLabelFor(Gui.this.texts.getString("ui.backgroundColor"), (JComponent)this.backgroundColor));
                                this.add("tab", (Component)this.backgroundColor);
                                this.add("tab", this.backgroundColor.getTextComponent());
                                this.add("tab", (Component)new JLabelFor(Gui.this.texts.getString("ui.textColor"), (JComponent)this.textColor));
                                this.add("tab", (Component)this.textColor);
                                this.add("tab", this.textColor.getTextComponent());
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.linkColor"), (JComponent)this.linkColor));
                                this.add("tab", (Component)this.linkColor);
                                this.add("tab", this.linkColor.getTextComponent());
                                this.add("tab", (Component)new JLabelFor(Gui.this.texts.getString("ui.hoverColor"), (JComponent)this.hoverColor));
                                this.add("tab", (Component)this.hoverColor);
                                this.add("tab", this.hoverColor.getTextComponent());
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.borderColor"), (JComponent)this.borderColor));
                                this.add("tab", (Component)this.borderColor);
                                this.add("tab", this.borderColor.getTextComponent());
                                this.add("tab", (Component)new JLabelFor(Gui.this.texts.getString("ui.borderWidth"), (JComponent)this.borderWidth));
                                this.add("", this.borderWidth);
                                this.add("", new JLabel("px"));
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.modalWindowsTheme"), (JComponent)this.modalWindowsTheme));
                                this.add("", this.modalWindowsTheme);
                            }
                        };
                        this.roundingPanel = new ControlPanel(Gui.this.texts.getString("ui.roundedCorners")){
                            JSpinner cornerRadius;
                            JSpinner imgCornerRadius;
                            {
                                this.cornerRadius = new JSpinner(new SpinnerNumberModel(6, 0, 100, 1));
                                this.imgCornerRadius = new JSpinner(new SpinnerNumberModel(0, 0, 200, 1));
                                this.cornerRadius.setToolTipText(Gui.this.texts.getString("ui.cornerRadiusInfo"));
                                this.add("", new JLabel(Gui.this.texts.getString("ui.themeImage")));
                                this.add("", this.cornerRadius);
                                this.add("", new JLabel("px"));
                                this.add("tab", new JLabel(Gui.this.texts.getString("ui.mainImage")));
                                this.add("", this.imgCornerRadius);
                                this.add("", new JLabel("px"));
                            }
                        };
                        this.backgroundImagePanel = new ControlPanel(Gui.this.texts.getString("ui.backgroundImage")){
                            JTextField backgroundImageName;
                            JButton selectImage;
                            JComboBox backgroundPos;
                            JComboBox backgroundRepeat;
                            {
                                this.backgroundImageName = new JSmartTextField(20);
                                this.selectImage = new JButton();
                                this.backgroundPos = new JComboBox<Object>(Gui.this.getPosition());
                                this.backgroundRepeat = new JComboBox<Object>(new Object[]{new Item((Object)"no-repeat", (Object)Gui.this.texts.getString("ui.bg_no_repeat")), new Item((Object)"repeat-x", (Object)Gui.this.texts.getString("ui.bg_repeat_x")), new Item((Object)"repeat-y", (Object)Gui.this.texts.getString("ui.bg_repeat_y")), new Item((Object)"repeat", (Object)Gui.this.texts.getString("ui.bg_repeat_both")), new Item((Object)"stretch", (Object)Gui.this.texts.getString("ui.bg_stretch"))});
                                this.backgroundImageName.setToolTipText(Gui.this.texts.getString("ui.backgroundImageInfo"));
                                this.selectImage.setText(Gui.this.texts.getString("ui.select"));
                                this.selectImage.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        Gui.this.getFileToRes(Gui.this.imgFilter, backgroundImageName);
                                    }
                                });
                                this.backgroundPos.setSelectedIndex(4);
                                this.backgroundRepeat.setSelectedIndex(4);
                                this.add("tab hfill", this.backgroundImageName);
                                this.add("", this.selectImage);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.position"), (JComponent)this.backgroundPos));
                                this.add("", this.backgroundPos);
                                this.add(" ", this.backgroundRepeat);
                            }
                        };
                        this.miscPanel = new ControlPanel("..."){
                            JCheckBox smartScroll;
                            JCheckBox use3dEffects;
                            JCheckBox stickControlsToTop;
                            {
                                this.smartScroll = new JCheckBox(Gui.this.texts.getString("ui.useSmartScroll"), true);
                                this.use3dEffects = new JCheckBox(Gui.this.texts.getString("ui.use3dEffects"), true);
                                this.stickControlsToTop = new JCheckBox(Gui.this.texts.getString("ui.stickControlsToTop"), true);
                                this.smartScroll.setToolTipText(Gui.this.texts.getString("ui.useSmartScrollInfo"));
                                this.use3dEffects.setToolTipText(Gui.this.texts.getString("ui.use3dEffectsInfo"));
                                this.stickControlsToTop.setToolTipText(Gui.this.texts.getString("ui.stickControlsToTopInfo"));
                                this.add("", this.smartScroll);
                                this.add("tab", this.use3dEffects);
                                this.add("tab", this.stickControlsToTop);
                            }
                        };
                        this.add("hfill", (Component)this.fontsPanel);
                        this.add("br hfill", (Component)this.colorsPanel);
                        this.add("br hfill", (Component)this.roundingPanel);
                        this.add("br hfill", (Component)this.backgroundImagePanel);
                        this.add("br hfill", (Component)this.miscPanel);
                    }
                };
                this.designPanel = new JScrollPane((Component)this.design, 20, 31);
                this.themeImage = new ControlPanel(){
                    ControlPanel themeImageDesign;
                    ControlPanel themeImageLayout;
                    ControlPanel themeImageFeatures;
                    {
                        this.themeImageDesign = new ControlPanel(Gui.this.texts.getString("ui.design")){
                            JComboBox headerType;
                            JColorSelector headerColor;
                            JCheckBox themeImageBlur;
                            JCheckBox themeImageSame;
                            JComboBox themeImagePattern;
                            {
                                this.headerType = new JComboBox<Object>(new Object[]{new Item((Object)"themeImage", (Object)Gui.this.texts.getString("ui.folderThumbnail")), new Item((Object)"flatColor", (Object)Gui.this.texts.getString("ui.flatColor"))});
                                this.headerColor = new JAlphaColorSelector(Gui.this.texts.getString("ui.color"), (JTextField)new JSmartTextField("#222222", 8));
                                this.themeImageBlur = new JCheckBox(Gui.this.texts.getString("ui.themeImageBlur"));
                                this.themeImageSame = new JCheckBox(Gui.this.texts.getString("ui.themeImageSame"));
                                this.themeImagePattern = new JComboBox<Object>(new Object[]{new Item((Object)"", (Object)Gui.this.texts.getString("ui.none")), new Item((Object)"cardboard.png", (Object)"Cardboard"), new Item((Object)"circles.png", (Object)"Circles"), new Item((Object)"dots.png", (Object)"Dots"), new Item((Object)"gplay.png", (Object)"GPlay"), new Item((Object)"linen.png", (Object)"Linen"), new Item((Object)"paper.png", (Object)"Paper"), new Item((Object)"pinstripe.png", (Object)"Pinstripe"), new Item((Object)"tiles.png", (Object)"Tiles"), new Item((Object)"wood.png", (Object)"Wood")});
                                this.headerType.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        int i = headerType.getSelectedIndex();
                                        if (i == 0) {
                                            headerColor.setEnabled(false);
                                            themeImageBlur.setEnabled(true);
                                            themeImageSame.setEnabled(true);
                                        } else {
                                            headerColor.setEnabled(true);
                                            themeImageBlur.setEnabled(false);
                                            themeImageSame.setEnabled(false);
                                        }
                                    }
                                });
                                this.headerColor.setEnabled(false);
                                this.themeImageBlur.setToolTipText(Gui.this.texts.getString("ui.themeImageBlurInfo"));
                                this.themeImageSame.setToolTipText(Gui.this.texts.getString("ui.themeImageSameInfo"));
                                this.themeImagePattern.setToolTipText(Gui.this.texts.getString("ui.themeImagePatternInfo"));
                                this.add("", (Component)new JLabelFor(Gui.this.texts.getString("ui.type"), (JComponent)this.headerType));
                                this.add("tab", this.headerType);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.color"), (JComponent)this.headerColor));
                                this.add("tab", (Component)this.headerColor);
                                this.add("br", this.themeImageBlur);
                                this.add("tab", this.themeImageSame);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.themeImagePattern"), (JComponent)this.themeImagePattern));
                                this.add("tab", this.themeImagePattern);
                            }
                        };
                        this.themeImageLayout = new ControlPanel(Gui.this.texts.getString("ui.layout")){
                            JTextField folderImageSize;
                            JTextField folderImageHeightPages;
                            JTextField folderImageHeightSubAlbums;
                            JCheckBox themeImageLeft;
                            {
                                this.folderImageSize = new JSmartTextField("900x240", 10);
                                this.folderImageHeightPages = new JSmartTextField("80", 5);
                                this.folderImageHeightSubAlbums = new JSmartTextField("240", 5);
                                this.themeImageLeft = new JCheckBox(Gui.this.texts.getString("ui.themeImageLeft"));
                                this.folderImageSize.setToolTipText(Gui.this.texts.getString("ui.folderImageSizeInfo"));
                                this.folderImageHeightPages.setToolTipText(Gui.this.texts.getString("ui.heightOnPagesInfo"));
                                this.folderImageHeightSubAlbums.setToolTipText(Gui.this.texts.getString("ui.heightOnSubFoldersInfo"));
                                this.themeImageLeft.setToolTipText(Gui.this.texts.getString("ui.themeImageLeftInfo"));
                                this.add("", new JLabel(Gui.this.texts.getString("ui.folderImageSize")));
                                this.add("tab", this.folderImageSize);
                                this.add("tab", this.themeImageLeft);
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.heightOnSubFolders")));
                                this.add("tab", this.folderImageHeightSubAlbums);
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.heightOnPages")));
                                this.add("tab", this.folderImageHeightPages);
                            }
                        };
                        this.themeImageFeatures = new ControlPanel(Gui.this.texts.getString("ui.features")){
                            JCheckBox descriptionVisible;
                            JCheckBox showStartSlideshow;
                            {
                                this.descriptionVisible = new JCheckBox(Gui.this.texts.getString("ui.descriptionVisible"), true);
                                this.showStartSlideshow = new JCheckBox(Gui.this.texts.getString("ui.showStartSlideshow"), true);
                                this.descriptionVisible.setToolTipText(Gui.this.texts.getString("ui.descriptionVisibleInfo"));
                                this.showStartSlideshow.setToolTipText(Gui.this.texts.getString("ui.showStartSlideshowInfo"));
                                this.add("", this.descriptionVisible);
                                this.add("br", this.showStartSlideshow);
                            }
                        };
                        this.add("hfill", (Component)this.themeImageLayout);
                        this.add("br hfill", (Component)this.themeImageFeatures);
                        this.add("br hfill", (Component)this.themeImageDesign);
                    }
                };
                this.themeImagePanel = new JScrollPane((Component)this.themeImage, 20, 31);
                this.thumbnails = new ControlPanel(){
                    ControlPanel thumbnailLayout;
                    ControlPanel folders;
                    ControlPanel pages;
                    ControlPanel thumbs;
                    {
                        this.thumbnailLayout = new ControlPanel(Gui.this.texts.getString("ui.layout")){
                            JSpinner folderCols;
                            JLabel thumbColsInfo;
                            String s;
                            String f;
                            String p;
                            String i;
                            JComboBox itemsOrder;
                            JSpinner thumbGap;
                            JSpinner minThumbPad;
                            JCheckBox fixedShapeThumbs;
                            JSpinner preZoomThumbs;
                            {
                                this.folderCols = new JSpinner(new SpinnerNumberModel(3, 1, 10, 1));
                                this.thumbColsInfo = new JLabel(Gui.this.createImageIcon("info.png"));
                                this.s = " > ";
                                this.f = Gui.this.texts.getString("ui.folders");
                                this.p = Gui.this.texts.getString("ui.pages");
                                this.i = Gui.this.texts.getString("ui.images");
                                this.itemsOrder = new JComboBox<Object>(new Object[]{new Item((Object)"fpi", (Object)(this.f + this.s + this.p + this.s + this.i)), new Item((Object)"fip", (Object)(this.f + this.s + this.i + this.s + this.p)), new Item((Object)"pfi", (Object)(this.p + this.s + this.f + this.s + this.i)), new Item((Object)"pif", (Object)(this.p + this.s + this.i + this.s + this.f)), new Item((Object)"ifp", (Object)(this.i + this.s + this.f + this.s + this.p)), new Item((Object)"ipf", (Object)(this.i + this.s + this.p + this.s + this.f)), new Item((Object)"fi", (Object)(this.f + this.s + this.i)), new Item((Object)"if", (Object)(this.i + this.s + this.f)), new Item((Object)"i", (Object)this.i)});
                                this.thumbGap = new JSpinner(new SpinnerNumberModel(4, 0, 20, 1));
                                this.minThumbPad = new JSpinner(new SpinnerNumberModel(3, 0, 20, 1));
                                this.fixedShapeThumbs = new JCheckBox(Gui.this.texts.getString("ui.fixedShapeThumbs"), true);
                                this.preZoomThumbs = new JSpinner(new SpinnerNumberModel(100, 100, 300, 5));
                                this.folderCols.setToolTipText(Gui.this.texts.getString("ui.folderColsInfo"));
                                this.thumbColsInfo.addMouseListener(new MouseAdapter(){

                                    public void mouseReleased(MouseEvent e) {
                                        JOptionPane.showMessageDialog((Component)Gui.this.window, Gui.this.texts.getString("ui.thumbColsRemark"), "Information", 1);
                                    }
                                });
                                this.itemsOrder.setSelectedIndex(1);
                                this.minThumbPad.setToolTipText(Gui.this.texts.getString("ui.minThumbPadInfo"));
                                this.fixedShapeThumbs.setToolTipText(Gui.this.texts.getString("ui.fixedShapeThumbsInfo"));
                                ComponentUtilities.whenSelectedEnable((AbstractButton)this.fixedShapeThumbs, (JComponent[])new JComponent[]{this.preZoomThumbs});
                                this.preZoomThumbs.setToolTipText(Gui.this.texts.getString("ui.preZoomThumbsInfo"));
                                this.add((Component)new JLabelFor(Gui.this.texts.getString("ui.folderCols"), (JComponent)this.folderCols));
                                this.add("", this.folderCols);
                                this.add("tab", (Component)new JLabelFor(Gui.this.texts.getString("ui.thumbCols"), (JComponent)this.thumbColsInfo));
                                this.add("", this.thumbColsInfo);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.itemsOrder"), (JComponent)this.itemsOrder));
                                this.add("", this.itemsOrder);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.gapBetweenThumbs"), (JComponent)this.thumbGap));
                                this.add("", this.thumbGap);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.minThumbPad"), (JComponent)this.minThumbPad));
                                this.add("", this.minThumbPad);
                                this.add("br", this.fixedShapeThumbs);
                                this.add("tab", (Component)new JLabelFor(Gui.this.texts.getString("ui.preZoomThumbs"), (JComponent)this.preZoomThumbs));
                                this.add("", this.preZoomThumbs);
                                this.add("", new JLabel("%"));
                            }

                            public void importVariables(Map<String, Object> vars) {
                                if (vars.get("folderCols") == null) {
                                    vars.put("folderCols", Gui.this.engine.getCols());
                                }
                            }
                        };
                        this.folders = new ControlPanel(Gui.this.texts.getString("ui.folders")){
                            JCheckBox showFolderDescription;
                            JCheckBox showFolderImageCount;
                            {
                                this.showFolderDescription = new JCheckBox(Gui.this.texts.getString("ui.showFolderDescription"), true);
                                this.showFolderImageCount = new JCheckBox(Gui.this.texts.getString("ui.showFolderImageCount"), true);
                                this.add(this.showFolderDescription);
                                this.add("br", this.showFolderImageCount);
                            }
                        };
                        this.pages = new ControlPanel(Gui.this.texts.getString("ui.pages")){
                            JCheckBox showPagesAsThumbs;
                            JCheckBox showPageExcerpt;
                            {
                                this.showPagesAsThumbs = new JCheckBox(Gui.this.texts.getString("ui.showPagesAsThumbnails"), false);
                                this.showPageExcerpt = new JCheckBox(Gui.this.texts.getString("ui.showPageExcerpt"), false);
                                this.showPageExcerpt.setToolTipText(Gui.this.texts.getString("ui.showPageExcerptInfo"));
                                this.add(this.showPageExcerpt);
                            }
                        };
                        this.thumbs = new ControlPanel(Gui.this.texts.getString("ui.images")){
                            JTextArea thumbCaptionTemplate;
                            JScrollPane tCaptionPane;
                            JComboBox captionPlacement;
                            JCheckBox focusCurrentThumb;
                            {
                                this.thumbCaptionTemplate = new JSmartTextArea(4, 30);
                                this.tCaptionPane = new JScrollPane(this.thumbCaptionTemplate);
                                this.captionPlacement = new JComboBox<Object>(new Object[]{new Item((Object)"tooltip", (Object)Gui.this.texts.getString("ui.tooltip")), new Item((Object)"below", (Object)Gui.this.texts.getString("ui.below"))});
                                this.focusCurrentThumb = new JCheckBox(Gui.this.texts.getString("ui.focusCurrentThumb"), true);
                                this.thumbCaptionTemplate.setText("<span class=\"nr\">${imageNum}</span> <strong>${fileTitle}</strong> <small>${comment}</small>");
                                this.thumbCaptionTemplate.setEditable(true);
                                this.thumbCaptionTemplate.setLineWrap(true);
                                this.thumbCaptionTemplate.setWrapStyleWord(true);
                                this.focusCurrentThumb.setToolTipText(Gui.this.texts.getString("ui.focusCurrentThumbInfo"));
                                this.add((Component)new JLabelFor(Gui.this.texts.getString("ui.placeThumbCaptions"), (JComponent)this.captionPlacement));
                                this.add(this.captionPlacement);
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.captionTemplate")));
                                this.add("br hfill", this.tCaptionPane);
                                this.add("br", this.focusCurrentThumb);
                            }
                        };
                        this.add("hfill", (Component)this.thumbnailLayout);
                        this.add("br", (Component)this.folders);
                        this.add("hfill", (Component)this.pages);
                        this.add("br hfill", (Component)this.thumbs);
                    }
                };
                this.thumbnailsPanel = new JScrollPane((Component)this.thumbnails, 20, 31);
                this.images = new ControlPanel(){
                    ControlPanel miscPanel;
                    ControlPanel visibility;
                    ControlPanel captionTemplate;
                    {
                        this.miscPanel = new ControlPanel(Gui.this.texts.getString("ui.behavior")){
                            JComboBox transitionType;
                            JTextField transitionSpeed;
                            JTextField slideshowDelay;
                            JCheckBox slideshowLoop;
                            JCheckBox slideshowAuto;
                            JComboBox afterLast;
                            JCheckBox slideshowFullScreen;
                            JCheckBox fitImages;
                            JCheckBox fitShrinkonly;
                            JCheckBox dontStretchBehind;
                            {
                                this.transitionType = new JComboBox<Object>(new Object[]{new Item((Object)"crossFade", (Object)Gui.this.texts.getString("ui.crossFade")), new Item((Object)"crossFadeAndZoom", (Object)Gui.this.texts.getString("ui.crossFadeAndZoom")), new Item((Object)"none", (Object)Gui.this.texts.getString("ui.none"))});
                                this.transitionSpeed = new JSmartTextField("600", 8);
                                this.slideshowDelay = new JSmartTextField("4", 3);
                                this.slideshowLoop = new JCheckBox(Gui.this.texts.getString("ui.loop"));
                                this.slideshowAuto = new JCheckBox(Gui.this.texts.getString("ui.autoStart"));
                                this.afterLast = new JComboBox<Object>(new Object[]{new Item((Object)"donothing", (Object)Gui.this.texts.getString("ui.doNothing")), new Item((Object)"startover", (Object)Gui.this.texts.getString("startOver")), new Item((Object)"onelevelup", (Object)Gui.this.texts.getString("upOneLevel")), new Item((Object)"backtoindex", (Object)Gui.this.texts.getString("backToIndex")), new Item((Object)"nextfolder", (Object)Gui.this.texts.getString("nextFolder")), new Item((Object)"ask", (Object)Gui.this.texts.getString("ui.ask"))});
                                this.slideshowFullScreen = new JCheckBox(Gui.this.texts.getString("ui.slideshowFullScreen"));
                                this.fitImages = new JCheckBox(Gui.this.texts.getString("ui.fitImages"));
                                this.fitShrinkonly = new JCheckBox(Gui.this.texts.getString("ui.fitShrinkonly"));
                                this.dontStretchBehind = new JCheckBox(Gui.this.texts.getString("ui.dontStretchBehind"), true);
                                this.transitionType.setSelectedIndex(1);
                                this.transitionSpeed.setToolTipText(Gui.this.texts.getString("ui.transitionSpeedInfo"));
                                this.slideshowDelay.setToolTipText(Gui.this.texts.getString("ui.slideshowDelayInfo"));
                                this.slideshowFullScreen.setToolTipText(Gui.this.texts.getString("ui.slideshowFullScreenInfo"));
                                this.afterLast.setToolTipText(Gui.this.texts.getString("ui.afterLastInfo"));
                                this.afterLast.setSelectedIndex(4);
                                this.fitImages.setToolTipText(Gui.this.texts.getString("ui.fitImagesInfo"));
                                this.fitShrinkonly.setToolTipText(Gui.this.texts.getString("ui.fitShrinkonlyInfo"));
                                this.dontStretchBehind.setToolTipText(Gui.this.texts.getString("ui.dontStretchBehindInfo"));
                                ComponentUtilities.whenSelectedEnable((AbstractButton)this.fitImages, (JComponent[])new JComponent[]{this.fitShrinkonly});
                                this.add((Component)new JLabelFor(Gui.this.texts.getString("ui.transition"), (JComponent)this.transitionType));
                                this.add("tab", this.transitionType);
                                this.add(" ", (Component)new JLabelFor(Gui.this.texts.getString("ui.transitionSpeed"), (JComponent)this.transitionSpeed));
                                this.add(this.transitionSpeed);
                                this.add(new JLabel("ms"));
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.slideshowDelay")));
                                this.add("tab", this.slideshowDelay);
                                this.add(" ", this.slideshowLoop);
                                this.add(" ", this.slideshowAuto);
                                this.add(" ", this.slideshowFullScreen);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.afterLast"), (JComponent)this.afterLast));
                                this.add("tab", this.afterLast);
                                this.add("br", this.fitImages);
                                this.add(" ", this.fitShrinkonly);
                                this.add("br", this.dontStretchBehind);
                            }
                        };
                        this.visibility = new ControlPanel(Gui.this.texts.getString("ui.visibility")){
                            JCheckBox thumbnailsVisible;
                            JComboBox reduceThumbs;
                            JCheckBox infoPanelVisible;
                            JCheckBox buttonLabelsVisible;
                            ControlPanel panelVisibility;
                            JCheckBox showImageNumbers;
                            {
                                this.thumbnailsVisible = new JCheckBox(Gui.this.texts.getString("ui.thumbnailsVisible"));
                                this.reduceThumbs = new JComboBox<Object>(new Object[]{new Item((Object)"1.0", (Object)"1 / 1"), new Item((Object)"0.75", (Object)"3 / 4"), new Item((Object)"0.66666667", (Object)"2 / 3"), new Item((Object)"0.5", (Object)"1 / 2"), new Item((Object)"0.33333333", (Object)"1 / 3"), new Item((Object)"0.25", (Object)"1 / 4")});
                                this.infoPanelVisible = new JCheckBox(Gui.this.texts.getString("ui.infoPanelVisible"), true);
                                this.buttonLabelsVisible = new JCheckBox(Gui.this.texts.getString("ui.buttonLabelsVisible"));
                                this.panelVisibility = new ControlPanel(Gui.this.texts.getString("ui.openByDefault")){
                                    JCheckBox shareVisible;
                                    JCheckBox commentsVisible;
                                    JCheckBox photoDataVisible;
                                    JCheckBox regionsVisible;
                                    JCheckBox mapVisible;
                                    JCheckBox shopVisible;
                                    {
                                        this.shareVisible = new JCheckBox(Gui.this.texts.getString("ui.sharing"));
                                        this.commentsVisible = new JCheckBox(Gui.this.texts.getString("ui.commenting"));
                                        this.photoDataVisible = new JCheckBox(Gui.this.texts.getString("ui.photoData"));
                                        this.regionsVisible = new JCheckBox(Gui.this.texts.getString("ui.regions"));
                                        this.mapVisible = new JCheckBox(Gui.this.texts.getString("ui.map"));
                                        this.shopVisible = new JCheckBox(Gui.this.texts.getString("ui.sellingPhotos"), true);
                                        this.add("", this.shareVisible);
                                        this.add("tab", this.commentsVisible);
                                        this.add("tab", this.photoDataVisible);
                                        this.add("br", this.regionsVisible);
                                        this.add("tab", this.mapVisible);
                                        this.add("tab", this.shopVisible);
                                    }
                                };
                                this.showImageNumbers = new JCheckBox(Gui.this.texts.getString("ui.showImageNumbers"), true);
                                this.showImageNumbers.setToolTipText(Gui.this.texts.getString("ui.showImageNumbersInfo"));
                                this.thumbnailsVisible.setToolTipText(Gui.this.texts.getString("ui.thumbnailsVisibleInfo"));
                                this.buttonLabelsVisible.setToolTipText(Gui.this.texts.getString("ui.buttonLabelsVisibleInfo"));
                                this.reduceThumbs.setSelectedIndex(2);
                                this.infoPanelVisible.setToolTipText(Gui.this.texts.getString("ui.infoPanelVisibleInfo"));
                                ComponentUtilities.whenSelectedEnable((AbstractButton)this.infoPanelVisible, (JComponent[])new JComponent[]{this.panelVisibility});
                                this.add(this.thumbnailsVisible);
                                this.add(" ", new JLabel(Gui.this.texts.getString("ui.shrink")));
                                this.add("", this.reduceThumbs);
                                this.add("br", this.infoPanelVisible);
                                this.add("br hfill", (Component)this.panelVisibility);
                                this.add("br", this.buttonLabelsVisible);
                                this.add("tab", this.showImageNumbers);
                            }

                            public void importVariables(Map<String, Object> vars) {
                                Object o = vars.get("preZoomThumbs");
                                int z = 0;
                                if (!(o instanceof Integer) || (z = ((Integer)o).intValue()) < 100) {
                                    vars.put("preZoomThumbs", z + 100);
                                }
                            }
                        };
                        this.captionTemplate = new ControlPanel(Gui.this.texts.getString("ui.captionTemplate")){
                            JTextArea imgCaptionTemplate;
                            JScrollPane iCaptionPane;
                            {
                                this.imgCaptionTemplate = new JSmartTextArea(3, 30);
                                this.iCaptionPane = new JScrollPane(this.imgCaptionTemplate);
                                this.imgCaptionTemplate.setText("<h2>${fileLabel}</h2><div class=\"comment\">${comment}</div>");
                                this.imgCaptionTemplate.setEditable(true);
                                this.imgCaptionTemplate.setLineWrap(true);
                                this.imgCaptionTemplate.setWrapStyleWord(true);
                                this.add("hfill", this.iCaptionPane);
                            }
                        };
                        this.add("hfill", (Component)this.miscPanel);
                        this.add("br hfill", (Component)this.visibility);
                        this.add("br hfill", (Component)this.captionTemplate);
                    }
                };
                this.imagesPanel = new JScrollPane((Component)this.images, 20, 31);
                this.filters = new ControlPanel(){
                    JCheckBox autoCorrect;
                    JCheckBox grayScale;
                    ControlPanel watermarkPanel;
                    ControlPanel logoFilterPanel;
                    {
                        this.autoCorrect = new JCheckBox(Gui.this.texts.getString("ui.autoCorrect"), false);
                        this.grayScale = new JCheckBox(Gui.this.texts.getString("ui.grayScale"), false);
                        this.watermarkPanel = new ControlPanel(Gui.this.texts.getString("ui.watermark")){
                            JTextField watermark;
                            JTextField watermarkFont;
                            JButton selectFont;
                            JComboBox watermarkPosition;
                            JTextField watermarkStrength;
                            JTextField watermarkSize;
                            {
                                this.watermark = new JSmartTextField(30);
                                this.watermarkFont = new JSmartTextField(30);
                                this.selectFont = new JButton(Gui.this.texts.getString("ui.select"));
                                this.watermarkPosition = new JComboBox<Object>(Gui.this.getPosition());
                                this.watermarkStrength = new JSmartTextField("15", 3);
                                this.watermarkSize = new JSmartTextField("20", 3);
                                this.watermark.setToolTipText(Gui.this.texts.getString("ui.watermarkInfo"));
                                this.watermarkFont.setToolTipText(Gui.this.texts.getString("ui.watermarkFontInfo"));
                                this.selectFont.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        Gui.this.fillFontFaces();
                                        String s = (String)JOptionPane.showInputDialog((Component)Gui.this.window, null, Gui.this.texts.getString("ui.chooseFont"), -1, null, Gui.this.fontFaces.toArray(), watermarkFont.getText());
                                        if (s != null && s.length() > 0) {
                                            watermarkFont.setText(s);
                                        }
                                    }
                                });
                                this.watermarkPosition.setSelectedIndex(8);
                                this.watermarkStrength.setToolTipText(Gui.this.texts.getString("ui.strengthInfo"));
                                this.watermarkSize.setToolTipText(Gui.this.texts.getString("ui.sizeInfo"));
                                this.add("", (Component)new JLabelFor(Gui.this.texts.getString("ui.text"), (JComponent)this.watermark));
                                this.add("tab hfill", this.watermark);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.font"), (JComponent)this.watermarkFont));
                                this.add("tab hfill", this.watermarkFont);
                                this.add("", this.selectFont);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.position"), (JComponent)this.watermarkPosition));
                                this.add("tab", this.watermarkPosition);
                                this.add(" ", (Component)new JLabelFor(Gui.this.texts.getString("ui.strength"), (JComponent)this.watermarkStrength));
                                this.add(this.watermarkStrength);
                                this.add((Component)new JLabelFor(Gui.this.texts.getString("ui.size"), (JComponent)this.watermarkSize));
                                this.add(this.watermarkSize);
                            }
                        };
                        this.logoFilterPanel = new ControlPanel(Gui.this.texts.getString("ui.logoFilter")){
                            JTextField logoFilterFilename;
                            JButton selectLogo;
                            JComboBox logoFilterPosition;
                            JTextField logoFilterMargin;
                            JTextField logoFilterStrength;
                            {
                                this.logoFilterFilename = new JSmartTextField(20);
                                this.selectLogo = new JButton(Gui.this.texts.getString("ui.select"));
                                this.logoFilterPosition = new JComboBox<Object>(Gui.this.getPosition());
                                this.logoFilterMargin = new JSmartTextField("15", 3);
                                this.logoFilterStrength = new JSmartTextField("100", 3);
                                this.selectLogo.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        Gui.this.getFile(Gui.this.imgFilter, logoFilterFilename);
                                    }
                                });
                                this.add("hfill", this.logoFilterFilename);
                                this.add("", this.selectLogo);
                                this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.position"), (JComponent)this.logoFilterPosition));
                                this.add("tab", this.logoFilterPosition);
                                this.add(" ", (Component)new JLabelFor(Gui.this.texts.getString("ui.strength"), (JComponent)this.logoFilterStrength));
                                this.add(this.logoFilterStrength);
                                this.add(" ", (Component)new JLabelFor(Gui.this.texts.getString("ui.margin") + " (px)", (JComponent)this.logoFilterMargin));
                                this.add(this.logoFilterMargin);
                            }
                        };
                        this.autoCorrect.setToolTipText(Gui.this.texts.getString("ui.autoCorrectInfo"));
                        this.grayScale.setToolTipText(Gui.this.texts.getString("ui.grayScaleInfo"));
                        this.add("", this.autoCorrect);
                        this.add("", this.grayScale);
                        this.add("br hfill", (Component)this.watermarkPanel);
                        this.add("br hfill", (Component)this.logoFilterPanel);
                    }
                };
                this.social = new ControlPanel(){
                    ControlPanel sharing = new ControlPanel(){
                        JComboBox shareBoxType;
                        JCheckBox shareLabelsVisible;
                        ControlPanel buttons;
                        ControlPanel shares;
                        {
                            this.shareBoxType = new JComboBox<Object>(new Object[]{new Item((Object)"dropdown", (Object)Gui.this.texts.getString("ui.dropdown")), new Item((Object)"unboxed", (Object)Gui.this.texts.getString("ui.unboxed"))});
                            this.shareLabelsVisible = new JCheckBox(Gui.this.texts.getString("ui.showLabels"), true);
                            this.buttons = new ControlPanel(Gui.this.texts.getString("ui.buttons")){
                                JCheckBox facebookLike;
                                JCheckBox twitterTweet;
                                JCheckBox googlePlus;
                                JCheckBox tumblrButton;
                                JCheckBox pinItButton;
                                {
                                    this.facebookLike = new JCheckBox(Gui.this.texts.getString("ui.facebookLikeButton"));
                                    this.twitterTweet = new JCheckBox(Gui.this.texts.getString("ui.tweetButton"));
                                    this.googlePlus = new JCheckBox(Gui.this.texts.getString("ui.googlePlus"));
                                    this.tumblrButton = new JCheckBox(Gui.this.texts.getString("ui.tumblrButton"));
                                    this.pinItButton = new JCheckBox(Gui.this.texts.getString("ui.pinItButton"));
                                    this.facebookLike.setToolTipText(Gui.this.texts.getString("ui.facebookLikeButtonInfo"));
                                    this.twitterTweet.setToolTipText(Gui.this.texts.getString("ui.tweetButtonInfo"));
                                    this.googlePlus.setToolTipText(Gui.this.texts.getString("ui.googlePlusInfo"));
                                    this.tumblrButton.setToolTipText(Gui.this.texts.getString("ui.tumblrButtonInfo"));
                                    this.pinItButton.setToolTipText(Gui.this.texts.getString("ui.pinItButtonInfo"));
                                    this.add(this.facebookLike);
                                    this.add("br", this.twitterTweet);
                                    this.add("br", this.googlePlus);
                                    this.add("br", this.pinItButton);
                                    this.add("br", this.tumblrButton);
                                }
                            };
                            this.shares = new ControlPanel(Gui.this.texts.getString("shareOn")){
                                JCheckBox shareFacebook;
                                JCheckBox shareTwitter;
                                JCheckBox shareGplus;
                                JCheckBox sharePinterest;
                                JCheckBox shareDigg;
                                JCheckBox shareDelicious;
                                JCheckBox shareMyspace;
                                JCheckBox shareStumbleupon;
                                JCheckBox shareReddit;
                                JCheckBox shareEmail;
                                {
                                    this.shareFacebook = new JCheckBox("Facebook");
                                    this.shareTwitter = new JCheckBox("Twitter");
                                    this.shareGplus = new JCheckBox("Google+");
                                    this.sharePinterest = new JCheckBox("Pinterest");
                                    this.shareDigg = new JCheckBox("Digg");
                                    this.shareDelicious = new JCheckBox("Delicious");
                                    this.shareMyspace = new JCheckBox("MySpace");
                                    this.shareStumbleupon = new JCheckBox("StumbleUpon");
                                    this.shareReddit = new JCheckBox("Reddit");
                                    this.shareEmail = new JCheckBox("Email");
                                    this.setLayout((LayoutManager)new RiverLayout(4, 5));
                                    this.add(new JLabel(ShareIcons.facebook));
                                    this.add(this.shareFacebook);
                                    this.add("tab", new JLabel(ShareIcons.digg));
                                    this.add(this.shareDigg);
                                    this.add("br", new JLabel(ShareIcons.twitter));
                                    this.add(this.shareTwitter);
                                    this.add("tab", new JLabel(ShareIcons.stumbleupon));
                                    this.add(this.shareStumbleupon);
                                    this.add("br", new JLabel(ShareIcons.googleplus));
                                    this.add(this.shareGplus);
                                    this.add("tab", new JLabel(ShareIcons.reddit));
                                    this.add(this.shareReddit);
                                    this.add("br", new JLabel(ShareIcons.pinterest));
                                    this.add(this.sharePinterest);
                                    this.add("tab", new JLabel(ShareIcons.delicious));
                                    this.add(this.shareDelicious);
                                    this.add("br", new JLabel(ShareIcons.myspace));
                                    this.add(this.shareMyspace);
                                    this.add("tab", new JLabel(ShareIcons.email));
                                    this.add(this.shareEmail);
                                }
                            };
                            this.add(new JLabel(Gui.this.texts.getString("ui.placement")));
                            this.add(" ", this.shareBoxType);
                            this.add("tab", this.shareLabelsVisible);
                            this.add("br", (Component)this.buttons);
                            this.add("hfill", (Component)this.shares);
                        }
                    };
                    ControlPanel commenting = new ControlPanel(){
                        ControlPanel fbCommenting = new ControlPanel("Facebook"){
                            JCheckBox facebookCommenting;
                            JComboBox facebookCommentingPlacement;
                            JTextField facebookAppId;
                            JTextField facebookCommentingPosts;
                            JTextField facebookAdmins;
                            {
                                this.facebookCommenting = new JCheckBox(Gui.this.texts.getString("ui.facebookCommenting"));
                                this.facebookCommentingPlacement = new JComboBox<Object>(new Object[]{new Item((Object)"index", (Object)Gui.this.texts.getString("ui.index")), new Item((Object)"slide", (Object)Gui.this.texts.getString("ui.slide")), new Item((Object)"both", (Object)Gui.this.texts.getString("ui.both"))});
                                this.facebookAppId = new JSmartTextField("");
                                this.facebookCommentingPosts = new JSmartTextField("3", 2);
                                this.facebookAdmins = new JSmartTextField("");
                                this.facebookAppId.setToolTipText(Gui.this.texts.getString("ui.facebookAppIdInfo"));
                                this.facebookCommentingPosts.setToolTipText(Gui.this.texts.getString("ui.facebookCommentingPostsInfo"));
                                this.facebookAdmins.setToolTipText(Gui.this.texts.getString("ui.facebookAdminsInfo"));
                                ComponentUtilities.whenSelectedEnable((AbstractButton)this.facebookCommenting, (JComponent[])new JComponent[]{this.facebookCommentingPlacement, this.facebookAppId, this.facebookCommentingPosts, this.facebookAdmins});
                                this.add(this.facebookCommenting);
                                this.add(" ", (Component)new JLabelFor(Gui.this.texts.getString("ui.placedOn"), (JComponent)this.facebookCommentingPlacement));
                                this.add("", this.facebookCommentingPlacement);
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.facebookAppId")));
                                this.add("tab hfill", this.facebookAppId);
                                this.add("", (Component)new JLinkLabel("https://developers.facebook.com/apps", Gui.this.texts.getString("ui.signUp")));
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.facebookCommentingPosts")));
                                this.add("tab", this.facebookCommentingPosts);
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.facebookAdmins")));
                                this.add("tab hfill", this.facebookAdmins);
                            }
                        };
                        ControlPanel disqCommenting = new ControlPanel("Disqus"){
                            JCheckBox disqusCommenting;
                            JComboBox disqusCommentingPlacement;
                            JTextField disqusAppId;
                            {
                                this.disqusCommenting = new JCheckBox(Gui.this.texts.getString("ui.disqusCommenting"));
                                this.disqusCommentingPlacement = new JComboBox<Object>(new Object[]{new Item((Object)"index", (Object)Gui.this.texts.getString("ui.index")), new Item((Object)"slide", (Object)Gui.this.texts.getString("ui.slide")), new Item((Object)"both", (Object)Gui.this.texts.getString("ui.both"))});
                                this.disqusAppId = new JSmartTextField("");
                                this.disqusAppId.setToolTipText(Gui.this.texts.getString("ui.disqusAppIdInfo"));
                                ComponentUtilities.whenSelectedEnable((AbstractButton)this.disqusCommenting, (JComponent[])new JComponent[]{this.disqusCommentingPlacement, this.disqusAppId});
                                this.add(this.disqusCommenting);
                                this.add(" ", (Component)new JLabelFor(Gui.this.texts.getString("ui.placedOn"), (JComponent)this.disqusCommentingPlacement));
                                this.add("", this.disqusCommentingPlacement);
                                this.add("br", new JLabel(Gui.this.texts.getString("ui.disqusAppId")));
                                this.add("tab hfill", this.disqusAppId);
                                this.add("", (Component)new JLinkLabel("http://disqus.com/admin/create/", Gui.this.texts.getString("ui.signUp")));
                            }
                        };
                        {
                            this.add("hfill", (Component)this.fbCommenting);
                            this.add("br hfill", (Component)this.disqCommenting);
                            this.add("br", new JLabel("<html><i>" + Gui.this.texts.getString("ui.commentingOnSlidesInfo") + "</i></html>"));
                        }
                    };
                    ControlPanel feedback = new ControlPanel(){
                        JLabel feedbackEmailLabel;
                        JTextField feedbackEmail;
                        {
                            this.feedbackEmailLabel = new JLabel(Gui.this.texts.getString("ui.feedbackEmail"));
                            this.feedbackEmail = new JSmartTextField();
                            this.add(" ", new JLabel("<html><i>" + Gui.this.texts.getString("ui.useFeedbackInfo") + "</i></html>"));
                            this.add("br", this.feedbackEmailLabel);
                            this.add("hfill", this.feedbackEmail);
                        }
                    };
                    JTabbedPane socialTabs = new JTabbedPane(){
                        {
                            this.addTab(Gui.this.texts.getString("ui.sharing"), Gui.this.createImageIcon("share.png"), (Component)sharing);
                            this.addTab(Gui.this.texts.getString("ui.commenting"), Gui.this.createImageIcon("commenting.png"), (Component)commenting);
                            this.addTab(Gui.this.texts.getString("ui.feedback"), Gui.this.createImageIcon("email.png"), (Component)feedback);
                        }
                    };
                    {
                        this.add("hfill vfill", this.socialTabs);
                    }
                };
                this.photoData = new ControlPanel(){
                    JCheckBox showRegions;
                    JCheckBox showPhotoData;
                    JCheckBox showPhotoDataLabel;
                    JTextArea photoDataTemplate;
                    JScrollPane photoDataPane;
                    {
                        this.showRegions = new JCheckBox(Gui.this.texts.getString("ui.showRegions"), true);
                        this.showPhotoData = new JCheckBox(Gui.this.texts.getString("ui.showPhotoData"));
                        this.showPhotoDataLabel = new JCheckBox(Gui.this.texts.getString("ui.showLabel"), true);
                        this.photoDataTemplate = new JSmartTextArea(12, 30);
                        this.photoDataPane = new JScrollPane(this.photoDataTemplate);
                        this.showRegions.setToolTipText(Gui.this.texts.getString("ui.showRegionsInfo"));
                        this.showPhotoData.setToolTipText(Gui.this.texts.getString("ui.showPhotoDataInfo"));
                        this.showPhotoDataLabel.setToolTipText(Gui.this.texts.getString("ui.showLabelInfo"));
                        this.photoDataTemplate.setText("photographer|artist|Artist|Owner|Copyright|Iptc.By-line|Iptc.Copyright Notice, Xmp.Creator, Xmp.Title, objectName, Xmp.Subject, Xmp.Description, Iptc.keywords, Xmp.Format, Xmp.Rights, Xmp.Identifier, Xmp.Label, Country/Primary Location, Province/State, City, Sub-location, originalDate|Date/Time Original|Date/Time|CreateDate|ModifyDate, camera|Model, lens|Lens|Xmp.Lens-Information|Canon Makernote.Unknown tag (0x0095), focalLength35mm|focusDistance|Focal Length|Focallength, SubjectDistance, meteringMode|Metering Mode, isoEquivalent|ISO Speed Ratings, exposureTime|Exposure Time|Shutter Speed Value|ShutterSpeedValue, Aperture Value|aperture|F-Number|FNumber|Aperturevalue, Exposure Bias Value, Exposure Program|Exposureprogram|Exposure Mode, Xmp.SceneType, White Balance|WhiteBalance, Xmp.ColorSpace, Xmp.LightSource, flash|Flash, resolution");
                        this.photoDataTemplate.setEditable(true);
                        this.photoDataTemplate.setLineWrap(true);
                        this.photoDataTemplate.setWrapStyleWord(true);
                        ComponentUtilities.whenSelectedEnable((AbstractButton)this.showPhotoData, (JComponent[])new JComponent[]{this.showPhotoDataLabel, this.photoDataTemplate});
                        this.add(this.showRegions);
                        this.add("br", this.showPhotoData);
                        this.add("tab", this.showPhotoDataLabel);
                        this.add("br hfill vfill", this.photoDataPane);
                    }
                };
                this.map = new ControlPanel(){
                    JComboBox showMap;
                    JComboBox mapType;
                    JCheckBox mapAll;
                    JSlider mapZoom;
                    JTextField googleApiKey;
                    {
                        this.showMap = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.texts.getString("ui.none")), new Item((Object)"index", (Object)Gui.this.texts.getString("ui.index")), new Item((Object)"slide", (Object)Gui.this.texts.getString("ui.slide")), new Item((Object)"both", (Object)Gui.this.texts.getString("ui.both"))});
                        this.mapType = new JComboBox<Object>(new Object[]{new Item((Object)"roadmap", (Object)Gui.this.texts.getString("ui.roadmap")), new Item((Object)"satellite", (Object)Gui.this.texts.getString("ui.satellite")), new Item((Object)"hybrid", (Object)Gui.this.texts.getString("ui.hybrid")), new Item((Object)"terrain", (Object)Gui.this.texts.getString("ui.terrain"))});
                        this.mapAll = new JCheckBox(Gui.this.texts.getString("ui.allMarkers"));
                        this.mapZoom = new JSlider(0, 1, 20, 18);
                        this.googleApiKey = new JSmartTextField(20);
                        this.showMap.setToolTipText(Gui.this.texts.getString("ui.showMapInfo"));
                        this.mapAll.setToolTipText(Gui.this.texts.getString("ui.allMarkersInfo"));
                        this.mapZoom.setOrientation(0);
                        this.mapZoom.setMinimum(0);
                        this.mapZoom.setMaximum(20);
                        this.mapZoom.setValue(18);
                        this.mapZoom.setMajorTickSpacing(10);
                        this.mapZoom.setMinorTickSpacing(1);
                        this.mapZoom.setPaintTicks(true);
                        this.mapZoom.setPaintLabels(true);
                        this.mapZoom.setSnapToTicks(true);
                        this.googleApiKey.setToolTipText(Gui.this.texts.getString("ui.googleApiKeyInfo"));
                        this.add((Component)new JLabelFor(Gui.this.texts.getString("ui.showMap"), (JComponent)this.showMap));
                        this.add(this.showMap);
                        this.add("br", this.mapAll);
                        this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.initialView"), (JComponent)this.mapType));
                        this.add("tab", this.mapType);
                        this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.initialZoom"), (JComponent)this.mapZoom));
                        this.add("tab", this.mapZoom);
                        this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.googleApiKey"), (JComponent)this.googleApiKey));
                        this.add("tab hfill", this.googleApiKey);
                        this.add(" ", (Component)new JLinkLabel("https://developers.google.com/maps/documentation/javascript/tutorial", Gui.this.texts.getString("ui.readMore")));
                    }

                    public void importVariables(Map<String, Object> vars) {
                        if (Boolean.TRUE == vars.get("useMap")) {
                            vars.put("useMap", "slides");
                        }
                    }
                };
                this.shop = new ControlPanel(){
                    ControlPanel paypal = new ControlPanel(){
                        JCheckBox showShop;
                        JComboBox shopGateway;
                        JComboBox shopPlacement;
                        JTextField shopId;
                        JComboBox shopCurrency;
                        JTextField shopHandling;
                        JTextField shopQuantityCap;
                        JTextArea shopOptions;
                        JTextField shopDiscountRate;
                        JTextArea shopCoupons;
                        JLabel shopOptionsHint;
                        JLabel shopCouponsHint;
                        JTextField shopContinueUrl;
                        {
                            this.showShop = new JCheckBox(Gui.this.texts.getString("ui.usePaypal"));
                            this.shopGateway = new JComboBox<Object>(new Object[]{new Item((Object)"paypal", (Object)"PayPal Website Standards Payment")});
                            this.shopPlacement = new JComboBox<Object>(new Object[]{new Item((Object)"index", (Object)Gui.this.texts.getString("ui.index")), new Item((Object)"slide", (Object)Gui.this.texts.getString("ui.slide")), new Item((Object)"both", (Object)Gui.this.texts.getString("ui.both"))});
                            this.shopId = new JTextField(24);
                            this.shopCurrency = new JComboBox<Object>(new Object[]{new Item((Object)"USD", (Object)"United States Dollar"), new Item((Object)"EUR", (Object)"Euro"), new Item((Object)"GBP", (Object)"British Pound"), new Item((Object)"CAD", (Object)"Canadian Dollar"), new Item((Object)"AUD", (Object)"Australian Dollar"), new Item((Object)"JPY", (Object)"Japanese Yen"), new Item((Object)"NZD", (Object)"New Zealand Dollar"), new Item((Object)"CHF", (Object)"Swiss Franc"), new Item((Object)"BRL", (Object)"Brazilian Real"), new Item((Object)"CZK", (Object)"Czech Koruna"), new Item((Object)"DKK", (Object)"Danish Krone"), new Item((Object)"HKD", (Object)"Hong Kong Dollar"), new Item((Object)"HUF", (Object)"Hungary Forint"), new Item((Object)"ILS", (Object)"Israel New Shekel"), new Item((Object)"MYR", (Object)"Malaysian Ringgit"), new Item((Object)"MXN", (Object)"Mexican Peso"), new Item((Object)"NOK", (Object)"Norway Krone"), new Item((Object)"PHP", (Object)"Philippines Peso"), new Item((Object)"PLN", (Object)"Poland Zlotych"), new Item((Object)"RUB", (Object)"Russian Ruble"), new Item((Object)"SGD", (Object)"Singapore Dollar"), new Item((Object)"SEK", (Object)"Sweden Krona"), new Item((Object)"TWD", (Object)"New Taiwan Dollar"), new Item((Object)"THB", (Object)"Thailand Baht"), new Item((Object)"TRY", (Object)"Turkish Lira")});
                            this.shopHandling = new JSmartTextField(4);
                            this.shopQuantityCap = new JSmartTextField(4);
                            this.shopOptions = new JSmartTextArea(5, 30);
                            this.shopDiscountRate = new JSmartTextField(4);
                            this.shopCoupons = new JSmartTextArea(5, 30);
                            this.shopOptionsHint = new JLabel(Gui.this.texts.getString("ui.shopOptionsHint"));
                            this.shopCouponsHint = new JLabel(Gui.this.texts.getString("ui.shopCouponsHint"));
                            this.shopContinueUrl = new JSmartTextField(20);
                            if (Gui.this.license.length() == 0) {
                                this.showShop.setSelected(false);
                                Gui.this.commercialMonitor.add(this.showShop);
                            }
                            this.showShop.setToolTipText(Gui.this.texts.getString("ui.sellPhotosInfo"));
                            this.shopGateway.setToolTipText(Gui.this.texts.getString("ui.paymentGatewayInfo"));
                            this.shopPlacement.setSelectedIndex(1);
                            this.shopId.setToolTipText(Gui.this.texts.getString("ui.sellerIdInfo"));
                            this.shopCurrency.setEditable(false);
                            this.shopHandling.setToolTipText(Gui.this.texts.getString("ui.handlingInfo"));
                            this.shopDiscountRate.setToolTipText(Gui.this.texts.getString("ui.shopDiscountRateInfo"));
                            this.shopQuantityCap.setToolTipText(Gui.this.texts.getString("ui.shopQuantityCapInfo"));
                            this.shopOptions.setToolTipText(Gui.this.texts.getString("ui.shopOptionsInfo"));
                            this.shopOptions.setText("Print (5x3.75\")=0.2\nPoster (A1)=10.0+2.0\nDownload (16 Mpx)=20.0");
                            this.shopOptions.setEditable(true);
                            this.shopOptions.setLineWrap(true);
                            this.shopOptions.setWrapStyleWord(true);
                            this.shopCoupons.setToolTipText(Gui.this.texts.getString("ui.shopCouponsInfo"));
                            this.shopCoupons.setEditable(true);
                            this.shopCoupons.setLineWrap(true);
                            this.shopCoupons.setWrapStyleWord(true);
                            this.shopContinueUrl.setToolTipText(Gui.this.texts.getString("ui.shopContinueUrlInfo"));
                            JScrollPane shopPane = new JScrollPane(this.shopOptions);
                            JScrollPane shopCouponsPane = new JScrollPane(this.shopCoupons);
                            ComponentUtilities.whenSelectedEnable((AbstractButton)this.showShop, (JComponent[])new JComponent[]{this.shopPlacement, this.shopGateway, this.shopId, this.shopCurrency, this.shopHandling, this.shopDiscountRate, this.shopQuantityCap, this.shopContinueUrl, this.shopOptions, this.shopOptionsHint, this.shopCoupons, this.shopCouponsHint});
                            this.add(this.showShop);
                            this.add(" ", (Component)new JLabelFor(Gui.this.texts.getString("ui.placedOn"), (JComponent)this.shopPlacement));
                            this.add("", this.shopPlacement);
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.sellerId"), (JComponent)this.shopId));
                            this.add("tab", this.shopId);
                            this.add(" ", (Component)new JLinkLabel("https://www.paypal.com/cgi-bin/webscr?cmd=_registration-run", Gui.this.texts.getString("ui.signUp")));
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.currency"), (JComponent)this.shopCurrency));
                            this.add("tab", this.shopCurrency);
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.handling"), (JComponent)this.shopHandling));
                            this.add("tab", this.shopHandling);
                            this.add("tab", (Component)new JLabelFor(Gui.this.texts.getString("ui.shopQuantityCap"), (JComponent)this.shopQuantityCap));
                            this.add("tab", this.shopQuantityCap);
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.shopOptions"), (JComponent)this.shopOptions));
                            this.add("br hfill", shopPane);
                            this.add("br", this.shopOptionsHint);
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.shopDiscountRate"), (JComponent)this.shopDiscountRate));
                            this.add("tab", this.shopDiscountRate);
                            this.add(new JLabel("%"));
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.shopCoupons"), (JComponent)this.shopCoupons));
                            this.add("br hfill", shopCouponsPane);
                            this.add("br", this.shopCouponsHint);
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.shopContinueUrl"), (JComponent)this.shopContinueUrl));
                            this.add("tab hfill", this.shopContinueUrl);
                        }
                    };
                    JScrollPane paypalPanel = new JScrollPane((Component)this.paypal, 20, 31);
                    ControlPanel fotomoto = new ControlPanel(){
                        JCheckBox useFotomoto;
                        JTextField fotomotoID;
                        {
                            this.useFotomoto = new JCheckBox(Gui.this.texts.getString("ui.useFotomoto"));
                            this.fotomotoID = new JSmartTextField();
                            this.fotomotoID.setToolTipText(Gui.this.texts.getString("ui.fotomotoIDInfo"));
                            ComponentUtilities.whenSelectedEnable((AbstractButton)this.useFotomoto, (JComponent[])new JComponent[]{this.fotomotoID});
                            this.add(this.useFotomoto);
                            this.add((Component)new JLinkLabel("http://my.fotomoto.com/signup", Gui.this.texts.getString("ui.signUp")));
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.sellerId"), (JComponent)this.fotomotoID));
                            this.add("tab hfill", this.fotomotoID);
                        }
                    };
                    ControlPanel mostphotos = new ControlPanel(){
                        JCheckBox useMostphotos;
                        JLabel mostphotosHint;
                        {
                            this.useMostphotos = new JCheckBox(Gui.this.texts.getString("ui.useMostphotos"), true);
                            this.mostphotosHint = new JLabel("<html><p>" + Gui.this.texts.getString("ui.mostphotosHint") + "</p></html>");
                            this.add(this.useMostphotos);
                            this.add((Component)new JLinkLabel("http://www.mostphotos.com/signup", Gui.this.texts.getString("ui.signUp")));
                            this.add("br", this.mostphotosHint);
                        }
                    };
                    JTabbedPane shopTabs = new JTabbedPane(){
                        {
                            paypalPanel.setBorder(BorderFactory.createEmptyBorder());
                            this.addTab("PayPal", Gui.this.createImageIcon("paypal.png"), paypalPanel);
                            this.addTab("Fotomoto", Gui.this.createImageIcon("fotomoto.png"), (Component)fotomoto);
                            this.addTab("Mostphotos", Gui.this.createImageIcon("mostphotos.png"), (Component)mostphotos);
                        }
                    };
                    {
                        this.add("hfill vfill", this.shopTabs);
                    }
                };
                this.av = new ControlPanel(){
                    JCheckBox videoAutoPlay;
                    JCheckBox videoMaximize;
                    JCheckBox videoTitleOn;
                    JCheckBox prioritizeFlash;
                    ControlPanel backgroundAudio;
                    {
                        this.videoAutoPlay = new JCheckBox(Gui.this.texts.getString("ui.startVideo"));
                        this.videoMaximize = new JCheckBox(Gui.this.texts.getString("ui.videoMaximize"));
                        this.videoTitleOn = new JCheckBox(Gui.this.texts.getString("ui.videoTitleOn"));
                        this.prioritizeFlash = new JCheckBox(Gui.this.texts.getString("ui.prioritizeFlash"));
                        this.backgroundAudio = new ControlPanel(Gui.this.texts.getString("ui.backgroundMusic")){
                            JCheckBox useAlbumAudioAsBackground;
                            JPlaylist playlist;
                            JCheckBox backgroundAudioAutoPlay;
                            JCheckBox backgroundAudioSlideshowControl;
                            JCheckBox backgroundAudioLoop;
                            JCheckBox backgroundAudioRetainPosition;
                            {
                                this.useAlbumAudioAsBackground = new JCheckBox(Gui.this.texts.getString("ui.useAlbumAudioAsBackground"));
                                this.playlist = new JPlaylist();
                                this.backgroundAudioAutoPlay = new JCheckBox(Gui.this.texts.getString("ui.autoStart"));
                                this.backgroundAudioSlideshowControl = new JCheckBox(Gui.this.texts.getString("ui.slideshowControl"));
                                this.backgroundAudioLoop = new JCheckBox(Gui.this.texts.getString("ui.loop"));
                                this.backgroundAudioRetainPosition = new JCheckBox(Gui.this.texts.getString("ui.retainPosition"), true);
                                ComponentUtilities.whenSelectedDisable((AbstractButton)this.useAlbumAudioAsBackground, (JComponent[])new JComponent[]{this.playlist});
                                this.backgroundAudioSlideshowControl.setToolTipText(Gui.this.texts.getString("ui.slideshowControlInfo"));
                                this.backgroundAudioRetainPosition.setToolTipText(Gui.this.texts.getString("ui.retainPositionInfo"));
                                this.add(this.useAlbumAudioAsBackground);
                                this.add("br hfill", (Component)this.playlist);
                                this.add("br", this.backgroundAudioAutoPlay);
                                this.add("tab", this.backgroundAudioSlideshowControl);
                                this.add("br", this.backgroundAudioLoop);
                                this.add("tab", this.backgroundAudioRetainPosition);
                            }
                        };
                        this.videoMaximize.setToolTipText(Gui.this.texts.getString("ui.videoMaximizeInfo"));
                        this.videoTitleOn.setToolTipText(Gui.this.texts.getString("ui.videoTitleOnInfo"));
                        this.prioritizeFlash.setToolTipText(Gui.this.texts.getString("ui.prioritizeFlashInfo"));
                        this.add("", this.videoAutoPlay);
                        this.add("tab", this.videoMaximize);
                        this.add("br", this.videoTitleOn);
                        this.add("tab", this.prioritizeFlash);
                        this.add("br hfill", (Component)this.backgroundAudio);
                        this.add("br center", new JLabel(Gui.this.texts.getString("ui.videoPlayerBy")));
                        this.add("", (Component)new JLinkLabel("http://jplayer.org/", "jplayer.org"));
                    }
                };
                this.advanced = new ControlPanel(){
                    ControlPanel general = new ControlPanel(){
                        JCheckBox enableMouseWheel;
                        JCheckBox enableKeyboard;
                        JCheckBox clickForNext;
                        JCheckBox autohideControls;
                        JCheckBox hideFitToggle;
                        JCheckBox rightClickProtect;
                        JCheckBox downloadNonImages;
                        JCheckBox preFormat;
                        JComboBox longComments;
                        JCheckBox copyFolderThumbs;
                        JCheckBox addAltTags;
                        JCheckBox useFavicon;
                        JCheckBox useNoscript;
                        JTextField uploadPath;
                        JCheckBox debugMode;
                        JTextField debugVars;
                        {
                            this.enableMouseWheel = new JCheckBox(Gui.this.texts.getString("ui.enableMouseWheel"), true);
                            this.enableKeyboard = new JCheckBox(Gui.this.texts.getString("ui.enableKeyboard"), true);
                            this.clickForNext = new JCheckBox(Gui.this.texts.getString("ui.clickForNext"), true);
                            this.autohideControls = new JCheckBox(Gui.this.texts.getString("ui.autohideControls"), true);
                            this.hideFitToggle = new JCheckBox(Gui.this.texts.getString("ui.hideFitToggle"));
                            this.rightClickProtect = new JCheckBox(Gui.this.texts.getString("ui.rightClickProtect"));
                            this.downloadNonImages = new JCheckBox(Gui.this.texts.getString("ui.enableDownloadNonImages"));
                            this.preFormat = new JCheckBox(Gui.this.texts.getString("ui.preFormatPages"), true);
                            this.longComments = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.texts.getString("ui.none")), new Item((Object)"shorten", (Object)Gui.this.texts.getString("ui.shorten")), new Item((Object)"scroll", (Object)Gui.this.texts.getString("ui.addScroll"))});
                            this.copyFolderThumbs = new JCheckBox(Gui.this.texts.getString("ui.copyFolderThumbs"), false);
                            this.addAltTags = new JCheckBox(Gui.this.texts.getString("ui.addAltTags"), true);
                            this.useFavicon = new JCheckBox(Gui.this.texts.getString("ui.useFavicon"), true);
                            this.useNoscript = new JCheckBox(Gui.this.texts.getString("ui.useNoscript"), true);
                            this.uploadPath = new JSmartTextField();
                            this.debugMode = new JCheckBox(Gui.this.texts.getString("ui.debugMode"));
                            this.debugVars = new JSmartTextField();
                            this.enableMouseWheel.setToolTipText(Gui.this.texts.getString("ui.enableMouseWheelInfo"));
                            this.enableKeyboard.setToolTipText(Gui.this.texts.getString("ui.enableKeyboardInfo"));
                            this.clickForNext.setToolTipText(Gui.this.texts.getString("ui.clickForNextInfo"));
                            this.autohideControls.setToolTipText(Gui.this.texts.getString("ui.autohideControlsInfo"));
                            this.hideFitToggle.setToolTipText(Gui.this.texts.getString("ui.hideFitToggleInfo"));
                            this.rightClickProtect.setToolTipText(Gui.this.texts.getString("ui.rightClickProtectInfo"));
                            this.downloadNonImages.setToolTipText(Gui.this.texts.getString("ui.enableDownloadNonImagesInfo"));
                            this.preFormat.setToolTipText(Gui.this.texts.getString("ui.preFormatPagesInfo"));
                            this.copyFolderThumbs.setToolTipText(Gui.this.texts.getString("ui.copyFolderThumbsInfo"));
                            this.addAltTags.setToolTipText(Gui.this.texts.getString("ui.addAltTagsInfo"));
                            this.useFavicon.setToolTipText(Gui.this.texts.getString("ui.useFaviconInfo"));
                            ComponentUtilities.whenSelectedEnable((AbstractButton)this.preFormat, (JComponent[])new JComponent[]{formattingHint1h, formattingHint2h, formattingHint1f, formattingHint2f});
                            this.uploadPath.setToolTipText(Gui.this.texts.getString("ui.uploadPathInfo"));
                            ComponentUtilities.whenSelectedEnable((AbstractButton)this.debugMode, (JComponent[])new JComponent[]{this.debugVars});
                            this.add("", this.enableMouseWheel);
                            this.add("br", this.enableKeyboard);
                            this.add("br", this.clickForNext);
                            this.add("br", this.autohideControls);
                            this.add("br", this.hideFitToggle);
                            this.add("br", this.rightClickProtect);
                            this.add("br", this.downloadNonImages);
                            this.add("br", this.preFormat);
                            this.add("br", new JLabel(Gui.this.texts.getString("ui.handlingLongComments")));
                            this.add("", this.longComments);
                            this.add("br", this.copyFolderThumbs);
                            this.add("br", this.addAltTags);
                            this.add("br", this.useFavicon);
                            this.add("br", this.useNoscript);
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.uploadPath"), (JComponent)this.uploadPath));
                            this.add("tab hfill", this.uploadPath);
                            this.add("br", this.debugMode);
                            this.add(" ", (Component)new JLabelFor(Gui.this.texts.getString("ui.variables"), (JComponent)this.debugVars));
                            this.add("hfill", this.debugVars);
                        }
                    };
                    JScrollPane generalPanel = new JScrollPane((Component)this.general, 20, 31);
                    ControlPanel albuminfoPanel = new ControlPanel(){
                        JCheckBox headerTopLevelOnly;
                        JTextArea header;
                        JScrollPane headerPane;
                        {
                            this.headerTopLevelOnly = new JCheckBox(Gui.this.texts.getString("ui.topLevelOnly"), true);
                            this.header = new JTextArea(6, 30);
                            this.headerPane = new JScrollPane(this.header);
                            this.header.setEditable(true);
                            this.header.setLineWrap(true);
                            this.header.setWrapStyleWord(true);
                            this.header.setFont(this.header.getFont().deriveFont(11.0f));
                            this.header.setToolTipText(Gui.this.texts.getString("ui.customContentInfo"));
                            this.add(new JLabel("<html><p><i>" + Gui.this.texts.getString("ui.albumInfoText") + "</i></p></html>"));
                            this.add("br", this.headerTopLevelOnly);
                            this.add("br hfill vfill", this.headerPane);
                            this.add("br", formattingHint1h);
                            this.add("br", formattingHint2h);
                        }
                    };
                    ControlPanel footerPanel = new ControlPanel(){
                        JCheckBox footerTopLevelOnly;
                        JTextArea footer;
                        JScrollPane footerPane;
                        {
                            this.footerTopLevelOnly = new JCheckBox(Gui.this.texts.getString("ui.topLevelOnly"), false);
                            this.footer = new JTextArea(6, 30);
                            this.footerPane = new JScrollPane(this.footer);
                            this.footer.setEditable(true);
                            this.footer.setLineWrap(true);
                            this.footer.setWrapStyleWord(true);
                            this.footer.setFont(this.footer.getFont().deriveFont(11.0f));
                            this.footer.setToolTipText(Gui.this.texts.getString("ui.customContentInfo"));
                            this.add(new JLabel("<html><p><i>" + Gui.this.texts.getString("ui.footerText") + "</i></p></html>"));
                            this.add("br", this.footerTopLevelOnly);
                            this.add("br hfill vfill", this.footerPane);
                            this.add("br", formattingHint1f);
                            this.add("br", formattingHint2f);
                        }
                    };
                    ControlPanel htmlHookTab = new ControlPanel(){
                        JTextArea headHook = new JTextArea(7, 20);
                        JScrollPane headHookPane = new JScrollPane(this.headHook);
                        JTextArea thumbsHook = new JTextArea(7, 20);
                        JScrollPane thumbsHookPane = new JScrollPane(this.thumbsHook);
                        JTextArea bodyHook = new JTextArea(7, 20);
                        JScrollPane bodyHookPane = new JScrollPane(this.bodyHook);
                        {
                            this.headHook.setEditable(true);
                            this.headHook.setLineWrap(false);
                            this.headHook.setFont(this.headHook.getFont().deriveFont(11.0f));
                            this.thumbsHook.setEditable(true);
                            this.thumbsHook.setLineWrap(false);
                            this.thumbsHook.setFont(this.thumbsHook.getFont().deriveFont(11.0f));
                            this.bodyHook.setEditable(true);
                            this.bodyHook.setLineWrap(false);
                            this.bodyHook.setFont(this.bodyHook.getFont().deriveFont(11.0f));
                            this.add(new JLabel("<html><p><b>HEAD</b> <i>" + Gui.this.texts.getString("ui.headText") + "</i></p></html>"));
                            this.add("br hfill", this.headHookPane);
                            this.add("br", new JLabel("<html><p><b>" + Gui.this.texts.getString("ui.thumbnails") + "</b> <i>" + Gui.this.texts.getString("ui.thumbnailsText") + "</i></p></html>"));
                            this.add("br hfill", this.thumbsHookPane);
                            this.add("br", new JLabel("<html><p><b>BODY</b> <i>" + Gui.this.texts.getString("ui.bodyText") + "</i></p></html>"));
                            this.add("br hfill vfill", this.bodyHookPane);
                        }
                    };
                    ControlPanel cssHookTab = new ControlPanel(){
                        JTextArea cssHook = new JTextArea(15, 30);
                        JScrollPane cssHookPane = new JScrollPane(this.cssHook);
                        {
                            this.cssHook.setEditable(true);
                            this.cssHook.setLineWrap(false);
                            this.cssHook.setFont(this.cssHook.getFont().deriveFont(11.0f));
                            this.add("", new JLabel("<html><p><i>" + Gui.this.texts.getString("ui.cssText") + "</i></p></html>"));
                            this.add("br hfill vfill", this.cssHookPane);
                        }
                    };
                    ControlPanel jsHookTab = new ControlPanel(){
                        JTextArea jsHook = new JTextArea(15, 30);
                        JScrollPane jsHookPane = new JScrollPane(this.jsHook);
                        {
                            this.jsHook.setEditable(true);
                            this.jsHook.setLineWrap(false);
                            this.jsHook.setFont(this.jsHook.getFont().deriveFont(11.0f));
                            this.add("", new JLabel("<html><i>" + Gui.this.texts.getString("ui.javascriptText") + "</i></html>"));
                            this.add("br hfill vfill", this.jsHookPane);
                        }
                    };
                    ControlPanel imgHookTab = new ControlPanel(){
                        JTextField imgHookBtn = new JSmartTextField(20);
                        JTextField imgHookWidth = new JSmartTextField("600", 5);
                        JTextField imgHookFn = new JSmartTextField(20);
                        JTextArea imgHook = new JTextArea(15, 30);
                        JScrollPane imgHookPane = new JScrollPane(this.imgHook);
                        {
                            this.imgHookBtn.setToolTipText(Gui.this.texts.getString("ui.imgHookBtnInfo"));
                            this.imgHookFn.setToolTipText(Gui.this.texts.getString("ui.imgHookFnInfo"));
                            this.imgHook.setEditable(true);
                            this.imgHook.setLineWrap(false);
                            this.imgHook.setFont(this.imgHook.getFont().deriveFont(11.0f));
                            this.add("", new JLabel("<html><p><i>" + Gui.this.texts.getString("ui.imageText") + "</i></p></html>"));
                            this.add("br", new JLabel(Gui.this.texts.getString("ui.buttonLabel")));
                            this.add("tab", this.imgHookBtn);
                            this.add(" ", new JLabel(Gui.this.texts.getString("ui.panelWidth")));
                            this.add("", this.imgHookWidth);
                            this.add("br", new JLabel(Gui.this.texts.getString("ui.imgHookFn")));
                            this.add("tab", this.imgHookFn);
                            this.add("br hfill vfill", this.imgHookPane);
                        }
                    };
                    ControlPanel googleTab = new ControlPanel(){
                        JComboBox googleAnalytics;
                        JTextField googleSiteID;
                        {
                            this.googleAnalytics = new JComboBox<Object>(new Object[]{new Item((Object)"none", (Object)Gui.this.texts.getString("ui.none")), new Item((Object)"classic", (Object)Gui.this.texts.getString("ui.classic")), new Item((Object)"universal", (Object)Gui.this.texts.getString("ui.universal"))});
                            this.googleSiteID = new JSmartTextField();
                            this.googleAnalytics.setSelectedItem(1);
                            this.googleSiteID.setToolTipText(Gui.this.texts.getString("ui.googleSiteIDInfo"));
                            this.add("", (Component)new JLabelFor(Gui.this.texts.getString("ui.useAnalytics"), (JComponent)this.googleAnalytics));
                            this.add("tab", this.googleAnalytics);
                            this.add(" ", (Component)new JLinkLabel("http://www.google.com/analytics/", Gui.this.texts.getString("ui.signUp")));
                            this.add("br", (Component)new JLabelFor(Gui.this.texts.getString("ui.googleSiteID"), (JComponent)this.googleSiteID));
                            this.add("tab hfill", this.googleSiteID);
                        }
                    };
                    JTabbedPane advancedTabs = new JTabbedPane(){
                        {
                            generalPanel.setBorder(BorderFactory.createEmptyBorder());
                            this.addTab(Gui.this.texts.getString("ui.general"), Gui.this.createImageIcon("general.png"), generalPanel);
                            this.addTab(Gui.this.texts.getString("ui.albumInfo"), Gui.this.createImageIcon("info.png"), (Component)albuminfoPanel);
                            this.addTab(Gui.this.texts.getString("ui.footer"), Gui.this.createImageIcon("footer.png"), (Component)footerPanel);
                            this.addTab("HTML", Gui.this.createImageIcon("code.png"), (Component)htmlHookTab);
                            this.addTab("CSS", Gui.this.createImageIcon("css.png"), (Component)cssHookTab);
                            this.addTab("JavaScript", Gui.this.createImageIcon("js.png"), (Component)jsHookTab);
                            this.addTab(Gui.this.texts.getString("ui.customButton"), Gui.this.createImageIcon("button.png"), (Component)imgHookTab);
                            this.addTab(Gui.this.texts.getString("ui.googleAnalytics"), Gui.this.createImageIcon("analytics.png"), (Component)googleTab);
                        }
                    };
                    {
                        this.add("hfill vfill", this.advancedTabs);
                    }
                };
                this.about = new ControlPanel(){
                    {
                        this.add("hfill vfill", Gui.this.aboutPanel);
                    }
                };
                this.tabs = new JTabbedPane(){
                    {
                        sitePanel.setBorder(BorderFactory.createEmptyBorder());
                        designPanel.setBorder(BorderFactory.createEmptyBorder());
                        themeImagePanel.setBorder(BorderFactory.createEmptyBorder());
                        thumbnailsPanel.setBorder(BorderFactory.createEmptyBorder());
                        imagesPanel.setBorder(BorderFactory.createEmptyBorder());
                        this.addTab(Gui.this.texts.getString("ui.site"), Gui.this.createImageIcon("site.png"), sitePanel);
                        this.addTab(Gui.this.texts.getString("ui.design"), Gui.this.createImageIcon("design.png"), designPanel);
                        this.addTab(Gui.this.texts.getString("ui.themeImage"), Gui.this.createImageIcon("header.png"), themeImagePanel);
                        this.addTab(Gui.this.texts.getString("ui.thumbnails"), Gui.this.createImageIcon("index.png"), thumbnailsPanel);
                        this.addTab(Gui.this.texts.getString("ui.images"), Gui.this.createImageIcon("slide.png"), imagesPanel);
                        this.addTab(Gui.this.texts.getString("ui.filters"), Gui.this.createImageIcon("filter.png"), (Component)filters);
                        this.addTab(Gui.this.texts.getString("ui.social"), Gui.this.createImageIcon("social.png"), (Component)social);
                        this.addTab(Gui.this.texts.getString("ui.photoData"), Gui.this.createImageIcon("photodata.png"), (Component)photoData);
                        this.addTab(Gui.this.texts.getString("ui.map"), Gui.this.createImageIcon("map.png"), (Component)map);
                        this.addTab(Gui.this.texts.getString("ui.sellingPhotos"), Gui.this.createImageIcon("shop.png"), (Component)shop);
                        this.addTab(Gui.this.texts.getString("ui.audioVideo"), Gui.this.createImageIcon("av.png"), (Component)av);
                        this.addTab(Gui.this.texts.getString("ui.advanced"), Gui.this.createImageIcon("advanced.png"), (Component)advanced);
                        this.addTab(Gui.this.texts.getString("ui.about"), Gui.this.createImageIcon("info.png"), (Component)about);
                    }
                };
                this.add("hfill vfill", this.tabs);
                this.add("br center", new JLabel("Jalbum " + Gui.this.internalVersion));
                this.add((Component)new JLinkLabel("http://jalbum.net/software/download/current", Gui.this.texts.getString("ui.upgrade"), Gui.this.texts.getString("ui.downloadJalbum")));
                this.add(new JLabel("|  " + Gui.this.skin + " skin " + Gui.this.skinVer));
                this.add((Component)new JLinkLabel("http://jalbum.net/skins/skin/" + Gui.this.skin, Gui.this.texts.getString("ui.upgrade"), Gui.this.texts.getString("ui.downloadSkin")));
                this.add(new JLabel("|"));
                this.add((Component)new JLinkLabel("http://lazaworx.com/turtle-skin-settings-explained/", Gui.this.texts.getString("help")));
                this.add(new JLabel("|"));
                this.add((Component)new JLinkLabel("http://jalbum.net/forum/index.jspa?categoryID=1", Gui.this.texts.getString("ui.support")));
            }
        };
        PluginContext pc = context.getPluginContext();
        EditPanel editPanel = pc.getEditPanel();
        ImageDataUI imageDataUI = new ImageDataUI(context);
        ExternalContentUI externalContentUI = new ExternalContentUI(context);
        editPanel.addCustomTab(this.texts.getString("ui.imageData"), (JComponent)((Object)imageDataUI));
        editPanel.addCustomTab(this.texts.getString("ui.external"), (JComponent)((Object)externalContentUI));
        this.ui.setBorder(BorderFactory.createEmptyBorder());
        window.setSkinUI(this.ui);
        window.pack();
    }

    class ExternalContentUI
    extends JCustomPanel {
        JTextArea externalContent;
        JScrollPane externalContentPane;
        JTextField externalContentSize;

        public ExternalContentUI(JAlbumContext context) {
            super(context);
            this.externalContent = new JSmartTextArea(3, 10);
            this.externalContentPane = new JScrollPane(this.externalContent);
            this.externalContentSize = new JSmartTextField(10);
            this.setBackground(SystemColor.text);
            this.setOpaque(true);
            this.externalContent.setToolTipText(Gui.this.texts.getString("ui.externalContentInfo"));
            this.externalContent.setText("");
            this.externalContent.setEditable(true);
            this.externalContent.setLineWrap(true);
            this.externalContent.setWrapStyleWord(true);
            this.externalContentSize.setToolTipText(Gui.this.texts.getString("ui.externalContentSizeInfo"));
            this.add(new JLabel(Gui.this.texts.getString("ui.externalContent")));
            this.add("br hfill vfill", this.externalContentPane);
            this.add("br", new JLabel(Gui.this.texts.getString("ui.externalContentSize")));
            this.add("tab hfill", this.externalContentSize);
            this.init();
        }
    }

    class ImageDataUI
    extends JCustomPanel {
        JCheckBox hideLocation;
        JTextField location;
        JTextField videoSize;
        JTextArea shopOptions;
        JScrollPane shopPane;
        JTextField shopDiscountRate;

        public ImageDataUI(JAlbumContext context) {
            super(context);
            this.hideLocation = new JCheckBox(Gui.this.texts.getString("ui.hideLocation"));
            this.location = new JSmartTextField(10);
            this.videoSize = new JSmartTextField(10);
            this.shopOptions = new JSmartTextArea(4, 10);
            this.shopPane = new JScrollPane(this.shopOptions);
            this.shopDiscountRate = new JTextField(10);
            this.setBackground(SystemColor.text);
            this.setOpaque(true);
            this.hideLocation.setToolTipText(Gui.this.texts.getString("ui.hideLocationInfo"));
            this.hideLocation.setOpaque(false);
            this.location.setToolTipText(Gui.this.texts.getString("ui.gpsLocationInfo"));
            this.videoSize.setToolTipText(Gui.this.texts.getString("ui.videoSizeInfo"));
            this.shopDiscountRate.setToolTipText(Gui.this.texts.getString("ui.shopDiscountRateInfo1"));
            this.shopOptions.setToolTipText(Gui.this.texts.getString("ui.shopOptionsInfo"));
            this.shopOptions.setText("");
            this.shopOptions.setEditable(true);
            this.shopOptions.setLineWrap(true);
            this.shopOptions.setWrapStyleWord(true);
            this.add(this.hideLocation);
            this.add("br", new JLabel(Gui.this.texts.getString("ui.gpsLocation")));
            this.add("tab hfill", this.location);
            this.add("br", new JLabel(Gui.this.texts.getString("ui.videoSize")));
            this.add("tab hfill", this.videoSize);
            this.add("br", new JLabel(Gui.this.texts.getString("ui.shopDiscountRate")));
            this.add("tab hfill", this.shopDiscountRate);
            this.add(new JLabel("%"));
            this.add("br", new JLabel(Gui.this.texts.getString("ui.shopOptions")));
            this.add("br hfill vfill", this.shopPane);
            this.init();
        }
    }
}

