/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.UIManager;

public class MultiSplitLayout
implements LayoutManager {
    private final Map childMap = new HashMap();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Node model;
    private int dividerSize;
    private boolean floatingDividers = true;

    public MultiSplitLayout() {
        this(new Leaf("default"));
    }

    public MultiSplitLayout(Node model) {
        this.model = model;
        this.dividerSize = UIManager.getInt("SplitPane.dividerSize");
        if (this.dividerSize == 0) {
            this.dividerSize = 7;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    private void firePCS(String propertyName, boolean oldValue, boolean newValue) {
        this.firePCS(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    private void firePCS(String propertyName, int oldValue, int newValue) {
        this.firePCS(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    private void firePCS(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Node getModel() {
        return this.model;
    }

    public void setModel(Node model) {
        if (model == null || model instanceof Divider) {
            throw new IllegalArgumentException("invalid model");
        }
        Node oldModel = model;
        this.model = model;
        this.firePCS("model", oldModel, model);
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int dividerSize) {
        if (dividerSize < 0) {
            throw new IllegalArgumentException("invalid dividerSize");
        }
        int oldDividerSize = this.dividerSize;
        this.dividerSize = dividerSize;
        this.firePCS("dividerSize", oldDividerSize, dividerSize);
    }

    public boolean getFloatingDividers() {
        return this.floatingDividers;
    }

    public void setFloatingDividers(boolean floatingDividers) {
        boolean oldFloatingDividers = this.floatingDividers;
        this.floatingDividers = floatingDividers;
        this.firePCS("floatingDividers", oldFloatingDividers, floatingDividers);
    }

    public void addLayoutComponent(String name, Component child) {
        if (name == null) {
            throw new IllegalArgumentException("name not specified");
        }
        this.childMap.put(name, child);
    }

    public void removeLayoutComponent(Component child) {
        String name = child.getName();
        if (name != null) {
            this.childMap.remove(name);
        }
    }

    private Component childForNode(Node node) {
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            String name = leaf.getName();
            return name != null ? this.childMap.get(name) : null;
        }
        return null;
    }

    private Dimension preferredComponentSize(Node node) {
        Component child = this.childForNode(node);
        return child != null ? child.getPreferredSize() : new Dimension(0, 0);
    }

    private Dimension minimumComponentSize(Node node) {
        Component child = this.childForNode(node);
        return child != null ? child.getMinimumSize() : new Dimension(0, 0);
    }

    private Dimension preferredNodeSize(Node root) {
        if (root instanceof Leaf) {
            return this.preferredComponentSize(root);
        }
        if (root instanceof Divider) {
            int dividerSize = this.getDividerSize();
            return new Dimension(dividerSize, dividerSize);
        }
        Split split = (Split)root;
        List splitChildren = split.getChildren();
        int width = 0;
        int height = 0;
        if (split.isRowLayout()) {
            for (Node splitChild : splitChildren) {
                Dimension size = this.preferredNodeSize(splitChild);
                width += size.width;
                height = Math.max(height, size.height);
            }
        } else {
            for (Node splitChild : splitChildren) {
                Dimension size = this.preferredNodeSize(splitChild);
                width = Math.max(width, size.width);
                height += size.height;
            }
        }
        return new Dimension(width, height);
    }

    private Dimension minimumNodeSize(Node root) {
        if (root instanceof Leaf) {
            Component child = this.childForNode(root);
            return child != null ? child.getMinimumSize() : new Dimension(0, 0);
        }
        if (root instanceof Divider) {
            int dividerSize = this.getDividerSize();
            return new Dimension(dividerSize, dividerSize);
        }
        Split split = (Split)root;
        List splitChildren = split.getChildren();
        int width = 0;
        int height = 0;
        if (split.isRowLayout()) {
            for (Node splitChild : splitChildren) {
                Dimension size = this.minimumNodeSize(splitChild);
                width += size.width;
                height = Math.max(height, size.height);
            }
        } else {
            for (Node splitChild : splitChildren) {
                Dimension size = this.minimumNodeSize(splitChild);
                width = Math.max(width, size.width);
                height += size.height;
            }
        }
        return new Dimension(width, height);
    }

    private Dimension sizeWithInsets(Container parent, Dimension size) {
        Insets insets = parent.getInsets();
        int width = size.width + insets.left + insets.right;
        int height = size.height + insets.top + insets.bottom;
        return new Dimension(width, height);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = this.preferredNodeSize(this.getModel());
        return this.sizeWithInsets(parent, size);
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension size = this.minimumNodeSize(this.getModel());
        return this.sizeWithInsets(parent, size);
    }

    private Rectangle boundsWithYandHeight(Rectangle bounds, double y, double height) {
        Rectangle r = new Rectangle();
        r.setBounds((int)bounds.getX(), (int)y, (int)bounds.getWidth(), (int)height);
        return r;
    }

    private Rectangle boundsWithXandWidth(Rectangle bounds, double x, double width) {
        Rectangle r = new Rectangle();
        r.setBounds((int)x, (int)bounds.getY(), (int)width, (int)bounds.getHeight());
        return r;
    }

    private void minimizeSplitBounds(Split split, Rectangle bounds) {
        Rectangle splitBounds = new Rectangle(bounds.x, bounds.y, 0, 0);
        List splitChildren = split.getChildren();
        Node lastChild = (Node)splitChildren.get(splitChildren.size() - 1);
        Rectangle lastChildBounds = lastChild.getBounds();
        if (split.isRowLayout()) {
            int lastChildMaxX = lastChildBounds.x + lastChildBounds.width;
            splitBounds.add(lastChildMaxX, bounds.y + bounds.height);
        } else {
            int lastChildMaxY = lastChildBounds.y + lastChildBounds.height;
            splitBounds.add(bounds.x + bounds.width, lastChildMaxY);
        }
        split.setBounds(splitBounds);
    }

    private void layoutShrink(Split split, Rectangle bounds) {
        Rectangle splitBounds = split.getBounds();
        ListIterator splitChildren = split.getChildren().listIterator();
        Node lastWeightedChild = split.lastWeightedChild();
        if (split.isRowLayout()) {
            boolean onlyShrinkWeightedComponents;
            double extraWidth;
            int totalWidth = 0;
            int minWeightedWidth = 0;
            int totalWeightedWidth = 0;
            for (Node splitChild : split.getChildren()) {
                int nodeWidth = splitChild.getBounds().width;
                int nodeMinWidth = Math.min(nodeWidth, this.minimumNodeSize((Node)splitChild).width);
                totalWidth += nodeWidth;
                if (!(splitChild.getWeight() > 0.0)) continue;
                minWeightedWidth += nodeMinWidth;
                totalWeightedWidth += nodeWidth;
            }
            double x = bounds.getX();
            double availableWidth = extraWidth = splitBounds.getWidth() - bounds.getWidth();
            boolean bl = onlyShrinkWeightedComponents = (double)(totalWeightedWidth - minWeightedWidth) > extraWidth;
            while (splitChildren.hasNext()) {
                Rectangle newSplitChildBounds;
                double splitChildWeight;
                Node splitChild = (Node)splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double minSplitChildWidth = this.minimumNodeSize(splitChild).getWidth();
                double d = splitChildWeight = onlyShrinkWeightedComponents ? splitChild.getWeight() : splitChildBounds.getWidth() / (double)totalWidth;
                if (!splitChildren.hasNext()) {
                    double newWidth = Math.max(minSplitChildWidth, bounds.getMaxX() - x);
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableWidth > 0.0 && splitChildWeight > 0.0) {
                    double allocatedWidth = Math.rint(splitChildWeight * extraWidth);
                    double oldWidth = splitChildBounds.getWidth();
                    double newWidth = Math.max(minSplitChildWidth, oldWidth - allocatedWidth);
                    Rectangle newSplitChildBounds2 = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds2);
                    availableWidth -= oldWidth - splitChild.getBounds().getWidth();
                } else {
                    double existingWidth = splitChildBounds.getWidth();
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, existingWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                x = splitChild.getBounds().getMaxX();
            }
        } else {
            boolean onlyShrinkWeightedComponents;
            double extraHeight;
            int totalHeight = 0;
            int minWeightedHeight = 0;
            int totalWeightedHeight = 0;
            for (Node splitChild : split.getChildren()) {
                int nodeHeight = splitChild.getBounds().height;
                int nodeMinHeight = Math.min(nodeHeight, this.minimumNodeSize((Node)splitChild).height);
                totalHeight += nodeHeight;
                if (!(splitChild.getWeight() > 0.0)) continue;
                minWeightedHeight += nodeMinHeight;
                totalWeightedHeight += nodeHeight;
            }
            double y = bounds.getY();
            double availableHeight = extraHeight = splitBounds.getHeight() - bounds.getHeight();
            boolean bl = onlyShrinkWeightedComponents = (double)(totalWeightedHeight - minWeightedHeight) > extraHeight;
            while (splitChildren.hasNext()) {
                double splitChildWeight;
                Node splitChild = (Node)splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double minSplitChildHeight = this.minimumNodeSize(splitChild).getHeight();
                double d = splitChildWeight = onlyShrinkWeightedComponents ? splitChild.getWeight() : splitChildBounds.getHeight() / (double)totalHeight;
                if (!splitChildren.hasNext()) {
                    double oldHeight = splitChildBounds.getHeight();
                    double newHeight = Math.max(minSplitChildHeight, bounds.getMaxY() - y);
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= oldHeight - splitChild.getBounds().getHeight();
                } else if (availableHeight > 0.0 && splitChildWeight > 0.0) {
                    double allocatedHeight = Math.rint(splitChildWeight * extraHeight);
                    double oldHeight = splitChildBounds.getHeight();
                    double newHeight = Math.max(minSplitChildHeight, oldHeight - allocatedHeight);
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= oldHeight - splitChild.getBounds().getHeight();
                } else {
                    double existingHeight = splitChildBounds.getHeight();
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, existingHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                y = splitChild.getBounds().getMaxY();
            }
        }
        this.minimizeSplitBounds(split, bounds);
    }

    private void layoutGrow(Split split, Rectangle bounds) {
        Rectangle splitBounds = split.getBounds();
        ListIterator splitChildren = split.getChildren().listIterator();
        Node lastWeightedChild = split.lastWeightedChild();
        if (split.isRowLayout()) {
            double extraWidth;
            double x = bounds.getX();
            double availableWidth = extraWidth = bounds.getWidth() - splitBounds.getWidth();
            while (splitChildren.hasNext()) {
                Rectangle newSplitChildBounds;
                Node splitChild = (Node)splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double splitChildWeight = splitChild.getWeight();
                if (!splitChildren.hasNext()) {
                    double newWidth = bounds.getMaxX() - x;
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableWidth > 0.0 && splitChildWeight > 0.0) {
                    double allocatedWidth = splitChild.equals(lastWeightedChild) ? availableWidth : Math.rint(splitChildWeight * extraWidth);
                    double newWidth = splitChildBounds.getWidth() + allocatedWidth;
                    Rectangle newSplitChildBounds2 = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds2);
                    availableWidth -= allocatedWidth;
                } else {
                    double existingWidth = splitChildBounds.getWidth();
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, existingWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                x = splitChild.getBounds().getMaxX();
            }
        } else {
            double extraHeight;
            double y = bounds.getY();
            double availableHeight = extraHeight = bounds.getMaxY() - splitBounds.getHeight();
            while (splitChildren.hasNext()) {
                Node splitChild = (Node)splitChildren.next();
                Rectangle splitChildBounds = splitChild.getBounds();
                double splitChildWeight = splitChild.getWeight();
                if (!splitChildren.hasNext()) {
                    double newHeight = bounds.getMaxY() - y;
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableHeight > 0.0 && splitChildWeight > 0.0) {
                    double allocatedHeight = splitChild.equals(lastWeightedChild) ? availableHeight : Math.rint(splitChildWeight * extraHeight);
                    double newHeight = splitChildBounds.getHeight() + allocatedHeight;
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= allocatedHeight;
                } else {
                    double existingHeight = splitChildBounds.getHeight();
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, existingHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                y = splitChild.getBounds().getMaxY();
            }
        }
    }

    private void layout2(Node root, Rectangle bounds) {
        if (root instanceof Leaf) {
            Component child = this.childForNode(root);
            if (child != null) {
                child.setBounds(bounds);
            }
            root.setBounds(bounds);
        } else if (root instanceof Divider) {
            root.setBounds(bounds);
        } else if (root instanceof Split) {
            boolean grow;
            Split split = (Split)root;
            boolean bl = split.isRowLayout() ? split.getBounds().width <= bounds.width : (grow = split.getBounds().height <= bounds.height);
            if (grow) {
                this.layoutGrow(split, bounds);
                root.setBounds(bounds);
            } else {
                this.layoutShrink(split, bounds);
            }
        }
    }

    private void layout1(Node root, Rectangle bounds) {
        if (root instanceof Leaf) {
            root.setBounds(bounds);
        } else if (root instanceof Split) {
            Split split = (Split)root;
            Iterator splitChildren = split.getChildren().iterator();
            Rectangle childBounds = null;
            int dividerSize = this.getDividerSize();
            if (split.isRowLayout()) {
                double x = bounds.getX();
                while (splitChildren.hasNext()) {
                    Node splitChild = (Node)splitChildren.next();
                    Divider dividerChild = splitChildren.hasNext() ? (Divider)splitChildren.next() : null;
                    double childWidth = 0.0;
                    childWidth = this.getFloatingDividers() ? this.preferredNodeSize(splitChild).getWidth() : (dividerChild != null ? dividerChild.getBounds().getX() - x : split.getBounds().getMaxX() - x);
                    childBounds = this.boundsWithXandWidth(bounds, x, childWidth);
                    this.layout1(splitChild, childBounds);
                    if (this.getFloatingDividers() && dividerChild != null) {
                        double dividerX = childBounds.getMaxX();
                        Rectangle dividerBounds = this.boundsWithXandWidth(bounds, dividerX, dividerSize);
                        dividerChild.setBounds(dividerBounds);
                    }
                    if (dividerChild == null) continue;
                    x = dividerChild.getBounds().getMaxX();
                }
            } else {
                double y = bounds.getY();
                while (splitChildren.hasNext()) {
                    Node splitChild = (Node)splitChildren.next();
                    Divider dividerChild = splitChildren.hasNext() ? (Divider)splitChildren.next() : null;
                    double childHeight = 0.0;
                    childHeight = this.getFloatingDividers() ? this.preferredNodeSize(splitChild).getHeight() : (dividerChild != null ? dividerChild.getBounds().getY() - y : split.getBounds().getMaxY() - y);
                    childBounds = this.boundsWithYandHeight(bounds, y, childHeight);
                    this.layout1(splitChild, childBounds);
                    if (this.getFloatingDividers() && dividerChild != null) {
                        double dividerY = childBounds.getMaxY();
                        Rectangle dividerBounds = this.boundsWithYandHeight(bounds, dividerY, dividerSize);
                        dividerChild.setBounds(dividerBounds);
                    }
                    if (dividerChild == null) continue;
                    y = dividerChild.getBounds().getMaxY();
                }
            }
            this.minimizeSplitBounds(split, bounds);
        }
    }

    private void throwInvalidLayout(String msg, Node node) {
        throw new InvalidLayoutException(msg, node);
    }

    private void checkLayout(Node root) {
        if (root instanceof Split) {
            Split split = (Split)root;
            if (split.getChildren().size() <= 2) {
                this.throwInvalidLayout("Split must have > 2 children", root);
            }
            Iterator splitChildren = split.getChildren().iterator();
            double weight = 0.0;
            while (splitChildren.hasNext()) {
                Node dividerChild;
                Node splitChild = (Node)splitChildren.next();
                if (splitChild instanceof Divider) {
                    this.throwInvalidLayout("expected a Split or Leaf Node", splitChild);
                }
                if (splitChildren.hasNext() && !((dividerChild = (Node)splitChildren.next()) instanceof Divider)) {
                    this.throwInvalidLayout("expected a Divider Node", dividerChild);
                }
                weight += splitChild.getWeight();
                this.checkLayout(splitChild);
            }
            if (weight > 1.0) {
                this.throwInvalidLayout("Split children's total weight > 1.0", root);
            }
        }
    }

    public void layoutContainer(Container parent) {
        this.checkLayout(this.getModel());
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int width = size.width - (insets.left + insets.right);
        int height = size.height - (insets.top + insets.bottom);
        Rectangle bounds = new Rectangle(insets.left, insets.top, width, height);
        this.layout1(this.getModel(), bounds);
        this.layout2(this.getModel(), bounds);
    }

    private Divider dividerAt(Node root, int x, int y) {
        if (root instanceof Divider) {
            Divider divider = (Divider)root;
            return divider.getBounds().contains(x, y) ? divider : null;
        }
        if (root instanceof Split) {
            Split split = (Split)root;
            for (Node child : split.getChildren()) {
                if (!child.getBounds().contains(x, y)) continue;
                return this.dividerAt(child, x, y);
            }
        }
        return null;
    }

    public Divider dividerAt(int x, int y) {
        return this.dividerAt(this.getModel(), x, y);
    }

    private boolean nodeOverlapsRectangle(Node node, Rectangle r2) {
        Rectangle r1 = node.getBounds();
        return r1.x <= r2.x + r2.width && r1.x + r1.width >= r2.x && r1.y <= r2.y + r2.height && r1.y + r1.height >= r2.y;
    }

    private List dividersThatOverlap(Node root, Rectangle r) {
        if (this.nodeOverlapsRectangle(root, r) && root instanceof Split) {
            ArrayList<Divider> dividers = new ArrayList<Divider>();
            for (Node child : ((Split)root).getChildren()) {
                if (child instanceof Divider) {
                    if (!this.nodeOverlapsRectangle(child, r)) continue;
                    dividers.add((Divider)child);
                    continue;
                }
                if (!(child instanceof Split)) continue;
                dividers.addAll(this.dividersThatOverlap(child, r));
            }
            return dividers;
        }
        return Collections.EMPTY_LIST;
    }

    public List dividersThatOverlap(Rectangle r) {
        if (r == null) {
            throw new IllegalArgumentException("null Rectangle");
        }
        return this.dividersThatOverlap(this.getModel(), r);
    }

    private static void throwParseException(StreamTokenizer st, String msg) throws Exception {
        throw new Exception("MultiSplitLayout.parseModel Error: " + msg);
    }

    private static void parseAttribute(String name, StreamTokenizer st, Node node) throws Exception {
        if (st.nextToken() != 61) {
            MultiSplitLayout.throwParseException(st, "expected '=' after " + name);
        }
        if (name.equalsIgnoreCase("WEIGHT")) {
            if (st.nextToken() == -2) {
                node.setWeight(st.nval);
            } else {
                MultiSplitLayout.throwParseException(st, "invalid weight");
            }
        } else if (name.equalsIgnoreCase("NAME")) {
            if (st.nextToken() == -3) {
                if (node instanceof Leaf) {
                    ((Leaf)node).setName(st.sval);
                } else {
                    MultiSplitLayout.throwParseException(st, "can't specify name for " + node);
                }
            } else {
                MultiSplitLayout.throwParseException(st, "invalid name");
            }
        } else {
            MultiSplitLayout.throwParseException(st, "unrecognized attribute \"" + name + "\"");
        }
    }

    private static void addSplitChild(Split parent, Node child) {
        ArrayList<Node> children = new ArrayList<Node>(parent.getChildren());
        if (children.size() == 0) {
            children.add(child);
        } else {
            children.add(new Divider());
            children.add(child);
        }
        parent.setChildren(children);
    }

    private static void parseLeaf(StreamTokenizer st, Split parent) throws Exception {
        int token;
        Leaf leaf = new Leaf();
        while ((token = st.nextToken()) != -1 && token != 41) {
            if (token == -3) {
                MultiSplitLayout.parseAttribute(st.sval, st, leaf);
                continue;
            }
            MultiSplitLayout.throwParseException(st, "Bad Leaf: " + leaf);
        }
        MultiSplitLayout.addSplitChild(parent, leaf);
    }

    private static void parseSplit(StreamTokenizer st, Split parent) throws Exception {
        int token;
        while ((token = st.nextToken()) != -1 && token != 41) {
            String nodeType;
            if (token == -3) {
                if (st.sval.equalsIgnoreCase("WEIGHT")) {
                    MultiSplitLayout.parseAttribute(st.sval, st, parent);
                    continue;
                }
                MultiSplitLayout.addSplitChild(parent, new Leaf(st.sval));
                continue;
            }
            if (token != 40) continue;
            token = st.nextToken();
            if (token != -3) {
                MultiSplitLayout.throwParseException(st, "invalid node type");
            }
            if ((nodeType = st.sval.toUpperCase()).equals("LEAF")) {
                MultiSplitLayout.parseLeaf(st, parent);
                continue;
            }
            if (nodeType.equals("ROW") || nodeType.equals("COLUMN")) {
                Split split = new Split();
                split.setRowLayout(nodeType.equals("ROW"));
                MultiSplitLayout.addSplitChild(parent, split);
                MultiSplitLayout.parseSplit(st, split);
                continue;
            }
            MultiSplitLayout.throwParseException(st, "unrecognized node type '" + nodeType + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Node parseModel(Reader r) {
        StreamTokenizer st = new StreamTokenizer(r);
        Split root = new Split();
        MultiSplitLayout.parseSplit(st, root);
        Node node = (Node)root.getChildren().get(0);
        Object var5_5 = null;
        try {
            r.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return node;
        catch (Exception e) {
            try {
                System.err.println(e);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    r.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                r.close();
            }
            catch (IOException ignore) {}
        }
        return null;
    }

    public static Node parseModel(String s) {
        return MultiSplitLayout.parseModel(new StringReader(s));
    }

    private static void printModel(String indent, Node root) {
        if (root instanceof Split) {
            Split split = (Split)root;
            System.out.println(indent + split);
            for (Node child : split.getChildren()) {
                MultiSplitLayout.printModel(indent + "  ", child);
            }
        } else {
            System.out.println(indent + root);
        }
    }

    public static void printModel(Node root) {
        MultiSplitLayout.printModel("", root);
    }

    public static class Divider
    extends Node {
        public final boolean isVertical() {
            Split parent = this.getParent();
            return parent != null ? parent.isRowLayout() : false;
        }

        public void setWeight(double weight) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "MultiSplitLayout.Divider " + this.getBounds().toString();
        }
    }

    public static class Leaf
    extends Node {
        private String name = "";

        public Leaf() {
        }

        public Leaf(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultiSplitLayout.Leaf");
            sb.append(" \"");
            sb.append(this.getName());
            sb.append("\"");
            sb.append(" weight=");
            sb.append(this.getWeight());
            sb.append(" ");
            sb.append(this.getBounds());
            return sb.toString();
        }
    }

    public static class Split
    extends Node {
        private List children = Collections.EMPTY_LIST;
        private boolean rowLayout = true;

        public boolean isRowLayout() {
            return this.rowLayout;
        }

        public void setRowLayout(boolean rowLayout) {
            this.rowLayout = rowLayout;
        }

        public List getChildren() {
            return new ArrayList(this.children);
        }

        public void setChildren(List children) {
            if (children == null) {
                throw new IllegalArgumentException("children must be a non-null List");
            }
            for (Node child : this.children) {
                child.setParent(null);
            }
            this.children = new ArrayList(children);
            for (Node child : this.children) {
                child.setParent(this);
            }
        }

        public void setChildren(Node[] children) {
            this.setChildren(children == null ? null : Arrays.asList(children));
        }

        public final Node lastWeightedChild() {
            List children = this.getChildren();
            Node weightedChild = null;
            for (Node child : children) {
                if (!(child.getWeight() > 0.0)) continue;
                weightedChild = child;
            }
            return weightedChild;
        }

        public String toString() {
            int nChildren = this.getChildren().size();
            StringBuilder sb = new StringBuilder("MultiSplitLayout.Split");
            sb.append(this.isRowLayout() ? " ROW [" : " COLUMN [");
            sb.append(nChildren).append(nChildren == 1 ? " child" : " children");
            sb.append("] ");
            sb.append(this.getBounds());
            return sb.toString();
        }
    }

    public static abstract class Node {
        private Split parent = null;
        private Rectangle bounds = new Rectangle();
        private double weight = 0.0;

        public Split getParent() {
            return this.parent;
        }

        public void setParent(Split parent) {
            this.parent = parent;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.bounds);
        }

        public void setBounds(Rectangle bounds) {
            if (bounds == null) {
                throw new IllegalArgumentException("null bounds");
            }
            this.bounds = new Rectangle(bounds);
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double weight) {
            if (weight < 0.0 || weight > 1.0) {
                throw new IllegalArgumentException("invalid weight");
            }
            this.weight = weight;
        }

        private Node siblingAtOffset(int offset) {
            Split parent = this.getParent();
            if (parent == null) {
                return null;
            }
            List siblings = parent.getChildren();
            int index = siblings.indexOf(this);
            if (index == -1) {
                return null;
            }
            return (index += offset) > -1 && index < siblings.size() ? siblings.get(index) : null;
        }

        public Node nextSibling() {
            return this.siblingAtOffset(1);
        }

        public Node previousSibling() {
            return this.siblingAtOffset(-1);
        }
    }

    public static class InvalidLayoutException
    extends RuntimeException {
        private final Node node;

        public InvalidLayoutException(String msg, Node node) {
            super(msg);
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

