/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import bsh.Interpreter;
import bsh.NameSpace;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filterManager.FilterManagerFriend;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JGlassButton;
import se.datadosen.component.JHeadingPanel;
import se.datadosen.component.JLineSplitPane;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.slider.RangeSlider;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JCommentPanel;
import se.datadosen.explorer.JFiltersPanel;
import se.datadosen.explorer.JPropertyPanel;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.EditListener2;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.EvaluationException;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.VideoProcessor;
import se.datadosen.jalbum.event.ImageListener;
import se.datadosen.tags.Element;
import se.datadosen.tags.Elements;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.PrintSafeHashMap;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.annotations.ToolTipText;

public class JEditPanel
extends JPanel
implements EditPanel,
FilterManagerFriend {
    public static final String NAME = "editPanel";
    private static final int CROSS_PADDING = 20;
    private final JAlbumExplorer context;
    final KeyStroke pgUp = KeyStroke.getKeyStroke(33, 0);
    final KeyStroke pgDown = KeyStroke.getKeyStroke(34, 0);
    final KeyStroke up = KeyStroke.getKeyStroke(38, 0);
    final KeyStroke down = KeyStroke.getKeyStroke(40, 0);
    final KeyStroke left = KeyStroke.getKeyStroke(37, 0);
    final KeyStroke right = KeyStroke.getKeyStroke(39, 0);
    final KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
    AlbumObject ao;
    ControlPanel metaPanel = new ControlPanel();
    JPanel centerPanel = new JPanel();
    JBackgroundPanel imagePanel;
    JComponent customUI;
    JPanel glassPanel = new JPanel(new BorderLayout());
    JProgressSpinner progressSpinner = new JProgressSpinner(36);
    JScrollPane imageScrollPane = new JMyScrollPane();
    JSplitPane vSplitPane = new JSplitPane(0);
    private final CardLayout filterPanelViewMode = new CardLayout();
    JPanel filterPanel = new JPanel(this.filterPanelViewMode);
    JFiltersPanel filtersPanel = new JFiltersPanel(this);
    FilterManager filterManager = new FilterManager(this);
    JAlbumImageFilter currentFilter;
    JHeadingPanel filterUIHeadingPanel;
    JPanel filterUIContainer = new JPanel(new BorderLayout());
    JPanel filterUI;
    JScrollPane filterScrollPane = new JScrollPane(20, 31);
    JPanel filterManagerControls;
    JCommentPanel commentPanel = new JCommentPanel(this);
    JPropertyPanel propertyPanel = new JPropertyPanel(this);
    JSplitPane hSplitPane = new JSplitPane(1);
    JSlider zoomSlider = new JSlider(0, 0, 100, 0);
    private List<ImageListener> imageListeners = new ArrayList<ImageListener>();
    @ToolTipText(value="edit.previousImageToolTip")
    public Action previousImageAction = new AbstractAction(){
        {
            this.putValue("AcceleratorKey", JEditPanel.this.pgUp);
            this.putValue("SmallIcon", Icons.getIcon("big.previous"));
        }

        public void actionPerformed(ActionEvent evt) {
            JEditPanel.this.commentPanel.save();
            JEditPanel.this.propertyPanel.save();
            JAlbumObject dest = JEditPanel.this.getPreviousComponent();
            if (dest != null) {
                JEditPanel.this.moveTo(dest.ao);
                JAlbumObject previous = JEditPanel.this.getPreviousComponent(dest.ao);
                ((JEditPanel)JEditPanel.this).context.imageCache.preload(previous != null ? previous.ao : null);
            }
        }
    };
    @ToolTipText(value="edit.nextImageToolTip")
    public Action nextImageAction = new AbstractAction(){
        {
            this.putValue("AcceleratorKey", JEditPanel.this.pgDown);
            this.putValue("SmallIcon", Icons.getIcon("big.next"));
        }

        public void actionPerformed(ActionEvent evt) {
            JEditPanel.this.commentPanel.save();
            JEditPanel.this.propertyPanel.save();
            JAlbumObject dest = JEditPanel.this.getNextComponent();
            if (dest != null) {
                JEditPanel.this.moveTo(dest.ao);
                JAlbumObject next = JEditPanel.this.getNextComponent(dest.ao);
                ((JEditPanel)JEditPanel.this).context.imageCache.preload(next != null ? next.ao : null);
            }
        }
    };
    @ToolTipText(value="edit.leaveTooltip")
    Action cancelAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.getIcon("big.return"));
        }

        public void actionPerformed(ActionEvent evt) {
            JEditPanel.this.context.setExplorerView();
            TipOfTheDay.showInBackground(Msg.get("tip.updateChanges", Msg.get("ui.makeAlbum")));
        }
    };
    JGlassButton previousButton = new JGlassButton(this.previousImageAction);
    JGlassButton nextButton = new JGlassButton(this.nextImageAction);
    JGlassButton returnButton = new JGlassButton(this.cancelAction);
    @ToolTipText(value="edit.chooseThumbnailToolTip")
    JSlider timeSlider = new JSlider();
    @ToolTipText(value="edit.trimVideoToolTip")
    RangeSlider clipSlider = new RangeSlider();
    FileFilters.BasicImageInfo imageInfo;
    private int moveCounter = 1;
    private ScheduledExecutorService delayedService = Executors.newScheduledThreadPool(1);
    private ScheduledFuture videoBrowser;
    private ChangeListener timeSliderChangeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            AlbumObjectProperties props = JEditPanel.this.ao.getProperties();
            TimeCode videoPos = TimeCode.fromMillis(JEditPanel.this.timeSlider.getValue());
            props.put("videoPosition", videoPos);
            props.save(false);
            if (JEditPanel.this.videoBrowser != null) {
                JEditPanel.this.videoBrowser.cancel(false);
            }
            JEditPanel.this.videoBrowser = JEditPanel.this.delayedService.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ((JEditPanel)JEditPanel.this).context.parent.progressSpinner.workStarted();
                        AlbumObject currentAO = JEditPanel.this.ao;
                        File repFile = currentAO.getRepresentingImageFile();
                        repFile.delete();
                        currentAO.getRepresentingImageFile();
                        currentAO.updateRepresentingIcon();
                        if (JEditPanel.this.videoBrowser.isCancelled()) {
                            Object var5_3 = null;
                            ((JEditPanel)JEditPanel.this).context.parent.progressSpinner.workDone();
                            return;
                        }
                        ((JEditPanel)JEditPanel.this).context.imageCache.clear();
                        try {
                            JEditPanel.this.updateImage(false);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        ((JEditPanel)JEditPanel.this).context.parent.progressSpinner.workDone();
                        throw throwable;
                    }
                    Object var5_4 = null;
                    ((JEditPanel)JEditPanel.this).context.parent.progressSpinner.workDone();
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
    };
    private ChangeListener clipSliderChangeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            try {
                if (JEditPanel.this.clipSlider.isLowerDragging() || JEditPanel.this.clipSlider.isUpperDragging()) {
                    if (JEditPanel.this.videoBrowser != null) {
                        JEditPanel.this.videoBrowser.cancel(false);
                    }
                    JEditPanel.this.videoBrowser = JEditPanel.this.delayedService.schedule(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            try {
                                try {
                                    int value;
                                    ((JEditPanel)JEditPanel.this).context.parent.progressSpinner.workStarted();
                                    AlbumObjectProperties props = JEditPanel.this.ao.getProperties();
                                    int n = value = JEditPanel.this.clipSlider.isUpperDragging() ? JEditPanel.this.clipSlider.getUpperValue() : JEditPanel.this.clipSlider.getValue();
                                    if (value >= JEditPanel.this.clipSlider.getMaximum()) {
                                        value -= 10;
                                    }
                                    TimeCode currentPos = TimeCode.fromMillis(value);
                                    VideoProcessor vp = ((JEditPanel)JEditPanel.this).context.parent.engine.getVideoProcessor();
                                    File tmp = File.createTempFile("clip", ".jpg");
                                    vp.createThumbnailFile(JEditPanel.this.ao.getFile(), tmp, currentPos);
                                    BufferedImage bi = FileFilters.loadImage(tmp);
                                    bi = RotationSupport.adjustOrientation(bi, JEditPanel.this.ao.getOrientation());
                                    tmp.delete();
                                    Image closeup = JEditPanel.this.scaleToFit(bi, JEditPanel.this.imagePanel.getDisplayableImageSize());
                                    if (JEditPanel.this.videoBrowser.isCancelled()) {
                                        Object var9_9 = null;
                                        ((JEditPanel)JEditPanel.this).context.parent.progressSpinner.workDone();
                                        return;
                                    }
                                    JEditPanel.this.imagePanel.setBackgroundImage(closeup);
                                    props.put("videoClipStart", TimeCode.fromMillis(JEditPanel.this.clipSlider.getValue()));
                                    props.put("videoClipLength", TimeCode.fromMillis(JEditPanel.this.clipSlider.getUpperValue() - JEditPanel.this.clipSlider.getValue()));
                                    props.save(false);
                                    JEditPanel.this.ao.getFile().setLastModified(new Date().getTime());
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace(System.err);
                                    Object var9_11 = null;
                                    ((JEditPanel)JEditPanel.this).context.parent.progressSpinner.workDone();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_12 = null;
                                ((JEditPanel)JEditPanel.this).context.parent.progressSpinner.workDone();
                                throw throwable;
                            }
                            Object var9_10 = null;
                            ((JEditPanel)JEditPanel.this).context.parent.progressSpinner.workDone();
                        }
                    }, 200L, TimeUnit.MILLISECONDS);
                } else {
                    JEditPanel.this.updateImage(true);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JEditPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };
    BufferedImage bufferedImage;
    MouseConverter mouseConverter = new MouseConverter();
    private transient Vector<EditListener> editListeners;

    public JEditPanel(JAlbumExplorer context) {
        this.context = context;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAO(AlbumObject ao) {
        if (this.videoBrowser != null && !this.videoBrowser.isDone()) {
            this.videoBrowser.cancel(true);
        }
        this.ao = ao;
        this.commentPanel.setAlbumObject(ao);
        this.propertyPanel.setAlbumObject(ao);
        if (this.customUI != null && this.customUI instanceof EditListener) {
            ((EditListener)((Object)this.customUI)).setAlbumObject(null);
        }
        try {
            block8: {
                try {
                    this.context.parent.waitCursor.workStarted();
                    this.fireEditingAlbumObject(ao);
                    if (ao != null) {
                        if (ao.hasDisplayableImage()) {
                            this.imageInfo = FileFilters.getBasicImageInfo(ao.getRepresentingImageFile());
                        }
                        this.refreshUI();
                        break block8;
                    }
                    this.imagePanel.setBackgroundImage(null);
                }
                catch (IOException iOException) {
                    Object var4_3 = null;
                    this.context.parent.waitCursor.workDone();
                }
            }
            Object var4_2 = null;
            this.context.parent.waitCursor.workDone();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.context.parent.waitCursor.workDone();
            throw throwable;
        }
    }

    public void saveState() {
        if (this.customUI instanceof EditListener2) {
            ((EditListener2)((Object)this.customUI)).saveState();
        }
        this.fireSaveState();
    }

    public AlbumObject getAO() {
        return this.ao;
    }

    void moveTo(AlbumObject dest) {
        if (dest == null) {
            return;
        }
        if (this.moveCounter++ == 3) {
            TipOfTheDay.showInBackground(Msg.get("tip.editModeMoveBetweenImages"));
        }
        this.setAO(dest);
    }

    void setFiltersViewMode() {
        this.filterPanelViewMode.show(this.filterPanel, "filtersPanel");
    }

    private JAlbumObject getPreviousComponent(AlbumObject ao) {
        return this.context.explorer.getPreviousComponent(this.context.getJAlbumObject(ao));
    }

    private JAlbumObject getPreviousComponent() {
        return this.getPreviousComponent(this.ao);
    }

    private JAlbumObject getNextComponent(AlbumObject ao) {
        return this.context.explorer.getNextComponent(this.context.getJAlbumObject(ao));
    }

    private JAlbumObject getNextComponent() {
        return this.getNextComponent(this.ao);
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.text);
        this.setFocusable(true);
        this.filtersPanel.setFocusable(false);
        this.filtersPanel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                TipOfTheDay.showInBackground(Msg.get("tip.originalsPreserved"));
            }
        });
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.setBackground(SystemColor.text);
        this.setToolTipText(Msg.get("edit.tipLabel"));
        this.setPreferredSize(new Dimension(760, 600));
        this.filterPanel.add((Component)this.filtersPanel, "filtersPanel");
        this.filterPanel.add((Component)this.filterUIContainer, "filterUI");
        this.filterScrollPane.setBorder(null);
        this.filterScrollPane.setOpaque(false);
        this.filterScrollPane.getViewport().setOpaque(false);
        Color borderColor = new Color(165, 165, 165);
        this.vSplitPane.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, borderColor));
        this.vSplitPane.setTopComponent(this.filterPanel);
        this.vSplitPane.setResizeWeight(0.9f);
        this.vSplitPane.setBottomComponent(this.propertyPanel);
        this.vSplitPane.validate();
        this.previousButton.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.previousButton.setBorderRadius(8);
        this.previousButton.setBorderOpacity(0.35f);
        this.nextButton.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.nextButton.setBorderRadius(8);
        this.nextButton.setBorderOpacity(0.35f);
        this.returnButton.setBorder(BorderFactory.createEmptyBorder(14, 16, 14, 12));
        this.returnButton.setBorderRadius(8);
        this.returnButton.setBorderOpacity(0.35f);
        this.returnButton.setDiscrete(true);
        this.previousButton.setDiscrete(true);
        this.nextButton.setDiscrete(true);
        this.timeSlider.setVisible(false);
        this.timeSlider.setOpaque(false);
        this.timeSlider.setPaintLabels(true);
        this.timeSlider.setSnapToTicks(false);
        this.clipSlider.setVisible(false);
        this.clipSlider.setOpaque(false);
        this.clipSlider.setPaintLabels(true);
        this.clipSlider.setSnapToTicks(false);
        this.clipSlider.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JEditPanel.this.clipSliderChangeListener.stateChanged(null);
            }
        });
        this.registerKeyboardAction(this.cancelAction, "cancel-dialog", this.escape, 2);
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", this.pgUp, 1);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", this.pgDown, 1);
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", this.up, 1);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", this.down, 1);
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", this.left, 1);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", this.right, 1);
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke('0'), "unrated");
        im.put(KeyStroke.getKeyStroke('1'), "1rated");
        im.put(KeyStroke.getKeyStroke('2'), "2rated");
        im.put(KeyStroke.getKeyStroke('3'), "3rated");
        im.put(KeyStroke.getKeyStroke('4'), "4rated");
        im.put(KeyStroke.getKeyStroke('5'), "5rated");
        ActionMap am = this.getActionMap();
        am.put("unrated", new RatingAction(0));
        am.put("1rated", new RatingAction(1));
        am.put("2rated", new RatingAction(2));
        am.put("3rated", new RatingAction(3));
        am.put("4rated", new RatingAction(4));
        am.put("5rated", new RatingAction(5));
        this.hSplitPane.setBorder(null);
        this.hSplitPane.setBackground(SystemColor.text);
        this.imagePanel = new JBackgroundPanel();
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.setBackground(SystemColor.text);
        this.centerPanel.setOpaque(true);
        this.imagePanel.setImageBorder(this.createImageBorder());
        MouseAdapter ml = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                JEditPanel.this.returnButton.setVisible(true);
                JEditPanel.this.previousButton.setVisible(true);
                JEditPanel.this.nextButton.setVisible(true);
            }

            public void mouseExited(MouseEvent e) {
                if (!JEditPanel.this.glassPanel.getBounds().contains(e.getPoint())) {
                    JEditPanel.this.returnButton.setVisible(false);
                    JEditPanel.this.previousButton.setVisible(false);
                    JEditPanel.this.nextButton.setVisible(false);
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getSource() instanceof JComponent) {
                    ((JComponent)e.getSource()).requestFocusInWindow();
                }
                JEditPanel.this.requestFocusInWindow();
            }
        };
        this.addMouseListener(ml);
        this.centerPanel.addMouseListener(ml);
        this.imagePanel.addMouseListener(ml);
        this.imageScrollPane.setViewportView(this.imagePanel);
        this.imageScrollPane.getViewport().setScrollMode(2);
        this.imageScrollPane.setBorder(null);
        JPanel overlayPanel = new JPanel();
        overlayPanel.setOpaque(false);
        this.imageScrollPane.getViewport().setOpaque(false);
        overlayPanel.setLayout(new OverlayLayout(overlayPanel));
        this.glassPanel.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.glassPanel.setOpaque(false);
        Box top = Box.createVerticalBox();
        Box north = Box.createHorizontalBox();
        north.add(this.previousButton);
        north.add(Box.createHorizontalStrut(8));
        north.add(this.returnButton);
        north.add(Box.createHorizontalStrut(8));
        north.add(this.nextButton);
        north.setAlignmentX(0.5f);
        top.add(north);
        this.glassPanel.add((Component)top, "North");
        Box sliderBox = Box.createVerticalBox();
        sliderBox.add(this.clipSlider);
        sliderBox.add(this.timeSlider);
        this.glassPanel.add((Component)sliderBox, "South");
        overlayPanel.add(this.glassPanel);
        overlayPanel.add(this.imageScrollPane);
        this.imageScrollPane.getViewport().setOpaque(false);
        JLineSplitPane split = new JLineSplitPane(0);
        split.setTopComponent(overlayPanel);
        split.setBottomComponent(this.commentPanel);
        split.setResizeWeight(1.0);
        split.setBorder(null);
        this.centerPanel.add((Component)split, "Center");
        this.hSplitPane.setLeftComponent(this.centerPanel);
        this.hSplitPane.setRightComponent(this.vSplitPane);
        this.hSplitPane.setDividerSize(3);
        this.hSplitPane.setResizeWeight(1.0);
        this.add((Component)this.hSplitPane, "Center");
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().downFocusCycle(JEditPanel.this);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Msg.maintainTranslated(this);
    }

    private Border createImageBorder() {
        return BorderFactory.createLineBorder(new Color(96, 96, 96));
    }

    private void refreshUI() throws IOException {
        AlbumObject ao = this.ao;
        this.context.updateRotateActions(this.ao);
        this.updateImage(true);
        this.enableImageBrowseActions();
        this.filtersPanel.setEnabled(ao != null && !ao.isFolder() && ao.hasDisplayableImage());
        if (ao != null) {
            this.context.parent.statusBar.setText(Msg.get("ui.editModeStatusText", ao.getFile().getName()));
        }
        this.context.parent.setTitle();
        this.timeSlider.setVisible(false);
        this.timeSlider.removeChangeListener(this.timeSliderChangeListener);
        this.clipSlider.setVisible(false);
        this.clipSlider.removeChangeListener(this.clipSliderChangeListener);
        AlbumObjectProperties props = ao.getProperties();
        if (props.get("videoDuration") != null) {
            TimeCode videoDuration = (TimeCode)props.get("videoDuration");
            TimeCode videoPosition = (TimeCode)props.get("videoPosition");
            if (videoPosition == null) {
                videoPosition = new TimeCode(0);
            }
            if (ao.getCategory() == Category.video && !IO.thumbFile(ao.getFile()).exists()) {
                if (props.get("videoDuration") != null) {
                    File repFile = ao.getRepresentingImageFile();
                    repFile.delete();
                    ao.getRepresentingImageFile();
                }
                this.timeSlider.setMinimum(0);
                this.timeSlider.setMaximum((int)videoDuration.asMillis() - 10);
                this.timeSlider.setMinorTickSpacing(1000);
                this.timeSlider.setPaintTicks(true);
                this.timeSlider.setValue((int)videoPosition.asMillis());
                Hashtable<Integer, JGlassLabel> table = new Hashtable<Integer, JGlassLabel>();
                ((Dictionary)table).put(0, new JGlassLabel(new TimeCode(0).toString() + "s"));
                ((Dictionary)table).put((int)videoDuration.asMillis(), new JGlassLabel(videoDuration.toString() + "s"));
                this.timeSlider.setLabelTable(table);
                this.timeSlider.setVisible(true);
                this.timeSlider.addChangeListener(this.timeSliderChangeListener);
            }
            if (ao.getCategory() == Category.video) {
                this.clipSlider.setMinimum(0);
                this.clipSlider.setMaximum((int)videoDuration.asMillis());
                this.clipSlider.setMinorTickSpacing(1000);
                this.clipSlider.setPaintTicks(true);
                TimeCode clipStart = props.get("videoClipStart", new TimeCode(0));
                TimeCode clipLength = props.get("videoClipLength", videoDuration);
                this.clipSlider.setValue(0);
                int cs = (int)clipStart.asMillis();
                this.clipSlider.setUpperValue(cs + (int)clipLength.asMillis());
                this.clipSlider.setValue(cs);
                Hashtable<Integer, JGlassLabel> table = new Hashtable<Integer, JGlassLabel>();
                ((Dictionary)table).put(0, new JGlassLabel(new TimeCode(0).toString() + "s"));
                ((Dictionary)table).put((int)videoDuration.asMillis(), new JGlassLabel(videoDuration.toString() + "s"));
                this.clipSlider.setLabelTable(table);
                this.clipSlider.setVisible(true);
                this.clipSlider.addChangeListener(this.clipSliderChangeListener);
            }
        }
    }

    void updateImage(boolean loadStack) throws IOException {
        block16: {
            this.imagePanel.setBackgroundImage(null);
            if (this.customUI != null) {
                this.imagePanel.removeAll();
                this.imagePanel.validate();
                this.customUI = null;
            }
            if (this.ao == null) {
                return;
            }
            if (this.ao.hasDisplayableImage()) {
                if (loadStack) {
                    AlbumObjectProperties props = this.ao.getProperties();
                    Object stack = props.get("filterList");
                    if (stack != null) {
                        this.filterManager.setFilterList((FilterList)stack);
                    } else {
                        this.filterManager.setFilterList(null);
                    }
                }
                Image closeup = this.context.imageCache.getImage(this.ao);
                this.filterManager.setImage((BufferedImage)closeup, this.filterManager.getFilterList());
                closeup = this.scaleToFit(closeup, this.imagePanel.getDisplayableImageSize());
                if (this.filterManager.hasFiltersInList()) {
                    closeup = this.filterManager.renderImage((BufferedImage)closeup, true);
                }
                this.imagePanel.setBackgroundImage(closeup);
            } else if (this.ao.getCategory() == Category.webPage) {
                String doc = IO.readTextFile(this.ao.getFile());
                try {
                    Element elem = Elements.getElementByName("ja:ui", doc, false);
                    if (elem == null || !"ja:ui".equals(elem.getName())) break block16;
                    Interpreter interpreter = new Interpreter();
                    NameSpace ns = interpreter.getNameSpace();
                    ns.importPackage("se.datadosen.jalbum");
                    ns.importPackage("se.datadosen.util");
                    ns.importPackage("se.datadosen.component");
                    PrintSafeHashMap vars = new PrintSafeHashMap();
                    JAlbumFrame ui = this.context.parent;
                    ui.engine.init();
                    ui.engine.addGlobals(vars);
                    vars.put("rootFolder", ui.albumExplorer.getRootFolder());
                    vars.put("currentFolder", ui.albumExplorer.getCurrentFolder());
                    Map userVariables = ui.engine.getUserVariables();
                    if (userVariables != null) {
                        vars.putAll(userVariables);
                    }
                    AlbumBean cfr_ignored_0 = ui.engine;
                    AlbumBean.setVars(vars, interpreter);
                    Object ret = interpreter.eval(elem.getContent());
                    if (ret instanceof Class) {
                        this.customUI = (JComponent)((Class)ret).newInstance();
                        this.imagePanel.setBorder(BorderFactory.createEmptyBorder(80, 10, 8, 8));
                        this.imagePanel.add((Component)this.customUI, "Center");
                        this.imagePanel.validate();
                        this.imagePanel.repaint();
                        if (this.customUI instanceof JAlbumPlugin) {
                            ((JAlbumPlugin)((Object)this.customUI)).init(this.context.parent.context.getPluginContext());
                        }
                        if (this.customUI instanceof EditListener) {
                            ((EditListener)((Object)this.customUI)).setAlbumObject(this.ao);
                        }
                        break block16;
                    }
                    throw new EvaluationException("Content of ja:ui element not evaluating to a class declaration");
                }
                catch (Exception ex) {
                    Debug.showCopyableError(this.context, ex, "Custum UI scripting error");
                }
            } else {
                Image closeup = this.ao.getRepresentingIcon(this.imagePanel.getDisplayableImageSize(), false).getImage();
                this.imagePanel.setBackgroundImage(closeup);
            }
        }
        this.fireImageUpdated();
    }

    void saveFilters() {
        AlbumObjectProperties props = this.ao.getProperties();
        props.putHidden("filterList", this.filterManager.getFilterList());
        props.save(false);
        this.ao.updateRepresentingIcon();
        BufferedImage thumbnail = this.filterManager.renderImage(this.bufferedImage, true);
    }

    private Image scaleToFit(Image image, Dimension boundingBox) {
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        if (newWidth < width && newHeight < height) {
            return ImageCache.scale(image, newWidth, newHeight);
        }
        return image;
    }

    public synchronized void addImageListener(ImageListener listener) {
        this.imageListeners.add(listener);
    }

    public synchronized void removeImageListener(ImageListener listener) {
        this.imageListeners.remove(listener);
    }

    public synchronized void fireImageUpdated() {
        if (this.imagePanel.getBackgroundImage() instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)this.imagePanel.getBackgroundImage();
            for (ImageListener listener : this.imageListeners) {
                listener.imageUpdated(bi);
            }
        }
    }

    void useFilter(JAlbumImageFilter filter) {
        this.currentFilter = filter;
        this.setImageInFilter();
        this.filterManager.addFilter(filter);
        this.imagePanel.addMouseListener(this.mouseConverter);
        this.imagePanel.addMouseMotionListener(this.mouseConverter);
        this.imagePanel.addMouseWheelListener(this.mouseConverter);
        this.imagePanel.addKeyListener(filter);
        this.cancelAction.setEnabled(false);
        this.glassPanel.setVisible(false);
        this.switchFilterUIHeading(filter.getProperties().getShortName());
        this.switchFilterUI(this.filterManager.getFilterControls());
        this.disableImageBrowseActions();
        this.switchFilterManagerControls(this.filterManager.getFilterManagerControls());
        this.filtersPanel.setUndoRedoEnabled(false);
        this.context.setTopBarActionsEnabled(false);
        this.commentPanel.setFocusable(false);
        this.propertyPanel.setFocusable(false);
        this.filterPanelViewMode.show(this.filterPanel, "filterUI");
        this.validate();
        this.commentPanel.setFocusable(true);
        this.propertyPanel.setFocusable(true);
    }

    void setImageInFilter() {
        try {
            this.bufferedImage = (BufferedImage)this.context.imageCache.getImage(this.ao);
            this.filterManager.setImage(this.bufferedImage, this.filterManager.getFilterList());
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    private void switchFilterUIHeading(String heading) {
        if (this.filterUIHeadingPanel != null) {
            this.filterUIContainer.remove(this.filterUIHeadingPanel);
        }
        this.filterUIHeadingPanel = new JHeadingPanel(heading);
        this.filterUIContainer.add((Component)this.filterUIHeadingPanel, "North");
    }

    private void switchFilterUI(JPanel filterControls) {
        if (this.filterUI != null) {
            this.filterUIContainer.remove(this.filterScrollPane);
        }
        this.filterUI = filterControls;
        if (this.filterUI != null) {
            this.filterScrollPane.setViewportView(this.filterUI);
            this.filterUIContainer.add((Component)this.filterScrollPane, "Center");
        }
    }

    private void switchFilterManagerControls(JPanel managerControls) {
        if (this.filterManagerControls != null) {
            this.filterUIContainer.remove(this.filterManagerControls);
        }
        this.filterManagerControls = managerControls;
        if (this.filterManagerControls != null) {
            this.filterUIContainer.add((Component)this.filterManagerControls, "South");
        }
    }

    private void disableImageBrowseActions() {
        this.nextImageAction.setEnabled(false);
        this.propertyPanel.nextImage.setEnabled(false);
        this.previousImageAction.setEnabled(false);
        this.propertyPanel.previousImage.setEnabled(false);
    }

    private void enableImageBrowseActions() {
        boolean hasNext = this.getNextComponent() != null;
        boolean hasPrevious = this.getPreviousComponent() != null;
        this.nextImageAction.setEnabled(hasNext);
        this.propertyPanel.nextImage.setEnabled(hasNext);
        this.previousImageAction.setEnabled(hasPrevious);
        this.propertyPanel.previousImage.setEnabled(hasPrevious);
    }

    public BufferedImage scaleImage(BufferedImage bi) {
        AlbumImage ai = new AlbumImage(bi, this.context.parent.engine);
        ai = ai.scaleToFit(this.imagePanel.getDisplayableImageSize());
        return ai.getBufferedImage();
    }

    public void filterMenuClosed(BufferedImage bi, boolean saveBeforeClose) {
        this.setImage(bi);
        if (this.filterUI != null) {
            this.filterUIContainer.remove(this.filterScrollPane);
            this.filterUI = null;
        }
        if (this.filterManagerControls != null) {
            this.filterUIContainer.remove(this.filterManagerControls);
            this.filterManagerControls = null;
        }
        this.filterPanelViewMode.show(this.filterPanel, "filtersPanel");
        this.enableImageBrowseActions();
        if (saveBeforeClose) {
            this.saveFilters();
        }
        this.filtersPanel.setUndoRedoEnabled(true);
        this.context.setTopBarActionsEnabled(true);
        this.cancelAction.setEnabled(true);
        this.glassPanel.setVisible(true);
        this.cleanFilterListeners();
        this.currentFilter = null;
        this.validate();
        this.requestFocusInWindow();
    }

    protected void cleanFilterListeners() {
        if (this.currentFilter != null) {
            this.imagePanel.removeMouseListener(this.mouseConverter);
            this.imagePanel.removeMouseMotionListener(this.mouseConverter);
            this.imagePanel.removeMouseWheelListener(this.mouseConverter);
            this.imagePanel.removeKeyListener(this.currentFilter);
        }
    }

    public void setImage(BufferedImage bi) {
        this.imagePanel.setBackgroundImage(bi);
        this.fireImageUpdated();
    }

    public JComponent getImageComponent() {
        return this.imagePanel;
    }

    public Point getImageCoordinates(MouseEvent e) {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        Dimension boundingBox = this.imagePanel.getDisplayableImageSize();
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        float xDistance = (float)((boundingBox.getWidth() - (double)newWidth) / 2.0);
        float yDistance = (float)((boundingBox.getHeight() - (double)newHeight) / 2.0);
        Point p = e.getPoint();
        int tx = (int)((double)p.x * maxScale - (double)xDistance);
        int ty = (int)((double)p.y * maxScale - (double)yDistance);
        return new Point(tx, ty);
    }

    public synchronized void addEditListener(EditListener l) {
        Vector v;
        Vector vector = v = this.editListeners == null ? new Vector(2) : (Vector)this.editListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            if (this.ao != null) {
                l.setAlbumObject(this.ao);
            }
            this.editListeners = v;
        }
    }

    public void removeEditListener(EditListener l) {
        if (this.editListeners != null && this.editListeners.contains(l)) {
            Vector v = (Vector)this.editListeners.clone();
            v.removeElement(l);
            this.editListeners = v;
        }
    }

    protected void fireEditingAlbumObject(AlbumObject ao) {
        if (this.editListeners != null) {
            for (EditListener listener : this.editListeners) {
                listener.setAlbumObject(ao);
            }
        }
    }

    protected void fireSaveState() {
        if (this.editListeners != null) {
            for (EditListener listener : this.editListeners) {
                if (!(listener instanceof EditListener2)) continue;
                ((EditListener2)listener).saveState();
            }
        }
    }

    public void addCustomTab(String title, JComponent panel) {
        this.propertyPanel.addTab(title, panel);
    }

    public void removeCustomTab(JComponent panel) {
        this.propertyPanel.removeTab(panel);
    }

    class MyViewPort
    extends JViewport {
        Point p1 = new Point();
        Point p2 = new Point();

        MyViewPort() {
        }

        public void paint(Graphics g2d) {
            Graphics2D g = (Graphics2D)g2d;
            super.paint(g);
            if (JEditPanel.this.ao != null && !JEditPanel.this.ao.isIncluded()) {
                Image crossImage = JAlbumObject.getCrossImage();
                g.drawImage(crossImage, JEditPanel.this.imagePanel.getImageTopCornerXCoordinate() + 20, JEditPanel.this.imagePanel.getImageTopCornerYCoordinate() + 20, null);
            }
            if (JEditPanel.this.glassPanel.isVisible()) {
                JEditPanel.this.returnButton.setDiscrete(false);
                JEditPanel.this.previousButton.setDiscrete(false);
                JEditPanel.this.nextButton.setDiscrete(false);
                this.paintComponent(JEditPanel.this.returnButton, g);
                this.paintComponent(JEditPanel.this.previousButton, g);
                this.paintComponent(JEditPanel.this.nextButton, g);
                if (JEditPanel.this.timeSlider.isVisible()) {
                    this.paintComponent(JEditPanel.this.timeSlider, g);
                }
                if (JEditPanel.this.clipSlider.isVisible()) {
                    this.paintComponent(JEditPanel.this.clipSlider, g);
                }
                JEditPanel.this.returnButton.setDiscrete(true);
                JEditPanel.this.previousButton.setDiscrete(true);
                JEditPanel.this.nextButton.setDiscrete(true);
            }
        }

        private void paintComponent(JComponent comp, Graphics2D g) {
            AffineTransform at = g.getTransform();
            int x = 0;
            int y = 0;
            Point p = null;
            Container c = comp;
            do {
                p = ((Component)c).getLocation(p);
                x += p.x;
                y += p.y;
            } while (c != JEditPanel.this.glassPanel && (c = c.getParent()) != null);
            g.translate(x, y);
            comp.paint(g);
            g.setTransform(at);
        }
    }

    private class RatingAction
    extends AbstractAction {
        private int rating;

        public RatingAction(int rating) {
            this.rating = rating;
        }

        public void actionPerformed(ActionEvent e) {
            JEditPanel.this.propertyPanel.rating.changeValue(this.rating);
        }
    }

    class JMyScrollPane
    extends JScrollPane {
        protected JViewport createViewport() {
            return new MyViewPort();
        }
    }

    class MouseConverter
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        MouseConverter() {
        }

        private MouseEvent convertMouseEvent(MouseEvent e) {
            Point p = JEditPanel.this.getImageCoordinates(e);
            MouseEvent correctedEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), (int)p.getX(), (int)p.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            return correctedEvent;
        }

        public void mouseClicked(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseClicked(this.convertMouseEvent(e));
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseEntered(this.convertMouseEvent(e));
            }
        }

        public void mouseExited(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseExited(this.convertMouseEvent(e));
            }
        }

        public void mousePressed(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mousePressed(this.convertMouseEvent(e));
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseReleased(this.convertMouseEvent(e));
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseDragged(this.convertMouseEvent(e));
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseMoved(this.convertMouseEvent(e));
            }
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                Point p = JEditPanel.this.getImageCoordinates(e);
                MouseWheelEvent correctedEvent = new MouseWheelEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), (int)p.getX(), (int)p.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
                JEditPanel.this.currentFilter.mouseWheelMoved(correctedEvent);
            }
        }
    }

    private static class JGlassLabel
    extends JLabel {
        public JGlassLabel(String string) {
            super(string);
            this.setOpaque(true);
            Color bg = this.getBackground();
            this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 128));
        }
    }
}

