/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Date;
import javax.swing.ImageIcon;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Category;
import se.datadosen.util.Orientation;
import se.datadosen.util.RotationSupport;

public class GenericRotationSupport
extends RotationSupport {
    public static ImageIcon adjustOrientation(ImageIcon ii, AlbumObject ao) {
        BufferedImage bi = GenericRotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
        bi = GenericRotationSupport.adjustOrientation(bi, GenericRotationSupport.getOrientation(ao));
        return new ImageIcon(bi);
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, AlbumObject ao) {
        return GenericRotationSupport.adjustOrientation(bi, GenericRotationSupport.getOrientation(ao));
    }

    public static Orientation getOrientation(AlbumObject ao) {
        try {
            Orientation o = Orientation.fromValue(GenericRotationSupport.getOrientation(ao.getFile()));
            if (o == null) {
                throw new IOException("Orientation tag not found");
            }
            return o;
        }
        catch (IOException ex) {
            AlbumObjectProperties props = ao.getProperties();
            try {
                Orientation o = (Orientation)((Object)props.get("orientation"));
                if (o == null && ao.getCategory() == Category.video) {
                    ao.getRepresentingImageFile();
                    o = (Orientation)((Object)props.get("orientation"));
                }
                return o != null ? o : Orientation.normal;
            }
            catch (ClassCastException ex2) {
                return Orientation.normal;
            }
        }
    }

    public static String getOrientationAsString(AlbumObject ao) {
        return GenericRotationSupport.getOrientation(ao).toString();
    }

    public static void setOrientation(Orientation orientation, AlbumObject ao) {
        try {
            GenericRotationSupport.setOrientation(orientation.getValue(), ao.getFile());
        }
        catch (IOException ex) {
            AlbumObjectProperties props = ao.getProperties();
            props.put("orientation", (Object)orientation);
            props.save(false);
            ao.getFile().setLastModified(new Date().getTime());
        }
    }
}

