/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import se.datadosen.component.JNotification;
import se.datadosen.explorer.JAlbumExplorer;

public class NotificationManager
implements PropertyChangeListener {
    private JAlbumExplorer explorer;
    private LinkedList<JNotification> queue = new LinkedList();
    private JNotification active = null;
    private int showCount = 0;
    private final Thread managerThread = new ManagerThread();
    private static final int MAX_SHOW_COUNT = 2;

    public NotificationManager(JAlbumExplorer explorer) {
        this.explorer = explorer;
        this.managerThread.start();
    }

    public synchronized void showNotification(JNotification n) {
        JNotification.Priority prio = n.getPriority();
        if (prio == JNotification.Priority.HIGH) {
            this.queue.addFirst(n);
            this.nextNotification();
            return;
        }
        this.queue.addLast(n);
        if (!this.isCurrentlyShowing()) {
            this.nextNotification();
        }
    }

    private boolean isCurrentlyShowing() {
        return this.active != null && this.active.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextNotification() {
        Thread thread = this.managerThread;
        synchronized (thread) {
            this.managerThread.notify();
        }
    }

    public int getShowCount() {
        return this.showCount;
    }

    public JNotification getActiveNotification() {
        return this.active != null && this.active.isVisible() ? this.active : null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.nextNotification();
    }

    private class ManagerThread
    extends Thread {
        public ManagerThread() {
            super("Notifiation manager");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long delay = 0L;
            try {
                while (true) {
                    Object object = this;
                    synchronized (object) {
                        this.wait(delay);
                    }
                    if (NotificationManager.this.active != null) {
                        if (NotificationManager.this.active.isShowing()) {
                            NotificationManager.this.active.rollDown();
                            NotificationManager.this.active.setVisible(false);
                        }
                        NotificationManager.this.active.removePropertyChangeListener(NotificationManager.this);
                        NotificationManager.this.active = null;
                    }
                    if (NotificationManager.this.showCount >= 2) {
                        object = NotificationManager.this;
                        synchronized (object) {
                            Iterator it = NotificationManager.this.queue.iterator();
                            while (it.hasNext()) {
                                JNotification n = (JNotification)it.next();
                                if (n.getPriority() != JNotification.Priority.LOW) continue;
                                it.remove();
                            }
                        }
                    }
                    if (!NotificationManager.this.queue.isEmpty()) {
                        NotificationManager.this.active = (JNotification)NotificationManager.this.queue.removeFirst();
                        NotificationManager.this.active.jumpDown();
                        NotificationManager.this.active.setVisible(true);
                        NotificationManager.this.active.addPropertyChangeListener("dismissed", NotificationManager.this);
                        NotificationManager.this.explorer.setNotification(NotificationManager.this.active);
                        NotificationManager.this.showCount++;
                        NotificationManager.this.active.rollUp();
                        delay = 1000 * NotificationManager.this.active.getExpiration();
                        continue;
                    }
                    delay = 0L;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

