/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterManagerInterface;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filterManager.JAlbumImageFilter;

public class BasicFilter
implements JAlbumImageFilter {
    private static final long serialVersionUID = 4118395418676584221L;
    protected String name = "JAlbum Image Filter";
    protected String shortName = "";
    protected ImageIcon icon = null;
    protected String author = "David Fichtmueller";
    protected String version = "1.0";
    protected String description = "This is the default filter class, all other filters must inherite from.";
    protected String help = "";
    protected String other = "";
    protected FilterProperties.FilterCategory category = FilterProperties.FilterCategory.OTHER;
    protected boolean prescale = true;
    protected boolean postscale = true;
    protected BufferedImage inputImage;
    protected BufferedImage outputImage;
    protected FilterManagerInterface filterManager;
    protected int width;
    protected int height;

    public void init() {
    }

    public JPanel getControls() {
        return null;
    }

    public void setPreviewImage(BufferedImage bi) {
        this.inputImage = this.cloneBufferedImage(bi);
        this.width = this.inputImage.getWidth();
        this.height = this.inputImage.getHeight();
        this.renderPreview();
    }

    protected BufferedImage cloneBufferedImage(BufferedImage bi) {
        return this.filterManager.cloneBufferedImage(bi);
    }

    public void renderImage() {
        this.outputImage = this.renderImage(this.cloneBufferedImage(this.inputImage));
        this.filterManager.setGUIImage(this.outputImage);
    }

    public BufferedImage renderImage(BufferedImage bi) {
        return bi;
    }

    public void renderPreview() {
        this.outputImage = this.renderImage(this.cloneBufferedImage(this.inputImage));
        this.paint(this.outputImage.getGraphics());
        this.filterManager.setGUIImage(this.outputImage);
    }

    public void paint(Graphics g) {
    }

    public void dispose() {
        this.inputImage = null;
        this.outputImage = null;
        this.filterManager = null;
    }

    public String getName() {
        return this.name;
    }

    public FilterProperties getProperties() {
        FilterProperties properties = new FilterProperties();
        properties.setAuthor(this.author);
        properties.setCategory(this.category);
        properties.setDescription(this.description);
        properties.setHelp(this.help);
        properties.setIcon(this.icon);
        properties.setOther(this.other);
        properties.setShortName(this.shortName);
        properties.setVersion(this.version);
        return properties;
    }

    public boolean isPrescale() {
        return this.prescale;
    }

    public boolean isPostscale() {
        return this.postscale;
    }

    public void setFilterManager(FilterManagerInterface filterManager) {
        this.filterManager = filterManager;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
    }
}

