/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.BasicFilter;
import net.jalbum.filters.StraightenControl;
import se.datadosen.jalbum.ModifiesSize;
import se.datadosen.jalbum.Msg;

public class StraightenFilterPlugin
extends BasicFilter
implements ModifiesSize {
    private static final long serialVersionUID = 3126311644370597656L;
    protected StraightenControl straightenControl;
    protected Color color = new Color(255, 255, 255);
    protected double angle = 0.0;
    protected double angle_out = 0.0;
    protected boolean random = false;
    protected boolean antialias = true;
    protected boolean user_rotating = false;
    protected boolean showGrid = true;
    protected int orientationWidth;
    protected int orientationHeight;
    protected int startX;
    protected int startY;
    protected int currentX;
    protected int currentY;
    public static final int RESIZE_CROPPING = 0;
    public static final int RESIZE_KEEP_SIZE = 1;
    public static final int RESIZE_ENLARGE = 2;
    protected int resizeOption = 0;
    protected int initalPanelWidth = 400;
    protected int initalPanelHeight = 400;
    protected final int guidelinesVertical = 16;
    protected final int guidelinesHorizontal = 16;

    public StraightenFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.straighten.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.straighten.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/straighten.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.straighten.description");
        this.category = FilterProperties.FilterCategory.BASIC;
        this.prescale = true;
        this.postscale = false;
        this.straightenControl = new StraightenControl(this);
    }

    public JPanel getControls() {
        return this.straightenControl;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        BufferedImage out;
        this.angle_out = this.checkAngle(this.angle_out);
        int w = bi.getWidth();
        int h = bi.getHeight();
        double segment1Width = Math.abs((double)h * Math.sin(Math.toRadians(this.angle_out)));
        double segment2Width = Math.abs((double)w * Math.cos(Math.toRadians(this.angle_out)));
        double segment1Height = Math.abs((double)h * Math.cos(Math.toRadians(this.angle_out)));
        double segment2Height = Math.abs((double)w * Math.sin(Math.toRadians(this.angle_out)));
        int newW = (int)(segment1Width + segment2Width);
        int newH = (int)(segment1Height + segment2Height);
        if (this.resizeOption == 0) {
            int smallerSide = 0;
            int largerSide = 0;
            if (w < h) {
                smallerSide = bi.getWidth();
                largerSide = bi.getHeight();
            } else {
                smallerSide = bi.getHeight();
                largerSide = bi.getWidth();
            }
            double absAngle_out = Math.abs(this.angle_out);
            double angleA = Math.toRadians(absAngle_out - (double)((int)(absAngle_out - 1.0) / 90 * 2) * (absAngle_out - 90.0));
            double angleB = Math.atan((double)largerSide / (double)smallerSide);
            double angleC = angleB - angleA;
            double diagonal = (double)smallerSide / Math.cos(angleC);
            double unroundedWidth = 0.0;
            double unroundedHeight = 0.0;
            if (w < h) {
                unroundedWidth = diagonal * Math.cos(angleB);
                unroundedHeight = diagonal * Math.sin(angleB);
            } else {
                unroundedWidth = diagonal * Math.sin(angleB);
                unroundedHeight = diagonal * Math.cos(angleB);
            }
            int cuttingWidth = (int)unroundedWidth;
            int cuttingHeight = (int)unroundedHeight;
            int positionX = (int)((double)this.orientationWidth * 0.5 - unroundedWidth / 2.0);
            int positionY = (int)((double)this.orientationHeight * 0.5 - unroundedHeight / 2.0);
            if (this.user_rotating) {
                out = new BufferedImage(this.orientationWidth, this.orientationHeight, 1);
                Graphics2D g = out.createGraphics();
                g.setColor(this.color);
                g.fillRect(0, 0, this.orientationWidth, this.orientationHeight);
                g.rotate(Math.toRadians(this.angle_out), this.orientationWidth / 2, this.orientationHeight / 2);
                g.drawImage((Image)bi, (this.orientationWidth - w) / 2, (this.orientationHeight - h) / 2, null);
                g.dispose();
                Graphics g2 = out.getGraphics();
                g2.setColor(Color.DARK_GRAY);
                g2.drawRect(positionX, positionY, cuttingWidth, cuttingHeight);
                g.fillOval(newW - (int)segment1Width, newH - (int)segment1Height, 3, 3);
            } else {
                out = new BufferedImage(cuttingWidth, cuttingHeight, 1);
                Graphics2D g = out.createGraphics();
                if (this.antialias) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                }
                g.setColor(this.color);
                g.fillRect(0, 0, cuttingWidth, cuttingHeight);
                g.rotate(Math.toRadians(this.angle_out), cuttingWidth / 2, cuttingHeight / 2);
                g.drawImage((Image)bi, (cuttingWidth - w) / 2, (cuttingHeight - h) / 2, null);
                g.dispose();
            }
        } else if (this.resizeOption == 1) {
            out = new BufferedImage(w, h, 1);
            Graphics2D g = out.createGraphics();
            if (this.antialias) {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
            g.setColor(this.color);
            g.fillRect(0, 0, w, h);
            g.rotate(Math.toRadians(this.angle_out), w / 2, h / 2);
            g.drawImage((Image)bi, 0, 0, null);
            g.dispose();
        } else if (this.user_rotating) {
            out = new BufferedImage(this.orientationWidth, this.orientationHeight, 1);
            Graphics2D g = out.createGraphics();
            g.setColor(this.color);
            g.fillRect(0, 0, this.orientationWidth, this.orientationHeight);
            g.rotate(Math.toRadians(this.angle_out), this.orientationWidth / 2, this.orientationHeight / 2);
            g.drawImage((Image)bi, (this.orientationWidth - w) / 2, (this.orientationHeight - h) / 2, null);
            g.dispose();
        } else {
            out = new BufferedImage(newW, newH, 1);
            Graphics2D g = out.createGraphics();
            if (this.antialias) {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            }
            g.setColor(this.color);
            g.fillRect(0, 0, newW, newH);
            g.rotate(Math.toRadians(this.angle_out), newW / 2, newH / 2);
            g.drawImage((Image)bi, (newW - w) / 2, (newH - h) / 2, null);
            g.dispose();
        }
        return out;
    }

    public void paint(Graphics g) {
        if (this.showGrid) {
            g.setColor(new Color(200, 200, 200, 150));
            int i = 0;
            while (true) {
                this.getClass();
                if (i >= 16) break;
                int n = i * this.outputImage.getWidth();
                this.getClass();
                int n2 = n / 16;
                int n3 = i * this.outputImage.getWidth();
                this.getClass();
                g.drawLine(n2, 0, n3 / 16, this.outputImage.getHeight());
                ++i;
            }
            i = 0;
            while (true) {
                this.getClass();
                if (i >= 16) break;
                int n = i * this.outputImage.getHeight();
                this.getClass();
                int n4 = n / 16;
                int n5 = this.outputImage.getWidth();
                int n6 = i * this.outputImage.getHeight();
                this.getClass();
                g.drawLine(0, n4, n5, n6 / 16);
                ++i;
            }
        }
        if (this.user_rotating) {
            g.setColor(new Color(64, 64, 64, 255));
            g.drawLine(this.startX, this.startY, this.outputImage.getWidth() / 2, this.outputImage.getHeight() / 2);
            g.drawLine(this.currentX, this.currentY, this.outputImage.getWidth() / 2, this.outputImage.getHeight() / 2);
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void adjustAngle(double angle) {
        this.angle = angle;
        this.angle_out = this.checkAngle(angle);
        this.renderPreview();
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void adjustRandom(boolean random) {
        this.random = random;
        if (random) {
            this.angle = Math.random() * Math.abs(this.angle) * 2.0 - Math.abs(this.angle);
        }
        this.straightenControl.updateAngle(this.angle);
        this.angle_out = this.checkAngle(this.angle);
        this.renderPreview();
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public void setResizeOption(int resizeOption) {
        this.resizeOption = resizeOption;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public void mouseEntered(MouseEvent arg0) {
        this.filterManager.setCursor(Cursor.getPredefinedCursor(13));
    }

    public void mouseExited(MouseEvent arg0) {
        this.filterManager.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mousePressed(MouseEvent event) {
        this.antialias = false;
        this.user_rotating = true;
        this.orientationWidth = this.outputImage.getWidth();
        this.orientationHeight = this.outputImage.getHeight();
        this.startX = event.getX();
        this.startY = event.getY();
        if (this.startX - this.outputImage.getWidth() / 2 == 0) {
            ++this.startX;
        }
        if (this.startY - this.outputImage.getHeight() / 2 == 0) {
            ++this.startY;
        }
        this.currentX = event.getX();
        this.currentY = event.getY();
        this.renderPreview();
    }

    public void mouseReleased(MouseEvent event) {
        this.antialias = true;
        this.user_rotating = false;
        this.currentX = event.getX();
        this.currentY = event.getY();
        this.calculateAngle();
        this.angle = this.angle_out;
        this.renderPreview();
    }

    public void mouseDragged(MouseEvent event) {
        this.currentX = event.getX();
        this.currentY = event.getY();
        this.calculateAngle();
        this.renderPreview();
    }

    protected double checkAngle(double angle) {
        angle = (angle % 360.0 + 360.0 + 180.0) % 360.0 - 180.0;
        return angle;
    }

    protected void calculateAngle() {
        if (this.currentX - this.outputImage.getWidth() / 2 == 0) {
            ++this.currentX;
        }
        if (this.currentY - this.outputImage.getHeight() / 2 == 0) {
            ++this.currentY;
        }
        int x1 = this.startX - this.orientationWidth / 2;
        int y1 = this.startY - this.orientationHeight / 2;
        int x2 = this.currentX - this.orientationWidth / 2;
        int y2 = this.currentY - this.orientationHeight / 2;
        double angleChanged = Math.toDegrees(Math.acos((double)(x1 * x2 + y1 * y2) / (Math.sqrt(x1 * x1 + y1 * y1) * Math.sqrt(x2 * x2 + y2 * y2))));
        double m2 = (double)(this.currentY - this.orientationHeight / 2) / (double)(this.currentX - this.orientationWidth / 2);
        double m1 = (double)(this.startY - this.orientationHeight / 2) / (double)(this.startX - this.orientationWidth / 2);
        double angleChanged2 = Math.toDegrees(Math.atan((m2 - m1) / (1.0 + m2 * m1)));
        if (angleChanged2 < 0.0 && angleChanged < 90.0 || angleChanged2 > 0.0 && angleChanged > 90.0) {
            angleChanged = -angleChanged;
        }
        this.angle_out = this.checkAngle(this.angle + angleChanged);
        this.straightenControl.updateAngle(this.angle_out);
    }

    public void keyPressed(KeyEvent arg0) {
        if (arg0.getKeyCode() == 226 || arg0.getKeyCode() == 37) {
            this.angle -= 1.0;
            this.straightenControl.updateAngle(this.angle);
            this.angle_out = this.checkAngle(this.angle);
            this.renderPreview();
        } else if (arg0.getKeyCode() == 227 || arg0.getKeyCode() == 39) {
            this.angle += 1.0;
            this.straightenControl.updateAngle(this.angle);
            this.angle_out = this.checkAngle(this.angle);
            this.renderPreview();
        } else if (arg0.getKeyCode() == 49 || arg0.getKeyCode() == 97) {
            this.resizeOption = 1;
            this.straightenControl.setResizeOption(this.resizeOption);
            this.renderPreview();
        } else if (arg0.getKeyCode() == 50 || arg0.getKeyCode() == 98) {
            this.resizeOption = 0;
            this.straightenControl.setResizeOption(this.resizeOption);
            this.renderPreview();
        } else if (arg0.getKeyCode() == 51 || arg0.getKeyCode() == 99) {
            this.resizeOption = 2;
            this.straightenControl.setResizeOption(this.resizeOption);
            this.renderPreview();
        }
    }

    public void setPreviewImage(BufferedImage bi) {
        this.inputImage = this.filterManager.cloneBufferedImage(bi);
        this.width = bi.getWidth();
        this.height = bi.getHeight();
        this.renderPreview();
    }

    public double getAngle_out() {
        return this.angle_out;
    }

    public void setAngle_out(double angle_out) {
        this.angle_out = angle_out;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public boolean isUser_rotating() {
        return this.user_rotating;
    }

    public void setUser_rotating(boolean user_rotating) {
        this.user_rotating = user_rotating;
    }

    public int getOrientationWidth() {
        return this.orientationWidth;
    }

    public void setOrientationWidth(int orientationWidth) {
        this.orientationWidth = orientationWidth;
    }

    public int getOrientationHeight() {
        return this.orientationHeight;
    }

    public void setOrientationHeight(int orientationHeight) {
        this.orientationHeight = orientationHeight;
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartX(int startX) {
        this.startX = startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int startY) {
        this.startY = startY;
    }

    public int getCurrentX() {
        return this.currentX;
    }

    public void setCurrentX(int currentX) {
        this.currentX = currentX;
    }

    public int getCurrentY() {
        return this.currentY;
    }

    public void setCurrentY(int currentY) {
        this.currentY = currentY;
    }

    public int getInitalPanelWidth() {
        return this.initalPanelWidth;
    }

    public void setInitalPanelWidth(int initalPanelWidth) {
        this.initalPanelWidth = initalPanelWidth;
    }

    public int getInitalPanelHeight() {
        return this.initalPanelHeight;
    }

    public void setInitalPanelHeight(int initalPanelHeight) {
        this.initalPanelHeight = initalPanelHeight;
    }

    public Color getColor() {
        return this.color;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isRandom() {
        return this.random;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public int getResizeOption() {
        return this.resizeOption;
    }

    public int getGuidelinesVertical() {
        this.getClass();
        return 16;
    }

    public int getGuidelinesHorizontal() {
        this.getClass();
        return 16;
    }

    public Dimension getModifiedSize(Dimension dim, Map arg1) {
        this.angle_out = this.checkAngle(this.angle_out);
        int w = dim.width;
        int h = dim.height;
        double segment1Width = Math.abs((double)h * Math.sin(Math.toRadians(this.angle_out)));
        double segment2Width = Math.abs((double)w * Math.cos(Math.toRadians(this.angle_out)));
        double segment1Height = Math.abs((double)h * Math.cos(Math.toRadians(this.angle_out)));
        double segment2Height = Math.abs((double)w * Math.sin(Math.toRadians(this.angle_out)));
        int newW = (int)(segment1Width + segment2Width);
        int newH = (int)(segment1Height + segment2Height);
        if (this.resizeOption == 0) {
            int smallerSide = 0;
            smallerSide = dim.width < dim.height ? dim.width : dim.height;
            double absAngle_out = Math.abs(this.angle_out);
            double angleA = Math.toRadians(absAngle_out - (double)((int)(absAngle_out - 1.0) / 90 * 2) * (absAngle_out - 90.0));
            double angleB = Math.atan((double)w / (double)h);
            double angleC = angleB - angleA;
            double diagonal = (double)smallerSide / Math.cos(angleC);
            int cuttingWidth = (int)(diagonal * Math.sin(angleB));
            int cuttingHeight = (int)(diagonal * Math.cos(angleB));
            return new Dimension(cuttingWidth, cuttingHeight);
        }
        if (this.resizeOption == 1) {
            return dim;
        }
        return new Dimension(newW, newH);
    }
}

