/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.fileutil;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import org.jdesktop.jdic.fileutil.NativeFileUtil;

class Win32NativeFileUtil
extends NativeFileUtil {
    Win32NativeFileUtil() {
    }

    public boolean recycle(File file) throws IOException, SecurityException {
        String string = file.getCanonicalPath();
        int n = this.recycle(string, false);
        if (n == 0) {
            return !file.exists();
        }
        throw new IOException();
    }

    public BigInteger getFreeSpace(File file) throws IOException {
        if (file.isFile()) {
            long[] lArray = this.getFreeSpace(file.getCanonicalFile().getParent());
            BigInteger bigInteger = new BigInteger(String.valueOf(lArray[1])).shiftLeft(32);
            BigInteger bigInteger2 = new BigInteger(String.valueOf(lArray[0]));
            return bigInteger.add(bigInteger2);
        }
        if (file.isDirectory()) {
            long[] lArray = this.getFreeSpace(file.getCanonicalPath());
            BigInteger bigInteger = new BigInteger(String.valueOf(lArray[1])).shiftLeft(32);
            BigInteger bigInteger3 = new BigInteger(String.valueOf(lArray[0]));
            return bigInteger.add(bigInteger3);
        }
        return BigInteger.ZERO;
    }

    public BigInteger getTotalSpace(File file) throws IOException {
        if (file.isFile()) {
            long[] lArray = this.getTotalSpace(file.getCanonicalFile().getParent());
            BigInteger bigInteger = new BigInteger(String.valueOf(lArray[1])).shiftLeft(32);
            BigInteger bigInteger2 = new BigInteger(String.valueOf(lArray[0]));
            return bigInteger.add(bigInteger2);
        }
        if (file.isDirectory()) {
            long[] lArray = this.getTotalSpace(file.getCanonicalPath());
            BigInteger bigInteger = new BigInteger(String.valueOf(lArray[1])).shiftLeft(32);
            BigInteger bigInteger3 = new BigInteger(String.valueOf(lArray[0]));
            return bigInteger.add(bigInteger3);
        }
        return BigInteger.ZERO;
    }

    public void close() {
        this.findClose();
    }

    public String readFirst(String string) {
        return this.findFirst(string);
    }

    public String readNext() {
        return this.findNext();
    }

    private native long[] getFreeSpace(String var1);

    private native long[] getTotalSpace(String var1);

    private native int recycle(String var1, boolean var2);

    private native String getFileSystem(String var1);

    private native boolean isArchive(String var1);

    private native boolean setArchive(String var1, boolean var2);

    private native boolean isNormal(String var1);

    private native boolean setNormal(String var1);

    private native boolean isReadOnly(String var1);

    private native boolean isSystem(String var1);

    private native boolean setSystem(String var1, boolean var2);

    private native boolean isTemporary(String var1);

    private native boolean setTemporary(String var1, boolean var2);

    private native boolean isCompressed(String var1);

    private native boolean isEncrypted(String var1);

    private native boolean setHidden(String var1, boolean var2);

    private native String findFirst(String var1);

    private native String findNext();

    private native boolean findClose();

    static {
        System.loadLibrary("jdic_fileutil");
    }
}

