/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyCore;
import component.DataChoiceUI;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import main.Oscar;
import uiutil.ChangeListener;
import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.HorizontalRule;
import uiutil.ListEditor;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.Log;

class BuddyListProps
extends PropertySheet
implements ActionListener,
ChoiceListener,
ChangeListener,
ItemListener {
    private static final String MODULE = "BuddyListProps";
    private static final String BLANKS = "                          ";
    private static int DELETE_BUDDY_LIST_CHOICE;
    private static int NEW_BUDDY_LIST_CHOICE;
    private static int RENAME_BUDDY_LIST_CHOICE;
    private BuddyCore core;
    private ChangeListener changeListener;
    private Button newListButton;
    private Button renameListButton;
    private Button deleteListButton;
    private Choice listChoice;
    private ListEditor listEditor;
    private Vector[] buddyNames;
    private Vector[] deletedBuddies;
    private Vector[] addedBuddies;
    private String[] newListNames;
    private String[] oldListNames;
    private boolean[] deletedLists;
    private boolean changed = false;
    private int listIndex;

    public BuddyListProps(BuddyCore buddyCore, ChangeListener changeListener) {
        this.core = buddyCore;
        this.changeListener = changeListener;
        this.setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel();
        this.add("North", transparentPanel);
        transparentPanel.setLayout(new BorderLayout(20, 0));
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel.add("North", transparentPanel2);
        transparentPanel2.add(new Label("Buddy List Group Name:"));
        this.listChoice = new Choice();
        transparentPanel2.add(this.listChoice);
        this.listChoice.addItemListener(this);
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add("South", transparentPanel2);
        this.newListButton = new Button("Add Group");
        transparentPanel2.add(this.newListButton);
        this.newListButton.addActionListener(this);
        this.renameListButton = new Button("Rename Group");
        transparentPanel2.add(this.renameListButton);
        this.renameListButton.addActionListener(this);
        this.deleteListButton = new Button("Delete Group");
        transparentPanel2.add(this.deleteListButton);
        this.deleteListButton.addActionListener(this);
        this.add("Center", new HorizontalRule(5, 0));
        transparentPanel = new TransparentPanel();
        this.add("South", transparentPanel);
        transparentPanel.add("West", new Spacer());
        this.listEditor = new ListEditor("Buddies In Group:", "Add Buddy", "Remove Buddy", this, buddyCore);
        transparentPanel.add("Center", this.listEditor);
        transparentPanel.add("East", new Spacer());
        this.setValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.deleteListButton)) {
            this.updateListBuddies(this.listIndex);
            this.deleteListAction();
            return;
        }
        if (object.equals(this.renameListButton)) {
            this.updateListBuddies(this.listIndex);
            this.renameListAction();
            return;
        }
        if (object.equals(this.newListButton)) {
            this.updateListBuddies(this.listIndex);
            this.newListAction();
        }
    }

    public boolean changed() {
        this.updateListBuddies(this.listIndex);
        return this.changed;
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n2 == 0) {
            Vector vector;
            if (n == DELETE_BUDDY_LIST_CHOICE) {
                this.deleteList();
                return;
            }
            if (n == NEW_BUDDY_LIST_CHOICE) {
                Vector vector2 = (Vector)object;
                if (vector2 != null) {
                    this.newList((String)vector2.elementAt(0));
                    return;
                }
            } else if (n == RENAME_BUDDY_LIST_CHOICE && (vector = (Vector)object) != null && vector.size() == 2) {
                this.renameList((String)vector.elementAt(0), (String)vector.elementAt(1));
            }
        }
    }

    private Vector cloneOrNull(Vector vector) {
        if (vector != null) {
            return (Vector)vector.clone();
        }
        return null;
    }

    public void deleteList() {
        this.deletedLists[this.listIndex] = true;
        this.listChoice.remove(this.newListNames[this.listIndex]);
        if (this.listChoice.getItemCount() == 0) {
            this.setStateEmpty();
        }
        this.listIndex = this.getListIndex();
        this.setListValues(this.listIndex);
        this.setChanged(true);
    }

    private void deleteListAction() {
        if (this.listIndex == -1) {
            return;
        }
        ChoiceUI.newChoiceUI(this, DELETE_BUDDY_LIST_CHOICE, null, "Delete Buddy Group", "Are you sure you want to delete buddy group \"" + this.newListNames[this.listIndex] + "\"?", "Delete", "Cancel", null, null);
    }

    public int getListIndex() {
        int n = -1;
        String string = this.listChoice.getSelectedItem();
        if (string != null && string != BLANKS) {
            n = 0;
            while (n < this.oldListNames.length) {
                if (this.newListNames[n] != null && string.equals(this.newListNames[n]) && !this.deletedLists[n]) break;
                ++n;
            }
        }
        return n;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Buddy List Setup Help", "This screen is where you go to create and modify your buddy list. To create a new buddy list group, click on the \"Add New Group\" button. This creates a window in which you enter the name of your new buddy group. Once you've created a new group, it appears in the area labeled \"Buddy List Group Name\". Now you can add buddies to your new buddy group by using the \"Add Buddy\" button. If you want to remove buddies, use the \"Remove Buddy\" button. The \"Rename Group\" button enables you to rename your buddy groups and the \"Delete Group\" button enables you to delete any of your buddy groups. You may edit your buddy groups in this folder at any time. ");
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.listChoice) {
            if (this.addListIsGood()) {
                this.updateListBuddies(this.listIndex);
                this.listIndex = this.getListIndex();
                this.setListValues(this.listIndex);
                return;
            }
            this.listChoice.select(this.listIndex);
            this.listEditor.requestFocus();
        }
    }

    private void newList(String string) {
        int n = this.buddyNames == null ? 1 : this.buddyNames.length + 1;
        Vector[] vectorArray = new Vector[n];
        Vector[] vectorArray2 = new Vector[n];
        Vector[] vectorArray3 = new Vector[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        boolean[] blArray = new boolean[n];
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n2) {
            vectorArray[n3] = this.buddyNames[n3];
            vectorArray2[n3] = this.deletedBuddies[n3];
            vectorArray3[n3] = this.addedBuddies[n3];
            stringArray[n3] = this.newListNames[n3];
            stringArray2[n3] = this.oldListNames[n3];
            blArray[n3] = this.deletedLists[n3];
            ++n3;
        }
        vectorArray[n2] = new Vector();
        vectorArray2[n2] = null;
        vectorArray3[n2] = null;
        stringArray[n2] = string;
        stringArray2[n2] = string;
        blArray[n2] = false;
        this.buddyNames = vectorArray;
        this.deletedBuddies = vectorArray2;
        this.addedBuddies = vectorArray3;
        this.newListNames = stringArray;
        this.oldListNames = stringArray2;
        this.deletedLists = blArray;
        this.setStateNonEmpty();
        this.listChoice.addItem(string);
        this.listChoice.select(string);
        this.listIndex = this.getListIndex();
        this.setListValues(this.listIndex);
        this.setChanged(true);
    }

    private void newListAction() {
        DataChoiceUI.newDataChoiceUI(this, NEW_BUDDY_LIST_CHOICE, null, "Enter a name for the new buddy group.", null, null, "Group Name:", null, "Create", "Cancel", null, null);
    }

    private void printLists() {
        if (this.newListNames != null) {
            int n = 0;
            while (n < this.newListNames.length) {
                int n2;
                Log.log(MODULE, Log.DB1, "oldListName: " + this.oldListNames[n]);
                Log.log(MODULE, Log.DB1, "newListName: " + this.newListNames[n]);
                Log.log(MODULE, Log.DB1, "    deleted: " + this.deletedLists[n]);
                Vector vector = this.buddyNames[n];
                Vector vector2 = this.deletedBuddies[n];
                Vector vector3 = this.addedBuddies[n];
                StringBuffer stringBuffer = new StringBuffer("    buddies:");
                if (vector != null) {
                    n2 = 0;
                    while (n2 < vector.size()) {
                        stringBuffer.append(" " + vector.elementAt(n2));
                        ++n2;
                    }
                }
                Log.log(MODULE, Log.DB1, stringBuffer.toString());
                stringBuffer = new StringBuffer("      added:");
                if (vector3 != null) {
                    n2 = 0;
                    while (n2 < vector3.size()) {
                        stringBuffer.append(" " + vector3.elementAt(n2));
                        ++n2;
                    }
                }
                Log.log(MODULE, Log.DB1, stringBuffer.toString());
                stringBuffer = new StringBuffer("    deleted:");
                if (vector2 != null) {
                    n2 = 0;
                    while (n2 < vector2.size()) {
                        stringBuffer.append(" " + vector2.elementAt(n2));
                        ++n2;
                    }
                }
                Log.log(MODULE, Log.DB1, stringBuffer.toString());
                ++n;
            }
        }
    }

    public void removeNotify() {
        int n;
        this.removeAll();
        this.core = null;
        this.changeListener = null;
        this.newListButton = null;
        this.renameListButton = null;
        this.deleteListButton = null;
        this.listChoice = null;
        this.listEditor = null;
        if (this.buddyNames != null) {
            n = 0;
            while (n < this.buddyNames.length) {
                this.buddyNames[n] = null;
                ++n;
            }
            this.buddyNames = null;
        }
        if (this.deletedBuddies != null) {
            n = 0;
            while (n < this.deletedBuddies.length) {
                this.deletedBuddies[n] = null;
                ++n;
            }
            this.deletedBuddies = null;
        }
        if (this.addedBuddies != null) {
            n = 0;
            while (n < this.addedBuddies.length) {
                this.addedBuddies[n] = null;
                ++n;
            }
            this.addedBuddies = null;
        }
        if (this.newListNames != null) {
            n = 0;
            while (n < this.newListNames.length) {
                this.newListNames[n] = null;
                ++n;
            }
            this.newListNames = null;
        }
        if (this.oldListNames != null) {
            n = 0;
            while (n < this.oldListNames.length) {
                this.oldListNames[n] = null;
                ++n;
            }
            this.oldListNames = null;
        }
        this.deletedLists = null;
        this.setLayout(null);
        super.removeNotify();
    }

    private void renameList(String string, String string2) {
        int n = 0;
        while (n < this.oldListNames.length) {
            if (string.equals(this.oldListNames[n])) break;
            ++n;
        }
        if (n == this.oldListNames.length) {
            n = 0;
            while (n < this.newListNames.length) {
                if (string.equals(this.newListNames[n])) break;
                ++n;
            }
        }
        if (n < this.newListNames.length) {
            this.newListNames[n] = string2;
        }
        int n2 = this.listChoice.getSelectedIndex();
        this.listChoice.remove(n2);
        this.listChoice.insert(string2, n2);
        this.listChoice.select(string2);
        this.setChanged(true);
    }

    private void renameListAction() {
        DataChoiceUI.newDataChoiceUI(this, RENAME_BUDDY_LIST_CHOICE, null, "Enter a new name for the buddy group.", "Old Name:", this.listChoice.getSelectedItem(), "New Name:", null, "Rename", "Cancel", null, null);
    }

    private void reset() {
        this.oldListNames = this.core.getBuddyListNames();
        if (this.oldListNames != null && this.oldListNames.length > 0) {
            this.buddyNames = new Vector[this.oldListNames.length];
            this.deletedBuddies = new Vector[this.oldListNames.length];
            this.addedBuddies = new Vector[this.oldListNames.length];
            this.newListNames = new String[this.oldListNames.length];
            int n = 0;
            while (n < this.oldListNames.length) {
                this.newListNames[n] = new String(this.oldListNames[n]);
                ++n;
            }
            this.deletedLists = new boolean[this.oldListNames.length];
        } else {
            this.buddyNames = null;
            this.deletedBuddies = null;
            this.addedBuddies = null;
            this.newListNames = null;
            this.deletedLists = null;
        }
        this.setChanged(false);
    }

    private final boolean addListIsGood() {
        Vector vector = this.listEditor.getAddList();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)vector.elementAt(n2);
                if (!this.listEditor.validItem(string)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean save() {
        if (!this.addListIsGood()) {
            return false;
        }
        this.core.saveEditedBuddyLists(this.newListNames, this.oldListNames, this.deletedLists, this.addedBuddies, this.deletedBuddies);
        this.reset();
        this.listIndex = this.getListIndex();
        this.setListValues(this.listIndex);
        return true;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setListValues(int n) {
        this.listEditor.clear();
        if (n != -1) {
            if (this.buddyNames[n] == null) {
                this.buddyNames[n] = this.core.getBuddyVector(this.oldListNames[n]);
            }
            this.listEditor.setValues(this.buddyNames[n]);
            this.listEditor.setAddList(this.addedBuddies[n]);
            this.listEditor.setDeleteList(this.deletedBuddies[n]);
            return;
        }
        this.listEditor.setValues((String[])null);
        this.listEditor.setAddList(null);
        this.listEditor.setDeleteList(null);
    }

    public void setStateEmpty() {
        this.listEditor.setEnabled(false);
        this.renameListButton.setEnabled(false);
        this.deleteListButton.setEnabled(false);
        if (this.listChoice.getItemCount() == 0) {
            this.listChoice.addItem(BLANKS);
        }
    }

    public void setStateNonEmpty() {
        String string;
        this.listEditor.setEnabled(true);
        this.renameListButton.setEnabled(true);
        this.deleteListButton.setEnabled(true);
        if (this.listChoice.getItemCount() == 1 && (string = this.listChoice.getItem(0)).equals(BLANKS)) {
            this.listChoice.remove(BLANKS);
        }
    }

    public void setValues() {
        this.reset();
        if (this.oldListNames != null && this.oldListNames.length > 0) {
            this.setStateNonEmpty();
            int n = 0;
            while (n < this.oldListNames.length) {
                this.listChoice.addItem(this.oldListNames[n]);
                ++n;
            }
            this.setListValues(this.listIndex);
        } else {
            this.setStateEmpty();
        }
        this.listIndex = this.getListIndex();
    }

    private void updateListBuddies(int n) {
        if (n != -1) {
            this.buddyNames[n] = this.cloneOrNull(this.listEditor.getListVector());
            this.addedBuddies[n] = this.cloneOrNull(this.listEditor.getAddList());
            this.deletedBuddies[n] = this.cloneOrNull(this.listEditor.getDeleteList());
            if (this.addedBuddies[n] != null && this.addedBuddies[n].size() > 0 || this.deletedBuddies[n] != null && this.deletedBuddies[n].size() > 0) {
                this.setChanged(true);
            }
        }
    }

    static {
        NEW_BUDDY_LIST_CHOICE = 1;
        RENAME_BUDDY_LIST_CHOICE = 2;
    }
}

