/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BrowserProps;
import component.ExportProps;
import component.FolderInfo;
import component.Folders;
import component.ImportProps;
import component.SetupListener;
import component.SetupUI;
import component.Tool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import main.Oscar;
import module.Module;
import module.Modules;
import uiutil.IUtil;
import uiutil.Icon;
import uiutil.ImagePanel;
import uiutil.MultiLineLabel;
import uiutil.OFrame;
import uiutil.TransparentPanel;
import uiutil.UIPack;
import util.JUtil;

public class OscarSetup
extends OFrame
implements ItemListener,
WindowListener {
    private Font plainFont;
    private SetupListener listener;
    private Tools tools;
    private SetupUI setupUI;
    private List setupList;
    private MultiLineLabel label;
    private String IMPORT_EXPORT = "Import / Export";
    private boolean importExportExists = false;
    private boolean browserExists = false;
    private final String BROWSER = "Browser";
    Hashtable groups = new Hashtable(11);

    public OscarSetup(SetupListener setupListener, Tools tools) {
        this(setupListener, tools, null, 0);
    }

    public OscarSetup(SetupListener setupListener, Tools tools, Tool tool, int n) {
        ((Component)this).setBackground(Oscar.backgroundColor);
        this.setResizable(true);
        this.listener = setupListener;
        this.tools = tools;
        this.setTitle("Setup");
        this.setLayout(new BorderLayout());
        ImagePanel imagePanel = new ImagePanel("main");
        this.add("Center", imagePanel);
        Tool tool2 = tools.get("Buddy List");
        Image image = Oscar.images.getImage(tool2, Oscar.BG_TILE, imagePanel, true);
        imagePanel.setTile(image);
        imagePanel.setLayout(new BorderLayout(10, 10));
        ImagePanel imagePanel2 = new ImagePanel("left");
        imagePanel.add("Center", imagePanel2);
        imagePanel2.setBackground(Color.white);
        imagePanel2.setLayout(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel("panel");
        imagePanel2.add("North", transparentPanel);
        transparentPanel.setLayout(new BorderLayout());
        Icon icon = new Icon(Oscar.images.getImage(tool2, "Setup", imagePanel2, false));
        transparentPanel.add("North", icon);
        this.label = new MultiLineLabel("Click to select the tool.", MultiLineLabel.CENTER, 5, 5);
        transparentPanel.add("South", this.label);
        this.setupList = new List(5, false);
        imagePanel2.add("Center", this.setupList);
        this.setupList.addItemListener(this);
        this.setupUI = new SetupUI(this, tools, tool2, image);
        imagePanel.add("East", this.setupUI);
        this.fillSetupList(this.setupList);
        if (tool == null) {
            tool = tool2;
            n = 0;
        }
        this.show(tool, n);
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void addNotify() {
        super.addNotify();
        Font font = this.getFont();
        this.plainFont = new Font(font.getName(), 0, font.getSize());
        this.label.setFont(this.plainFont);
    }

    private Folders configureImportExport(Tool tool) {
        FolderInfo[] folderInfoArray = new FolderInfo[]{new FolderInfo(tool, 0, this.IMPORT_EXPORT, "Export", new ExportProps(this, this.tools, this.setupUI), true), new FolderInfo(tool, 1, this.IMPORT_EXPORT, "Import", new ImportProps(this, this.tools, this.setupUI), true)};
        return new Folders(this.setupUI, tool, folderInfoArray, 0);
    }

    private Folders configureBrowser(Tool tool) {
        FolderInfo[] folderInfoArray = new FolderInfo[]{new FolderInfo(tool, 0, "Browser", "Browser", new BrowserProps(this, this.setupUI), true)};
        return new Folders(this.setupUI, tool, folderInfoArray, 0);
    }

    private void editAction() {
        Folders folders;
        String string = this.setupList.getSelectedItem();
        if (string == null) {
            return;
        }
        if (string.equals(this.IMPORT_EXPORT) && !this.importExportExists) {
            folders = this.configureImportExport(Oscar.permit);
            this.setupUI.addFolders(this.IMPORT_EXPORT, folders);
            this.importExportExists = true;
        }
        if (string.equals("Browser") && !this.browserExists) {
            folders = this.configureBrowser(Oscar.permit);
            this.setupUI.addFolders("Browser", folders);
            this.browserExists = true;
        }
        this.setupUI.showFolders(string, 0);
    }

    Folders getFolders(String string) {
        return (Folders)this.groups.get(string);
    }

    private void fillSetupList(List list) {
        Object object;
        int n;
        Object object2;
        Module module;
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>(11);
        Enumeration enumeration = this.tools.elements();
        while (enumeration.hasMoreElements()) {
            module = (Tool)enumeration.nextElement();
            object2 = module.configure(this.setupUI);
            if (object2 == null) continue;
            n = 0;
            while (n < ((FolderInfo[])object2).length) {
                object = (Vector)hashtable.get(object2[n].getGroupName());
                if (object == null) {
                    object = new Vector<Object>(4);
                    hashtable.put(((FolderInfo)object2[n]).getGroupName(), (Serializable)object);
                }
                ((Vector)object).addElement(object2[n]);
                if (!IUtil.inList(((FolderInfo)object2[n]).getGroupName(), list)) {
                    list.addItem(((FolderInfo)object2[n]).getGroupName());
                }
                ++n;
            }
        }
        enumeration = Modules.elements();
        while (enumeration.hasMoreElements()) {
            module = (Module)enumeration.nextElement();
            object2 = module.configure(this.setupUI);
            if (object2 == null) continue;
            n = 0;
            while (n < ((FolderInfo[])object2).length) {
                object = object2[n];
                if (object != null) {
                    Vector<Serializable> vector = (Vector<Serializable>)hashtable.get(((FolderInfo)object).getGroupName());
                    if (vector == null) {
                        vector = new Vector<Serializable>(4);
                        hashtable.put(((FolderInfo)object).getGroupName(), vector);
                    }
                    vector.addElement((Serializable)object);
                    if (!IUtil.inList(((FolderInfo)object).getGroupName(), list)) {
                        list.addItem(((FolderInfo)object).getGroupName());
                    }
                }
                ++n;
            }
        }
        module = this.tools.get("Buddy List");
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Vector)enumeration.nextElement();
            Object[] objectArray = new FolderInfo[((Vector)object2).size()];
            ((Vector)object2).copyInto(objectArray);
            object = new Folders(this.setupUI, (UIPack)((Object)module), (FolderInfo[])objectArray, 0);
            this.groups.put(((FolderInfo)objectArray[0]).getGroupName(), object);
        }
        boolean bl = JUtil.isTrue(Oscar.config.getValue("debug.importexport"));
        if (bl) {
            list.addItem(this.IMPORT_EXPORT);
        }
        list.addItem("Browser");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.setupList)) {
            this.editAction();
        }
    }

    public void selectToolName(String string) {
        int n = this.setupList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.setupList.getItem(n2);
            if (string2.equals(string)) {
                this.setupList.select(n2);
                return;
            }
            ++n2;
        }
    }

    public void show(Tool tool, int n) {
        String string = tool.getName();
        this.setupUI.showFolders(string, n);
        this.selectToolName(string);
    }

    public void removeNotify() {
        this.removeAll();
        this.plainFont = null;
        if (this.listener != null) {
            this.listener.setupDisposed();
            this.listener = null;
        }
        this.tools = null;
        this.setupUI = null;
        this.setupList = null;
        this.label = null;
        this.IMPORT_EXPORT = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setupUI.cancelAction();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

