/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Hashtable;
import java.util.Vector;
import main.RegistryEntry;
import snac.Listener;
import snac.SnacHandler;
import uiutil.ErrorMgr;

class Registry {
    Vector entries = new Vector();

    Registry() {
    }

    public String toString() {
        String string = "Registry: ";
        if (this.entries == null || this.entries.size() == 0) {
            string = String.valueOf(string) + "with no entries";
        } else {
            int n = 0;
            while (n < this.entries.size()) {
                RegistryEntry registryEntry = (RegistryEntry)this.entries.elementAt(n);
                string = String.valueOf(string) + registryEntry.toString() + " ";
                ++n;
            }
        }
        return string;
    }

    public int[] familyArray() {
        int[] nArray = new int[this.entries.size()];
        int n = 0;
        while (n < this.entries.size()) {
            RegistryEntry registryEntry = (RegistryEntry)this.entries.elementAt(n);
            nArray[n] = registryEntry.family;
            ++n;
        }
        return nArray;
    }

    public Vector listeners() {
        Hashtable hashtable = new Hashtable(this.entries.size());
        Vector vector = new Vector();
        int n = 0;
        while (n < this.entries.size()) {
            RegistryEntry registryEntry = (RegistryEntry)this.entries.elementAt(n);
            int n2 = 0;
            while (registryEntry.listeners != null && n2 < registryEntry.listeners.size()) {
                Object e = registryEntry.listeners.elementAt(n2);
                if (hashtable.get(e) == null) {
                    vector.addElement(e);
                    hashtable.put(e, e);
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public void registerSNACHandler(int n, int n2, SnacHandler snacHandler) {
        RegistryEntry registryEntry = this.lookupEntryCreateIfNecessary(n);
        if (n2 > registryEntry.version) {
            registryEntry.family = n;
            registryEntry.version = n2;
            registryEntry.handler = snacHandler;
            registryEntry.listeners = null;
        }
    }

    public void registerListener(int n, int n2, Listener listener) {
        RegistryEntry registryEntry = this.lookupEntryCreateIfNecessary(n);
        if (registryEntry.listeners == null) {
            registryEntry.listeners = new Vector();
        }
        registryEntry.listeners.addElement(listener);
    }

    public RegistryEntry lookupEntry(int n) {
        int n2 = this.lookupEntryInternal(n);
        if (n2 == -1) {
            ErrorMgr.warn("Registry", "no entry for group " + n);
            return null;
        }
        return (RegistryEntry)this.entries.elementAt(n2);
    }

    private int lookupEntryInternal(int n) {
        int n2 = 0;
        while (n2 < this.entries.size()) {
            RegistryEntry registryEntry = (RegistryEntry)this.entries.elementAt(n2);
            if (registryEntry.family == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public RegistryEntry lookupEntryCreateIfNecessary(int n) {
        RegistryEntry registryEntry;
        int n2 = this.lookupEntryInternal(n);
        if (n2 == -1) {
            registryEntry = new RegistryEntry();
            registryEntry.family = n;
            registryEntry.version = -1;
            registryEntry.listeners = null;
            this.entries.addElement(registryEntry);
        } else {
            registryEntry = (RegistryEntry)this.entries.elementAt(n2);
        }
        return registryEntry;
    }
}

