/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import snac.SnacConstants;

public class SnacNickname
implements SnacConstants {
    private static final String MODULE = "SNAC";
    public int length;
    public byte[] data;

    public SnacNickname(int n, byte[] byArray) {
        this.length = n;
        this.data = byArray;
    }

    SnacNickname(DataInputStream dataInputStream) throws IOException {
        this.length = dataInputStream.readUnsignedByte();
        if (this.length < 1 || this.length > 32) {
            throw new IOException("length bad value " + this.length);
        }
        int n = dataInputStream.available();
        if (n < this.length) {
            throw new IOException("read underflow");
        }
        this.data = new byte[this.length];
        if (this.length > 0) {
            dataInputStream.read(this.data, 0, this.length);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        if (this.length < 1 || this.length > 32) {
            throw new IOException("length bad value " + this.length);
        }
        dataOutputStream.writeByte(this.length);
        if (this.data.length < this.length) {
            throw new IOException("write underflow");
        }
        if (this.data.length > this.length) {
            throw new IOException("write overflow");
        }
        dataOutputStream.write(this.data, 0, this.data.length);
    }
}

