/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.ShutdownListener;
import util.JUtil;
import util.Log;
import util.Timer;
import util.TimerListener;

public class ErrorMgr
implements ChoiceListener,
TimerListener {
    private static boolean inited;
    private static String appName;
    private static String errorSound;
    private static String warningSound;
    private static ShutdownListener shutdownListener;
    private static int fatalExitCode;
    private static String exit;
    private static String details;
    private static String FATAL;
    private static String WARN;
    private static int EXIT_EVENT;
    private static int FATAL_CHOICE;
    private static int WARN_CHOICE;
    private Exception exception;

    public static void initErrorMgr(String string, String string2, String string3, ShutdownListener shutdownListener, int n) {
        if (inited) {
            return;
        }
        appName = string;
        errorSound = string2;
        warningSound = string3;
        ErrorMgr.shutdownListener = shutdownListener;
        fatalExitCode = n;
        inited = true;
    }

    public static void error(String string, String string2, Exception exception) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (exception == null) {
            exception = new Exception("Erorr Stack Trace");
        }
        Log.log(string, Log.ERROR, string2, exception);
        ChoiceUI.newChoiceUI(new ErrorMgr(exception), FATAL_CHOICE, null, ErrorMgr.title(FATAL, string), string2, exit, details, null, errorSound);
    }

    public static void error(String string, String string2) {
        ErrorMgr.error(string, string2, new Exception("Erorr Stack Trace"));
    }

    public static void warn(String string, String string2, Exception exception) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (exception == null) {
            exception = new Exception("Warn Stack Trace");
        }
        Log.log(string, Log.WARNING, string2, exception);
        ChoiceUI.newChoiceUI(new ErrorMgr(exception), WARN_CHOICE, null, ErrorMgr.title(WARN, string), string2, "OK", details, null, warningSound);
    }

    public static void warn(String string, String string2) {
        ErrorMgr.warn(string, string2, new Exception("Warn Stack Trace"));
    }

    public static void diag(String string, int n, String string2, Exception exception) {
        Log.log(string, n, string2, exception);
    }

    public static void diag(String string, int n, String string2) {
        ErrorMgr.diag(string, n, string2, null);
    }

    public static void diag(String string, String string2, Exception exception) {
        ErrorMgr.diag(string, Log.INFO, string2, exception);
    }

    public static void diag(String string, String string2) {
        ErrorMgr.diag(string, Log.INFO, string2, null);
    }

    private static String title(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (appName != null) {
            return String.valueOf(appName) + " " + string + ": " + string2;
        }
        return String.valueOf(string) + ": " + string2;
    }

    private ErrorMgr(Exception exception) {
        this.exception = exception;
    }

    private void displayDetails(Exception exception) {
        if (exception != null) {
            ChoiceUI.newChoiceUI("Details", "Here is the java stack trace, it is also reported in the log:\n" + JUtil.stackTrace(exception));
            return;
        }
        ChoiceUI.newChoiceUI("Details", "Sorry, there were no details to report.");
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n == FATAL_CHOICE) {
            if (n2 == 0 || n2 == -1) {
                this.exit();
                return;
            }
            if (n2 == 1) {
                this.displayDetails(this.exception);
                this.exit();
                return;
            }
        } else if (n == WARN_CHOICE && n2 == 1) {
            this.displayDetails(this.exception);
        }
    }

    private void exit() {
        int n = 100000;
        Timer.createEvent("Error", this, EXIT_EVENT, null, n);
        if (shutdownListener != null) {
            shutdownListener.shutdown(fatalExitCode);
        }
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == EXIT_EVENT) {
            System.exit(1);
        }
    }

    static {
        appName = null;
        errorSound = null;
        warningSound = null;
        shutdownListener = null;
        fatalExitCode = 1;
        exit = "Exit";
        details = "";
        FATAL = "Fatal Error";
        WARN = "Alert";
        WARN_CHOICE = 1;
    }
}

