/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn;

import java.awt.Point;
import java.awt.Window;
import rath.NotSupportedPlatformException;
import rath.jmsn.MainFrame;
import rath.tools.Win32Toolkit;
import rath.tools.tray.TrayEventAdapter;
import rath.tools.tray.TrayIcon;
import rath.tools.tray.TrayIconManager;

public class NativeToolkit {
    private static NativeToolkit tk = null;
    private Win32Toolkit win32tk;
    private TrayIconManager tim;
    public boolean isWin9x;
    public boolean isWin2k;
    public boolean isWindows;
    public boolean isMacOS;

    private NativeToolkit() {
        this.prepareWindows();
        this.prepareMacOSX();
    }

    private void prepareWindows() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows 9") || os.startsWith("Windows N")) {
            try {
                this.win32tk = Win32Toolkit.getInstance();
                this.isWin9x = true;
                this.isWindows = true;
            }
            catch (NotSupportedPlatformException e) {
            }
            catch (UnsatisfiedLinkError e) {}
        } else {
            try {
                this.win32tk = Win32Toolkit.getInstance();
                this.isWin2k = true;
                this.isWindows = true;
            }
            catch (NotSupportedPlatformException e) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        if (os.startsWith("Windows") && this.win32tk != null) {
            this.tim = new TrayIconManager(this.win32tk);
        }
    }

    private void prepareMacOSX() {
        this.isMacOS = false;
    }

    public void makeTransparency(Window window, int alpha) {
        if (this.isWin2k) {
            this.win32tk.makeTransparency(window, alpha);
        }
    }

    public void makeTopMost(Window window, boolean enable) {
        if (this.isWindows) {
            this.win32tk.makeTopMost(window, enable);
        }
    }

    public void addTrayIcon(TrayIcon icon) {
        if (this.isWin9x || this.isWin2k) {
            this.tim.addTrayIcon(icon, new TrayEventAdapter(){

                public void mouseDblClicked(Point p) {
                    MainFrame.INSTANCE.show();
                }
            });
        }
    }

    public void setTrayIcon(TrayIcon icon, int field) {
        if (this.isWindows) {
            this.tim.modifyTrayIcon(icon, field);
        }
    }

    public static synchronized NativeToolkit getInstance() {
        if (tk == null) {
            tk = new NativeToolkit();
        }
        return tk;
    }
}

