/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.file;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.DialogAppender;
import rath.jmsn.util.Msg;
import rath.msnm.ftp.VolatileTransfer;
import rath.msnm.msg.MimeMessage;

public class FileProgress
extends JProgressBar
implements ActionListener {
    private VolatileTransfer transfer;
    private DialogAppender appender;
    private Timer timer = null;
    private int oldValue;

    public FileProgress(DialogAppender appender) {
        super(0, 100);
        this.setFont(ToolBox.FONT);
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.appender = appender;
        this.timer = new Timer(500, this);
        this.setStringPainted(true);
        this.setPreferredSize(new Dimension(80, 20));
    }

    public void setTransfer(VolatileTransfer transfer) {
        this.transfer = transfer;
        this.timer.start();
        this.setToolTipText(transfer.getFilename());
    }

    public void actionPerformed(ActionEvent e) {
        int percent = this.transfer.getCommitPercent();
        if (this.oldValue != percent) {
            this.oldValue = percent;
            this.setValue(percent);
            this.setString(percent + "%");
            if (percent == 100) {
                this.timer.stop();
                this.processEnded();
            }
        }
    }

    private void processEnded() {
        final FileProgress me = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanel panel = (JPanel)FileProgress.this.getParent();
                if (panel != null) {
                    panel.remove(me);
                    panel.doLayout();
                    panel.validate();
                    panel.repaint();
                }
            }
        });
        MimeMessage msg = new MimeMessage();
        msg.setMessage(Msg.get("file.transfer.complete", this.transfer.getFilename()));
        this.appender.appendMessage(msg);
    }
}

