/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.Res;
import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.SingletonDataSetManager;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.util.BlackBox;
import borland.jbcl.util.Variant;
import borland.jbcl.view.CheckboxView;

public class CheckboxControl
extends CheckboxView
implements NavigationListener,
AccessListener,
WritableSingletonModel,
BlackBox {
    private DataSet dataSet;
    private String columnName;
    private boolean initialized = false;

    public CheckboxControl() {
        this.setModel(new BasicSingletonContainer());
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(67));
        }
        super.setModel(singletonModel);
    }

    public void setChecked(boolean bl) {
        boolean bl2;
        if (!this.isReadOnly() && (bl2 = this.isChecked()) != bl) {
            Object object = this.get();
            if (object instanceof Variant) {
                switch (((Variant)object).getType()) {
                    case 11: {
                        ((Variant)object).setBoolean(bl);
                        this.set(object);
                        break;
                    }
                    case 16: {
                        ((Variant)object).setString(String.valueOf(bl));
                        this.set(object);
                        break;
                    }
                    case 2: {
                        ((Variant)object).setByte(bl ? 1 : 0);
                        this.set(object);
                        break;
                    }
                    case 3: {
                        ((Variant)object).setShort((short)(bl ? 1 : 0));
                        this.set(object);
                        break;
                    }
                    case 4: {
                        ((Variant)object).setInt(bl ? 1 : 0);
                        this.set(object);
                        break;
                    }
                    case 5: {
                        ((Variant)object).setLong(bl ? 1 : 0);
                        this.set(object);
                        break;
                    }
                    case 6: {
                        ((Variant)object).setFloat(bl ? 1 : 0);
                        this.set(object);
                        break;
                    }
                    case 7: {
                        ((Variant)object).setDouble(bl ? 1 : 0);
                        this.set(object);
                        break;
                    }
                }
            } else {
                super.setChecked(bl);
            }
        }
    }

    public boolean isChecked() {
        Object object = this.get();
        if (object instanceof Variant) {
            switch (((Variant)object).getType()) {
                case 11: {
                    return ((Variant)object).getBoolean();
                }
                case 16: {
                    return Boolean.valueOf(((Variant)object).getString());
                }
                case 2: {
                    return ((Variant)object).getByte() != 0;
                }
                case 3: {
                    return ((Variant)object).getShort() != 0;
                }
                case 4: {
                    return ((Variant)object).getInt() != 0;
                }
                case 5: {
                    return ((Variant)object).getLong() != (long)0;
                }
                case 6: {
                    return ((Variant)object).getFloat() != 0.0f;
                }
                case 7: {
                    return ((Variant)object).getDouble() != 0.0;
                }
            }
            return false;
        }
        return super.isChecked();
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.openDataSet(dataSet);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.initialized) {
            this.bindDataSet();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeAccessListener(this);
        }
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
        } else if (this.initialized || this.dataSet.isOpen()) {
            if (!this.dataSet.isOpen()) {
                try {
                    this.dataSet.open();
                }
                catch (DataSetException dataSetException) {
                    DataSetException.handleException(this.dataSet, this, dataSetException);
                    this.setModel(new BasicSingletonContainer());
                    return;
                }
                this.initialized = true;
            }
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column));
        }
    }

    public Object get() {
        return this.getModel().get();
    }

    public boolean canSet(boolean bl) {
        return this.isReadOnly() ? false : this.getWriteModel().canSet(bl);
    }

    public void set(Object object) {
        if (!this.isReadOnly()) {
            this.getWriteModel().set(object);
        }
    }

    public void touched() {
        this.getWriteModel().touched();
    }

    public void enableModelEvents(boolean bl) {
        this.getWriteModel().enableModelEvents(bl);
    }
}

