/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import COM.objectspace.jgl.Array;
import borland.jbcl.control.MessageDialog;
import borland.jbcl.control.Res;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class Message
implements WindowListener {
    public static final int OK = 1;
    public static final int YES = 2;
    public static final int NO = 4;
    public static final int CANCEL = 8;
    public static final int OK_CANCEL = 9;
    public static final int YES_NO = 6;
    public static final int YES_NO_CANCEL = 14;
    protected MessageDialog dialog;
    protected Frame frame;
    protected String title;
    protected String message;
    protected int buttonSet = 1;
    protected String[] labels;
    protected int result;
    protected Array listeners = new Array();

    public Message(Frame frame, String string, String string2) {
        this.frame = frame;
        this.title = string;
        this.message = string2;
        if (frame != null) {
            this.dialog = new MessageDialog(frame, string, string2);
            this.dialog.addWindowListener(this);
        }
    }

    public Message(Frame frame, String string) {
        this(frame, string, "");
    }

    public Message(Frame frame) {
        this(frame, "", "");
    }

    public Message() {
        this(null, "", "");
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.dialog != null) {
            this.dialog.setTitle(string);
        }
    }

    public String getTitle() {
        if (this.dialog != null) {
            this.title = this.dialog.getTitle();
        }
        return this.title;
    }

    public void setMessage(String string) {
        this.message = string;
        if (this.dialog != null) {
            this.dialog.setMessage(string);
        }
    }

    public String getMessage() {
        if (this.dialog != null) {
            this.message = this.dialog.getMessage();
        }
        return this.message;
    }

    public void setButtonSet(int n) {
        if (n != this.buttonSet) {
            this.buttonSet = n;
            if (this.dialog != null) {
                this.dialog.setButtonSet(n);
            }
        }
    }

    public int getButtonSet() {
        return this.buttonSet;
    }

    public void setLabels(String[] stringArray) {
        this.labels = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.labels, 0, stringArray.length);
        if (this.dialog != null) {
            this.dialog.setLabels(stringArray);
        }
    }

    public String[] getLabels() {
        if (this.dialog != null) {
            this.labels = this.dialog.getLabels();
        }
        return this.labels;
    }

    public void setResult(int n) {
        this.result = n;
        if (this.dialog != null) {
            this.dialog.setResult(this.result);
        }
    }

    public int getResult() {
        if (this.dialog != null) {
            this.result = this.dialog.getResult();
        }
        return this.result;
    }

    public void show() {
        this.setVisible(true);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.dialog == null) {
                if (this.frame == null) {
                    throw new IllegalStateException(Res.getString(63));
                }
                this.dialog = new MessageDialog(this.frame, this.title, this.message);
                if (this.buttonSet >= 0) {
                    this.dialog.setButtonSet(this.buttonSet);
                }
                if (this.labels != null) {
                    this.dialog.setLabels(this.labels);
                }
                this.dialog.setResult(this.result);
                this.dialog.addWindowListener(this);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.dialog.addActionListener((ActionListener)this.listeners.at(i));
                }
            }
            this.dialog.pack();
            this.dialog.show();
        } else if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.dialog != null) {
            this.dialog.addActionListener(actionListener);
        } else {
            this.listeners.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.dialog != null) {
            this.dialog.removeActionListener(actionListener);
        } else {
            this.listeners.remove(actionListener);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.result = this.dialog.getResult();
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (this.dialog != null) {
            this.result = this.dialog.getResult();
        }
        this.dialog = null;
        if (this.frame.isShowing()) {
            if (this.frame.getFocusOwner() != null) {
                this.frame.getFocusOwner().requestFocus();
            } else {
                this.frame.requestFocus();
            }
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

