/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.DataColumn;
import borland.jbcl.dataset.NullState;
import borland.jbcl.util.Variant;
import java.math.BigDecimal;

class BigDecimalColumn
extends DataColumn {
    private BigDecimal[] vector = new BigDecimal[16];

    public BigDecimalColumn(NullState nullState) {
        super(nullState);
        this.vectorLength = this.vector.length;
    }

    final void copy(int n, int n2) {
        this.vector[n2] = this.vector[n];
        if (this.hasNulls) {
            this.nullState.copy(n, n2, this.nullMask);
        }
    }

    protected final void grow(int n) {
        BigDecimal[] bigDecimalArray = new BigDecimal[n];
        System.arraycopy(this.vector, 0, bigDecimalArray, 0, this.vectorLength);
        this.vector = bigDecimalArray;
        this.vectorLength = this.vector.length;
    }

    final int compare(int n, int n2) {
        if (this.hasNulls && (this.comp = this.nullState.compare(n, n2, this.nullMask)) != 0) {
            return this.comp;
        }
        return this.vector[n].compareTo(this.vector[n2]);
    }

    final int compareIgnoreCase(int n, int n2) {
        return this.compare(n, n2);
    }

    final void getVariant(int n, Variant variant) {
        if (this.hasNulls && this.vector[n] == DataColumn.nullBigDecimal) {
            this.nullState.getNull(n, variant, this.nullMask, this.assignedMask);
        } else {
            variant.setBigDecimal(this.vector[n]);
        }
    }

    final void setVariant(int n, Variant variant) {
        if (variant.isNull()) {
            this.vector[n] = DataColumn.nullBigDecimal;
            this.setNull(n, variant.getType());
        } else {
            if (this.hasNulls) {
                int n2 = n;
                this.nullState.vector[n2] = (byte)(this.nullState.vector[n2] & ~this.nullMask);
            }
            this.vector[n] = variant.getBigDecimal();
        }
    }
}

