/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.DataColumn;

class KeyComparator {
    int leftPivot;
    int rightPivot;
    int pivotRow;
    int pivotDataRow;
    int comp;
    boolean caseInsensitive;
    private boolean referenceCopy;
    private int columnCount;
    private DataColumn firstColumn;
    private int[] indexVector;
    private KeyComparator keyComparator;
    private DataColumn[] dataColumns;

    KeyComparator(int[] nArray, DataColumn[] dataColumnArray, boolean bl) {
        this.dataColumns = dataColumnArray;
        this.indexVector = nArray;
        this.firstColumn = dataColumnArray[0];
        this.columnCount = dataColumnArray.length;
        this.caseInsensitive = bl;
        if (!bl) {
            this.enableReferenceCopy();
        }
    }

    final void setIndexVector(int[] nArray) {
        this.indexVector = nArray;
    }

    private final void printIndexVector() {
    }

    protected final int compare(int n, int n2) {
        this.comp = this.caseInsensitive ? this.firstColumn.compareIgnoreCase(n, n2) : this.firstColumn.compare(n, n2);
        if (this.comp == 0) {
            this.secondaryCompare(this.columnCount, n, n2, true);
        }
        return this.comp;
    }

    protected final int searchCompare(int n, int n2, int n3) {
        this.comp = this.caseInsensitive ? this.firstColumn.compareIgnoreCase(n2, n3) : this.firstColumn.compare(n2, n3);
        if (this.comp == 0) {
            this.secondaryCompare(n, n2, n3, false);
        }
        return this.comp;
    }

    private final void secondaryCompare(int n, int n2, int n3, boolean bl) {
        if (n > 1) {
            for (int i = 1; this.comp == 0 && i < n; ++i) {
                this.comp = this.caseInsensitive ? this.dataColumns[i].compareIgnoreCase(n2, n3) : this.dataColumns[i].compare(n2, n3);
            }
        }
        if (this.comp == 0) {
            if (this.referenceCopy) {
                if (n2 > n3) {
                    this.firstColumn.copyReference(n2, n3);
                } else {
                    this.firstColumn.copyReference(n3, n2);
                }
            }
            if (bl) {
                this.comp = n2 - n3;
            }
        }
    }

    final void setPivot(int n) {
        this.pivotRow = n;
        this.pivotDataRow = this.indexVector[n];
        this.firstColumn.setPivot(this.indexVector, this.pivotDataRow);
    }

    final void findPivots(int n, int n2) {
        this.leftPivot = n;
        this.rightPivot = n2;
        do {
            this.leftPivot = this.firstColumn.forwardCompare(this.leftPivot, this.caseInsensitive);
            this.comp = this.firstColumn.comp;
            if (this.comp > 0) break;
            this.secondaryCompare(this.columnCount, this.indexVector[this.leftPivot], this.pivotDataRow, true);
        } while (this.comp < 0);
        do {
            this.rightPivot = this.firstColumn.reverseCompare(this.rightPivot, this.caseInsensitive);
            this.comp = this.firstColumn.comp;
            if (this.comp < 0) break;
            this.secondaryCompare(this.columnCount, this.indexVector[this.rightPivot], this.pivotDataRow, true);
        } while (this.comp > 0);
    }

    void reverseLimitedCompare() {
        if (this.caseInsensitive) {
            while (--this.rightPivot > -1 && (this.comp = this.firstColumn.compareIgnoreCase(this.indexVector[this.rightPivot], this.pivotDataRow)) > 0) {
            }
        } else {
            while (--this.rightPivot > -1 && (this.comp = this.firstColumn.compare(this.indexVector[this.rightPivot], this.pivotDataRow)) > 0) {
            }
        }
    }

    final int findInsertPoint(int n) {
        this.setPivot(n);
        this.rightPivot = n;
        do {
            this.reverseLimitedCompare();
            if (this.comp < 0 || this.rightPivot < 0) break;
            this.secondaryCompare(this.columnCount, this.indexVector[this.rightPivot], this.pivotDataRow, true);
        } while (this.comp > 0);
        return this.rightPivot + 1;
    }

    final void enableReferenceCopy() {
        this.referenceCopy = this.firstColumn.immutable;
    }

    final void disableReferenceCopy() {
        this.referenceCopy = false;
    }
}

