/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.AggManager;
import borland.jbcl.dataset.BigDecimalColumn;
import borland.jbcl.dataset.BinaryStreamColumn;
import borland.jbcl.dataset.BooleanColumn;
import borland.jbcl.dataset.ByteColumn;
import borland.jbcl.dataset.CalcPlaceHolderColumn;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataColumn;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.DateColumn;
import borland.jbcl.dataset.DirectIndex;
import borland.jbcl.dataset.DoubleColumn;
import borland.jbcl.dataset.FloatColumn;
import borland.jbcl.dataset.IntColumn;
import borland.jbcl.dataset.InternalRow;
import borland.jbcl.dataset.LocaleStringColumn;
import borland.jbcl.dataset.LongColumn;
import borland.jbcl.dataset.MatrixData;
import borland.jbcl.dataset.MemoryIndex;
import borland.jbcl.dataset.NullState;
import borland.jbcl.dataset.RowFilterListener;
import borland.jbcl.dataset.ShortColumn;
import borland.jbcl.dataset.SortDescriptor;
import borland.jbcl.dataset.SortedMemoryIndex;
import borland.jbcl.dataset.StorageDataSet;
import borland.jbcl.dataset.StringColumn;
import borland.jbcl.dataset.TimeColumn;
import borland.jbcl.dataset.TimestampColumn;
import borland.jbcl.util.Variant;

class MemoryData
extends MatrixData {
    private IntColumn statusColumn = new IntColumn(null);
    private IntColumn originalColumn;
    private DataColumn[] dataColumns = new DataColumn[0];
    private int rowCount = 1;
    private NullState nullState;
    private boolean needsRecalc = true;

    MemoryData() {
    }

    public final void addColumn(Column column) throws DataSetException {
        if (!this.validColumnType(column.getDataType())) {
            DataSetException.throwInvalidColumnType(column.getDataType());
        }
        this.needsRecalc = true;
        int n = this.dataColumns == null ? 1 : this.dataColumns.length + 1;
        DataColumn[] dataColumnArray = new DataColumn[n];
        if (n > 1) {
            System.arraycopy(this.dataColumns, 0, dataColumnArray, 0, n - 1);
        }
        dataColumnArray[n - 1] = this.createColumnStorage(column, this.allocateNullState());
        if (n > 1) {
            dataColumnArray[n - 1].growTo(dataColumnArray[0].vectorLength, this.rowCount);
        } else {
            this.rowCount = 1;
        }
        this.dataColumns = dataColumnArray;
        this.freeAllIndexes();
    }

    public void changeColumn(int n, Column column, Column column2) throws DataSetException {
        if (column.dataType != column2.dataType) {
            column2.ordinal = this.dataColumns.length;
            this.addColumn(column2);
            this.dataColumns[column.ordinal] = this.dataColumns[this.dataColumns.length - 1];
            column2.ordinal = column.ordinal;
            this.dropColumn(this.dataColumns.length - 1);
            this.freeAllIndexes();
        }
    }

    public void moveColumn(int n, int n2) throws DataSetException {
        int n3 = this.dataColumns.length;
        DataColumn[] dataColumnArray = new DataColumn[n3];
        DataColumn dataColumn = this.dataColumns[n];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (this.dataColumns[i] == dataColumn) continue;
            if (n4 == n2) {
                // empty if block
            }
            int n5 = ++n4;
            ++n4;
            dataColumnArray[n5] = this.dataColumns[i];
        }
        dataColumnArray[n2] = dataColumn;
        this.dataColumns = dataColumnArray;
        this.freeAllIndexes();
    }

    public void openData(StorageDataSet storageDataSet) throws DataSetException {
        if (this.insertIndex == null) {
            this.insertIndex = this.openIndex(storageDataSet, null, null, 4, 0);
            this.deleteIndex = this.openIndex(storageDataSet, null, null, 1, 0);
            this.updateIndex = this.openIndex(storageDataSet, null, null, 2, 0);
        }
    }

    public final boolean validColumnType(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    private final DataColumn createColumnStorage(Column column, NullState nullState) {
        if (column.getCalcType() == 2) {
            return new CalcPlaceHolderColumn(nullState);
        }
        switch (column.getDataType()) {
            case 16: {
                if (column.getLocale() == null || column.getLocale().getLanguage().equals("en")) {
                    return new StringColumn(nullState);
                }
                return new LocaleStringColumn(nullState, column);
            }
            case 12: {
                return new BinaryStreamColumn(nullState);
            }
            case 2: {
                return new ByteColumn(nullState);
            }
            case 3: {
                return new ShortColumn(nullState);
            }
            case 4: {
                return new IntColumn(nullState);
            }
            case 11: {
                return new BooleanColumn(nullState);
            }
            case 6: {
                return new FloatColumn(nullState);
            }
            case 7: {
                return new DoubleColumn(nullState);
            }
            case 5: {
                return new LongColumn(nullState);
            }
            case 10: {
                return new BigDecimalColumn(nullState);
            }
            case 14: {
                return new TimeColumn(nullState);
            }
            case 15: {
                return new TimestampColumn(nullState);
            }
            case 13: {
                return new DateColumn(nullState);
            }
        }
        return null;
    }

    public void dropColumn(int n) throws DataSetException {
        DataColumn[] dataColumnArray = new DataColumn[this.dataColumns.length - 1];
        this.needsRecalc = true;
        System.arraycopy(this.dataColumns, 0, dataColumnArray, 0, n);
        if (n + 1 < this.dataColumns.length) {
            System.arraycopy(this.dataColumns, n + 1, dataColumnArray, n, this.dataColumns.length - (n + 1));
        }
        this.dataColumns = dataColumnArray;
    }

    NullState allocateNullState() {
        if (this.nullState == null || this.nullState.slot >= 6) {
            this.nullState = new NullState();
            return this.nullState;
        }
        this.nullState.slot += 2;
        return this.nullState;
    }

    public final int getStatus(int n) {
        return this.statusColumn.getInt(n);
    }

    public final void setStatus(int n, int n2) {
        this.statusColumn.setInt(n, n2);
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final int addStoreRow(Variant[] variantArray, int n) throws DataSetException {
        int n2 = this.appendRow();
        this.statusColumn.setInt(n2, n);
        for (int i = 0; i < variantArray.length; ++i) {
            this.dataColumns[i].setVariant(n2, variantArray[i]);
        }
        return n2;
    }

    public final void deleteStoreRow(int n) throws DataSetException {
        this.statusColumn.setInt(n, this.statusColumn.getInt(n) | 1);
    }

    public final void updateStoreRow(int n, Variant[] variantArray, Column[] columnArray) throws DataSetException {
        if (columnArray != null) {
            for (int i = 0; i < columnArray.length; ++i) {
                int n2 = columnArray[i].ordinal;
                this.dataColumns[n2].setVariant(n, variantArray[n2]);
            }
        } else {
            for (int i = 0; i < variantArray.length; ++i) {
                this.dataColumns[i].setVariant(n, variantArray[i]);
            }
        }
    }

    public final void setNeedsRecalc(boolean bl) {
        this.needsRecalc = bl;
    }

    public boolean getNeedsRecalc() {
        return this.needsRecalc;
    }

    public final boolean copyStreams() {
        return true;
    }

    public boolean getNeedsRestructure() {
        return this.needsRecalc;
    }

    public void restructure(StorageDataSet storageDataSet, boolean bl, Column[] columnArray, Variant[] variantArray, AggManager aggManager) throws DataSetException {
        if (bl && this.needsRecalc) {
            this.recalc(storageDataSet, aggManager);
        }
    }

    public final void getVariant(int n, int n2, Variant variant) {
        this.dataColumns[n2].getVariant(n, variant);
    }

    public final void getRowData(int n, Variant[] variantArray) throws DataSetException {
        for (int i = 0; i < this.dataColumns.length; ++i) {
            this.dataColumns[i].getVariant(n, variantArray[i]);
        }
    }

    private final int appendRow() {
        for (int i = 0; i < this.dataColumns.length; ++i) {
            this.dataColumns[i].append();
        }
        this.statusColumn.append();
        return this.rowCount++;
    }

    private final void copyRow(int n, int n2) {
        for (int i = 0; i < this.dataColumns.length; ++i) {
            this.dataColumns[i].copy(n, n2);
        }
    }

    private final void copyValues(int n, Variant[] variantArray) {
        for (int i = 0; i < this.dataColumns.length; ++i) {
            this.dataColumns[i].setVariant(n, variantArray[i]);
        }
    }

    public final void saveStoreRow(int n, int n2) throws DataSetException {
        int n3 = (n2 & 2) != 0 ? this.originalColumn.getInt(n) : this.appendRow();
        this.copyRow(n, n3);
        this.statusColumn.setInt(n3, 16);
        if (this.originalColumn == null) {
            this.originalColumn = new IntColumn(null);
        }
        this.originalColumn.growTo(this.dataColumns[0].vectorLength, this.rowCount);
        this.originalColumn.setInt(n, n3);
    }

    public final DirectIndex createIndex(StorageDataSet storageDataSet, SortDescriptor sortDescriptor, RowFilterListener rowFilterListener, int n, int n2) throws DataSetException {
        InternalRow internalRow = null;
        if (rowFilterListener != null) {
            internalRow = this.getInternalReadRow(storageDataSet);
        }
        MemoryIndex memoryIndex = null;
        if (sortDescriptor != null) {
            int n3;
            int n4 = sortDescriptor.keyCount();
            DataColumn[] dataColumnArray = new DataColumn[n4];
            Column[] columnArray = new Column[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                Column column = storageDataSet.getColumn(sortDescriptor.getKeys()[n3]);
                if (!column.isSortable()) {
                    DataSetException.throwNotSortable();
                }
                columnArray[n3] = column;
                dataColumnArray[n3] = this.dataColumns[column.ordinal];
            }
            if (n4 > 0 && n3 >= n4) {
                memoryIndex = new SortedMemoryIndex(sortDescriptor, rowFilterListener, internalRow, this, this.dataColumns, n, n2, this.statusColumn, dataColumnArray, columnArray);
            }
        }
        if (memoryIndex == null) {
            memoryIndex = new MemoryIndex(sortDescriptor, rowFilterListener, internalRow, this, this.dataColumns, n, n2, this.statusColumn);
        }
        return memoryIndex;
    }

    public final void getOriginalRow(int n, Variant[] variantArray) throws DataSetException {
        this.getRowData(this.originalColumn.getInt(n), variantArray);
    }
}

