/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.SingletonModelEvent;
import borland.jbcl.model.SingletonModelListener;
import borland.jbcl.model.SingletonModelMulticaster;
import borland.jbcl.model.SingletonViewManager;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.view.BeanPanel;
import borland.jbcl.view.ButtonItemPainter;
import borland.jbcl.view.SingletonView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class ButtonView
extends BeanPanel
implements SingletonView,
SingletonModelListener,
ItemPaintSite {
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private transient SingletonViewManager viewManager;
    private boolean readOnly;
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    protected String actionCommand;
    protected ButtonItemPainter borderPainter = new ButtonItemPainter();
    protected int state;
    protected boolean mouseDown;

    public ButtonView() {
        this.setBackground(SystemColor.control);
    }

    public Insets getItemMargins() {
        return new Insets(0, 0, 0, 0);
    }

    public int getAlignment() {
        return 0;
    }

    public String getLabel() {
        Object object = this.model != null ? this.model.get() : null;
        return object != null ? object.toString() : "";
    }

    public void setLabel(String string) {
        if (!this.isReadOnly()) {
            this.writeModel.set(string);
            this.repaint(100L);
        }
    }

    public void setFocusAware(boolean bl) {
        super.setFocusAware(bl);
        this.repaint(100L);
    }

    public boolean isFocusAware() {
        return super.isFocusAware();
    }

    public boolean isSelected() {
        return (this.state & 4) != 0;
    }

    public void setSelected(boolean bl) {
        this.state = bl ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.repaint(100L);
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            this.state = bl ? (this.state &= 0xFFFFFFFE) : (this.state |= 1);
            super.setEnabled(bl);
            this.repaint(100L);
        }
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)this.model : null;
        this.repaint(100L);
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public SingletonViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(SingletonViewManager singletonViewManager) {
        this.viewManager = singletonViewManager;
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        this.repaint(100L);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public Dimension getPreferredSize() {
        Object object;
        Graphics graphics = this.getGraphics();
        Dimension dimension = this.borderPainter.getPreferredSize(null, graphics, this.state | this.focusState, this);
        if (this.model != null && this.viewManager != null && (object = this.model.get()) != null) {
            Dimension dimension2 = this.viewManager.getPainter(object, this.state | this.focusState).getPreferredSize(object, graphics, this.state | this.focusState, this);
            return new Dimension(dimension2.width + dimension.width, dimension2.height + dimension.height);
        }
        return dimension;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.repaint(300L);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        block0: {
            ItemPainter itemPainter;
            super.paint(graphics);
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.borderPainter.getPreferredSize(null, graphics, this.state | this.focusState, this);
            Dimension dimension3 = new Dimension(dimension.width - dimension2.width, dimension.height - dimension2.height);
            this.borderPainter.paint(null, graphics, new Rectangle(0, 0, dimension.width, dimension.height), this.state | this.focusState, this);
            boolean bl = (this.state & 4) != 0;
            int n = dimension2.width / 2 + (bl ? 1 : 0);
            int n2 = dimension2.height / 2 + (bl ? 1 : 0);
            Object object = this.model != null ? this.model.get() : null;
            ItemPainter itemPainter2 = itemPainter = this.viewManager != null ? this.viewManager.getPainter(object, this.state | this.focusState) : null;
            if (itemPainter == null) break block0;
            Rectangle rectangle = new Rectangle(n, n2, dimension3.width, dimension3.height);
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.getBackground());
            graphics.setFont(this.getFont());
            itemPainter.paint(object, graphics, rectangle, this.state | this.focusState, this);
        }
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.mouseDown = false;
            this.setSelected(false);
        }
        super.setVisible(bl);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusAware) {
            this.repaint(100L);
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 32: {
                this.state |= 4;
                this.repaint();
            }
        }
    }

    protected void processKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.state &= 0xFFFFFFFB;
            this.repaint();
            this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        this.state |= 4;
        this.mouseDown = true;
        this.repaint();
    }

    protected void processMouseReleased(MouseEvent mouseEvent) {
        boolean bl = (this.state & 4) != 0;
        this.state &= 0xFFFFFFFB;
        this.mouseDown = false;
        this.repaint();
        if (bl) {
            this.processActionEvent(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    protected void processMouseEntered(MouseEvent mouseEvent) {
        if (this.mouseDown) {
            this.state |= 4;
            this.repaint();
        }
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
        if (this.mouseDown) {
            this.state &= 0xFFFFFFFB;
            this.repaint();
        }
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",label="))).concat(String.valueOf(this.getLabel()))).concat(String.valueOf(",state="))).concat(String.valueOf(this.state));
    }
}

