/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import COM.objectspace.jgl.Array;
import borland.jbcl.model.ItemPaintSite;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.model.SingleVectorSelection;
import borland.jbcl.model.VectorModel;
import borland.jbcl.model.VectorModelEvent;
import borland.jbcl.model.VectorModelListener;
import borland.jbcl.model.VectorModelMulticaster;
import borland.jbcl.model.VectorSelectionEvent;
import borland.jbcl.model.VectorSelectionListener;
import borland.jbcl.model.VectorSelectionMulticaster;
import borland.jbcl.model.VectorSubfocusEvent;
import borland.jbcl.model.VectorSubfocusListener;
import borland.jbcl.model.VectorViewManager;
import borland.jbcl.model.WritableVectorModel;
import borland.jbcl.model.WritableVectorSelection;
import borland.jbcl.util.EventMulticaster;
import borland.jbcl.view.BeanPanel;
import borland.jbcl.view.FocusableItemPainter;
import borland.jbcl.view.TabInfo;
import borland.jbcl.view.TextItemPainter;
import borland.jbcl.view.VectorView;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class TabsetView
extends BeanPanel
implements ItemPaintSite,
VectorModelListener,
VectorSelectionListener,
VectorView {
    static final int SEL_HEIGHT_INCREASE = 2;
    static final int SLOPE = 1;
    static final int EDGE = 2;
    static final int LINE = 2;
    static final int SCROLLER_WIDTH = 28;
    static final int SCROLLER_HEIGHT = 14;
    protected transient VectorModel model;
    protected transient WritableVectorModel writeModel;
    protected transient VectorViewManager viewManager;
    protected transient WritableVectorSelection selection = new SingleVectorSelection();
    private int alignment = 34;
    private boolean clientBordered = false;
    private boolean doubleBuffer = true;
    private Insets itemMargins = new Insets(1, 4, 1, 4);
    private boolean readOnly = false;
    private boolean tabsOnTop = true;
    boolean thickBorder = true;
    int border = 2;
    protected ItemPainter defaultPainter;
    private int tabBarTop;
    private int tabBarWidth;
    private int tabBarHeight;
    private int oldIndex = -1;
    int firstVisible = 0;
    int lastVisible = -1;
    int xOffset = 0;
    Rectangle leftArrowRect = new Rectangle();
    Rectangle rightArrowRect = new Rectangle();
    boolean needScroller = false;
    boolean lastClipped = false;
    transient EventMulticaster subfocusListeners = new EventMulticaster();
    private transient VectorModelMulticaster modelMulticaster = new VectorModelMulticaster();
    private transient VectorSelectionMulticaster selectionMulticaster = new VectorSelectionMulticaster();
    Array tabInfo = new Array();
    private Image canvas;

    public TabsetView() {
        this.setBackground(SystemColor.control);
        this.selection.addSelectionListener(this);
        this.selection.addSelectionListener(this.selectionMulticaster);
        TextItemPainter textItemPainter = new TextItemPainter(33, new Insets(1, 1, 1, 1), true);
        this.defaultPainter = new FocusableItemPainter(textItemPainter);
    }

    public void setLabels(String[] stringArray) {
        if (this.isReadOnly()) {
            return;
        }
        if (stringArray != null) {
            this.writeModel.enableModelEvents(false);
            this.writeModel.removeAll();
            for (int i = 0; i < stringArray.length; ++i) {
                this.writeModel.addItem(stringArray[i]);
            }
            this.writeModel.enableModelEvents(true);
        } else {
            this.writeModel.removeAll();
        }
    }

    public String[] getLabels() {
        String[] stringArray = new String[this.model.getCount()];
        for (int i = 0; i < this.model.getCount(); ++i) {
            stringArray[i] = this.model.get(i).toString();
        }
        return stringArray;
    }

    public void setLabel(int n, Object object) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeModel.set(n, object);
    }

    public String getLabel(int n) {
        return this.model.get(n).toString();
    }

    public void addTab(Object object) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeModel.addItem(object);
    }

    public void removeTab(Object object) {
        if (this.isReadOnly()) {
            return;
        }
        int n = this.writeModel.find(object);
        if (n != -1) {
            this.writeModel.remove(n);
        }
    }

    public void addTab(int n, Object object) {
        if (this.isReadOnly()) {
            return;
        }
        if (n == -1) {
            this.writeModel.addItem(object);
        } else {
            this.writeModel.addItem(n, object);
        }
    }

    public void renameTab(String string, String string2) {
        if (this.isReadOnly()) {
            return;
        }
        int n = this.writeModel.find(string);
        if (n != -1) {
            this.writeModel.set(n, string2);
        }
    }

    public VectorModel getModel() {
        return this.model;
    }

    public WritableVectorModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(VectorModel vectorModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = vectorModel;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableVectorModel ? (WritableVectorModel)this.model : null;
        this.updateTabInfo();
    }

    public VectorViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(VectorViewManager vectorViewManager) {
        this.viewManager = vectorViewManager;
        this.invalidate();
        this.repaint(100L);
    }

    public int getSubfocus() {
        return this.getSelectedIndex();
    }

    public void setSubfocus(int n) {
        this.selectTab(n);
    }

    public WritableVectorSelection getSelection() {
        return this.selection;
    }

    public void setSelection(WritableVectorSelection writableVectorSelection) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
            this.selection.removeSelectionListener(this.selectionMulticaster);
        }
        this.selection = writableVectorSelection;
        if (this.selection != null) {
            this.selection.addSelectionListener(this);
            this.selection.addSelectionListener(this.selectionMulticaster);
        }
        int n = this.getSelectedIndex();
        this.repaintTab(n);
        this.repaintTab(this.oldIndex);
        this.oldIndex = n;
    }

    public int getSelectedIndex() {
        int[] nArray = this.selection.getAll();
        return nArray.length > 0 ? nArray[0] : -1;
    }

    public void setSelectedIndex(int n) {
        this.selectTab(n);
    }

    public String getSelectedTab() {
        int n = this.getSelectedIndex();
        if (n >= 0) {
            return this.model.get(n).toString();
        }
        return null;
    }

    public void setSelectedTab(Object object) {
        this.selectTab(this.model.find(object));
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint(100L);
    }

    public boolean isClientBordered() {
        return this.clientBordered;
    }

    public void setClientBordered(boolean bl) {
        this.clientBordered = bl;
        this.repaint(100L);
    }

    public boolean isDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setDoubleBuffer(boolean bl) {
        this.doubleBuffer = bl;
    }

    public boolean isFocusAware() {
        return super.isFocusAware();
    }

    public void setFocusAware(boolean bl) {
        super.setFocusAware(bl);
        this.repaintTab(this.getSelectedIndex());
    }

    public Insets getItemMargins() {
        return this.itemMargins;
    }

    public void setItemMargins(Insets insets) {
        this.itemMargins = insets;
        this.invalidate();
        this.repaint(100L);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isTabsOnTop() {
        return this.tabsOnTop;
    }

    public void setTabsOnTop(boolean bl) {
        this.tabsOnTop = bl;
        this.invalidate();
        this.repaint(100L);
    }

    public void setThickBorder(boolean bl) {
        this.thickBorder = bl;
        this.repaint(100L);
    }

    public boolean isThickBorder() {
        return this.thickBorder;
    }

    public int hitTest(int n, int n2) {
        if (this.needScroller && n > this.leftArrowRect.x) {
            return -1;
        }
        if (this.tabsOnTop ? n2 < this.border || n2 >= this.border + this.tabBarHeight : n2 < this.getSize().height - this.border - this.tabBarHeight || n2 >= this.getSize().height - this.border) {
            return -1;
        }
        return this.hitTestX(n);
    }

    int hitTestX(int n) {
        try {
            for (int i = this.firstVisible; i <= this.lastVisible; ++i) {
                TabInfo tabInfo = (TabInfo)this.tabInfo.at(i);
                if (!tabInfo.hitTestX(n + this.xOffset)) continue;
                int n2 = i;
                return n2;
            }
            int n3 = -1;
            return n3;
        }
        catch (Exception exception) {
            int n4 = -1;
            return n4;
        }
    }

    public void addModelListener(VectorModelListener vectorModelListener) {
        this.modelMulticaster.add(vectorModelListener);
    }

    public void removeModelListener(VectorModelListener vectorModelListener) {
        this.modelMulticaster.remove(vectorModelListener);
    }

    public void addSelectionListener(VectorSelectionListener vectorSelectionListener) {
        this.selectionMulticaster.add(vectorSelectionListener);
    }

    public void removeSelectionListener(VectorSelectionListener vectorSelectionListener) {
        this.selectionMulticaster.remove(vectorSelectionListener);
    }

    public void addSubfocusListener(VectorSubfocusListener vectorSubfocusListener) {
        this.subfocusListeners.add(vectorSubfocusListener);
    }

    public void removeSubfocusListener(VectorSubfocusListener vectorSubfocusListener) {
        this.subfocusListeners.remove(vectorSubfocusListener);
    }

    public void modelContentChanged(VectorModelEvent vectorModelEvent) {
        switch (vectorModelEvent.getChange()) {
            case 1: {
                this.updateTabInfo();
                break;
            }
            case 17: 
            case 33: {
                TabInfo tabInfo = (TabInfo)this.tabInfo.at(vectorModelEvent.getLocation());
                tabInfo.item = this.model.get(vectorModelEvent.getLocation());
                this.updateTabRects();
                this.adjustScrollbar();
                this.repaint(100L);
            }
        }
    }

    public void modelStructureChanged(VectorModelEvent vectorModelEvent) {
        this.updateTabInfo();
    }

    public void selectionItemChanged(VectorSelectionEvent vectorSelectionEvent) {
    }

    public void selectionRangeChanged(VectorSelectionEvent vectorSelectionEvent) {
    }

    public void selectionChanged(VectorSelectionEvent vectorSelectionEvent) {
        int n = this.getSelectedIndex();
        this.repaintTab(n);
        this.repaintTab(this.oldIndex);
        this.oldIndex = n;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        this.repaintTab(this.getSelectedIndex());
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 36: {
                this.selectTab(0);
                break;
            }
            case 37: {
                int n = this.getSelectedIndex();
                if (n <= 0) break;
                this.selectTab(n - 1);
                break;
            }
            case 39: {
                int n = this.getSelectedIndex();
                if (n >= this.tabInfo.size() - 1) break;
                this.selectTab(n + 1);
                break;
            }
            case 35: {
                if (this.tabInfo.size() <= 0) break;
                this.selectTab(this.tabInfo.size() - 1);
            }
        }
    }

    protected boolean preProcessSubfocusEvent(VectorSubfocusEvent vectorSubfocusEvent) {
        if (this.subfocusListeners.hasListeners()) {
            return this.subfocusListeners.vetoableDispatch(vectorSubfocusEvent);
        }
        return true;
    }

    protected void processSubfocusEvent(VectorSubfocusEvent vectorSubfocusEvent) {
        if (this.subfocusListeners.hasListeners()) {
            this.subfocusListeners.dispatch(vectorSubfocusEvent);
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        if (mouseEvent.isMetaDown()) {
            return;
        }
        if (this.scrollCheck(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        int n = this.hitTest(mouseEvent.getX(), mouseEvent.getY());
        if (n >= 0) {
            this.selectTab(n);
        }
    }

    protected void setBorderHeight(int n) {
        this.border = n;
    }

    protected void updateTabInfo() {
        this.tabInfo.clear();
        for (int i = 0; i < this.model.getCount(); ++i) {
            this.tabInfo.add(new TabInfo(this.model.get(i)));
        }
        int[] nArray = this.selection.getAll();
        if (nArray.length > 0 && nArray[0] >= this.tabInfo.size()) {
            int[] nArray2 = new int[]{};
            this.selection.removeAll();
            this.selection.add(nArray2);
        }
        this.updateTabRects();
        this.adjustScrollbar();
        this.invalidate();
        this.repaint(100L);
    }

    protected void selectTab(int n) {
        if (n != this.getSelectedIndex() && n < this.tabInfo.size()) {
            if (!this.preProcessSubfocusEvent(new VectorSubfocusEvent(this, 1, n))) {
                return;
            }
            int n2 = this.getSelectedIndex();
            this.selection.enableSelectionEvents(false);
            this.selection.removeAll();
            if (n >= 0) {
                this.selection.add(n);
            }
            this.selection.enableSelectionEvents(true);
            this.processSubfocusEvent(new VectorSubfocusEvent(this, 2, n));
        }
    }

    protected void scrollLeft() {
        if (this.firstVisible > 0) {
            --this.firstVisible;
            this.adjustScrollbar();
            this.repaint(100L);
        }
    }

    protected void scrollRight() {
        if ((this.lastClipped || this.lastVisible < this.tabInfo.size() - 1) && this.firstVisible < this.tabInfo.size() - 1) {
            ++this.firstVisible;
            this.adjustScrollbar();
            this.repaint(100L);
        }
    }

    protected boolean scrollCheck(int n, int n2) {
        if (this.needScroller) {
            if (this.leftArrowRect.contains(n, n2)) {
                this.scrollLeft();
                return true;
            }
            if (this.rightArrowRect.contains(n, n2)) {
                this.scrollRight();
                return true;
            }
        }
        return false;
    }

    void updateTabRects() {
        Graphics graphics = this.getGraphics();
        this.tabBarWidth = 0;
        if (graphics != null) {
            int n = 2;
            int n2 = 0;
            graphics.setFont(this.getFont());
            for (int i = 0; i < this.tabInfo.size(); ++i) {
                TabInfo tabInfo = (TabInfo)this.tabInfo.at(i);
                int n3 = 0;
                if (i == this.getSelectedIndex()) {
                    n3 |= 4;
                    n3 |= this.focusState;
                }
                ItemPainter itemPainter = this.getPainter(i, n3);
                Dimension dimension = itemPainter.getPreferredSize(tabInfo.item, graphics, n3, this);
                tabInfo.x = n;
                tabInfo.itemWidth = dimension.width;
                tabInfo.width = 2 + tabInfo.itemWidth + 2;
                tabInfo.itemHeight = dimension.height;
                int n4 = 4 + tabInfo.itemHeight + 2;
                n += tabInfo.width;
                if (n4 <= n2) continue;
                n2 = n4;
            }
            this.tabBarWidth = n + 2;
            this.tabBarHeight = n2;
        }
    }

    protected void adjustScrollbar() {
        this.tabBarTop = this.tabsOnTop ? this.border : this.getSize().height - this.border - this.tabBarHeight;
        this.xOffset = 0;
        this.needScroller = false;
        this.lastClipped = false;
        if (this.tabBarWidth <= this.getSize().width) {
            this.firstVisible = 0;
            this.lastVisible = this.tabInfo.size() - 1;
            return;
        }
        int n = this.getSize().width - 28 - 2 - this.itemMargins.right;
        int n2 = (this.tabBarHeight - 14) / 2;
        n2 = this.tabsOnTop ? (n2 += this.border) : (n2 += this.getSize().height - this.border - this.tabBarHeight);
        if (this.tabInfo.size() > 0) {
            this.xOffset = ((TabInfo)this.tabInfo.at((int)this.firstVisible)).x - 2;
            this.lastVisible = this.firstVisible;
            int n3 = this.firstVisible;
            while (n3 < this.tabInfo.size()) {
                TabInfo tabInfo = (TabInfo)this.tabInfo.at(n3);
                this.lastVisible = n3;
                if (tabInfo.x - this.xOffset + tabInfo.width > n - 2 - this.itemMargins.right) {
                    this.lastClipped = true;
                    this.needScroller = true;
                    break;
                }
                this.lastVisible = n3++;
            }
        }
        if (this.firstVisible != 0) {
            this.needScroller = true;
        }
        if (this.needScroller) {
            this.leftArrowRect = new Rectangle(n, n2, 14, 14);
            this.rightArrowRect = new Rectangle(n + 14 + 1, n2, 14, 14);
        }
    }

    ItemPainter getPainter(int n, int n2) {
        return this.viewManager != null ? this.viewManager.getPainter(n, ((TabInfo)this.tabInfo.at((int)n)).item, n2) : this.defaultPainter;
    }

    public Insets insets() {
        this.updateTabRects();
        if (this.tabsOnTop) {
            return new Insets(this.tabBarHeight + this.border, 2, this.clientBordered ? 2 : 0, 2);
        }
        return new Insets(this.clientBordered ? 2 : 0, 2, this.tabBarHeight + this.border, 2);
    }

    public Dimension getPreferredSize() {
        Insets insets = this.insets();
        return new Dimension(this.tabBarWidth, insets.top + insets.bottom);
    }

    public void doLayout() {
        super.doLayout();
        this.adjustScrollbar();
    }

    public void paint(Graphics graphics) {
        Graphics graphics2;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0 || this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        if (this.doubleBuffer) {
            if (this.canvas == null || this.canvas.getWidth(null) != this.getSize().width || this.canvas.getHeight(null) != this.getSize().height) {
                this.canvas = this.createImage(this.getSize().width, this.getSize().height);
            }
            graphics2 = this.canvas.getGraphics();
            graphics2.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            graphics2 = graphics;
        }
        super.paint(graphics2);
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.paintBorder(graphics2);
        if (this.tabInfo.size() > 0) {
            if (rectangle.y < this.tabBarTop + this.tabBarHeight && rectangle.y + rectangle.height > this.tabBarTop) {
                TabInfo tabInfo;
                int n = this.hitTestX(rectangle.x);
                int n2 = this.hitTestX(rectangle.x + rectangle.width - 1);
                if (n == -1) {
                    tabInfo = (TabInfo)this.tabInfo.at(this.firstVisible);
                    if (rectangle.x + this.xOffset < tabInfo.x) {
                        n = this.firstVisible;
                    }
                }
                if (n2 == -1) {
                    try {
                        tabInfo = (TabInfo)this.tabInfo.at(this.lastVisible);
                        if (rectangle.x + rectangle.width + this.xOffset > tabInfo.x + tabInfo.width) {
                            n2 = this.lastVisible;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n != -1 && n2 != -1) {
                    for (int i = n; i <= n2; ++i) {
                        this.paintTab(graphics2, i);
                    }
                }
            }
            if (this.needScroller) {
                this.paintScrollArrows(graphics2);
            }
        }
        if (this.doubleBuffer) {
            graphics.drawImage(this.canvas, 0, 0, null);
            graphics2.dispose();
        }
    }

    void paintBorder(Graphics graphics) {
        int n = 0;
        int n2 = this.getSize().width - 1;
        int n3 = 0;
        int n4 = this.getSize().height - 1;
        if (this.tabsOnTop) {
            n3 = this.border + this.tabBarHeight - 2;
        } else {
            n4 = this.getSize().height - this.border - this.tabBarHeight + 1;
        }
        if (this.clientBordered) {
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n, n3, n2 - 1, n3);
            graphics.drawLine(n, n3, n, n4 - 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n, n4, n2, n4);
            graphics.drawLine(n2, n3, n2, n4);
            if (this.thickBorder) {
                graphics.setColor(SystemColor.controlHighlight);
                graphics.drawLine(n + 1, n3 + 1, n2 - 2, n3 + 1);
                graphics.drawLine(n + 1, n3 + 1, n + 1, n4 - 2);
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(n + 1, n4 - 1, n2 - 2, n4 - 1);
                graphics.drawLine(n2 - 1, n3 + 1, n2 - 1, n4 - 1);
            }
        }
        if (this.tabsOnTop) {
            if (!this.clientBordered) {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(n, n3, n2 - 1, n3);
            }
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(n + 1, n3 + 1, n2 - 2, n3 + 1);
        } else {
            if (!this.clientBordered) {
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(n, n4, n2, n4);
            }
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n + 1, n4 - 1, n2 - 2, n4 - 1);
        }
    }

    public void repaintTab(int n) {
        if (n == -1 || n > this.tabInfo.size() - 1) {
            return;
        }
        TabInfo tabInfo = (TabInfo)this.tabInfo.at(n);
        this.repaint(100L, tabInfo.x - this.xOffset, this.tabBarTop, tabInfo.width, this.tabBarHeight);
    }

    private void paintTab(Graphics graphics, int n) {
        if (this.tabsOnTop) {
            this.paintTopTab(graphics, n);
        } else {
            this.paintBottomTab(graphics, n);
        }
    }

    private void paintTopTab(Graphics graphics, int n) {
        int n2;
        TabInfo tabInfo = (TabInfo)this.tabInfo.at(n);
        boolean bl = n == this.getSelectedIndex();
        int n3 = 0;
        graphics.setColor(this.getBackground());
        graphics.fillRect(tabInfo.x - this.xOffset, this.tabBarTop, tabInfo.width, this.tabBarHeight);
        int n4 = tabInfo.x - this.xOffset;
        int n5 = n4 + tabInfo.width - 1;
        int n6 = bl ? this.border : this.border + 2;
        int n7 = this.border + this.tabBarHeight - 2;
        ItemPainter itemPainter = this.getPainter(n, n3);
        Font font = this.getFont();
        Font font2 = this.getFont();
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n4, n6 + 1 + 1, n4, n7);
        graphics.drawLine(n4 + 1, n6 + 1, n4 + 1, n6 + 1);
        graphics.drawLine(n4 + 1 + 1, n6, n5 - 1 - 1, n6);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n4 + 1, n6 + 1 + 2, n4 + 1, n7);
        graphics.drawLine(n4 + 1, n6 + 1 + 1, n4 + 1 + 1, n6 + 1);
        graphics.drawLine(n4 + 1 + 1, n6 + 1, n5 - 1 - 1, n6 + 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n5 - 1, n6 + 1, n5, n6 + 1 + 1);
        graphics.drawLine(n5, n6 + 1 + 2, n5, n7);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n5 - 1, n6 + 2, n5 - 1, n6 + 1 + 2);
        graphics.drawLine(n5 - 1, n6 + 1 + 3, n5 - 1, n7);
        if (bl) {
            n3 |= 4;
            n3 |= this.focusState;
            graphics.setFont(font2);
            n2 = this.border + this.tabBarHeight - 2;
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n5, n2, n5, n2);
        } else {
            n2 = this.border + this.tabBarHeight - 2;
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n4, n2, n5, n2);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(n4, n2 + 1, n5, n2 + 1);
            graphics.setFont(font);
        }
        Rectangle rectangle = new Rectangle(n4 + 2, n6 + 2, tabInfo.itemWidth, tabInfo.itemHeight);
        if (!this.isEnabled()) {
            n3 |= 1;
        }
        graphics.setColor(this.getBackground());
        itemPainter.paint(tabInfo.item, graphics, rectangle, n3, this);
    }

    private void paintBottomTab(Graphics graphics, int n) {
        int n2;
        TabInfo tabInfo = (TabInfo)this.tabInfo.at(n);
        boolean bl = n == this.getSelectedIndex();
        int n3 = 0;
        graphics.setColor(this.getBackground());
        graphics.fillRect(tabInfo.x - this.xOffset, this.tabBarTop, tabInfo.width, this.tabBarHeight);
        int n4 = tabInfo.x - this.xOffset;
        int n5 = n4 + tabInfo.width - 1;
        int n6 = this.getSize().height - this.border - this.tabBarHeight + 2 - 1;
        int n7 = this.getSize().height - this.border - (bl ? 0 : 2) - 1;
        ItemPainter itemPainter = this.getPainter(n, n3);
        Font font = this.getFont();
        Font font2 = this.getFont();
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n5, n6, n5, n7 - 1 - 1);
        graphics.drawLine(n5, n7 - 1 - 1, n5 - 1, n7 - 1);
        graphics.drawLine(n5 - 1 - 1, n7, n4 + 1 + 1, n7);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n5 - 1, n6, n5 - 1, n7 - 1 - 1);
        graphics.drawLine(n5 - 1, n7 - 2 - 1, n5 - 1 - 1, n7 - 2);
        graphics.drawLine(n5 - 1 - 1, n7 - 1, n4 + 1, n7 - 1);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n4 + 1, n7 - 1, n4, n7 - 1 - 1);
        graphics.drawLine(n4, n7 - 1 - 1, n4, n6);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n4 + 1, n7 - 2, n4 + 1, n7 - 2 - 1);
        graphics.drawLine(n4 + 1, n7 - 2 - 1, n4 + 1, n6);
        if (bl) {
            n3 |= 4;
            n3 |= this.focusState;
            graphics.setFont(font2);
            n2 = this.getSize().height - this.tabBarHeight - this.border;
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n4, n2, n4, n2);
            graphics.drawLine(n5 - 1, n2, n5, n2);
        } else {
            n2 = this.getSize().height - this.tabBarHeight - this.border;
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n4, n2 + 1, n5, n2 + 1);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n4, n2, n5, n2);
            graphics.setFont(font);
        }
        Rectangle rectangle = new Rectangle(n4 + 2, n7 - 2 - tabInfo.itemHeight + 1, tabInfo.itemWidth, tabInfo.itemHeight);
        if (!this.isEnabled()) {
            n3 |= 1;
        }
        graphics.setColor(this.getBackground());
        itemPainter.paint(tabInfo.item, graphics, rectangle, n3, this);
    }

    private void paintScrollArrows(Graphics graphics) {
        if (this.lastClipped) {
            int n = 0;
            int n2 = this.tabBarTop;
            int n3 = this.tabBarTop + this.tabBarHeight - 1;
            int n4 = this.leftArrowRect.x - 2 - this.itemMargins.left + 1;
            int n5 = this.getSize().width - 1;
            graphics.setColor(this.getBackground());
            graphics.fillRect(n4, n2, n5 - n4 + 1, this.tabBarHeight);
            if (this.tabsOnTop) {
                n = this.border + this.tabBarHeight - 2;
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawLine(n4, n, n5, n);
                graphics.setColor(SystemColor.controlHighlight);
                graphics.drawLine(n4, n + 1, n5, n + 1);
                if (this.clientBordered) {
                    graphics.setColor(SystemColor.controlDkShadow);
                    graphics.drawLine(n5, n, n5, n + 1);
                    if (this.thickBorder) {
                        graphics.setColor(SystemColor.controlShadow);
                        graphics.drawLine(n5 - 1, n + 1, n5 - 1, n + 1);
                    }
                }
            } else {
                n = this.getSize().height - this.tabBarHeight - this.border;
                graphics.setColor(SystemColor.controlDkShadow);
                graphics.drawLine(n4, n + 1, n5, n + 1);
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawLine(n4, n, n5, n);
                if (this.clientBordered) {
                    graphics.setColor(SystemColor.controlDkShadow);
                    graphics.drawLine(n5, n, n5, n);
                }
            }
            int n6 = this.getSelectedIndex();
            if (n6 == -1 || n6 != this.hitTestX(n4)) {
                if (this.tabsOnTop) {
                    n2 += 2;
                } else {
                    n3 -= 2;
                }
            }
            graphics.setColor(SystemColor.controlShadow);
            int n7 = 0;
            int n8 = 1;
            int n9 = 0;
            int n10 = n3 - n2;
            int[] nArray = new int[n10];
            int[] nArray2 = new int[n10];
            int n11 = 0;
            for (int i = n2; i < n3; ++i) {
                nArray[n11] = n4 + n7;
                nArray2[n11] = i;
                ++n11;
                if (n9 == 1) {
                    n9 = 0;
                    if ((n7 += n8) == 2) {
                        n8 = -1;
                        continue;
                    }
                    if (n7 != 0) continue;
                    n8 = 1;
                    continue;
                }
                ++n9;
            }
            graphics.drawPolyline(nArray, nArray2, n10);
        }
        this.paintScrollArrow(graphics, true);
        this.paintScrollArrow(graphics, false);
    }

    private void paintScrollArrow(Graphics graphics, boolean bl) {
        Rectangle rectangle = bl ? this.leftArrowRect : this.rightArrowRect;
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 2);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        if (bl) {
            if (this.firstVisible > 0) {
                graphics.setColor(SystemColor.controlDkShadow);
            } else {
                graphics.setColor(SystemColor.controlShadow);
            }
            graphics.drawLine(rectangle.x + rectangle.width / 2 - 1, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width / 2 - 1, rectangle.y + rectangle.height / 2);
            graphics.drawLine(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 - 1, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + 1);
            graphics.drawLine(rectangle.x + rectangle.width / 2 + 1, rectangle.y + rectangle.height / 2 - 2, rectangle.x + rectangle.width / 2 + 1, rectangle.y + rectangle.height / 2 + 2);
        } else {
            if (this.lastClipped) {
                graphics.setColor(SystemColor.controlDkShadow);
            } else {
                graphics.setColor(SystemColor.controlShadow);
            }
            graphics.drawLine(rectangle.x + rectangle.width / 2 + 1, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width / 2 + 1, rectangle.y + rectangle.height / 2);
            graphics.drawLine(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 - 1, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + 1);
            graphics.drawLine(rectangle.x + rectangle.width / 2 - 1, rectangle.y + rectangle.height / 2 - 2, rectangle.x + rectangle.width / 2 - 1, rectangle.y + rectangle.height / 2 + 2);
        }
    }
}

