/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;

public class InstallPanel
extends IzPanel
implements AbstractUIProgressHandler {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    protected JLabel tipLabel;
    protected JLabel packOpLabel;
    protected JLabel overallOpLabel;
    protected JProgressBar packProgressBar;
    protected JProgressBar overallProgressBar;
    private volatile boolean validated = false;
    private int noOfPacks = 0;

    public InstallPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        this.setLayout(this.layout);
        int row = 1;
        this.tipLabel = LabelFactory.create(parent.langpack.getString("InstallPanel.tip"), parent.icons.getImageIcon("information"), 11);
        parent.buildConstraints(this.gbConstraints, 0, row++, 2, 1, 1.0, 0.0);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 18;
        this.layout.addLayoutComponent(this.tipLabel, this.gbConstraints);
        this.add(this.tipLabel);
        this.packOpLabel = LabelFactory.create(" ", 11);
        parent.buildConstraints(this.gbConstraints, 0, row++, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 16;
        this.layout.addLayoutComponent(this.packOpLabel, this.gbConstraints);
        this.add(this.packOpLabel);
        this.packProgressBar = new JProgressBar();
        this.packProgressBar.setStringPainted(true);
        this.packProgressBar.setString(parent.langpack.getString("InstallPanel.begin"));
        this.packProgressBar.setValue(0);
        parent.buildConstraints(this.gbConstraints, 0, row++, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 11;
        this.gbConstraints.fill = 2;
        this.layout.addLayoutComponent(this.packProgressBar, this.gbConstraints);
        this.add(this.packProgressBar);
        JSeparator sep = new JSeparator();
        Dimension dim = new Dimension(0, 10);
        sep.setPreferredSize(dim);
        sep.setMinimumSize(dim);
        sep.setMaximumSize(dim);
        parent.buildConstraints(this.gbConstraints, 0, row++, 2, 1, 1.0, 0.0);
        this.layout.addLayoutComponent(sep, this.gbConstraints);
        this.add(sep);
        this.overallOpLabel = LabelFactory.create(parent.langpack.getString("InstallPanel.progress"), parent.icons.getImageIcon("information"), 11);
        parent.buildConstraints(this.gbConstraints, 0, row++, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 18;
        this.gbConstraints.fill = 0;
        this.layout.addLayoutComponent(this.overallOpLabel, this.gbConstraints);
        this.add(this.overallOpLabel);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setStringPainted(true);
        this.overallProgressBar.setString("");
        this.overallProgressBar.setValue(0);
        parent.buildConstraints(this.gbConstraints, 0, row++, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 11;
        this.gbConstraints.fill = 2;
        this.layout.addLayoutComponent(this.overallProgressBar, this.gbConstraints);
        this.add(this.overallProgressBar);
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void startAction(String name, int noOfJobs) {
        this.parent.blockGUI();
        this.noOfPacks = noOfJobs;
        this.overallProgressBar.setMinimum(0);
        this.overallProgressBar.setMaximum(this.noOfPacks);
        this.overallProgressBar.setString("0 / " + Integer.toString(this.noOfPacks));
    }

    public void emitError(String title, String error) {
        this.packOpLabel.setText(error);
        this.idata.installSuccess = false;
        JOptionPane.showMessageDialog(this, error, this.parent.langpack.getString("installer.error"), 0);
    }

    public void stopAction() {
        this.parent.releaseGUI();
        this.parent.lockPrevButton();
        this.overallProgressBar.setValue(this.overallProgressBar.getValue() + 1);
        this.packProgressBar.setString(this.parent.langpack.getString("InstallPanel.finished"));
        this.packProgressBar.setEnabled(false);
        String no_of_packs = Integer.toString(this.noOfPacks);
        this.overallProgressBar.setString(no_of_packs + " / " + no_of_packs);
        this.overallProgressBar.setEnabled(false);
        this.packOpLabel.setText(" ");
        this.packOpLabel.setEnabled(false);
        this.idata.canClose = true;
        this.validated = true;
        if (this.idata.panels.indexOf(this) != this.idata.panels.size() - 1) {
            this.parent.unlockNextButton();
        }
    }

    public void progress(int val, String msg) {
        this.packProgressBar.setValue(val + 1);
        this.packOpLabel.setText(msg);
    }

    public void nextStep(String packName, int stepno, int max) {
        this.packProgressBar.setValue(0);
        this.packProgressBar.setMinimum(0);
        this.packProgressBar.setMaximum(max);
        this.packProgressBar.setString(packName);
        this.overallProgressBar.setValue(stepno - 1);
        this.overallProgressBar.setString(Integer.toString(stepno) + " / " + Integer.toString(this.noOfPacks));
    }

    public void panelActivate() {
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
        this.parent.install(this);
    }
}

