/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.os.ShellLink;
import com.izforge.izpack.util.os.Shortcut;
import java.io.File;
import java.util.Vector;

public class Win_Shortcut
extends Shortcut {
    private ShellLink shortcut;

    public void initialize(int type, String name) throws Exception {
        switch (type) {
            case 1: {
                this.shortcut = new ShellLink(2, name);
                break;
            }
            case 2: {
                this.shortcut = new ShellLink(3, name);
                break;
            }
            case 3: {
                this.shortcut = new ShellLink(1, name);
                break;
            }
            case 4: {
                this.shortcut = new ShellLink(4, name);
                break;
            }
            default: {
                this.shortcut = new ShellLink(2, name);
            }
        }
    }

    public String getBasePath() throws Exception {
        return this.shortcut.getLinkPath(this.shortcut.getUserType());
    }

    public Vector getProgramGroups(int userType) {
        int type = 0;
        type = userType == 2 ? 1 : 0;
        String linkPath = this.shortcut.getLinkPath(type);
        if (linkPath == null) {
            return new Vector();
        }
        File path = new File(linkPath);
        File[] file = path.listFiles();
        Vector<String> groups = new Vector<String>();
        if (file != null) {
            for (int i = 0; i < file.length; ++i) {
                if (!file[i].isDirectory()) continue;
                groups.add(file[i].getName());
            }
        }
        return groups;
    }

    public String getFileName() {
        return this.shortcut.getFileName();
    }

    public String getDirectoryCreated() {
        return this.shortcut.getDirectoryCreated();
    }

    public boolean multipleUsers() {
        String au = this.shortcut.getallUsersLinkPath();
        String cu = this.shortcut.getcurrentUserLinkPath();
        if (au == null || cu == null) {
            return false;
        }
        return au.length() > 0 && cu.length() > 0;
    }

    public boolean supported() {
        return true;
    }

    public void setArguments(String arguments) {
        this.shortcut.setArguments(arguments);
    }

    public void setDescription(String description) {
        this.shortcut.setDescription(description);
    }

    public void setIconLocation(String path, int index) {
        this.shortcut.setIconLocation(path, index);
    }

    public String getIconLocation() {
        return this.shortcut.getIconLocation();
    }

    public void setProgramGroup(String groupName) {
        this.shortcut.setProgramGroup(groupName);
    }

    public void setShowCommand(int show) throws IllegalArgumentException {
        switch (show) {
            case 0: {
                this.shortcut.setShowCommand(7);
                break;
            }
            case 1: {
                this.shortcut.setShowCommand(1);
                break;
            }
            case 2: {
                this.shortcut.setShowCommand(7);
                break;
            }
            case 3: {
                this.shortcut.setShowCommand(3);
                break;
            }
            default: {
                throw new IllegalArgumentException(show + "is not recognized as a show command");
            }
        }
    }

    public int getShowCommand() {
        int showCommand = this.shortcut.getShowCommand();
        switch (showCommand) {
            case 1: {
                showCommand = 1;
                break;
            }
            case 2: 
            case 7: {
                showCommand = 2;
                break;
            }
            case 3: {
                showCommand = 3;
                break;
            }
        }
        return showCommand;
    }

    public void setTargetPath(String path) {
        this.shortcut.setTargetPath(path);
    }

    public void setWorkingDirectory(String dir) {
        this.shortcut.setWorkingDirectory(dir);
    }

    public String getWorkingDirectory() {
        return this.shortcut.getWorkingDirectory();
    }

    public void setLinkName(String name) {
        this.shortcut.setLinkName(name);
    }

    public int getLinkType() {
        int typ = this.shortcut.getLinkType();
        switch (typ) {
            case 1: {
                typ = 3;
                break;
            }
            case 2: {
                typ = 1;
                break;
            }
            case 3: {
                typ = 2;
                break;
            }
            case 4: {
                typ = 4;
                break;
            }
        }
        return typ;
    }

    public void setLinkType(int type) throws IllegalArgumentException {
        switch (type) {
            case 3: {
                this.shortcut.setLinkType(1);
                break;
            }
            case 1: {
                this.shortcut.setLinkType(2);
                break;
            }
            case 2: {
                this.shortcut.setLinkType(3);
                break;
            }
            case 4: {
                this.shortcut.setLinkType(4);
                break;
            }
            default: {
                throw new IllegalArgumentException(type + "is not recognized as a valid link type");
            }
        }
    }

    public int getUserType() {
        int utype = this.shortcut.getUserType();
        switch (utype) {
            case 1: {
                utype = 2;
                break;
            }
            case 0: {
                utype = 1;
            }
        }
        return utype;
    }

    public void setUserType(int type) {
        if (type == 1) {
            if (this.shortcut.getcurrentUserLinkPath().length() > 0) {
                this.shortcut.setUserType(0);
            }
        } else if (type == 2 && this.shortcut.getallUsersLinkPath().length() > 0) {
            this.shortcut.setUserType(1);
        }
    }

    public void save() throws Exception {
        this.shortcut.save();
    }

    public int getHotkey() {
        return this.shortcut.getHotkey();
    }

    public void setHotkey(int hotkey) {
        this.shortcut.setHotkey(hotkey);
    }
}

