/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.core.GenericObject;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.NetObject;
import java.util.Iterator;

public class TelephoneNumber
extends NetObject {
    public static final String POSTDIAL = "postdial";
    public static final String PHONE_CONTEXT_TAG = "context-tag";
    public static final String ISUB = "isub";
    public static final String PROVIDER_TAG = "provider-tag";
    protected boolean isglobal;
    protected String phoneNumber;
    protected NameValueList parms = new NameValueList("telparms");

    public void deleteParm(String name) {
        this.parms.delete(name);
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getPostDial() {
        return (String)this.parms.getValue(POSTDIAL);
    }

    public String getIsdnSubaddress() {
        return (String)this.parms.getValue(ISUB);
    }

    public boolean hasPostDial() {
        return this.parms.getValue(POSTDIAL) != null;
    }

    public boolean hasParm(String pname) {
        return this.parms.hasNameValue(pname);
    }

    public boolean hasIsdnSubaddress() {
        return this.hasParm(ISUB);
    }

    public boolean isGlobal() {
        return this.isglobal;
    }

    public void removePostDial() {
        this.parms.delete(POSTDIAL);
    }

    public void removeIsdnSubaddress() {
        this.deleteParm(ISUB);
    }

    public void setParameters(NameValueList p) {
        this.parms = p;
    }

    public void setGlobal(boolean g) {
        this.isglobal = g;
    }

    public void setPostDial(String p) {
        NameValue nv = new NameValue(POSTDIAL, p);
        this.parms.add(nv);
    }

    public void setParm(String name, Object value) {
        NameValue nv = new NameValue(name, value);
        this.parms.add(nv);
    }

    public void setIsdnSubaddress(String isub) {
        this.setParm(ISUB, isub);
    }

    public void setPhoneNumber(String num) {
        this.phoneNumber = num;
    }

    public String encode() {
        String retval = "";
        if (this.isglobal) {
            retval = retval + "+";
        }
        retval = retval + this.phoneNumber;
        if (!this.parms.isEmpty()) {
            retval = retval + ";";
            retval = retval + this.parms.encode();
        }
        return retval;
    }

    public String getParameter(String name) {
        Object val = this.parms.getValue(name);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    public Iterator getParameterNames() {
        return this.parms.getNames();
    }

    public void removeParameter(String parameter) {
        this.parms.delete(parameter);
    }

    public void setParameter(String name, String value) {
        NameValue nv = new NameValue(name, value);
        this.parms.add(nv);
    }
}

