/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.accolorhelper.ColorWithText;
import net.sf.accolorhelper.ui.ColorListCellRenderer;
import net.sf.accolorhelper.ui.ColorListModel;
import net.sf.accolorhelper.ui.ColorTextChooserPanel;
import net.sf.accolorhelper.ui.Separator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorEditorComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ColorListModel aModel;
    private boolean aHaveColorsBeenModified;
    private JList aColorList;
    private JButton aEditButton;
    private JButton aUpButton;
    private JButton aDownButton;
    private JButton aRemoveButton;
    private ResourceBundle aResources = ResourceBundle.getBundle(ColorEditorComponent.class.getName());

    public ColorEditorComponent() {
        this.aModel = new ColorListModel(new ColorWithText[0]);
        this.createChildren();
        this.addModelListenerForButtonUpdates();
    }

    public ColorEditorComponent(ColorWithText[] pColors) {
        this.aModel = new ColorListModel(pColors);
        this.createChildren();
        this.addModelListenerForButtonUpdates();
    }

    public ColorEditorComponent(boolean pIsDoubleBuffered, ColorWithText[] pColors) {
        super(pIsDoubleBuffered);
        this.aModel = new ColorListModel(pColors);
        this.createChildren();
        this.addModelListenerForButtonUpdates();
    }

    public boolean haveColorsBeenModified() {
        return this.aHaveColorsBeenModified;
    }

    public List<ColorWithText> getColors() {
        return this.aModel.getColors();
    }

    private void createChildren() {
        GridBagLayout lLayout = new GridBagLayout();
        this.setLayout(lLayout);
        this.createColorList(lLayout);
        Separator lSeparator = new Separator(2);
        this.add(lSeparator);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.gridx = 0;
        lConstraints.gridy = 1;
        lLayout.setConstraints(lSeparator, lConstraints);
        this.createAddButton(lLayout);
        lSeparator = new Separator(2);
        this.add(lSeparator);
        lConstraints = new GridBagConstraints();
        lConstraints.gridx = 1;
        lConstraints.gridy = 2;
        lLayout.setConstraints(lSeparator, lConstraints);
        this.createEditButton(lLayout);
        lSeparator = new Separator(2);
        this.add(lSeparator);
        lConstraints = new GridBagConstraints();
        lConstraints.gridx = 3;
        lConstraints.gridy = 2;
        lLayout.setConstraints(lSeparator, lConstraints);
        this.createUpButton(lLayout);
        lSeparator = new Separator(2);
        this.add(lSeparator);
        lConstraints = new GridBagConstraints();
        lConstraints.gridx = 5;
        lConstraints.gridy = 2;
        lLayout.setConstraints(lSeparator, lConstraints);
        this.createDownButton(lLayout);
        lSeparator = new Separator(2);
        this.add(lSeparator);
        lConstraints = new GridBagConstraints();
        lConstraints.gridx = 7;
        lConstraints.gridy = 2;
        lLayout.setConstraints(lSeparator, lConstraints);
        this.createRemoveButton(lLayout);
        this.aColorList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent pEvent) {
                ColorEditorComponent.this.updateButtonStates();
            }
        });
    }

    private void createColorList(GridBagLayout lLayout) {
        this.aColorList = new JList(this.aModel);
        this.aColorList.setSelectionMode(0);
        this.aColorList.setCellRenderer(new ColorListCellRenderer());
        JScrollPane lColorListScrollPane = new JScrollPane(this.aColorList);
        lColorListScrollPane.setPreferredSize(new Dimension(300, 400));
        this.add(lColorListScrollPane);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.gridx = 0;
        lConstraints.gridy = 0;
        lConstraints.gridwidth = 9;
        lConstraints.weightx = 1.0;
        lConstraints.weighty = 1.0;
        lConstraints.fill = 1;
        lLayout.setConstraints(lColorListScrollPane, lConstraints);
    }

    private void createAddButton(GridBagLayout lLayout) {
        JButton lAddButton = new JButton(this.aResources.getString("button.add"));
        this.setMnemonic(lAddButton, "button.add");
        lAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                JColorChooser lColorChooser = new JColorChooser(Color.BLACK);
                ColorTextChooserPanel lColorTextPanel = new ColorTextChooserPanel("");
                lColorChooser.addChooserPanel(lColorTextPanel);
                ColorChooserDialogOkListener lOkListener = new ColorChooserDialogOkListener(lColorChooser);
                JDialog lColorChooserDialog = JColorChooser.createDialog(ColorEditorComponent.this, ColorEditorComponent.this.getTitle("editcolors"), true, lColorChooser, lOkListener, null);
                lColorChooserDialog.setVisible(true);
                Color lColorToAdd = lOkListener.getColor();
                if (lColorToAdd != null) {
                    ColorEditorComponent.this.aModel.add(lColorToAdd, lColorTextPanel.getText());
                    int lNewColorIndex = ColorEditorComponent.this.aModel.getSize() - 1;
                    ColorEditorComponent.this.aColorList.ensureIndexIsVisible(lNewColorIndex);
                    ColorEditorComponent.this.aColorList.setSelectedIndex(lNewColorIndex);
                    ColorEditorComponent.this.aHaveColorsBeenModified = true;
                }
            }
        });
        this.add(lAddButton);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.gridx = 0;
        lConstraints.gridy = 2;
        lConstraints.anchor = 13;
        lConstraints.weightx = 1.0;
        lLayout.setConstraints(lAddButton, lConstraints);
    }

    private void createEditButton(GridBagLayout lLayout) {
        this.aEditButton = new JButton(this.aResources.getString("button.edit"));
        this.setMnemonic(this.aEditButton, "button.edit");
        this.aEditButton.setEnabled(false);
        this.aEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                int lSelectedIndex = ColorEditorComponent.this.aColorList.getSelectedIndex();
                ColorWithText lColorWithText = (ColorWithText)ColorEditorComponent.this.aModel.getElementAt(lSelectedIndex);
                JColorChooser lColorChooser = new JColorChooser(lColorWithText.getColor());
                ColorTextChooserPanel lColorTextPanel = new ColorTextChooserPanel(lColorWithText.getText());
                lColorChooser.addChooserPanel(lColorTextPanel);
                ColorChooserDialogOkListener lOkListener = new ColorChooserDialogOkListener(lColorChooser);
                JDialog lColorChooserDialog = JColorChooser.createDialog(ColorEditorComponent.this, ColorEditorComponent.this.getTitle("editcolors"), true, lColorChooser, lOkListener, null);
                lColorChooserDialog.setVisible(true);
                Color lColorToEdit = lOkListener.getColor();
                if (lColorToEdit != null) {
                    ColorEditorComponent.this.aModel.set(lSelectedIndex, lColorToEdit, lColorTextPanel.getText());
                    ColorEditorComponent.this.aColorList.ensureIndexIsVisible(lSelectedIndex);
                    ColorEditorComponent.this.aColorList.setSelectedIndex(lSelectedIndex);
                    ColorEditorComponent.this.aHaveColorsBeenModified = true;
                }
            }
        });
        this.add(this.aEditButton);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.gridx = 2;
        lConstraints.gridy = 2;
        lConstraints.anchor = 13;
        lConstraints.weightx = 1.0;
        lLayout.setConstraints(this.aEditButton, lConstraints);
    }

    private void createUpButton(GridBagLayout lLayout) {
        this.aUpButton = new JButton(this.aResources.getString("button.up"));
        this.setMnemonic(this.aUpButton, "button.up");
        this.aUpButton.setEnabled(false);
        this.aUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                int lSelectedIndex = ColorEditorComponent.this.aColorList.getSelectedIndex();
                ColorEditorComponent.this.aModel.swap(lSelectedIndex, lSelectedIndex - 1);
                ColorEditorComponent.this.aColorList.ensureIndexIsVisible(lSelectedIndex - 1);
                ColorEditorComponent.this.aColorList.setSelectedIndex(lSelectedIndex - 1);
                ColorEditorComponent.this.aHaveColorsBeenModified = true;
            }
        });
        this.add(this.aUpButton);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.gridx = 4;
        lConstraints.gridy = 2;
        lLayout.setConstraints(this.aUpButton, lConstraints);
    }

    private void createDownButton(GridBagLayout lLayout) {
        this.aDownButton = new JButton(this.aResources.getString("button.down"));
        this.setMnemonic(this.aDownButton, "button.down");
        this.aDownButton.setEnabled(false);
        this.aDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pEvent) {
                int lSelectedIndex = ColorEditorComponent.this.aColorList.getSelectedIndex();
                ColorEditorComponent.this.aModel.swap(lSelectedIndex, lSelectedIndex + 1);
                ColorEditorComponent.this.aColorList.ensureIndexIsVisible(lSelectedIndex + 1);
                ColorEditorComponent.this.aColorList.setSelectedIndex(lSelectedIndex + 1);
                ColorEditorComponent.this.aHaveColorsBeenModified = true;
            }
        });
        this.add(this.aDownButton);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.gridx = 6;
        lConstraints.gridy = 2;
        lLayout.setConstraints(this.aDownButton, lConstraints);
    }

    private void createRemoveButton(GridBagLayout lLayout) {
        this.aRemoveButton = new JButton(this.aResources.getString("button.remove"));
        this.setMnemonic(this.aRemoveButton, "button.remove");
        this.aRemoveButton.setEnabled(false);
        this.aRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent pE) {
                ColorEditorComponent.this.aModel.remove(ColorEditorComponent.this.aColorList.getSelectedIndex());
                ColorEditorComponent.this.aHaveColorsBeenModified = true;
            }
        });
        this.add(this.aRemoveButton);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.gridx = 8;
        lConstraints.gridy = 2;
        lConstraints.anchor = 17;
        lConstraints.weightx = 1.0;
        lLayout.setConstraints(this.aRemoveButton, lConstraints);
    }

    private void addModelListenerForButtonUpdates() {
        this.aModel.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent pE) {
                ColorEditorComponent.this.updateButtonStates();
            }

            public void intervalRemoved(ListDataEvent pE) {
                ColorEditorComponent.this.updateButtonStates();
            }

            public void contentsChanged(ListDataEvent pE) {
                ColorEditorComponent.this.updateButtonStates();
            }
        });
    }

    private void updateButtonStates() {
        if (this.aColorList != null) {
            int lSelectedIndex = this.aColorList.getSelectedIndex();
            if (lSelectedIndex == -1) {
                this.aEditButton.setEnabled(false);
                this.aUpButton.setEnabled(false);
                this.aDownButton.setEnabled(false);
                this.aRemoveButton.setEnabled(false);
            } else {
                this.aEditButton.setEnabled(true);
                this.aRemoveButton.setEnabled(true);
                int lNumberOfItems = this.aColorList.getModel().getSize();
                if (lSelectedIndex == 0 || lNumberOfItems < 2) {
                    this.aUpButton.setEnabled(false);
                } else {
                    this.aUpButton.setEnabled(true);
                }
                if (lSelectedIndex == lNumberOfItems - 1 || lNumberOfItems < 2) {
                    this.aDownButton.setEnabled(false);
                } else {
                    this.aDownButton.setEnabled(true);
                }
            }
        }
    }

    private String getTitle(String pTitleKey) {
        return "AccolorHelper - " + this.aResources.getString("title." + pTitleKey);
    }

    private void setMnemonic(JButton pButton, String pBaseKey) {
        int lMnemonic = this.getMnemonic(pBaseKey);
        if (lMnemonic != 0) {
            pButton.setMnemonic(lMnemonic);
        }
    }

    private int getMnemonic(String lBaseKey) {
        int result = 0;
        String lMnemonic = this.aResources.getString(lBaseKey + ".mnemonic");
        if (lMnemonic != null && lMnemonic.length() > 0) {
            result = lMnemonic.charAt(0);
        }
        return result;
    }

    private static class ColorChooserDialogOkListener
    implements ActionListener {
        private JColorChooser aColorChooser;
        private Color aColor;

        public void actionPerformed(ActionEvent pEvent) {
            this.aColor = this.aColorChooser.getColor();
        }

        public Color getColor() {
            return this.aColor;
        }

        private ColorChooserDialogOkListener(JColorChooser pColorChooser) {
            this.aColorChooser = pColorChooser;
        }
    }
}

