/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import net.sf.accolorhelper.ColorWithText;

public class ColorListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private JList aList;
    private ColorWithText aColor;
    private boolean aIsSelected;
    private boolean aCellHasFocus;
    private JLabel aTextLabel;

    public ColorListCellRenderer() {
        this.setLayout(new GridLayout(1, 1));
        this.aTextLabel = new JLabel("", 2);
        this.aTextLabel.setBorder(new EmptyBorder(4, 114, 4, 4));
        this.add(this.aTextLabel);
    }

    public Component getListCellRendererComponent(JList pList, Object pValue, int pIndex, boolean pIsSelected, boolean pCellHasFocus) {
        this.aList = pList;
        this.setBackground(pList.getBackground());
        this.aColor = (ColorWithText)pValue;
        this.aTextLabel.setText(this.aColor.getText());
        this.aIsSelected = pIsSelected;
        this.aCellHasFocus = pCellHasFocus;
        return this;
    }

    public Dimension getMinimumSize() {
        return new Dimension(110 + this.aTextLabel.getMinimumSize().width, 61);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics pGraphics) {
        super.paint(pGraphics);
        if (this.aIsSelected) {
            pGraphics.setColor(this.aList.getForeground());
        } else {
            pGraphics.setColor(this.aList.getBackground());
        }
        pGraphics.fillRect(0, 0, 111, 61);
        if (this.aIsSelected) {
            pGraphics.setColor(this.aList.getBackground());
        } else {
            pGraphics.setColor(this.aList.getForeground());
        }
        pGraphics.drawRect(6, 6, 98, 48);
        pGraphics.setColor(this.aColor.getColor());
        pGraphics.fillRect(7, 7, 97, 47);
        if (this.aCellHasFocus) {
            if (this.aIsSelected) {
                pGraphics.setColor(this.aList.getBackground());
            } else {
                pGraphics.setColor(this.aList.getForeground());
            }
            pGraphics.drawRect(2, 2, 106, 56);
            pGraphics.drawRect(3, 3, 104, 54);
        }
    }
}

