/*
 * Decompiled with CFR 0.152.
 */
package com.casaerwin.brutus;

import com.casaerwin.brutus.DBM;
import com.casaerwin.brutus.Entity;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DBMEntity
extends DBM {
    private static PreparedStatement newKeyEntity;
    private static PreparedStatement insertEntity;
    private static PreparedStatement updateEntity;
    private static PreparedStatement deleteEntity;
    private static PreparedStatement retrieveEntity;
    private static PreparedStatement getEntity;
    private static PreparedStatement browseEntity;
    public static boolean psOpened;
    int DBMEntityRC;
    SQLException sqlEx;
    Vector entityTitles = new Vector();
    Vector row;

    DBMEntity() {
        if (!psOpened) {
            try {
                String string = "SELECT MAX ENT_SEQ + 1 AS NEW_KEY FROM ENTITY;";
                newKeyEntity = conn.prepareStatement(string);
                string = "INSERT INTO ENTITY VALUES(?, ?, ?, ?, ?, ?, ?);";
                insertEntity = conn.prepareStatement(string);
                string = "UPDATE ENTITY SET ENT_MEDIA = ?, ENT_TITLE = ?, ENT_LOCATION = ?, ENT_COMMENTS = ?, ENT_DATE = ? WHERE ENT_ID = ? AND ENT_SEQ = ?;";
                updateEntity = conn.prepareStatement(string);
                string = "DELETE FROM ENTITY WHERE ENT_ID = ? AND ENT_SEQ = ?;";
                deleteEntity = conn.prepareStatement(string);
                string = "SELECT ENT_MEDIA, ENT_TITLE, ENT_LOCATION, ENT_COMMENTS, ENT_DATE FROM ENTITY WHERE ENT_ID = ? AND ENT_SEQ = ?;";
                retrieveEntity = conn.prepareStatement(string);
                string = "SELECT ENT_ID, ENT_SEQ, ENT_MEDIA, ENT_LOCATION, ENT_COMMENTS, ENT_DATE FROM ENTITY WHERE ENT_TITLE = ?;";
                getEntity = conn.prepareStatement(string);
                string = "SELECT ENT_ID, ENT_SEQ, ENT_TITLE FROM ENTITY WHERE ENT_ID = ? ORDER BY ENT_TITLE;";
                browseEntity = conn.prepareStatement(string);
                this.DBMEntityRC = 0;
                psOpened = true;
            }
            catch (SQLException sQLException) {
                this.sqlEx = sQLException;
                this.DBMEntityRC = 12;
                this.handleSQLException(sQLException);
            }
        }
    }

    public void storeEntity(Entity entity) {
        entity.setSequence(this.getNewPrimaryKey());
        if (this.DBMEntityRC == 0) {
            try {
                insertEntity.setInt(1, entity.getIdentifier());
                insertEntity.setInt(2, entity.getSequence());
                insertEntity.setInt(3, entity.getMedia());
                insertEntity.setString(4, entity.getTitle());
                insertEntity.setString(5, entity.getLocation());
                insertEntity.setString(6, entity.getComments());
                insertEntity.setString(7, entity.getDate());
                insertEntity.executeUpdate();
                this.DBMEntityRC = 0;
            }
            catch (SQLException sQLException) {
                this.sqlEx = sQLException;
                this.DBMEntityRC = 12;
                this.handleSQLException(sQLException);
            }
        }
    }

    int getNewPrimaryKey() {
        try {
            ResultSet resultSet = newKeyEntity.executeQuery();
            if (resultSet.next()) {
                this.DBMEntityRC = 0;
                return resultSet.getInt("NEW_KEY");
            }
            this.DBMEntityRC = 8;
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMEntityRC = 12;
            this.handleSQLException(sQLException);
            return 0;
        }
    }

    public void updateEntity(Entity entity) {
        try {
            updateEntity.setInt(1, entity.getMedia());
            updateEntity.setString(2, entity.getTitle());
            updateEntity.setString(3, entity.getLocation());
            updateEntity.setString(4, entity.getComments());
            updateEntity.setString(5, entity.getDate());
            updateEntity.setInt(6, entity.getIdentifier());
            updateEntity.setInt(7, entity.getSequence());
            updateEntity.executeUpdate();
            this.DBMEntityRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMEntityRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    public void deleteEntity(Entity entity) {
        try {
            deleteEntity.setInt(1, entity.getIdentifier());
            deleteEntity.setInt(2, entity.getSequence());
            deleteEntity.executeUpdate();
            this.DBMEntityRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMEntityRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    public void retrieveEntity(Entity entity) {
        try {
            retrieveEntity.setInt(1, entity.getIdentifier());
            retrieveEntity.setInt(2, entity.getSequence());
            ResultSet resultSet = retrieveEntity.executeQuery();
            if (resultSet.next()) {
                entity.setMedia(resultSet.getInt("ENT_MEDIA"));
                entity.setTitle(resultSet.getString("ENT_TITLE"));
                entity.setLocation(resultSet.getString("ENT_LOCATION"));
                entity.setComments(resultSet.getString("ENT_COMMENTS"));
                entity.setDate(resultSet.getString("ENT_DATE"));
                this.DBMEntityRC = 0;
            } else {
                this.DBMEntityRC = 8;
            }
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMEntityRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    public void getEntity(Entity entity) {
        try {
            getEntity.setString(1, entity.getTitle());
            ResultSet resultSet = getEntity.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                entity.setSequence(resultSet.getInt("ENT_ID"));
                entity.setSequence(resultSet.getInt("ENT_SEQ"));
                entity.setMedia(resultSet.getInt("ENT_MEDIA"));
                entity.setLocation(resultSet.getString("ENT_LOCATION"));
                entity.setComments(resultSet.getString("ENT_COMMENTS"));
                entity.setDate(resultSet.getString("ENT_DATE"));
                ++n;
            }
            this.DBMEntityRC = n > 0 ? 0 : 8;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMEntityRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    public void browseEntity(int n) {
        try {
            browseEntity.setInt(1, n);
            ResultSet resultSet = browseEntity.executeQuery();
            int n2 = 0;
            while (resultSet.next()) {
                this.row = new Vector();
                this.row.add(new Integer(resultSet.getInt("ENT_ID")));
                this.row.add(new Integer(resultSet.getInt("ENT_SEQ")));
                this.row.add(resultSet.getString("ENT_TITLE"));
                this.entityTitles.add(this.row);
                ++n2;
            }
            this.DBMEntityRC = n2 > 0 ? 0 : 8;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMEntityRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    static {
        psOpened = false;
    }
}

