/*
 * Decompiled with CFR 0.152.
 */
package com.casaerwin.brutus;

import com.casaerwin.brutus.DBM;
import com.casaerwin.brutus.DBMArtist;
import com.casaerwin.brutus.DBMTrack;
import com.casaerwin.brutus.Movie;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DBMMovie
extends DBM {
    private static PreparedStatement newKeyMovie;
    private static PreparedStatement insertMovie;
    private static PreparedStatement deleteMovie;
    private static PreparedStatement retrieveMovie;
    public static boolean psOpened;
    int DBMMovieRC;
    SQLException sqlEx;
    Vector movieTitles = new Vector();
    Vector row;

    DBMMovie() {
        if (!psOpened) {
            try {
                String string = "SELECT MAX MOV_SEQ + 1 AS NEW_KEY FROM MOVIES;";
                newKeyMovie = conn.prepareStatement(string);
                string = "INSERT INTO MOVIES VALUES(?, ?, ?, ?, ?);";
                insertMovie = conn.prepareStatement(string);
                string = "DELETE FROM MOVIES WHERE MOV_PARENT_ID = ? AND MOV_PARENT_KEY = ?;";
                deleteMovie = conn.prepareStatement(string);
                string = "SELECT MOV_DIRECTOR, MOV_GENRE FROM MOVIES WHERE MOV_PARENT_ID = ? AND MOV_PARENT_KEY = ?;";
                retrieveMovie = conn.prepareStatement(string);
                this.DBMMovieRC = 0;
                psOpened = true;
            }
            catch (SQLException sQLException) {
                this.sqlEx = sQLException;
                this.DBMMovieRC = 12;
                this.handleSQLException(sQLException);
            }
        }
    }

    public void storeMovie(Movie movie) {
        try {
            insertMovie.setInt(1, this.getNewPrimaryKey());
            if (this.DBMMovieRC == 0) {
                insertMovie.setString(2, movie.getDirector());
                insertMovie.setInt(3, movie.getGenre());
                insertMovie.setInt(4, movie.getIdentifier());
                insertMovie.setInt(5, movie.getSequence());
                insertMovie.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMMovieRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    int getNewPrimaryKey() {
        try {
            ResultSet resultSet = newKeyMovie.executeQuery();
            if (resultSet.next()) {
                this.DBMMovieRC = 0;
                return resultSet.getInt("NEW_KEY");
            }
            this.DBMMovieRC = 8;
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMMovieRC = 12;
            this.handleSQLException(sQLException);
            return 0;
        }
    }

    public void deleteMovie(int n, int n2) {
        try {
            deleteMovie.setInt(1, n);
            deleteMovie.setInt(2, n2);
            deleteMovie.executeUpdate();
            this.DBMMovieRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMMovieRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    public void retrieveMovie(Movie movie) {
        try {
            retrieveMovie.setInt(1, movie.getIdentifier());
            retrieveMovie.setInt(2, movie.getSequence());
            ResultSet resultSet = retrieveMovie.executeQuery();
            if (resultSet.next()) {
                movie.setDirector(resultSet.getString("MOV_DIRECTOR"));
                movie.setGenre(resultSet.getInt("MOV_GENRE"));
                this.DBMMovieRC = 0;
                DBMArtist dBMArtist = new DBMArtist();
                dBMArtist.retrieveArtist(movie.getIdentifier(), movie.getSequence());
                for (int i = 0; i < dBMArtist.artList.size(); ++i) {
                    this.row = (Vector)dBMArtist.artList.get(i);
                    movie.addArtist(this.row);
                }
                DBMTrack dBMTrack = new DBMTrack();
                dBMTrack.retrieveTrack(movie.getIdentifier(), movie.getSequence());
                for (int i = 0; i < dBMTrack.trackTitles.size(); ++i) {
                    movie.trackList.add((String)dBMTrack.trackTitles.get(i));
                }
            } else {
                this.DBMMovieRC = 8;
            }
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMMovieRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    static {
        psOpened = false;
    }
}

