/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CreateDatabaseDialog
extends JDialog
implements DocumentListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private CardLayout cardLayout;
    private String path;
    private Color errorLabelBg;
    private Color errorLabelFg;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel continueLabel;
    private JLabel imageLabel;
    private JLabel invalidPathLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel messageLabel;
    private JButton nextButton;
    private JButton okButton;
    private JTextField pathField;
    private JLabel pathLabel;
    private JPanel pathPanel;
    private JPanel splashPanel;
    private int returnStatus = 0;

    public CreateDatabaseDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Color c = this.invalidPathLabel.getBackground();
        this.errorLabelBg = new Color(c.getRGB());
        this.errorLabelFg = this.invalidPathLabel.getForeground();
        this.path = System.getProperty("user.home");
        this.pathField.setText(this.path);
        this.pathField.getDocument().addDocumentListener(this);
        this.cardLayout = (CardLayout)this.jPanel3.getLayout();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkPath();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkPath();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkPath();
    }

    private void checkPath() {
        this.path = this.pathField.getText();
        File f = new File(this.path);
        boolean valid = f.isDirectory() && f.canWrite();
        this.okButton.setEnabled(valid);
        this.invalidPathLabel.setForeground(valid ? this.errorLabelBg : this.errorLabelFg);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public String getSelectedPath() {
        return this.pathField.getText();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.nextButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel3 = new JPanel();
        this.splashPanel = new JPanel();
        this.imageLabel = new JLabel();
        this.continueLabel = new JLabel();
        this.pathPanel = new JPanel();
        this.messageLabel = new JLabel();
        this.pathLabel = new JLabel();
        this.pathField = new JTextField();
        this.browseButton = new JButton();
        this.invalidPathLabel = new JLabel();
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CreateDatabaseDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setLayout(new GridLayout(1, 0, 5, 0));
        ResourceBundle bundle = ResourceBundle.getBundle("com/lemckes/cellarboss/Bundle");
        this.nextButton.setText(bundle.getString("CreateDatabaseDialog.nextButton.text"));
        this.nextButton.setName("nextButton");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseDialog.this.nextButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.nextButton);
        this.okButton.setText(bundle.getString("CreateDatabaseDialog.okButton.text"));
        this.okButton.setEnabled(false);
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.okButton);
        this.cancelButton.setText(bundle.getString("CreateDatabaseDialog.cancelButton.text"));
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelButton);
        this.jPanel1.add(this.jPanel2);
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.jPanel3.setName("jPanel3");
        this.jPanel3.setLayout(new CardLayout());
        this.splashPanel.setName("splashPanel");
        this.splashPanel.setLayout(new BorderLayout());
        this.imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/lemckes/cellarboss/resources/CellarBossSplash.png")));
        this.imageLabel.setName("imageLabel");
        this.splashPanel.add((Component)this.imageLabel, "Center");
        this.continueLabel.setBackground(new Color(255, 255, 255));
        this.continueLabel.setFont(this.continueLabel.getFont().deriveFont(this.continueLabel.getFont().getStyle() | 2 | 1, this.continueLabel.getFont().getSize() + 6));
        this.continueLabel.setHorizontalAlignment(0);
        this.continueLabel.setText(bundle.getString("CreateDatabaseDialog.continueLabel.text"));
        this.continueLabel.setBorder(BorderFactory.createEmptyBorder(4, 1, 4, 1));
        this.continueLabel.setName("continueLabel");
        this.continueLabel.setOpaque(true);
        this.splashPanel.add((Component)this.continueLabel, "Last");
        this.jPanel3.add((Component)this.splashPanel, "card3");
        this.pathPanel.setName("pathPanel");
        this.pathPanel.setLayout(new GridBagLayout());
        this.messageLabel.setText(bundle.getString("CreateDatabaseDialog.messageLabel.text"));
        this.messageLabel.setName("messageLabel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 11, 6);
        this.pathPanel.add((Component)this.messageLabel, gridBagConstraints);
        this.pathLabel.setText(bundle.getString("CreateDatabaseDialog.pathLabel.text"));
        this.pathLabel.setName("pathLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.pathPanel.add((Component)this.pathLabel, gridBagConstraints);
        this.pathField.setColumns(20);
        this.pathField.setName("pathField");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.pathPanel.add((Component)this.pathField, gridBagConstraints);
        this.browseButton.setText(bundle.getString("CreateDatabaseDialog.browseButton.text"));
        this.browseButton.setName("browseButton");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseDialog.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.pathPanel.add((Component)this.browseButton, gridBagConstraints);
        this.invalidPathLabel.setForeground(new Color(255, 102, 0));
        this.invalidPathLabel.setText(bundle.getString("CreateDatabaseDialog.invalidPathLabel.text"));
        this.invalidPathLabel.setName("invalidPathLabel");
        this.invalidPathLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pathPanel.add((Component)this.invalidPathLabel, gridBagConstraints);
        this.jPanel3.add((Component)this.pathPanel, "card2");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(this.path);
        fc.setFileSelectionMode(1);
        int res = fc.showDialog(this, "Ok");
        if (res == 0) {
            this.pathField.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.cardLayout.next(this.jPanel3);
        this.nextButton.setEnabled(false);
        this.checkPath();
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

