/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.IdName;
import com.lemckes.cellarboss.util.DbUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class IdNameList
extends ArrayList<IdName> {
    private Connection connection;
    private String tableName;
    private EventListenerList listenerList;

    public IdNameList(Connection connection, String tableName) {
        this.connection = connection;
        this.tableName = tableName;
        this.listenerList = new EventListenerList();
    }

    private void closeStatement(Statement s) {
        DbUtils.closeStatement(s);
    }

    public void readRecords() throws SQLException {
        PreparedStatement ps = null;
        try {
            String q = "select * from " + this.tableName + " order by name";
            ps = this.connection.prepareStatement(q);
            ps.execute();
            ResultSet rs = ps.getResultSet();
            this.clear();
            while (rs.next()) {
                this.add(new IdName(rs.getInt("id"), rs.getString("name")));
            }
            this.closeStatement(ps);
        }
        catch (SQLException ex) {
            this.closeStatement(ps);
            throw ex;
        }
    }

    void saveRecord(IdName idName) throws SQLException {
        PreparedStatement ps = null;
        try {
            boolean isNewRecord = idName.getId() == null;
            String q = isNewRecord ? "insert into " + this.tableName + " (name)" + " values (?)" : "update " + this.tableName + " set" + " name=" + "?" + " where id=?";
            ps = this.connection.prepareStatement(q);
            int paramIndex = 1;
            ps.setString(paramIndex++, idName.getName());
            if (!isNewRecord) {
                ps.setInt(paramIndex++, idName.getId());
            }
            ps.executeUpdate();
            if (isNewRecord) {
                this.readRecords();
            }
            this.fireDataUpdated();
            this.closeStatement(ps);
        }
        catch (SQLException ex) {
            this.closeStatement(ps);
            throw ex;
        }
    }

    public void deleteRecord(IdName idName) throws SQLException {
        PreparedStatement ps = null;
        try {
            String q = "delete from " + this.tableName + " where id = " + idName.getId();
            ps = this.connection.prepareStatement(q);
            ps.executeUpdate();
            this.closeStatement(ps);
            this.remove(idName);
            this.fireDataUpdated();
        }
        catch (SQLException ex) {
            this.closeStatement(ps);
            throw ex;
        }
    }

    public IdName findIdNameForId(int id) {
        IdName result = null;
        for (IdName in : this) {
            if (in.getId() != id) continue;
            result = in;
            break;
        }
        return result;
    }

    public IdName findIdNameForName(String name) {
        IdName result = null;
        for (IdName in : this) {
            if (!in.getName().equals(name)) continue;
            result = in;
            break;
        }
        return result;
    }

    public boolean containsName(String name) {
        boolean contains = false;
        for (IdName in : this) {
            if (!in.getName().equals(name)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public void addUpdateListener(UpdateListener l) {
        this.listenerList.add(UpdateListener.class, l);
    }

    public void removeUpdateListener(UpdateListener l) {
        this.listenerList.remove(UpdateListener.class, l);
    }

    private void fireDataUpdated() {
        for (UpdateListener l : (UpdateListener[])this.listenerList.getListeners(UpdateListener.class)) {
            l.idNameDataUpdated();
        }
    }

    Connection getConnection() {
        return this.connection;
    }

    public static interface UpdateListener
    extends EventListener {
        public void idNameDataUpdated();
    }
}

