/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.IdName;
import com.lemckes.cellarboss.IdNameList;
import com.lemckes.cellarboss.IdNameTableModel;
import com.lemckes.cellarboss.util.DbUtils;
import com.lemckes.cellarboss.util.TableColumnWidthSetter;
import com.lemckes.cellarboss.util.TextFieldFocusHandlers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IdNameManagerView
extends JPanel
implements ListSelectionListener {
    protected IdNameList idNameList;
    protected IdName editIdName;
    protected DocumentListener nameCheckListener;
    private TextFieldFocusHandlers fh = new TextFieldFocusHandlers();
    private FocusAdapter moveToEndFocusListener = this.fh.getMoveToEnd();
    private FocusAdapter selectAllFocusListener = this.fh.getSelectAll();
    private JPanel controlPanel;
    private JTable dataTable;
    private JButton deleteButton;
    private JPanel detailPanel;
    private JButton editButton;
    private JLabel idLabel;
    private JPanel jPanel;
    private JScrollPane jScrollPane;
    private JTextField nameField;
    private JLabel nameLabel;
    private JButton newButton;
    private JButton saveButton;

    public IdNameManagerView(IdNameList idNameList) {
        this.idNameList = idNameList;
        this.initComponents();
        this.setTableModel();
        this.setInputCheckListener();
        TableColumnWidthSetter.setColumnWidths(this.dataTable, false);
        int prefWidth = this.dataTable.getColumnModel().getTotalColumnWidth();
        Dimension size = this.dataTable.getPreferredScrollableViewportSize();
        size.width = prefWidth;
        this.dataTable.setPreferredScrollableViewportSize(size);
        this.dataTable.getSelectionModel().addListSelectionListener(this);
        this.editIdName = new IdName(null, "");
        this.nameField.setText("");
        this.nameField.addFocusListener(this.selectAllFocusListener);
        this.nameField.getDocument().addDocumentListener(this.nameCheckListener);
        this.idLabel.setText("(NEW)");
        this.saveButton.setEnabled(false);
        this.enableControlButtons();
    }

    protected void setTableModel() {
        this.dataTable.setModel(new IdNameTableModel(this.idNameList));
    }

    protected void setInputCheckListener() {
        this.nameCheckListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IdNameManagerView.this.checkInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IdNameManagerView.this.checkInput();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IdNameManagerView.this.checkInput();
            }
        };
    }

    protected void checkInput() {
        boolean enabled = this.nameField.getText().length() > 0 && !this.idNameList.containsName(this.nameField.getText());
        this.enableSaveButton(enabled);
    }

    protected void enableSaveButton(boolean enabled) {
        this.saveButton.setEnabled(enabled);
    }

    protected boolean isSaveEnabled() {
        return this.saveButton.isEnabled();
    }

    protected String getNameFieldText() {
        return this.nameField.getText();
    }

    private void enableControlButtons() {
        boolean selected = this.dataTable.getSelectedRowCount() > 0;
        this.editButton.setEnabled(selected);
        this.deleteButton.setEnabled(selected);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.enableControlButtons();
        }
    }

    private void doSave() {
        boolean saved = this.saveRecord();
        if (saved) {
            this.clearFields();
        }
    }

    protected boolean saveRecord() {
        boolean saved = true;
        try {
            this.editIdName.setName(this.nameField.getText());
            this.idNameList.saveRecord(this.editIdName);
            TableColumnWidthSetter.setColumnWidths(this.dataTable, false);
        }
        catch (SQLException ex) {
            saved = false;
            DbUtils.logSQLException(this.getClass(), "IdName Save Failed", ex);
            JOptionPane.showMessageDialog(this, ex, "Save Error", 0);
        }
        return saved;
    }

    protected void clearFields() {
        this.editIdName = new IdName(null, "");
        this.nameField.setText("");
        this.idLabel.setText("(NEW)");
        this.nameField.requestFocusInWindow();
    }

    protected void newRecord() {
        this.editIdName = new IdName(null, "");
        this.nameField.setText("");
        this.idLabel.setText("(NEW)");
        this.nameField.requestFocusInWindow();
    }

    protected void editRecord() {
        int row = this.dataTable.convertRowIndexToModel(this.dataTable.getSelectedRow());
        this.editIdName = (IdName)this.idNameList.get(row);
        this.nameField.setText(this.editIdName.getName());
        this.idLabel.setText("(" + this.editIdName.getId() + ")");
        this.nameField.requestFocusInWindow();
    }

    protected void deleteRecord() {
        int row = this.dataTable.convertRowIndexToModel(this.dataTable.getSelectedRow());
        IdName idName = (IdName)this.idNameList.get(row);
        String name = idName.getName();
        String message = "Are you sure you want to delete '" + name + "'?";
        int yesNo = JOptionPane.showConfirmDialog(this, message, "Delete record", 0, 3);
        if (yesNo == 0) {
            try {
                this.idNameList.deleteRecord(idName);
            }
            catch (SQLException ex) {
                DbUtils.logSQLException(this.getClass(), "IdName Delete Failed", ex);
                JOptionPane.showMessageDialog(this, ex, "Delete Error", 0);
            }
        }
    }

    protected JPanel getDetailPanel() {
        return this.detailPanel;
    }

    protected JTable getDataTable() {
        return this.dataTable;
    }

    private void initComponents() {
        this.controlPanel = new JPanel();
        this.jPanel = new JPanel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.detailPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.saveButton = new JButton();
        this.idLabel = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.dataTable = new JTable();
        this.setLayout(new BorderLayout());
        this.jPanel.setLayout(new GridLayout(0, 1, 0, 5));
        this.newButton.setText("New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdNameManagerView.this.newButtonActionPerformed(evt);
            }
        });
        this.jPanel.add(this.newButton);
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdNameManagerView.this.editButtonActionPerformed(evt);
            }
        });
        this.jPanel.add(this.editButton);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdNameManagerView.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel.add(this.deleteButton);
        this.controlPanel.add(this.jPanel);
        this.add((Component)this.controlPanel, "After");
        this.detailPanel.setLayout(new GridBagLayout());
        this.nameLabel.setText("Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.detailPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setColumns(16);
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdNameManagerView.this.nameFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.detailPanel.add((Component)this.nameField, gridBagConstraints);
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdNameManagerView.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 6);
        this.detailPanel.add((Component)this.saveButton, gridBagConstraints);
        this.idLabel.setText("(NEW)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 9, 0, 3);
        this.detailPanel.add((Component)this.idLabel, gridBagConstraints);
        this.add((Component)this.detailPanel, "Last");
        this.dataTable.setAutoCreateRowSorter(true);
        this.dataTable.setAutoResizeMode(0);
        this.dataTable.setSelectionMode(0);
        this.jScrollPane.setViewportView(this.dataTable);
        this.add((Component)this.jScrollPane, "Center");
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.newRecord();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.editRecord();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteRecord();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.doSave();
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.doSave();
    }
}

