/*
 * Decompiled with CFR 0.152.
 */
package com.lemckes.cellarboss;

import com.lemckes.cellarboss.Bottle;
import com.lemckes.cellarboss.BottleEditorPanel;
import com.lemckes.cellarboss.WineList;
import com.lemckes.cellarboss.WineListTableModel;
import com.lemckes.cellarboss.util.DbUtils;
import com.lemckes.cellarboss.util.TableColumnWidthSetter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WineListView
extends JPanel
implements ListSelectionListener {
    private WineList wineList;
    private BottleEditorPanel editor;
    private JPanel bottleDetailPanel;
    private JTable bottlesTable;
    private JPanel controlPanel;
    private JButton deleteButton;
    private JButton editButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton newButton;

    public WineListView(WineList wineList) {
        this.wineList = wineList;
        this.initComponents();
        this.editor = new BottleEditorPanel(this, wineList);
        this.bottleDetailPanel.add(this.editor);
        this.bottlesTable.setModel(new WineListTableModel(wineList));
        TableColumnWidthSetter.setColumnWidths(this.bottlesTable, false);
        int prefWidth = this.bottlesTable.getColumnModel().getTotalColumnWidth();
        Dimension size = this.bottlesTable.getPreferredScrollableViewportSize();
        size.width = prefWidth;
        this.bottlesTable.setPreferredScrollableViewportSize(size);
        this.bottlesTable.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
    }

    private void enableButtons() {
        boolean selected = this.bottlesTable.getSelectedRowCount() > 0;
        this.editButton.setEnabled(selected);
        this.deleteButton.setEnabled(selected);
    }

    void tableChanged() {
        TableColumnWidthSetter.setColumnWidths(this.bottlesTable, true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.enableButtons();
        }
    }

    private void initComponents() {
        this.controlPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.bottleDetailPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.bottlesTable = new JTable();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridLayout(0, 1, 0, 5));
        this.newButton.setText("New");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WineListView.this.newButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.newButton);
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WineListView.this.editButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.editButton);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WineListView.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.deleteButton);
        this.controlPanel.add(this.jPanel1);
        this.add((Component)this.controlPanel, "After");
        this.bottleDetailPanel.setLayout(new BorderLayout());
        this.add((Component)this.bottleDetailPanel, "Last");
        this.bottlesTable.setAutoCreateRowSorter(true);
        this.bottlesTable.setAutoResizeMode(0);
        this.bottlesTable.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.bottlesTable);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        this.editor.setBottle(new Bottle());
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int row = this.bottlesTable.convertRowIndexToModel(this.bottlesTable.getSelectedRow());
        this.editor.setBottle(this.wineList.getBottles().get(row));
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int row = this.bottlesTable.convertRowIndexToModel(this.bottlesTable.getSelectedRow());
        Bottle bottle = this.wineList.getBottles().get(row);
        String winery = bottle.getWinery().getName();
        String variety = bottle.getVariety().getName();
        String name = bottle.getName();
        int vintage = bottle.getVintage();
        String vintString = vintage > 0 ? " " + vintage + " " : " ";
        String message = "<html>";
        message = message + "You mean to tell me you've drunk all the<br/>";
        int yesNo = JOptionPane.showConfirmDialog(this, message = message + "<b>" + winery + vintString + name + " " + variety + "?</b></html>", "Delete bottle", 0, 3);
        if (yesNo == 0) {
            try {
                this.wineList.deleteBottle(bottle);
                this.tableChanged();
            }
            catch (SQLException ex) {
                DbUtils.logSQLException(this.getClass(), "Delete Bottle Failed", ex);
                JOptionPane.showMessageDialog(this, ex, "Delete Error", 0);
            }
        }
    }
}

